/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dldcomm.util;

import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class RenameFile {
    private String sDriverSurname;
    private String sDriverForename;
    private String sDriverMemberState;
    private String sDCNumber;
    private String sVRN;
    private String sVIN;
    private String sVehMemberState;
    private Calendar cLocal = Calendar.getInstance();
    private static final Logger logger = Logger.getLogger(RenameFile.class);

    private String getDetails(String sFile, String sFileExt, int iFileType) {
        String[] sExistingFileArray = sFile.split("\\.");
        String ExistingExtn = "";
        String year = "";
        String year2digit = "";
        String months = "";
        String days = "";
        String hrs = "";
        String time24 = "";
        String minutes = "";
        String DDDDate = "";
        String TGDDate = "";
        String V1BDate = "";
        String A1BDate = "";
        String C1BDate = "";
        if (this.cLocal != null) {
            logger.debug((Object)"inside cLocal");
            year = String.valueOf(this.cLocal.get(1));
            year2digit = year.substring(0, 2);
            months = String.format("%2s", String.valueOf(this.cLocal.get(2))).replace(' ', '0');
            days = String.format("%2s", String.valueOf(this.cLocal.get(5))).replace(' ', '0');
            hrs = String.format("%2s", String.valueOf(this.cLocal.get(11))).replace(' ', '0');
            minutes = String.format("%2s", String.valueOf(this.cLocal.get(12))).replace(' ', '0');
            time24 = String.valueOf(hrs) + minutes;
            TGDDate = DDDDate = String.valueOf(year) + months + days + "_" + time24;
            V1BDate = String.valueOf(year2digit) + months + days + "_" + time24;
            A1BDate = String.valueOf(year) + months + days + time24;
            C1BDate = String.valueOf(year2digit) + months + days + time24;
            logger.error((Object)("DDDDate:::" + DDDDate));
            logger.error((Object)("TGDDate:::" + TGDDate));
            logger.error((Object)("V1BDate:::" + V1BDate));
            logger.error((Object)("A1BDate:::" + A1BDate));
            logger.error((Object)("C1BDate:::" + C1BDate));
        }
        ExistingExtn = sExistingFileArray.length < 2 ? "DDD" : sExistingFileArray[sExistingFileArray.length - 1];
        String sTemp = "";
        String[] subStrings = sFile.split("_");
        logger.debug((Object)("ExistingExtn:::" + ExistingExtn));
        logger.debug((Object)("sFile:::" + sFile));
        logger.debug((Object)("sFileExt:::" + sFileExt));
        logger.debug((Object)("iFileType:::" + iFileType));
        sFileExt = sFileExt.toUpperCase().trim();
        ExistingExtn = ExistingExtn.toUpperCase().trim();
        if (iFileType == 128 || iFileType == 129) {
            logger.debug((Object)"Renaming DC File");
            if (sFileExt.equals("DDD")) {
                this.sDriverForename = RenameFile.ReplaceNotAllowedChar(this.sDriverForename.trim());
                this.sDriverSurname = RenameFile.ReplaceNotAllowedChar(this.sDriverSurname.trim());
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("C1B")) {
                        sTemp = "C_20" + sFile.substring(17, 23) + "_" + sFile.substring(23, 27) + "_" + this.sDriverForename.substring(0, 1) + "_" + this.sDriverSurname + "_" + this.sDCNumber.substring(0, 14) + ".DDD";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = "C_" + subStrings[3] + "_" + subStrings[4].substring(0, 4) + "_" + this.sDriverForename.substring(0, 1) + "_" + this.sDriverSurname + "_" + this.sDCNumber.substring(0, 14) + ".DDD";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = "C_" + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + "_" + this.sDriverForename.substring(0, 1) + "_" + this.sDriverSurname + "_" + this.sDCNumber.substring(0, 14) + ".DDD";
                    }
                } else {
                    sTemp = "C_" + DDDDate + "_" + this.sDriverForename.substring(0, 1) + "_" + this.sDriverSurname + "_" + this.sDCNumber.substring(0, 14) + ".DDD";
                    logger.debug((Object)("TGD sTemp: " + sTemp));
                }
            } else if (sFileExt.equals("C1B")) {
                this.sDCNumber = RenameFile.ReplaceAllowedChar(this.sDCNumber);
                sTemp = this.sDriverMemberState;
                int iCount = this.sDriverMemberState.length();
                while (iCount < 3) {
                    sTemp = String.valueOf(sTemp) + "_";
                    ++iCount;
                }
                sTemp = String.valueOf(sTemp) + this.sDCNumber.substring(0, 14);
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(4, 10) + sFile.substring(11, 15) + ".C1B";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = String.valueOf(sTemp) + subStrings[3].substring(2, 8) + subStrings[4].substring(0, 4) + ".C1B";
                    } else if (ExistingExtn.equals("C1B")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(17, 27) + ".C1B";
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + C1BDate + ".C1B";
                    logger.debug((Object)("TGD sTemp: " + sTemp));
                }
            } else if (sFileExt.equals("TGD")) {
                logger.debug((Object)"inside TGD");
                sTemp = "C_" + this.sDCNumber + "_" + this.sDriverMemberState.trim() + "_";
                logger.debug((Object)("sTemp: " + sTemp));
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + ".TGD";
                        logger.debug((Object)("DDD sTemp: " + sTemp));
                    } else if (ExistingExtn.equals("C1B")) {
                        sTemp = String.valueOf(sTemp) + "20" + sFile.substring(17, 23) + "_" + sFile.substring(23, 27) + ".TGD";
                        logger.debug((Object)("C1b sTemp: " + sTemp));
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = String.valueOf(sTemp) + subStrings[3] + "_" + subStrings[4].substring(0, 4) + ".TGD";
                        logger.debug((Object)("TGD sTemp: " + sTemp));
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + TGDDate + ".TGD";
                    logger.debug((Object)("TGD sTemp: " + sTemp));
                }
            }
        } else if (iFileType == 130) {
            logger.debug((Object)sFileExt);
            if (sFileExt.equals("DDD")) {
                this.sVRN = RenameFile.ReplaceNotAllowedChar(this.sVRN.trim());
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("V1B")) {
                        sTemp = "M_20" + sFile.substring(16, 22) + "_" + sFile.substring(22, 26) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = "M_" + subStrings[3] + "_" + subStrings[4].substring(0, 4) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + "M_" + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + "M_" + DDDDate + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                }
            } else if (sFileExt.equals("V1B")) {
                this.sVRN = RenameFile.ReplaceAllowedChar(this.sVRN.trim());
                sTemp = this.sVehMemberState;
                int iCount = this.sVehMemberState.length();
                while (iCount < 3) {
                    sTemp = String.valueOf(sTemp) + "_";
                    ++iCount;
                }
                if (this.sVRN.length() < 13) {
                    int index = this.sVRN.length();
                    while (index < 13) {
                        this.sVRN = String.valueOf(this.sVRN) + "_";
                        ++index;
                    }
                }
                sTemp = String.valueOf(sTemp) + this.sVRN;
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("V1B")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(16, 22) + sFile.substring(22, 26) + ".V1B";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = String.valueOf(sTemp) + subStrings[3].substring(2, 8) + subStrings[4].substring(0, 4) + ".V1B";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(4, 10) + sFile.substring(11, 15) + ".V1B";
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + V1BDate + ".V1B";
                }
            } else if (sFileExt.equals("TGD")) {
                logger.debug((Object)"inside TGD");
                this.sVRN = RenameFile.ReplaceNotAllowedChar(this.sVRN.trim());
                logger.debug((Object)("VRN" + this.sVRN));
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("V1B")) {
                        sTemp = "V_" + this.sVRN + "_" + this.sVehMemberState + "_20" + sFile.substring(16, 22) + "_" + sFile.substring(22, 26) + ".TGD";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = "V_" + this.sVRN + "_" + this.sVehMemberState + "_" + subStrings[3] + "_" + subStrings[4].substring(0, 4) + ".TGD";
                        logger.debug((Object)sTemp);
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = "V_" + this.sVRN + "_" + this.sVehMemberState + "_" + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + ".TGD";
                    }
                } else {
                    sTemp = "V_" + this.sVRN + "_" + this.sVehMemberState + "_" + TGDDate + ".TGD";
                }
            }
        } else if (iFileType == 131) {
            logger.debug((Object)"Renaming VDO File");
            if (sFileExt.equals("DDD")) {
                this.sVRN = RenameFile.ReplaceNotAllowedChar(this.sVRN.trim());
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("A1B")) {
                        sTemp = "S_" + sFile.substring(18, 26) + "_" + sFile.substring(26, 30) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = "S_" + subStrings[3] + "_" + subStrings[4].substring(0, 4) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + "S_" + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + "S_" + DDDDate + "_" + this.sVRN + "_" + this.sVIN + ".DDD";
                }
            } else if (sFileExt.equals("A1B")) {
                this.sVRN = RenameFile.ReplaceAllowedChar(this.sVRN.trim());
                this.sVRN = RenameFile.ReplaceAllowedChar(this.sVRN.trim());
                sTemp = "S_" + this.sVehMemberState;
                int iCount = this.sVehMemberState.length();
                while (iCount < 3) {
                    sTemp = String.valueOf(sTemp) + "_";
                    ++iCount;
                }
                if (this.sVRN.length() < 13) {
                    int index = this.sVRN.length();
                    while (index < 13) {
                        this.sVRN = String.valueOf(this.sVRN) + "_";
                        ++index;
                    }
                }
                sTemp = String.valueOf(sTemp) + this.sVRN;
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("A1B")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(18, 26) + sFile.substring(26, 30) + ".A1B";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = String.valueOf(sTemp) + subStrings[3] + subStrings[4].substring(0, 4) + ".A1B";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = String.valueOf(sTemp) + sFile.substring(2, 10) + sFile.substring(11, 15) + ".A1B";
                    }
                } else {
                    sTemp = String.valueOf(sTemp) + A1BDate + ".A1B";
                }
            } else if (sFileExt.equals("TGD")) {
                this.sVRN = RenameFile.ReplaceNotAllowedChar(this.sVRN.trim());
                if (this.cLocal == null) {
                    if (ExistingExtn.equals("A1B")) {
                        sTemp = "S_" + this.sVRN + "_" + this.sVehMemberState + "_" + sFile.substring(18, 26) + "_" + sFile.substring(26, 30) + ".TGD";
                    } else if (ExistingExtn.equals("TGD")) {
                        sTemp = "S_" + this.sVRN + "_" + this.sVehMemberState + "_" + subStrings[3] + "_" + subStrings[4].substring(0, 4) + ".TGD";
                    } else if (ExistingExtn.equals("DDD")) {
                        sTemp = "S_" + this.sVRN + "_" + this.sVehMemberState + "_" + sFile.substring(2, 10) + "_" + sFile.substring(11, 15) + ".TGD";
                    }
                } else {
                    sTemp = "S_" + this.sVRN + "_" + this.sVehMemberState + "_" + TGDDate + ".TGD";
                }
            }
        }
        return sTemp;
    }

    public String rename(byte[] data, String fileName, String strExt, int iFileType) {
        FileInputStream fis = null;
        try {
            logger.debug((Object)"rename");
            logger.debug((Object)("iFileType::: " + iFileType));
            if (iFileType == 0) {
                return "-1";
            }
            if (iFileType == 130 || iFileType == 131) {
                this.getVehicleRegistrationNumber(data);
            } else {
                this.getDriverName(data);
            }
            String string = this.getDetails(fileName, strExt, iFileType);
            return string;
        }
        catch (Exception ex) {
            logger.debug((Object)("rename:::" + ex.getStackTrace()));
            return "-1";
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    logger.debug((Object)("Exception in rename method of RenameFile :::" + ex.getStackTrace()));
                }
            }
        }
    }

    private void getDriverName(byte[] data) throws UnsupportedEncodingException {
        try {
            boolean ValidDate = false;
            int i = 0;
            int fileID1 = 0;
            int fileID2 = 0;
            int fileType = 0;
            int fileLen = 0;
            while (i < data.length) {
                fileID1 = this.convertUnsignedByteToInt(data[i]);
                fileID2 = this.convertUnsignedByteToInt(data[i + 1]);
                fileType = this.convertUnsignedByteToInt(data[i + 2]);
                fileLen = this.convertUnsignedByteArrayToInt(data, i + 3, 2);
                logger.debug((Object)fileLen);
                i += 5;
                if (fileType == 0) {
                    if (fileID1 == 5 && fileID2 == 32) {
                        byte memberState = data[i];
                        this.sDriverMemberState = RenameFile.GetNumeric((char)memberState);
                        this.sDCNumber = new String(data, i + 1, 16);
                        int codePage = this.convertUnsignedByteToInt(data[i + 65]);
                        String strEncoding = "";
                        switch (codePage) {
                            case 2: {
                                strEncoding = "ISO-8859-2";
                                break;
                            }
                            case 3: {
                                strEncoding = "ISO-8859-3";
                                break;
                            }
                            case 5: {
                                strEncoding = "ISO-8859-5";
                                break;
                            }
                            case 7: {
                                strEncoding = "ISO-8859-7";
                                break;
                            }
                            case 9: {
                                strEncoding = "ISO-8859-9";
                                break;
                            }
                            case 13: {
                                strEncoding = "ISO-8859-13";
                                break;
                            }
                            case 15: {
                                strEncoding = "ISO-8859-15";
                                break;
                            }
                            case 16: {
                                strEncoding = "Windows-1250";
                                break;
                            }
                            case 80: {
                                strEncoding = "Cyrillic";
                                break;
                            }
                            case 85: {
                                strEncoding = "Cyrillic";
                                break;
                            }
                            default: {
                                strEncoding = "ISO-8859-1";
                            }
                        }
                        this.sDriverSurname = new String(data, i + 65 + 1, 35, strEncoding);
                        codePage = this.convertUnsignedByteToInt(data[i + 65 + 36]);
                        switch (codePage) {
                            case 2: {
                                strEncoding = "ISO-8859-2";
                                break;
                            }
                            case 3: {
                                strEncoding = "ISO-8859-3";
                                break;
                            }
                            case 5: {
                                strEncoding = "ISO-8859-5";
                                break;
                            }
                            case 7: {
                                strEncoding = "ISO-8859-7";
                                break;
                            }
                            case 9: {
                                strEncoding = "ISO-8859-9";
                                break;
                            }
                            case 13: {
                                strEncoding = "ISO-8859-13";
                                break;
                            }
                            case 15: {
                                strEncoding = "ISO-8859-15";
                                break;
                            }
                            case 16: {
                                strEncoding = "Windows-1250";
                                break;
                            }
                            case 80: {
                                strEncoding = "Cyrillic";
                                break;
                            }
                            case 85: {
                                strEncoding = "Cyrillic";
                                break;
                            }
                            default: {
                                strEncoding = "ISO-8859-1";
                            }
                        }
                        this.sDriverForename = new String(data, i + 65 + 37, 35, strEncoding);
                        String fullName = String.valueOf(this.sDriverSurname.trim()) + "," + this.sDriverForename.trim();
                        logger.debug((Object)("fullName::: " + fullName));
                        break;
                    }
                    if (fileID1 == 5 && fileID2 == 14) {
                        try {
                            int seconds = this.convertUnsignedByteArrayToInt(data, i, 4);
                            this.cLocal.setTimeInMillis((long)seconds * 1000L);
                            logger.debug((Object)("dFileDate:::" + this.cLocal.getTime()));
                            this.cLocal.setTime(this.getUTCTIME(this.cLocal));
                            logger.debug((Object)this.cLocal.getTime());
                            if (this.cLocal != null && this.cLocal.get(1) > 2000) {
                                ValidDate = true;
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Exception while setting cLocal.", (Throwable)e);
                        }
                    }
                }
                i += fileLen;
            }
            if (!ValidDate) {
                logger.debug((Object)"Date field not found");
                this.cLocal = null;
            }
        }
        catch (Exception exp) {
            logger.error((Object)("Exception in getDriverName:::" + exp.getMessage()));
        }
    }

    private final int convertUnsignedByteToInt(byte data) {
        int retVal = data;
        if (retVal < 0) {
            retVal = 255 + data + 1;
        }
        return retVal;
    }

    private final int convertUnsignedByteArrayToInt(byte[] data, int offset, int len) {
        int maxLen = len < 0 ? 0 : len;
        maxLen = maxLen > 4 ? 4 : maxLen;
        int shifter = (maxLen - 1) * 8;
        int retVal = 0;
        int i = 0;
        while (i < len) {
            retVal |= this.convertUnsignedByteToInt(data[offset + i]) << shifter;
            shifter -= 8;
            ++i;
        }
        return retVal;
    }

    private void getVehicleRegistrationNumber(byte[] data) {
        try {
            byte[] vrnByteArray = new byte[13];
            byte[] vin = new byte[17];
            int indexoriginal = 0;
            int indexnew = 0;
            int StartOfVehReg = 409;
            int StartVIN = 390;
            boolean ValidDate = false;
            byte codePage = data[408];
            while (indexoriginal < 13) {
                if (data[StartOfVehReg + indexoriginal] == 0) {
                    ++indexoriginal;
                    continue;
                }
                vrnByteArray[indexnew] = data[StartOfVehReg + indexoriginal];
                ++indexoriginal;
                ++indexnew;
            }
            indexoriginal = 0;
            indexnew = 0;
            while (indexoriginal < 17) {
                if (data[StartVIN + indexoriginal] == 0) {
                    ++indexoriginal;
                    continue;
                }
                vin[indexnew] = data[StartVIN + indexoriginal];
                ++indexoriginal;
                ++indexnew;
            }
            indexoriginal = 0;
            indexnew = 0;
            byte vNation = data[StartOfVehReg - 2];
            String strEncoding = "";
            switch (codePage) {
                case 2: {
                    strEncoding = "ISO-8859-2";
                    break;
                }
                case 3: {
                    strEncoding = "ISO-8859-3";
                    break;
                }
                case 5: {
                    strEncoding = "ISO-8859-5";
                    break;
                }
                case 7: {
                    strEncoding = "ISO-8859-7";
                    break;
                }
                case 9: {
                    strEncoding = "ISO-8859-9";
                    break;
                }
                case 13: {
                    strEncoding = "ISO-8859-13";
                    break;
                }
                case 15: {
                    strEncoding = "ISO-8859-15";
                    break;
                }
                case 16: {
                    strEncoding = "Windows-1250";
                    break;
                }
                case 80: {
                    strEncoding = "Cyrillic";
                    break;
                }
                case 85: {
                    strEncoding = "Cyrillic";
                    break;
                }
                default: {
                    strEncoding = "ISO-8859-1";
                }
            }
            Charset c = Charset.forName(strEncoding);
            this.sVRN = new String(vrnByteArray, c);
            this.sVIN = new String(vin, c);
            this.sVehMemberState = RenameFile.GetNumeric((char)vNation);
            int seconds = 0;
            try {
                seconds = this.convertUnsignedByteArrayToInt(data, 423, 4);
                logger.debug((Object)("Seconds from file:::" + seconds));
                this.cLocal.setTimeInMillis((long)seconds * 1000L);
                logger.debug((Object)("FileDate local:::" + this.cLocal.getTime()));
                this.cLocal.setTime(this.getUTCTIME(this.cLocal));
                logger.debug((Object)("UTCTime in file:::" + this.cLocal.getTime()));
                if (this.cLocal != null && this.cLocal.get(1) > 2000) {
                    ValidDate = true;
                }
            }
            catch (Exception exp) {
                logger.error((Object)("Exception in " + exp.getMessage()));
                exp.printStackTrace();
            }
            if (!ValidDate) {
                logger.debug((Object)"Date field not found");
                this.cLocal = null;
            }
            logger.debug((Object)("VIN::: " + this.sVIN));
            logger.debug((Object)("nation::: " + this.sVehMemberState));
            logger.debug((Object)("strVehicleRegNumber::: " + this.sVRN));
        }
        catch (Exception ex) {
            logger.error((Object)"Couldn't extract from file contents", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    public int getFileType(byte[] DataBlock) {
        int iFileType;
        try {
            int iNoOfBytes;
            logger.debug((Object)(DataBlock == null ? "DataBlock is null" : "DataBlock.length::: " + DataBlock.length));
            char cFirstByte = (char)DataBlock[0];
            char cSecondByte = (char)DataBlock[1];
            logger.debug((Object)("cFirstByte::: " + cFirstByte));
            logger.debug((Object)("cSecondByte::: " + cSecondByte));
            if (cFirstByte == 'v' && cSecondByte == '\u0006') {
                cFirstByte = (char)DataBlock[2];
                cSecondByte = (char)DataBlock[3];
            }
            iFileType = cFirstByte == 'v' ? (cSecondByte == '\u0001' ? ((iNoOfBytes = 493 + (1 + DataBlock[493] * 98) + (1 + DataBlock[494 + DataBlock[493] * 98] * 31) + 128) >= DataBlock.length ? 130 : (DataBlock[iNoOfBytes] == 118 && DataBlock[iNoOfBytes + 1] >= 17 && DataBlock[iNoOfBytes + 1] <= 21 ? 131 : 130)) : 0) : (cFirstByte == '\u0000' && (cSecondByte == '\u0002' || cSecondByte == '\u0005') ? 129 : (cFirstByte == '\u00c1' && (cSecondByte == '\u0000' || cSecondByte == '\b') ? 129 : (cFirstByte == '\u0005' && cSecondByte >= '\u0001' && cSecondByte <= '\b' ? 129 : (cFirstByte == '\u0005' && (cSecondByte == ' ' || cSecondByte == '\u000e' || cSecondByte == '!' || cSecondByte == '\"') ? 129 : 0))));
        }
        catch (Exception exp) {
            return -1;
        }
        return iFileType;
    }

    public static String GetNumeric(char cNumericCode) {
        String[] csArrayNation = new String[]{"_", "A", "AL", "AND", "ARM", "AZ", "B", "BG", "BIH", "BY", "CH", "CY", "CZ", "D", "DK", "E", "EST", "F", "FIN", "FL", "FR", "UK", "GE", "GR", "H", "HR", "I", "IRL", "IS", "KZ", "L", "LT", "LV", "M", "MC", "MD", "MK", "N", "NL", "P", "PL", "RO", "RSM", "RUS", "S", "SK", "SLO", "TM", "TR", "UA", "V", "YU", "UNK", "EC", "EUR", "WLD"};
        String csNation = cNumericCode >= '4' && cNumericCode <= '\u00fc' ? "UNK" : (cNumericCode == '\u00fd' ? "EC" : (cNumericCode == '\u00fe' ? "EUR" : (cNumericCode == '\u00ff' ? "WLD" : csArrayNation[cNumericCode])));
        return csNation;
    }

    private static String ReplaceNotAllowedChar(String FileNameToRename) {
        FileNameToRename = FileNameToRename.replace("\\", "-");
        FileNameToRename = FileNameToRename.replace("/", "-");
        FileNameToRename = FileNameToRename.replace(":", "-");
        FileNameToRename = FileNameToRename.replace("*", "-");
        FileNameToRename = FileNameToRename.replace("?", "-");
        FileNameToRename = FileNameToRename.replace("<", "-");
        FileNameToRename = FileNameToRename.replace(">", "-");
        FileNameToRename = FileNameToRename.replace("|", "-");
        FileNameToRename = FileNameToRename.replace("\"", "-");
        return FileNameToRename;
    }

    private static String ReplaceAllowedChar(String FileNameToRename) {
        String strValid = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int ilength = FileNameToRename.length();
        int i = 0;
        while (i < ilength) {
            if (strValid.indexOf(String.valueOf(FileNameToRename.charAt(i))) == -1) {
                FileNameToRename = FileNameToRename.replaceFirst(String.valueOf(FileNameToRename.charAt(i)), "_");
            }
            ++i;
        }
        return FileNameToRename;
    }

    private Date getUTCTIME(Calendar cLocal) {
        Date dstDate;
        Date dtLocal;
        Date ret;
        TimeZone tz = TimeZone.getDefault();
        if (tz.inDaylightTime(ret = new Date((dtLocal = cLocal.getTime()).getTime() - (long)tz.getRawOffset())) && tz.inDaylightTime(dstDate = new Date(ret.getTime() - (long)tz.getDSTSavings()))) {
            ret = dstDate;
        }
        logger.debug((Object)("UTCTime:::" + ret));
        return ret;
    }
}

