/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.Utility;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigUtil {
    static Properties prProperty = new Properties();
    static Properties prPropertyForProxy = new Properties();
    private static final Logger logger = Logger.getLogger(ConfigUtil.class);

    public static String getValue(String key) {
        String strValue = null;
        try {
            if (prProperty.size() == 0) {
                prProperty.load(new Object().getClass().getResourceAsStream("/config/integration.properties"));
            }
            strValue = prProperty.getProperty(key);
        }
        catch (Exception exp) {
            logger.error((Object)"Exception in getValue method of ConfiUtil:", (Throwable)exp);
            return null;
        }
        return strValue != null ? strValue.trim() : strValue;
    }

    public static String getValueForProxy(String key) {
        String strValue = "";
        try {
            if (prPropertyForProxy.size() == 0) {
                String ProxyFilePath = ConfigUtil.getValue("ProxySettingFilePath");
                logger.debug((Object)("ProxyFilePath:-->" + ProxyFilePath));
                prPropertyForProxy.load(new Object().getClass().getResourceAsStream(ProxyFilePath));
            }
            strValue = prPropertyForProxy.getProperty(key);
        }
        catch (Exception exp) {
            logger.error((Object)"Exception in getValueForProxy method of ConfiUtil:", (Throwable)exp);
            return null;
        }
        return strValue != null ? strValue.trim() : "";
    }

    public static String getUserSettingsValue(String strFilePath, String key) {
        String value = null;
        try {
            FileInputStream fis = new FileInputStream(strFilePath);
            Properties props = new Properties();
            props.load(fis);
            value = props.getProperty(key);
            if (value != null) {
                value = value.trim();
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"FileNotFoundException in getUserSettingsValue method of ConfiUtil:", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getUserSettingsValue method of ConfiUtil:", (Throwable)e);
        }
        return value;
    }

    public static void cleanup(Connection conn, Statement stmt, ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }

    public static void cleanup(Connection conn, Statement stmt) throws SQLException {
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static byte[] stringToByte(String value) {
        byte[] bValue = null;
        try {
            bValue = String.valueOf(value).getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bValue;
    }

    public static byte[] getPassKey() {
        byte[] byteArr = null;
        String keyValue = ConfigUtil.jumbleStringEncrypt("CYDkVKDXOXSDXYm");
        byteArr = ConfigUtil.stringToByte(keyValue);
        return byteArr;
    }

    public static String executeVolCommand() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            Process pb = new ProcessBuilder("cmd", "/c", "vol").start();
            InputStream in = pb.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                buffer.append(String.valueOf(line) + NEWLINE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String jumbleStringEncrypt(String strInput) {
        StringBuffer strInputBuffer = new StringBuffer(strInput);
        String strInputReverse = strInputBuffer.reverse().toString();
        char[] chars = strInputReverse.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            sb.append(ConfigUtil.getEncryptedJumbleChar(chars[i]));
            ++i;
        }
        String strReturn = sb.toString();
        return strReturn;
    }

    public static char getEncryptedJumbleChar(char inputChar) {
        int jumbleChar = inputChar;
        switch (inputChar) {
            case 97: {
                jumbleChar = 75;
                break;
            }
            case 98: {
                jumbleChar = 76;
                break;
            }
            case 99: {
                jumbleChar = 77;
                break;
            }
            case 100: {
                jumbleChar = 78;
                break;
            }
            case 101: {
                jumbleChar = 79;
                break;
            }
            case 102: {
                jumbleChar = 80;
                break;
            }
            case 103: {
                jumbleChar = 81;
                break;
            }
            case 104: {
                jumbleChar = 82;
                break;
            }
            case 105: {
                jumbleChar = 83;
                break;
            }
            case 106: {
                jumbleChar = 84;
                break;
            }
            case 107: {
                jumbleChar = 85;
                break;
            }
            case 108: {
                jumbleChar = 86;
                break;
            }
            case 109: {
                jumbleChar = 87;
                break;
            }
            case 110: {
                jumbleChar = 88;
                break;
            }
            case 111: {
                jumbleChar = 89;
                break;
            }
            case 112: {
                jumbleChar = 90;
                break;
            }
            case 113: {
                jumbleChar = 65;
                break;
            }
            case 114: {
                jumbleChar = 66;
                break;
            }
            case 115: {
                jumbleChar = 67;
                break;
            }
            case 116: {
                jumbleChar = 68;
                break;
            }
            case 117: {
                jumbleChar = 69;
                break;
            }
            case 118: {
                jumbleChar = 70;
                break;
            }
            case 119: {
                jumbleChar = 71;
                break;
            }
            case 120: {
                jumbleChar = 72;
                break;
            }
            case 121: {
                jumbleChar = 73;
                break;
            }
            case 122: {
                jumbleChar = 74;
                break;
            }
            case 65: {
                jumbleChar = 107;
                break;
            }
            case 66: {
                jumbleChar = 108;
                break;
            }
            case 67: {
                jumbleChar = 109;
                break;
            }
            case 68: {
                jumbleChar = 110;
                break;
            }
            case 69: {
                jumbleChar = 111;
                break;
            }
            case 70: {
                jumbleChar = 112;
                break;
            }
            case 71: {
                jumbleChar = 113;
                break;
            }
            case 72: {
                jumbleChar = 114;
                break;
            }
            case 73: {
                jumbleChar = 115;
                break;
            }
            case 74: {
                jumbleChar = 116;
                break;
            }
            case 75: {
                jumbleChar = 117;
                break;
            }
            case 76: {
                jumbleChar = 118;
                break;
            }
            case 77: {
                jumbleChar = 119;
                break;
            }
            case 78: {
                jumbleChar = 120;
                break;
            }
            case 79: {
                jumbleChar = 121;
                break;
            }
            case 80: {
                jumbleChar = 122;
                break;
            }
            case 81: {
                jumbleChar = 97;
                break;
            }
            case 82: {
                jumbleChar = 98;
                break;
            }
            case 83: {
                jumbleChar = 99;
                break;
            }
            case 84: {
                jumbleChar = 100;
                break;
            }
            case 85: {
                jumbleChar = 101;
                break;
            }
            case 86: {
                jumbleChar = 102;
                break;
            }
            case 87: {
                jumbleChar = 103;
                break;
            }
            case 88: {
                jumbleChar = 104;
                break;
            }
            case 89: {
                jumbleChar = 105;
                break;
            }
            case 90: {
                jumbleChar = 106;
                break;
            }
            case 48: {
                jumbleChar = 41;
                break;
            }
            case 49: {
                jumbleChar = 33;
                break;
            }
            case 50: {
                jumbleChar = 64;
                break;
            }
            case 51: {
                jumbleChar = 35;
                break;
            }
            case 52: {
                jumbleChar = 36;
                break;
            }
            case 53: {
                jumbleChar = 37;
                break;
            }
            case 54: {
                jumbleChar = 94;
                break;
            }
            case 55: {
                jumbleChar = 38;
                break;
            }
            case 56: {
                jumbleChar = 42;
                break;
            }
            case 57: {
                jumbleChar = 40;
                break;
            }
            case 63: {
                jumbleChar = 47;
                break;
            }
            case 41: {
                jumbleChar = 48;
                break;
            }
            case 33: {
                jumbleChar = 49;
                break;
            }
            case 64: {
                jumbleChar = 50;
                break;
            }
            case 35: {
                jumbleChar = 51;
                break;
            }
            case 36: {
                jumbleChar = 52;
                break;
            }
            case 37: {
                jumbleChar = 53;
                break;
            }
            case 94: {
                jumbleChar = 54;
                break;
            }
            case 38: {
                jumbleChar = 55;
                break;
            }
            case 42: {
                jumbleChar = 56;
                break;
            }
            case 40: {
                jumbleChar = 57;
                break;
            }
            case 47: {
                jumbleChar = 63;
            }
        }
        return (char)jumbleChar;
    }
}

