/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.Utility;

import com.sisl.dtco.Utility.ScheduleIterator;
import java.util.Calendar;
import java.util.Date;

public class DailyIterator
implements ScheduleIterator {
    private final int hourOfDay;
    private final int minute;
    private final int second;
    private final Calendar calendar = Calendar.getInstance();

    public DailyIterator(int hourOfDay, int minute, int second) {
        this(hourOfDay, minute, second, new Date());
    }

    public DailyIterator(int hourOfDay, int minute, int second, Date date) {
        this.hourOfDay = hourOfDay;
        this.minute = minute;
        this.second = second;
        this.calendar.setTime(date);
        this.calendar.set(11, hourOfDay);
        this.calendar.set(12, minute);
        this.calendar.set(13, second);
        this.calendar.set(14, 0);
        if (!this.calendar.getTime().before(date)) {
            this.calendar.add(5, -1);
        }
    }

    @Override
    public Date next() {
        this.calendar.add(5, 1);
        return this.calendar.getTime();
    }
}

