/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.Utility;

import com.sisl.dldcomm.util.RenameFile;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.exceptions.AuthenticationModuleException;
import com.sisl.dtco.integration.AccountManagement;
import com.sisl.dtco.integration.UIFileHandler;
import com.sisl.dtco.vo.CustomerRequestListVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import com.sisl.dtco.vo.RequestListVO;
import com.sisl.dtco.vo.UserSettingsDetailsUIVO;
import com.sisl.dtco.vo.XMLObject;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.tempuri.AccountsDetailsXMLChild;

public class GeneralAPI {
    private static final Logger logger = Logger.getLogger(GeneralAPI.class);
    static byte[] byteArr = null;

    static {
        String keyValue = GeneralAPI.jumbleStringEncrypt("CYDkVKDXOXSDXYm");
        byteArr = GeneralAPI.convertStringToByte(keyValue);
    }

    public static void removeLineFromFile(String file, String lineToRemove, String command) throws Exception {
        try {
            boolean check = false;
            File inFile = new File(file);
            if (!inFile.isFile()) {
                return;
            }
            File tempFile = new File(String.valueOf(inFile.getAbsolutePath()) + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(file));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0 || line.indexOf(",") == -1) {
                    pw.println(line);
                    pw.flush();
                    continue;
                }
                String[] tknLineData = line.split(",");
                String compared = "";
                if (command.equalsIgnoreCase("DLVH")) {
                    compared = tknLineData[0];
                }
                if (command.equalsIgnoreCase("DLDR")) {
                    compared = String.valueOf(tknLineData[1]) + tknLineData[3];
                }
                if (command.equalsIgnoreCase("deleteDevice")) {
                    compared = tknLineData[0];
                }
                if (compared.equalsIgnoreCase(lineToRemove)) {
                    check = true;
                    continue;
                }
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!inFile.delete()) {
                logger.debug((Object)"Could not delete file");
                throw new AuthenticationModuleException("File be used by some other resource :7");
            }
            if (!tempFile.renameTo(inFile)) {
                logger.debug((Object)"Could not rename file");
            }
            if (!check) {
                throw new AuthenticationModuleException("Record has already been deleted by some other user:5");
            }
        }
        catch (AuthenticationModuleException amex) {
            throw amex;
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)"Exception in removeLineFromFile method of class generaAPI", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)"Exception in removeLineFromFile method of class generaAPI", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in removeLineFromFile method of class generaAPI", (Throwable)ex);
        }
    }

    public static Object xmlToObject(ArrayList<XMLObject> objectInfo, String strXml) {
        XStream xstream = new XStream();
        Iterator<XMLObject> itr = objectInfo.iterator();
        XMLObject objXml = null;
        Object obj = null;
        try {
            while (itr.hasNext()) {
                objXml = itr.next();
                xstream.alias(objXml.getAlias(), objXml.getClassName());
            }
        }
        catch (Exception e) {
            logger.error((Object)("The Exception is" + e));
        }
        try {
            obj = xstream.fromXML(strXml);
        }
        catch (Exception e) {
            logger.error((Object)("The Exception is" + e));
        }
        return obj;
    }

    public static String getTisURL() {
        String tisURL = ConfigUtil.getUserSettingsValue(ConfigUtil.getValue("UserSettingsDetailsPath"), "urlTW").trim();
        String ip = tisURL.split("//")[1].split("/")[0];
        String finalURL = String.valueOf(tisURL.split("//")[0]) + "//" + ip + "/DownloadDueWS/DownloadDueWS.asmx?WSDL";
        logger.debug((Object)finalURL);
        return finalURL;
    }

    public static String getRSURL(String rsURL) {
        String virtualDirectoryRSIF06 = ConfigUtil.getValue("VirtualDirectoryRSIF06");
        String finalURL = String.valueOf(rsURL) + "/" + virtualDirectoryRSIF06;
        logger.debug((Object)finalURL);
        return finalURL;
    }

    public static String getRS2URL() {
        String rs2URL = ConfigUtil.getUserSettingsValue(ConfigUtil.getValue("UserSettingsDetailsPath"), "urlRS2").trim();
        String virtualDirectoryRS2IF06 = ConfigUtil.getValue("VirtualDirectoryRSIF06");
        String finalURL = String.valueOf(rs2URL) + "/" + virtualDirectoryRS2IF06;
        logger.debug((Object)finalURL);
        return finalURL;
    }

    public static String getFileName() {
        Calendar objCal = Calendar.getInstance();
        SimpleDateFormat dtFormat = new SimpleDateFormat("dd-MM-yyyy");
        String strDate = dtFormat.format(objCal.getTime());
        String strFileName = String.valueOf(ConfigUtil.getValue("STATUSFILEPATH")) + strDate;
        return strFileName;
    }

    public static int getCurrentDateTimeInt() {
        Calendar objCal = Calendar.getInstance();
        long timeSec = objCal.getTimeInMillis();
        int intTime = (int)(timeSec / 1000L);
        return intTime;
    }

    public static String getCurrentDate(String strDateFormat) {
        Calendar objCal = Calendar.getInstance();
        SimpleDateFormat dtFormat = strDateFormat == null || strDateFormat.trim().length() == 0 ? new SimpleDateFormat("dd-MM-yyyy") : new SimpleDateFormat(strDateFormat);
        String strDateTime = dtFormat.format(objCal.getTime());
        return strDateTime;
    }

    public static String getCurrentDateTime() {
        Calendar objCal = Calendar.getInstance();
        SimpleDateFormat dtFormat = new SimpleDateFormat("EEE dd.MM.yyyy HH:mm");
        String strDateTime = dtFormat.format(objCal.getTime());
        return strDateTime;
    }

    public static Date toDate(String strDate, String strDateFormat) throws ParseException {
        SimpleDateFormat dtDateFormat = new SimpleDateFormat(strDateFormat);
        Date objDate = dtDateFormat.parse(strDate);
        return objDate;
    }

    public static Date addNumberOfDays(Date d, int days) {
        try {
            SimpleDateFormat dtDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            String sDate = dtDateFormat.format(d);
            d = dtDateFormat.parse(sDate);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            c.add(5, days);
            d = c.getTime();
            d = dtDateFormat.parse(dtDateFormat.format(d));
        }
        catch (ParseException e) {
            logger.error((Object)("Exception in Date Parsing GeneralAPI : :" + e));
        }
        return d;
    }

    public static Date addMinutes(Date date, int minutes) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(12, minutes);
        date = c.getTime();
        return date;
    }

    public static int compareDates(Date Date1) {
        int iStatus = 0;
        try {
            Date Date2 = new Date();
            SimpleDateFormat dtDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            String sDate2 = dtDateFormat.format(Date2);
            Date objDate2 = dtDateFormat.parse(sDate2);
            iStatus = Date1.compareTo(objDate2);
        }
        catch (ParseException objPex) {
            logger.error((Object)("ParseException in compareDates method of GeneralAPI class " + objPex));
            iStatus = 0;
        }
        catch (Exception objExp) {
            logger.error((Object)("Exception in compareDates method of GeneralAPI class" + objExp));
            iStatus = 0;
        }
        return iStatus;
    }

    public static String getDateToString(Date objDate, String strDateFormat) throws Exception {
        if (objDate != null) {
            try {
                SimpleDateFormat dtFormat = new SimpleDateFormat(strDateFormat);
                return dtFormat.format(objDate);
            }
            catch (Exception objExp) {
                logger.error((Object)("ParseException in getDateToString method of GeneralAPI class" + objExp));
                throw new Exception(objExp.toString());
            }
        }
        return "";
    }

    public static String objectToXml(Object object, ArrayList<XMLObject> objectInfo) {
        XStream xstream = new XStream();
        Iterator<XMLObject> itr = objectInfo.iterator();
        XMLObject objXml = null;
        Object obj = null;
        try {
            objXml = objectInfo.get(0);
            obj = objXml.getClass().newInstance();
            obj = object;
            int count = 0;
            while (itr.hasNext()) {
                logger.debug((Object)("Inside objectToXml... while loop.. count is =" + count));
                objXml = itr.next();
                xstream.alias(objXml.getAlias(), objXml.getClassName());
                ++count;
            }
        }
        catch (Exception e) {
            logger.error((Object)("in objectToXml of InvokeRemoteDevice : and the Exception is :: " + e));
        }
        return xstream.toXML(obj);
    }

    public static String addXmlHeader(String strXml) {
        String strNewXml = "";
        strNewXml = strXml.contains("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") ? strXml : "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + strXml;
        return strNewXml;
    }

    public static String removeXmlHeader(String strXml) {
        String[] str1 = strXml.split(">", 2);
        return str1[1];
    }

    public static Socket getClientSocketConnection() {
        Socket connect = null;
        try {
            String host = "127.0.0.1";
            int port = Integer.parseInt(Application.objServiceInfo.getSCommunicatorServicePortForBrowserAndAuth());
            logger.debug((Object)(" in general api : port for sending TMDl: " + port));
            InetAddress address = InetAddress.getByName(host);
            if (address == null) {
                logger.debug((Object)"Address : null");
            }
            connect = new Socket(address, port);
            logger.debug((Object)("Connection with COMM on port established:" + port));
        }
        catch (BindException b) {
            connect = null;
            logger.error((Object)"Exception iin getClientSocketConnection in generalAPI:: Exception while establishing connection :Binding Exception");
        }
        catch (ConnectException ce) {
            connect = null;
            logger.error((Object)"Exception iin getClientSocketConnection in generalAPI:: Exception while establishing connection :Server is not running");
        }
        catch (IOException f) {
            logger.error((Object)("Exception iin getClientSocketConnection in generalAPI:: IOException: " + f));
        }
        catch (Exception g) {
            logger.error((Object)("Exception iin getClientSocketConnection in generalAPI:: Exception: " + g));
        }
        return connect;
    }

    public static String getTokenValueByIndex(String strEntityID, int index) {
        String indexValue = "";
        FileInputStream fis = null;
        RandomAccessFile raf = null;
        try {
            String[] entityId = strEntityID.split("#", -1);
            raf = new RandomAccessFile(String.valueOf(GeneralAPI.getFileName()) + ".txt", "rw");
            fis = new FileInputStream(String.valueOf(GeneralAPI.getFileName()) + ".txt");
            InputStreamReader ind = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader brd = new BufferedReader(ind);
            String lineData = "";
            block17: while ((lineData = brd.readLine()) != null) {
                String[] tknLineData = lineData.split(",", -1);
                int j = 0;
                while (j < entityId.length) {
                    if (tknLineData[0].equalsIgnoreCase(entityId[j])) {
                        indexValue = tknLineData[index];
                        continue block17;
                    }
                    ++j;
                }
            }
            if (indexValue == null || indexValue.length() == 0) {
                indexValue = "0";
            }
            String string = indexValue;
            return string;
        }
        catch (Exception ex) {
            logger.error((Object)"In getTokenValueByIndex method of General API ", (Throwable)ex);
            return "0";
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error in File input stream", (Throwable)e);
                }
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while closing random access file", (Throwable)e);
                }
            }
        }
    }

    public static void closeSocketConnection(DTCOCommandVO objDTCOCommandVO) {
        Socket connection = objDTCOCommandVO.getConnection();
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SocketException se) {
            logger.error((Object)("Exception while closing socket connection" + se));
        }
        catch (IOException e) {
            logger.error((Object)("Exception in closing socket connection" + e));
        }
    }

    public static Socket getRDSServerConnection() {
        Socket connect = null;
        try {
            String host = Application.objServiceInfo.getSRDSHost();
            int port = Integer.parseInt(Application.objServiceInfo.getSRDSPort());
            logger.debug((Object)(" RDSServer host and port  in  GeneralAPI for sending CSVS: " + host + " , " + port));
            InetAddress address = InetAddress.getByName(host);
            if (address == null) {
                logger.debug((Object)"Address : null");
            }
            connect = new Socket(address, port);
        }
        catch (BindException b) {
            connect = null;
            logger.error((Object)"Exception in getRDSServerConnection in generalAPI:: Exception while establishing connection :Binding Exception");
        }
        catch (ConnectException ce) {
            connect = null;
            logger.error((Object)"Exception in getRDSServerConnection in generalAPI:: Exception while establishing connection :Server is not running");
        }
        catch (IOException f) {
            logger.error((Object)("Exception in getRDSServerConnection in generalAPI:: IOException: " + f));
        }
        catch (Exception g) {
            logger.error((Object)("Exception in getRDSServerConnection in generalAPI:: Exception: " + g));
        }
        return connect;
    }

    public static Socket getRDSServerConnectionForAuthentication() {
        Socket connect = null;
        try {
            String host = Application.objServiceInfo.getSRDSHost();
            int port = Integer.parseInt(Application.objServiceInfo.getSRDSPort());
            logger.debug((Object)(" getRDSServerConnectionForAuthentication Host And Port:: " + host + " , " + port));
            InetAddress address = InetAddress.getByName(host);
            if (address == null) {
                logger.debug((Object)"Address : null");
            }
            connect = new Socket(address, port);
        }
        catch (BindException b) {
            connect = null;
            logger.error((Object)"Exception in getRDSServerConnectionForAuthentication in generalAPI:: Exception while establishing connection :Binding Exception");
        }
        catch (ConnectException ce) {
            connect = null;
            logger.error((Object)"Exception in getRDSServerConnectionForAuthentication in generalAPI:: Exception while establishing connection :Server is not running");
        }
        catch (IOException f) {
            logger.error((Object)("Exception in getRDSServerConnectionForAuthentication in generalAPI:: IOException: " + f));
        }
        catch (Exception g) {
            logger.error((Object)("Exception in getRDSServerConnectionForAuthentication in generalAPI:: Exception: " + g));
        }
        return connect;
    }

    public static synchronized String showMessage(int i, String port) {
        String message = "";
        try {
            logger.debug((Object)("Message code to be added in list:" + i));
            switch (i) {
                case 1: {
                    message = "1, ";
                    break;
                }
                case 2: {
                    message = "2, ";
                    break;
                }
                case 3: {
                    message = "3, ";
                    break;
                }
                case 4: {
                    message = "4, ";
                    break;
                }
                case 5: {
                    message = "5, ";
                    break;
                }
                case 6: {
                    message = "6, ";
                    break;
                }
                case 7: {
                    message = "7, ";
                    break;
                }
                case 8: {
                    message = "8, ";
                    break;
                }
                case 9: {
                    message = "9, ";
                    break;
                }
                case 10: {
                    message = "10, ";
                    break;
                }
                case 11: {
                    message = "11, ";
                    break;
                }
                case 12: {
                    message = "12, ";
                    break;
                }
                case 13: {
                    message = "13, ";
                    break;
                }
                case 14: {
                    message = "14, ";
                    break;
                }
                case 15: {
                    message = "15, ";
                    break;
                }
                case 16: {
                    message = "16, ";
                    break;
                }
                case 17: {
                    message = "17, ";
                    break;
                }
                case 18: {
                    message = "18, ";
                    break;
                }
                case 19: {
                    message = "19, ";
                    break;
                }
                case 20: {
                    message = "20, ";
                }
            }
            message = i == 10 ? String.valueOf(message) + GeneralAPI.getCurrentDateTimeInt() + "," + port + System.getProperty("line.separator") : String.valueOf(message) + GeneralAPI.getCurrentDateTimeInt() + System.getProperty("line.separator");
        }
        catch (Exception ex) {
            logger.error((Object)("Error in showMessage method of general API " + ex));
        }
        return message;
    }

    private static byte[] getDriverCoDriverData() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(3);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception while flushing ByteArrayOutputStream in getDriverCoDriverData method of GeneralAPI class", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private static byte[] getBytes(byte hexcode) {
        ByteArrayOutputStream bs1 = new ByteArrayOutputStream();
        bs1.write(hexcode);
        try {
            bs1.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception in get bytes method of DTCOCommandHelper:", (Throwable)e);
        }
        byte[] remMessage1 = bs1.toByteArray();
        return remMessage1;
    }

    public static RequestListVO[] getRequestListVO() throws Exception {
        FileInputStream fis = null;
        String strRequestList = "";
        String strFileName = "";
        try {
            strFileName = String.valueOf(ConfigUtil.getValue("PersistRequestXMLFile")) + ".xml";
            fis = new FileInputStream(strFileName);
            int x = fis.available();
            byte[] b = new byte[x];
            fis.read(b);
            strRequestList = new String(b);
            logger.debug((Object)("Request List:" + strRequestList));
        }
        catch (FileNotFoundException e1) {
            logger.error((Object)("File Not Found Exception" + e1));
            throw e1;
        }
        catch (IOException e1) {
            logger.error((Object)("IO Exception" + e1));
            throw e1;
        }
        XStream objXStream1 = new XStream();
        Object objRequest = null;
        objXStream1.alias("CustomerRequestListVO", CustomerRequestListVO.class);
        objXStream1.alias("RequestListVO", RequestListVO.class);
        try {
            objRequest = objXStream1.fromXML(strRequestList);
        }
        catch (Exception e) {
            logger.error((Object)("Not able to parse xml string" + e));
            throw e;
        }
        CustomerRequestListVO objCustomerRequestListVO = (CustomerRequestListVO)objRequest;
        RequestListVO[] objRequestListVO = objCustomerRequestListVO.getRequestList();
        return objRequestListVO;
    }

    public static String decryptString(String str) {
        String key = "Encrypt";
        StringBuffer sb = new StringBuffer(str);
        int lenStr = str.length();
        int lenKey = key.length();
        int i = 0;
        int j = 0;
        while (i < lenStr) {
            if (j >= lenKey) {
                j = 0;
            }
            sb.setCharAt(i, (char)(str.charAt(i) ^ key.charAt(j)));
            ++i;
            ++j;
        }
        return sb.toString();
    }

    public static String jumbleString(String strInput) {
        StringBuffer strInputBuffer = new StringBuffer(strInput);
        String strInputReverse = strInputBuffer.reverse().toString();
        char[] chars = strInputReverse.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            sb.append(GeneralAPI.getDecryptedJumbleChar(chars[i]));
            ++i;
        }
        String strReturn = sb.toString();
        return strReturn;
    }

    public static char getEncryptedJumbleChar(char inputChar) {
        int jumbleChar = inputChar;
        switch (inputChar) {
            case 97: {
                jumbleChar = 75;
                break;
            }
            case 98: {
                jumbleChar = 76;
                break;
            }
            case 99: {
                jumbleChar = 77;
                break;
            }
            case 100: {
                jumbleChar = 78;
                break;
            }
            case 101: {
                jumbleChar = 79;
                break;
            }
            case 102: {
                jumbleChar = 80;
                break;
            }
            case 103: {
                jumbleChar = 81;
                break;
            }
            case 104: {
                jumbleChar = 82;
                break;
            }
            case 105: {
                jumbleChar = 83;
                break;
            }
            case 106: {
                jumbleChar = 84;
                break;
            }
            case 107: {
                jumbleChar = 85;
                break;
            }
            case 108: {
                jumbleChar = 86;
                break;
            }
            case 109: {
                jumbleChar = 87;
                break;
            }
            case 110: {
                jumbleChar = 88;
                break;
            }
            case 111: {
                jumbleChar = 89;
                break;
            }
            case 112: {
                jumbleChar = 90;
                break;
            }
            case 113: {
                jumbleChar = 65;
                break;
            }
            case 114: {
                jumbleChar = 66;
                break;
            }
            case 115: {
                jumbleChar = 67;
                break;
            }
            case 116: {
                jumbleChar = 68;
                break;
            }
            case 117: {
                jumbleChar = 69;
                break;
            }
            case 118: {
                jumbleChar = 70;
                break;
            }
            case 119: {
                jumbleChar = 71;
                break;
            }
            case 120: {
                jumbleChar = 72;
                break;
            }
            case 121: {
                jumbleChar = 73;
                break;
            }
            case 122: {
                jumbleChar = 74;
                break;
            }
            case 65: {
                jumbleChar = 107;
                break;
            }
            case 66: {
                jumbleChar = 108;
                break;
            }
            case 67: {
                jumbleChar = 109;
                break;
            }
            case 68: {
                jumbleChar = 110;
                break;
            }
            case 69: {
                jumbleChar = 111;
                break;
            }
            case 70: {
                jumbleChar = 112;
                break;
            }
            case 71: {
                jumbleChar = 113;
                break;
            }
            case 72: {
                jumbleChar = 114;
                break;
            }
            case 73: {
                jumbleChar = 115;
                break;
            }
            case 74: {
                jumbleChar = 116;
                break;
            }
            case 75: {
                jumbleChar = 117;
                break;
            }
            case 76: {
                jumbleChar = 118;
                break;
            }
            case 77: {
                jumbleChar = 119;
                break;
            }
            case 78: {
                jumbleChar = 120;
                break;
            }
            case 79: {
                jumbleChar = 121;
                break;
            }
            case 80: {
                jumbleChar = 122;
                break;
            }
            case 81: {
                jumbleChar = 97;
                break;
            }
            case 82: {
                jumbleChar = 98;
                break;
            }
            case 83: {
                jumbleChar = 99;
                break;
            }
            case 84: {
                jumbleChar = 100;
                break;
            }
            case 85: {
                jumbleChar = 101;
                break;
            }
            case 86: {
                jumbleChar = 102;
                break;
            }
            case 87: {
                jumbleChar = 103;
                break;
            }
            case 88: {
                jumbleChar = 104;
                break;
            }
            case 89: {
                jumbleChar = 105;
                break;
            }
            case 90: {
                jumbleChar = 106;
                break;
            }
            case 48: {
                jumbleChar = 41;
                break;
            }
            case 49: {
                jumbleChar = 33;
                break;
            }
            case 50: {
                jumbleChar = 64;
                break;
            }
            case 51: {
                jumbleChar = 35;
                break;
            }
            case 52: {
                jumbleChar = 36;
                break;
            }
            case 53: {
                jumbleChar = 37;
                break;
            }
            case 54: {
                jumbleChar = 94;
                break;
            }
            case 55: {
                jumbleChar = 38;
                break;
            }
            case 56: {
                jumbleChar = 42;
                break;
            }
            case 57: {
                jumbleChar = 40;
                break;
            }
            case 63: {
                jumbleChar = 47;
                break;
            }
            case 41: {
                jumbleChar = 48;
                break;
            }
            case 33: {
                jumbleChar = 49;
                break;
            }
            case 64: {
                jumbleChar = 50;
                break;
            }
            case 35: {
                jumbleChar = 51;
                break;
            }
            case 36: {
                jumbleChar = 52;
                break;
            }
            case 37: {
                jumbleChar = 53;
                break;
            }
            case 94: {
                jumbleChar = 54;
                break;
            }
            case 38: {
                jumbleChar = 55;
                break;
            }
            case 42: {
                jumbleChar = 56;
                break;
            }
            case 40: {
                jumbleChar = 57;
                break;
            }
            case 47: {
                jumbleChar = 63;
            }
        }
        return (char)jumbleChar;
    }

    public static char getDecryptedJumbleChar(char inputChar) {
        int jumbleChar = inputChar;
        switch (inputChar) {
            case 75: {
                jumbleChar = 97;
                break;
            }
            case 76: {
                jumbleChar = 98;
                break;
            }
            case 77: {
                jumbleChar = 99;
                break;
            }
            case 78: {
                jumbleChar = 100;
                break;
            }
            case 79: {
                jumbleChar = 101;
                break;
            }
            case 80: {
                jumbleChar = 102;
                break;
            }
            case 81: {
                jumbleChar = 103;
                break;
            }
            case 82: {
                jumbleChar = 104;
                break;
            }
            case 83: {
                jumbleChar = 105;
                break;
            }
            case 84: {
                jumbleChar = 106;
                break;
            }
            case 85: {
                jumbleChar = 107;
                break;
            }
            case 86: {
                jumbleChar = 108;
                break;
            }
            case 87: {
                jumbleChar = 109;
                break;
            }
            case 88: {
                jumbleChar = 110;
                break;
            }
            case 89: {
                jumbleChar = 111;
                break;
            }
            case 90: {
                jumbleChar = 112;
                break;
            }
            case 65: {
                jumbleChar = 113;
                break;
            }
            case 66: {
                jumbleChar = 114;
                break;
            }
            case 67: {
                jumbleChar = 115;
                break;
            }
            case 68: {
                jumbleChar = 116;
                break;
            }
            case 69: {
                jumbleChar = 117;
                break;
            }
            case 70: {
                jumbleChar = 118;
                break;
            }
            case 71: {
                jumbleChar = 119;
                break;
            }
            case 72: {
                jumbleChar = 120;
                break;
            }
            case 73: {
                jumbleChar = 121;
                break;
            }
            case 74: {
                jumbleChar = 122;
                break;
            }
            case 107: {
                jumbleChar = 65;
                break;
            }
            case 108: {
                jumbleChar = 66;
                break;
            }
            case 109: {
                jumbleChar = 67;
                break;
            }
            case 110: {
                jumbleChar = 68;
                break;
            }
            case 111: {
                jumbleChar = 69;
                break;
            }
            case 112: {
                jumbleChar = 70;
                break;
            }
            case 113: {
                jumbleChar = 71;
                break;
            }
            case 114: {
                jumbleChar = 72;
                break;
            }
            case 115: {
                jumbleChar = 73;
                break;
            }
            case 116: {
                jumbleChar = 74;
                break;
            }
            case 117: {
                jumbleChar = 75;
                break;
            }
            case 118: {
                jumbleChar = 76;
                break;
            }
            case 119: {
                jumbleChar = 77;
                break;
            }
            case 120: {
                jumbleChar = 78;
                break;
            }
            case 121: {
                jumbleChar = 79;
                break;
            }
            case 122: {
                jumbleChar = 80;
                break;
            }
            case 97: {
                jumbleChar = 81;
                break;
            }
            case 98: {
                jumbleChar = 82;
                break;
            }
            case 99: {
                jumbleChar = 83;
                break;
            }
            case 100: {
                jumbleChar = 84;
                break;
            }
            case 101: {
                jumbleChar = 85;
                break;
            }
            case 102: {
                jumbleChar = 86;
                break;
            }
            case 103: {
                jumbleChar = 87;
                break;
            }
            case 104: {
                jumbleChar = 88;
                break;
            }
            case 105: {
                jumbleChar = 89;
                break;
            }
            case 106: {
                jumbleChar = 90;
                break;
            }
            case 48: {
                jumbleChar = 41;
                break;
            }
            case 49: {
                jumbleChar = 33;
                break;
            }
            case 50: {
                jumbleChar = 64;
                break;
            }
            case 51: {
                jumbleChar = 35;
                break;
            }
            case 52: {
                jumbleChar = 36;
                break;
            }
            case 53: {
                jumbleChar = 37;
                break;
            }
            case 54: {
                jumbleChar = 94;
                break;
            }
            case 55: {
                jumbleChar = 38;
                break;
            }
            case 56: {
                jumbleChar = 42;
                break;
            }
            case 57: {
                jumbleChar = 40;
                break;
            }
            case 63: {
                jumbleChar = 47;
                break;
            }
            case 41: {
                jumbleChar = 48;
                break;
            }
            case 33: {
                jumbleChar = 49;
                break;
            }
            case 64: {
                jumbleChar = 50;
                break;
            }
            case 35: {
                jumbleChar = 51;
                break;
            }
            case 36: {
                jumbleChar = 52;
                break;
            }
            case 37: {
                jumbleChar = 53;
                break;
            }
            case 94: {
                jumbleChar = 54;
                break;
            }
            case 38: {
                jumbleChar = 55;
                break;
            }
            case 42: {
                jumbleChar = 56;
                break;
            }
            case 40: {
                jumbleChar = 57;
                break;
            }
            case 47: {
                jumbleChar = 63;
            }
        }
        return (char)jumbleChar;
    }

    private static final byte[] reverse_order(byte[] abyte0, int i) {
        byte[] abyte1 = new byte[i];
        int byte0 = 0;
        while (byte0 <= i - 1) {
            abyte1[byte0] = abyte0[i - 1 - byte0];
            byte0 = (byte)(byte0 + 1);
        }
        return abyte1;
    }

    public static int toInt(byte[] abyte0, boolean flag) {
        int i = 0;
        if (flag) {
            abyte0 = GeneralAPI.reverse_order(abyte0, 4);
        }
        int byte0 = 0;
        while (byte0 <= 3) {
            int j;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                j = abyte0[byte0];
                j |= 0x80;
            } else {
                j = abyte0[byte0];
            }
            i |= j;
            if (byte0 < 3) {
                i <<= 8;
            }
            byte0 = (byte)(byte0 + 1);
        }
        return i;
    }

    public static final int toInt(byte[] abyte0) {
        return GeneralAPI.toInt(abyte0, false);
    }

    public static boolean moveFile(String source, String dest) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            File tempFile = new File(source);
            if (tempFile.delete()) {
                logger.debug((Object)"Tempory File Deleted.");
            } else {
                logger.debug((Object)"Tempory File could not be Deleted.");
            }
            return true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"File Not Found Exception in moveFile method of General API", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.error((Object)"I/O Exception in moveFile method of General API", (Throwable)e);
            return false;
        }
    }

    public static void copy(File source, File dest) throws IOException {
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            try {
                in = new FileInputStream(source).getChannel();
                out = new FileOutputStream(dest).getChannel();
                long size = ((FileChannel)in).size();
                MappedByteBuffer buf = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, 0L, size);
                ((FileChannel)out).write(buf);
                logger.debug((Object)"File copied to detination successfully.");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static Date dateExtractor(File aFile) {
        Date dateFormat = null;
        try {
            String fileName = aFile.getName();
            String[] tokens = null;
            String entity = null;
            if (fileName.toUpperCase().endsWith(".TGD")) {
                tokens = fileName.split("_");
                entity = String.valueOf(tokens[3]) + " " + tokens[4];
            }
            if (fileName.toUpperCase().endsWith(".DDD")) {
                tokens = fileName.split("_");
                entity = String.valueOf(tokens[1]) + " " + tokens[2];
            }
            if (fileName.toUpperCase().endsWith(".V1B")) {
                entity = fileName.substring(16, 26);
                logger.debug((Object)("Entity is :" + entity));
            }
            if (fileName.toUpperCase().endsWith(".A1B")) {
                entity = fileName.substring(18, 30);
                logger.debug((Object)("Entity is :" + entity));
            }
            if (fileName.toUpperCase().endsWith(".C1B")) {
                entity = fileName.substring(17, 27);
                logger.debug((Object)("extracted value: " + entity));
            }
            if (fileName.toUpperCase().endsWith(".DDD") || fileName.toUpperCase().endsWith(".TGD")) {
                dateFormat = new SimpleDateFormat("yyyyMMdd HHmm").parse(entity);
                logger.debug((Object)("\nDate is Ok :" + dateFormat));
            } else if (fileName.toUpperCase().endsWith(".A1B")) {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmm").parse(entity);
                logger.debug((Object)("\nDate is Ok :" + dateFormat));
            } else {
                dateFormat = new SimpleDateFormat("yyMMddHHmm").parse(entity);
                logger.debug((Object)("\nDate is Ok :" + dateFormat));
            }
        }
        catch (ParseException e) {
            logger.error((Object)"Error in parsing the date", (Throwable)e);
        }
        return dateFormat;
    }

    public static String searchValue(String strFileName, String strKey, int index) {
        String value = "";
        logger.debug((Object)("Key to be searched:" + strKey));
        try {
            FileInputStream fis = new FileInputStream(strFileName);
            InputStreamReader ind = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader brd = new BufferedReader(ind);
            String lineData = "";
            while ((lineData = brd.readLine()) != null) {
                String[] tokenData;
                if (lineData.trim().length() == 0 || lineData.indexOf(",") == -1 || !(tokenData = lineData.split(","))[0].equalsIgnoreCase(strKey)) continue;
                value = tokenData[index];
                logger.debug((Object)("Value Returned:" + value));
                return value;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"FileNotFoundException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"UnsupportedEncodingException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        logger.debug((Object)"Empty String Returned:");
        return value;
    }

    public static String searchValueInDriverDetails(String strKey, int index) {
        String value = "";
        logger.debug((Object)("Key to be searched in DriverDetails file:" + strKey));
        String fileNameDriverDetails = ConfigUtil.getValue("DriverDetailsPath");
        try {
            FileInputStream fis = new FileInputStream(fileNameDriverDetails);
            InputStreamReader ind = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader brd = new BufferedReader(ind);
            String lineData = "";
            while ((lineData = brd.readLine()) != null) {
                String[] tokenData;
                if (lineData.trim().length() == 0 || lineData.indexOf(",") == -1 || !(tokenData = lineData.split(","))[1].equalsIgnoreCase(strKey)) continue;
                value = tokenData[index];
                logger.debug((Object)("Value Returned:" + value));
                return value;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"FileNotFoundException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"UnsupportedEncodingException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException in searchValue method of GeneralAPI:", (Throwable)e);
        }
        logger.debug((Object)"Empty String Returned:");
        return value;
    }

    public static String searchLine(String strFileName, String strKey) {
        String lineData = "";
        logger.debug((Object)("Key to be searched:" + strKey));
        try {
            FileInputStream fis = null;
            int indexOut = 0;
            String prevLine = null;
            fis = new FileInputStream(strFileName);
            InputStreamReader ind = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader brd = new BufferedReader(ind);
            while ((lineData = brd.readLine()) != null) {
                String[] arrLineData;
                if (lineData.trim().length() == 0 || lineData.indexOf(",") == -1) {
                    prevLine = lineData;
                    indexOut = indexOut + lineData.length() + 2;
                    continue;
                }
                if (prevLine != null) {
                    int lenBefore = prevLine.length();
                    logger.debug((Object)("prevLine:" + prevLine));
                    String prevLineUTF = new String(prevLine.getBytes("UTF-8"));
                    int lenAfter = prevLineUTF.length();
                    indexOut += lenAfter - lenBefore;
                }
                if ((arrLineData = lineData.split(","))[0].equalsIgnoreCase(strKey)) {
                    return lineData.trim();
                }
                prevLine = lineData;
                indexOut = indexOut + lineData.length() + 2;
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"FileNotFoundException in searchLine method of GeneralAPI:", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"UnsupportedEncodingException in searchLine method of GeneralAPI:", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException in searchLine method of GeneralAPI:", (Throwable)e);
        }
        logger.debug((Object)"Empty String Returned:");
        return lineData;
    }

    public static void saveTisWebRequestList(String strRequsetList) {
        logger.debug((Object)"Saving Request List Details in UserSettings Files in case of TIS-Web : ");
        try {
            UserSettingsDetailsUIVO userSettingsVO = new UserSettingsDetailsUIVO();
            XStream objXStream1 = new XStream();
            Object objRequest = null;
            CustomerRequestListVO objCustomerRequestListVO = null;
            objXStream1.alias("CustomerRequestListVO", CustomerRequestListVO.class);
            objXStream1.alias("RequestListVO", RequestListVO.class);
            objRequest = objXStream1.fromXML(strRequsetList);
            objCustomerRequestListVO = (CustomerRequestListVO)objRequest;
            RequestListVO[] objRequestListVO = objCustomerRequestListVO.getRequestList();
            logger.debug((Object)("RequestListVO :" + objRequestListVO));
            userSettingsVO.setCmdName("USDL");
            int q = 0;
            while (q < objRequestListVO.length) {
                logger.debug((Object)("Response Data :" + objRequestListVO[q].toString()));
                byte[] data = objRequestListVO[q].getRequestData();
                if (data[0] == 3) {
                    logger.debug((Object)"Response Data  is EVENTS_AND_FAULTS ");
                    userSettingsVO.setEventsDataBlock(1);
                } else if (data[0] == 4) {
                    logger.debug((Object)"Response Data  is DETAILED_SPEED ");
                    userSettingsVO.setSpeedDataBlock(1);
                } else if (data[0] == 5) {
                    logger.debug((Object)"Response Data  is TECHNICAL_DATA ");
                    userSettingsVO.setTechnicalDataBlock(1);
                } else if (data[0] == 2) {
                    logger.debug((Object)"Response Data  is ACTIVITIES_OF_SPECIFIED_CALENDER_DAY ");
                    userSettingsVO.setActivityDataBlock(1);
                } else if (data[0] == 17) {
                    userSettingsVO.setSVSpecificDataIndicator(1);
                    logger.debug((Object)"Response Data  is SPEED_PROFILES ");
                } else if (data[0] == 25) {
                    userSettingsVO.setDetailedSpeedBlock(1);
                    logger.debug((Object)"Response Data  is HRS168_VEHICLE_DETAILED_SPEED ");
                }
                ++q;
            }
            userSettingsVO.setVehicleDataDownloadFrequency(-1);
            userSettingsVO.setVehicleDataDownloadFrequencyPeriod(-1);
            userSettingsVO.setDriverDataDownloadFrequency(-1);
            userSettingsVO.setDriverDataDownloadFrequencyPeriod(-1);
            userSettingsVO.setSpecialDataDownloadFrequency(-1);
            userSettingsVO.setSpecialDataDownloadFrequencyPeriod(-1);
            userSettingsVO.setDriverDataIndicator(-1);
            userSettingsVO.setPollingFrequency(-1);
            userSettingsVO.setDownloadDirectory(null);
            userSettingsVO.setUploadDirectory(null);
            userSettingsVO.setUploadTime(null);
            userSettingsVO.setDownloadTime(null);
            userSettingsVO.setCOMMPort_DLD(-1);
            userSettingsVO.setCOMMPort_Client(-1);
            userSettingsVO.setAuthPort_COMM(-1);
            userSettingsVO.setAuthPort_Client(-1);
            userSettingsVO.setCommandsMaxDur(-1);
            userSettingsVO.setCommServerText(null);
            userSettingsVO.setCommServerIndicator(-1);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("UserSettingsDetailsUIVO");
            objXmlObject.setClassName(UserSettingsDetailsUIVO.class);
            objArr.add(objXmlObject);
            String strUserSettingsXML = GeneralAPI.objectToXml(userSettingsVO, objArr);
            strUserSettingsXML = "?" + strUserSettingsXML;
            logger.debug((Object)("UserSettings VO created after adding ? :" + strUserSettingsXML));
            UIFileHandler uifileHandler = UIFileHandler.getInstance();
            uifileHandler.xmlRequestHandler(strUserSettingsXML);
        }
        catch (Exception e) {
            logger.error((Object)"Exception in saveTisWebRequestList method of General API", (Throwable)e);
        }
    }

    public static String getFileContents(String strFileName) {
        String strEntities = "";
        try {
            FileReader frd = new FileReader(strFileName);
            BufferedReader brd = new BufferedReader(frd);
            String strLine = "";
            while ((strLine = brd.readLine()) != null) {
                strEntities = String.valueOf(strEntities) + strLine;
            }
            frd.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        return strEntities;
    }

    public static String getFileContentsUTF8(String strFileName) {
        String strEntities = "";
        try {
            FileInputStream fis = new FileInputStream(new File(strFileName));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                strEntities = String.valueOf(strEntities) + strLine;
            }
            fis.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        logger.debug((Object)("string returned from file:" + strEntities));
        return strEntities;
    }

    public static boolean renameDownloadedFile(String strTempPath, String fileName, String strSerialID, String accName) {
        boolean fileRenamedSuccessfully;
        block59: {
            String strTempFileName = String.valueOf(strTempPath) + fileName;
            File sourceFile = new File(strTempFileName);
            String strDentinationDirectory = String.valueOf(Application.objServiceInfo.getSDataDownloadDirectory().trim()) + "\\";
            File destinationFile = null;
            FileInputStream fis = null;
            fileRenamedSuccessfully = false;
            try {
                CompanyDao objCompanyDao = CompanyDao.getInstance();
                logger.debug((Object)"Renaming File and Moving to DTCO Data Folder");
                String suffix = "";
                RenameFile objRenameFile = new RenameFile();
                fis = new FileInputStream(sourceFile);
                int iFileType = 0;
                byte[] data = new byte[fis.available()];
                try {
                    fis.read(data);
                }
                catch (Exception exp) {
                    logger.debug((Object)("FIS message:::" + exp.getMessage()));
                }
                logger.debug((Object)"before getFileType");
                iFileType = objRenameFile.getFileType(data);
                if (fis != null) {
                    fis.close();
                }
                logger.debug((Object)("iFileType::: " + iFileType));
                AccountManagement am = new AccountManagement();
                am.readAccountsXML();
                if (AccountManagement.objAccDetailsVO == null) {
                    return false;
                }
                AccountsDetailsXMLChild[] objAccountsVO = AccountManagement.objAccDetailsVO.getAccounts();
                boolean exist = false;
                String DCFileExtID = "";
                String VDOFileExtID = "";
                String VUFileExtID = "";
                if (objAccountsVO != null) {
                    int i = 0;
                    while (i < objAccountsVO.length) {
                        if (objAccountsVO[i].getAccountName().equalsIgnoreCase(accName)) {
                            DCFileExtID = new String(objAccountsVO[i].getIDCFileExtensionID());
                            VDOFileExtID = new String(objAccountsVO[i].getIVDOFileExtensionID());
                            VUFileExtID = new String(objAccountsVO[i].getIVUFileExtensionID());
                            exist = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!exist) {
                    logger.debug((Object)"Account id doesn't exists in Accounts XML in renameDownloadedFile() of GeneralAPI ");
                    return false;
                }
                try {
                    if (iFileType != 0) {
                        if (iFileType == 129) {
                            suffix = new String(DCFileExtID);
                        }
                        if (iFileType == 130) {
                            suffix = new String(VUFileExtID);
                        }
                        if (iFileType == 131) {
                            suffix = new String(VDOFileExtID);
                        }
                        int fileNameLenght = fileName.length();
                        logger.debug((Object)("suffix form file:" + suffix));
                        String strNewFileName = "";
                        logger.debug((Object)("strTempPath: " + strTempPath));
                        logger.debug((Object)("fileName: " + fileName));
                        logger.debug((Object)("suffix: " + suffix));
                        logger.debug((Object)("fileNameLenght: " + fileNameLenght));
                        strNewFileName = objRenameFile.rename(data, fileName, suffix, iFileType);
                        String strSuccesDestination = "";
                        logger.debug((Object)("strSerialID::: " + strSerialID));
                        File dstDirectory = null;
                        dstDirectory = new File(String.valueOf(strDentinationDirectory) + accName + "\\");
                        logger.debug((Object)("Destination directory: " + strDentinationDirectory + accName + "\\"));
                        if (!dstDirectory.isDirectory()) {
                            logger.debug((Object)"Before directory");
                            dstDirectory.mkdir();
                            logger.debug((Object)"directory created");
                        }
                        strSuccesDestination = String.valueOf(strDentinationDirectory) + accName + "\\" + strNewFileName;
                        logger.debug((Object)("strSuccesDestination::: " + strSuccesDestination));
                        logger.debug((Object)("New File Name:" + strNewFileName));
                        if (!(strNewFileName.equals("-1") || strNewFileName.equals("-2") || strNewFileName.equals("-3"))) {
                            destinationFile = new File(strSuccesDestination);
                            GeneralAPI.copy(sourceFile, destinationFile);
                            System.gc();
                            Thread.sleep(1000L);
                            if (sourceFile.delete()) {
                                logger.debug((Object)"Tempory File Deleted.");
                            } else {
                                logger.debug((Object)"Tempory File could not be Deleted.");
                            }
                            Date dateSet = GeneralAPI.dateExtractor(destinationFile);
                            logger.debug((Object)("Date is : " + dateSet));
                            boolean dateModified = destinationFile.setLastModified(dateSet.getTime());
                            logger.debug((Object)("Date Modified " + dateModified));
                            fileRenamedSuccessfully = true;
                        }
                        break block59;
                    }
                    logger.debug((Object)"Suffix not proper.");
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)"Invalid date");
                }
                catch (IOException e) {
                    logger.error((Object)"In renameDownloadedFile method:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"In renameDownloadedFile method:", (Throwable)e);
                }
                catch (Error e) {
                    logger.error((Object)"In renameDownloadedFile method:", (Throwable)e);
                }
            }
            finally {
                try {
                    logger.debug((Object)"Finally block");
                    if (fis != null) {
                        fis.close();
                    }
                    if (!fileRenamedSuccessfully) {
                        String strFailedPath;
                        File strFailedDir;
                        String strDentinationDirectory1 = String.valueOf(Application.objServiceInfo.getSDataDownloadDirectory().trim()) + "\\";
                        File dstDirectory = null;
                        dstDirectory = new File(String.valueOf(strDentinationDirectory1) + accName + "\\");
                        logger.debug((Object)("Destination directory in finally block: " + strDentinationDirectory1 + accName + "\\"));
                        if (!dstDirectory.isDirectory()) {
                            logger.debug((Object)"Before directory in finally block");
                            dstDirectory.mkdir();
                            logger.debug((Object)"directory created in finally block");
                        }
                        if (!(strFailedDir = new File(strFailedPath = String.valueOf(strDentinationDirectory1) + accName + "\\" + "ReceivedFailed")).isDirectory()) {
                            strFailedDir.mkdir();
                        }
                        strDentinationDirectory1 = String.valueOf(strFailedPath) + "\\" + fileName;
                        destinationFile = new File(strDentinationDirectory1);
                        GeneralAPI.copy(sourceFile, destinationFile);
                        System.gc();
                        Thread.sleep(1000L);
                        if (sourceFile.delete()) {
                            logger.debug((Object)"Tempory File Deleted.");
                        } else {
                            logger.debug((Object)"Tempory File could not be Deleted.");
                        }
                        Date dateSet = GeneralAPI.dateExtractor(destinationFile);
                        logger.debug((Object)("Date is : " + dateSet));
                        boolean dateModified = destinationFile.setLastModified(dateSet.getTime());
                        logger.debug((Object)("Date Modified " + dateModified));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"In renameDownloadedFile method, finally block:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"In renameDownloadedFile method, finally block:", (Throwable)e);
                }
            }
        }
        return fileRenamedSuccessfully;
    }

    public static String jumbleStringEncrypt(String strInput) {
        StringBuffer strInputBuffer = new StringBuffer(strInput);
        String strInputReverse = strInputBuffer.reverse().toString();
        char[] chars = strInputReverse.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            sb.append(GeneralAPI.getEncryptedJumbleChar(chars[i]));
            ++i;
        }
        String strReturn = sb.toString();
        return strReturn;
    }

    public static byte[] getPassKey() {
        return byteArr;
    }

    public static byte[] convertStringToByte(String str) {
        byte[] byteArr = null;
        try {
            byteArr = String.valueOf(str).getBytes("UTF-8");
        }
        catch (Exception Ex) {
            logger.error((Object)"Exception in convertStringToByte:", (Throwable)Ex);
        }
        return byteArr;
    }

    public static String byteToString(byte[] byteArr) {
        String strValue = "";
        try {
            strValue = new String(byteArr, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strValue;
    }

    public static void addDldVersion(int iServiceId) {
        boolean flag = false;
        String strVersion = "";
        try {
            strVersion = ConfigUtil.getValue("version");
            logger.debug((Object)("service id =" + iServiceId));
            logger.debug((Object)("version is=" + strVersion));
            InvokeRTMWebService.getInstance().UpdateVersion(iServiceId, strVersion, GeneralAPI.getPassKey());
            logger.debug((Object)("value of flag in addGenralMessage: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in addGenralMessage: " + e.getMessage()));
        }
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            }
            catch (Exception e) {
                logger.error((Object)(" Exception occurred in copyFile " + e.getMessage()));
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static byte failureCode(String str, int len) {
        int code = 0;
        try {
            if (str.endsWith("6281")) {
                code = 51;
            } else if (str.substring(len - 4, len - 1).equals("63C")) {
                code = 52;
            } else if (str.endsWith("6400")) {
                code = 53;
            } else if (str.endsWith("6500")) {
                code = 54;
            } else if (str.endsWith("6581")) {
                code = 55;
            } else if (str.endsWith("6688")) {
                code = 56;
            } else if (str.endsWith("6700")) {
                code = 57;
            } else if (str.endsWith("6900")) {
                code = 58;
            } else if (str.endsWith("6982")) {
                code = 59;
            } else if (str.endsWith("6983")) {
                code = 60;
            } else if (str.endsWith("6985")) {
                code = 61;
            } else if (str.endsWith("6986")) {
                code = 62;
            } else if (str.endsWith("6987")) {
                code = 63;
            } else if (str.endsWith("6988")) {
                code = 64;
            } else if (str.endsWith("6A82")) {
                code = 65;
            } else if (str.endsWith("6A86")) {
                code = 66;
            } else if (str.endsWith("6A88")) {
                code = 67;
            } else if (str.endsWith("6B00")) {
                code = 68;
            } else if (str.substring(len - 4, len - 2).equals("6C")) {
                code = 69;
            } else if (str.endsWith("6D00")) {
                code = 70;
            } else if (str.endsWith("6E00")) {
                code = 71;
            } else if (str.endsWith("6F00")) {
                code = 72;
            }
        }
        catch (Exception ex) {
            logger.error((Object)(" Exception occurred in failureCode " + ex.getMessage()));
        }
        return (byte)code;
    }

    public static byte authFailureCode(byte[] apdu) {
        int code = 0;
        try {
            byte newByte1 = apdu[5];
            byte newByte2 = apdu[6];
            if (newByte1 == 1) {
                code = 73;
            } else if (newByte1 == 2) {
                if (newByte2 == 16) {
                    code = 74;
                } else if (newByte2 == 17) {
                    code = 75;
                } else if (newByte2 == 18) {
                    code = 76;
                } else if (newByte2 == 19) {
                    code = 77;
                } else if (newByte2 == 33) {
                    code = 78;
                } else if (newByte2 == 34) {
                    code = 79;
                } else if (newByte2 == 36) {
                    code = 80;
                } else if (newByte2 == 49) {
                    code = 81;
                } else if (newByte2 == 51) {
                    code = 82;
                } else if (newByte2 == 127) {
                    code = 83;
                } else if (newByte2 == 147) {
                    code = 84;
                }
            } else if (newByte1 == 3) {
                if (newByte2 == 12) {
                    code = 85;
                } else if (newByte2 == 14) {
                    code = 86;
                } else if (newByte2 == 16) {
                    code = 87;
                }
            } else if (newByte1 == 4) {
                if (newByte2 == 1) {
                    code = 88;
                } else if (newByte2 == 2) {
                    code = 89;
                } else if (newByte2 == 3) {
                    code = 90;
                } else if (newByte2 == 4) {
                    code = 91;
                } else if (newByte2 == 5) {
                    code = 92;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)(" Exception occurred in authFailureCode " + ex.getMessage()));
        }
        return (byte)code;
    }
}

