/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.Utility;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.dao.GeneralDao;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class PingThreadForRDSServer
implements Runnable {
    private static final Logger logger = Logger.getLogger(PingThreadForRDSServer.class);
    private final Socket connection;

    public PingThreadForRDSServer(Socket connect) {
        this.connection = connect;
    }

    @Override
    public void run() {
        logger.info((Object)"Inside RDS Ping Thread **** ");
        try {
            while (true) {
                byte[] pingArray = new byte[4];
                int interval = GeneralDao.getAuthRDSPingFreqSec();
                logger.info((Object)("Ping Interval value in secs from property file = " + interval));
                Thread.sleep(interval * 1000);
                DataOutputStream pingOutputSteam = new DataOutputStream(this.connection.getOutputStream());
                pingOutputSteam.write(pingArray);
                pingOutputSteam.flush();
                logger.info((Object)"Ping Thread Sent");
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)("InterruptedException in PingThreadForRDSServer: " + ConfigUtil.getStackTraceAsString(e)));
        }
        catch (IOException e) {
            logger.error((Object)("IOException in PingThreadForRDSServer: " + ConfigUtil.getStackTraceAsString(e)));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in PingThreadForRDSServer: " + ConfigUtil.getStackTraceAsString(e)));
        }
    }
}

