/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.Utility;

import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class SMCPUtils {
    public static final byte TERMINATING_BYTE = 32;
    private static final Logger logger = Logger.getLogger(SMCPUtils.class);

    public static byte[] getBytes(String type, int length) {
        if (length <= 0) {
            return null;
        }
        if (type == null || "".equals(type)) {
            byte[] returnBytes = new byte[length];
            int i = 0;
            while (i < length) {
                returnBytes[i] = 32;
                ++i;
            }
            return returnBytes;
        }
        if (type.length() > length) {
            type = type.substring(0, length);
        }
        byte[] typeBytes = null;
        try {
            typeBytes = type.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.debug((Object)"Exception in getBytes of SMCPUtils", (Throwable)e1);
        }
        if (typeBytes.length < length) {
            byte[] returnBytes = new byte[length];
            System.arraycopy(typeBytes, 0, returnBytes, 0, typeBytes.length);
            int i = typeBytes.length;
            while (i < length) {
                returnBytes[i] = 32;
                ++i;
            }
            return returnBytes;
        }
        return typeBytes;
    }

    public static byte[] convertIntToBytes(int v) {
        byte[] returnBytes = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return returnBytes;
    }

    public static byte[] convertShortToBytes(short v) {
        byte[] returnBytes = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return returnBytes;
    }

    public static String getString(String inpStr, int length, String padding) {
        if (inpStr.length() > length) {
            return inpStr.substring(0, length);
        }
        if (inpStr.length() < length) {
            int diff = length - inpStr.length();
            StringBuffer seqNum = new StringBuffer();
            seqNum.append("");
            int index = 0;
            while (index < diff) {
                seqNum.append(padding);
                ++index;
            }
            seqNum.append(inpStr);
            return seqNum.toString();
        }
        return inpStr;
    }

    public byte[] getPayloadForString(String payload) {
        if (payload == null || "".equals(payload)) {
            return null;
        }
        byte[] payloadBytes = new byte[2 + payload.length() + 1];
        short lenStr = (short)payload.length();
        payloadBytes[0] = (byte)(lenStr >>> 8 & 0xFF);
        payloadBytes[1] = (byte)(lenStr >>> 0 & 0xFF);
        try {
            byte[] strBytes = payload.getBytes("UTF8");
            System.arraycopy(strBytes, 0, payloadBytes, 2, strBytes.length);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug((Object)"Exception in getPayloadForString of SMCPUtils", (Throwable)e);
        }
        payloadBytes[payloadBytes.length - 1] = 32;
        return payloadBytes;
    }

    public byte[] getPayloadForStrings(String[] payloadArr) {
        if (payloadArr == null || payloadArr.length <= 0) {
            return null;
        }
        int size = 0;
        int index = 0;
        while (index < payloadArr.length) {
            if (payloadArr[index] != null && !"".equals(payloadArr)) {
                size += payloadArr[index].length();
            }
            ++index;
        }
        byte[] payloadBytes = new byte[2 + size + 1];
        short lenStr = (short)size;
        payloadBytes[0] = (byte)(lenStr >>> 8 & 0xFF);
        payloadBytes[1] = (byte)(lenStr >>> 0 & 0xFF);
        int lenWrite = 2;
        int index2 = 0;
        while (index2 < payloadArr.length) {
            String payload = payloadArr[index2];
            if (payload != null && !"".equals(payload)) {
                try {
                    byte[] strBytes = payload.getBytes("UTF8");
                    System.arraycopy(strBytes, 0, payloadBytes, lenWrite, strBytes.length);
                    lenWrite += strBytes.length;
                }
                catch (UnsupportedEncodingException e) {
                    logger.debug((Object)"Exception in getPayloadForStrings of SMCPUtils", (Throwable)e);
                }
            }
            ++index2;
        }
        payloadBytes[payloadBytes.length - 1] = 32;
        return payloadBytes;
    }

    public static final byte[] toByte(int i, boolean flag) {
        byte[] abyte0 = new byte[4];
        int byte0 = 0;
        while (byte0 <= 3) {
            abyte0[byte0] = (byte)(i >>> (3 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 4);
        }
        return abyte0;
    }

    public static final byte[] toByte(int i) {
        return SMCPUtils.toByte(i, false);
    }

    public static final byte[] toByte(short word0, boolean flag) {
        byte[] abyte0 = new byte[2];
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0] = (byte)(word0 >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 2);
        }
        return abyte0;
    }

    public static final byte[] toByte(short word0) {
        return SMCPUtils.toByte(word0, false);
    }

    public static final byte[] toByte(long l, boolean flag) {
        byte[] abyte0 = new byte[8];
        int byte0 = 0;
        while (byte0 <= 7) {
            abyte0[byte0] = (byte)(l >>> (7 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 8);
        }
        return abyte0;
    }

    public static final byte[] toByte(long l) {
        return SMCPUtils.toByte(l, false);
    }

    public static final byte[] toByte(char c, boolean flag) {
        byte[] abyte0 = new byte[2];
        int byte0 = 0;
        while (byte0 <= 1) {
            abyte0[byte0] = (byte)(c >>> (1 - byte0) * 8);
            byte0 = (byte)(byte0 + 1);
        }
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 2);
        }
        return abyte0;
    }

    public static final byte[] toByte(char c) {
        return SMCPUtils.toByte(c, false);
    }

    public static final byte[] toByte(float f, boolean flag) {
        byte[] abyte0 = new byte[4];
        int i = Float.floatToIntBits(f);
        abyte0 = SMCPUtils.toByte(i, flag);
        return abyte0;
    }

    public static final byte[] toByte(float f) {
        return SMCPUtils.toByte(f, false);
    }

    public static final byte[] toByte(double d, boolean flag) {
        byte[] abyte0 = new byte[8];
        long l = Double.doubleToLongBits(d);
        abyte0 = SMCPUtils.toByte(l, flag);
        return abyte0;
    }

    public static final byte[] toByte(double d) {
        return SMCPUtils.toByte(d, false);
    }

    public static final int toInt(byte[] abyte0, boolean flag) {
        int i = 0;
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 4);
        }
        int byte0 = 0;
        while (byte0 <= 3) {
            int j;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                j = abyte0[byte0];
                j |= 0x80;
            } else {
                j = abyte0[byte0];
            }
            i |= j;
            if (byte0 < 3) {
                i <<= 8;
            }
            byte0 = (byte)(byte0 + 1);
        }
        return i;
    }

    public static final int toInt(byte[] abyte0) {
        return SMCPUtils.toInt(abyte0, false);
    }

    public static final short toShort(byte[] abyte0, boolean flag) {
        short word0 = 0;
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 2);
        }
        int byte0 = 0;
        while (byte0 <= 1) {
            short word1;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                word1 = abyte0[byte0];
                word1 = (short)(word1 | 0x80);
            } else {
                word1 = abyte0[byte0];
            }
            word0 = (short)(word0 | word1);
            if (byte0 < 1) {
                word0 = (short)(word0 << 8);
            }
            byte0 = (byte)(byte0 + 1);
        }
        return word0;
    }

    public static final short toShort(byte[] abyte0) {
        return SMCPUtils.toShort(abyte0, false);
    }

    public static final long toLong(byte[] abyte0, boolean flag) {
        long l = 0L;
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 8);
        }
        int byte0 = 0;
        while (byte0 <= 7) {
            long l1;
            if (abyte0[byte0] < 0) {
                abyte0[byte0] = (byte)(abyte0[byte0] & 0x7F);
                l1 = abyte0[byte0];
                l1 |= 0x80L;
            } else {
                l1 = abyte0[byte0];
            }
            l |= l1;
            if (byte0 < 7) {
                l <<= 8;
            }
            byte0 = (byte)(byte0 + 1);
        }
        return l;
    }

    public static final long toLong(byte[] abyte0) {
        return SMCPUtils.toLong(abyte0, false);
    }

    public static final char toChar(byte[] abyte0, boolean flag) {
        char c = '\u0000';
        if (flag) {
            abyte0 = SMCPUtils.reverse_order(abyte0, 2);
        }
        c = (char)((c | (char)abyte0[0]) << 8);
        c = (char)(c | (char)abyte0[1]);
        return c;
    }

    public static final char toChar(byte[] abyte0) {
        return SMCPUtils.toChar(abyte0, false);
    }

    public static final float toFloat(byte[] abyte0, boolean flag) {
        float f = 0.0f;
        int i = SMCPUtils.toInt(abyte0, flag);
        f = Float.intBitsToFloat(i);
        return f;
    }

    public static final float toFloat(byte[] abyte0) {
        return SMCPUtils.toFloat(abyte0, false);
    }

    public static final double toDouble(byte[] abyte0, boolean flag) {
        double d = 0.0;
        long l = SMCPUtils.toLong(abyte0, flag);
        d = Double.longBitsToDouble(l);
        return d;
    }

    public static final double toDouble(byte[] abyte0) {
        return SMCPUtils.toDouble(abyte0, false);
    }

    private static final byte[] reverse_order(byte[] abyte0, int i) {
        byte[] abyte1 = new byte[i];
        int byte0 = 0;
        while (byte0 <= i - 1) {
            abyte1[byte0] = abyte0[i - 1 - byte0];
            byte0 = (byte)(byte0 + 1);
        }
        return abyte1;
    }

    public static String toHexString(byte[] b) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static String stringToHex(String str) {
        char[] chars = str.toCharArray();
        StringBuffer strBuffer = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            strBuffer.append(Integer.toHexString(chars[i]));
            strBuffer.append(" ");
            ++i;
        }
        return strBuffer.toString();
    }
}

