/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.appl;

import com.sisl.dtco.Utility.DailyIterator;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.ReadRegistry;
import com.sisl.dtco.Utility.Scheduler;
import com.sisl.dtco.Utility.SchedulerTask;
import com.sisl.dtco.appl.App;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.FailureMessageDao;
import com.sisl.dtco.dao.GeneralDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.integration.ClientXMLThread;
import com.sisl.dtco.integration.CompanyCardDetectionThread;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.GeneralMaintenanceThread;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.integration.SRSocketListener;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.UIFileHandler;
import com.sisl.dtco.integration.UISocketListener;
import com.sisl.dtco.integration.UpdateListThread;
import com.sisl.dtco.integration.WRFileTransferThread;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.service.GeneralFailureMessageService;
import com.sisl.dtco.service.SpecificRSTWFailureMessageService;
import com.sisl.dtco.vo.UrlRead;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountVO;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.ServiceInfo;
import org.tempuri.ServiceVO;

public class Application {
    private static final Logger logger = Logger.getLogger(Application.class);
    static Application instance = new Application();
    static Scheduler schedulerMidNight;
    public static String strPort;
    static Properties prProperty;
    static Properties prPropertyForProxy;
    private static HashMap<Integer, Scheduler> refreshRLSchedulerHashMap;
    public static AccountDetailsXMLParent listAccounts;
    public static boolean proxyServerUsedReg;
    public static String proxyHostReg;
    public static String proxyUserReg;
    public static String proxyPasswordReg;
    public static String proxyPortReg;
    public static ServiceInfo objServiceInfo;

    static {
        strPort = "";
        prProperty = new Properties();
        prPropertyForProxy = new Properties();
        refreshRLSchedulerHashMap = new HashMap();
        listAccounts = new AccountDetailsXMLParent();
        proxyServerUsedReg = false;
        proxyHostReg = "";
        proxyUserReg = "";
        proxyPasswordReg = "";
        proxyPortReg = "";
        objServiceInfo = new ServiceInfo();
    }

    public static Application getApplication() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public static void main(String[] args) throws Exception {
        logger.info((Object)"Starting RTM 2.0.8...............");
        WrapperManager.addWrapperEventListener((WrapperEventListener)new WrapperEventListener(){

            public void fired(WrapperEvent event) {
                if (event instanceof WrapperServiceControlEvent) {
                    WrapperServiceControlEvent scEvent = (WrapperServiceControlEvent)event;
                    switch (scEvent.getServiceControlCode()) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 201: {
                            Application.controlEventcall();
                        }
                    }
                }
            }
        }, (long)1L);
        try {
            Object objEntity;
            XStream objXStream;
            prProperty.load(new Object().getClass().getResourceAsStream("/config/log4j.properties"));
            PropertyConfigurator.configure((Properties)prProperty);
            Thread.sleep(1000L);
            String pgPath = System.getenv("ProgramData");
            logger.debug((Object)("pgPath in service xml=" + pgPath));
            String xmlFileName2 = String.valueOf(pgPath) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
            logger.debug((Object)("service xml=" + xmlFileName2));
            String xmlFileNameUrl = String.valueOf(pgPath) + "\\RTMTrayIconProxySettings\\URL.xml";
            logger.debug((Object)("url xml=" + xmlFileNameUrl));
            File fileXmlurl = new File(xmlFileNameUrl);
            String urlValue = "";
            String urlVal = "";
            String strCommand = "";
            String downloadDirectory = "";
            strCommand = "reg query \"HKEY_Local_Machine\\Software\\RTMWeb\" /v InstallationPath";
            downloadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
            logger.debug((Object)("RegPath:" + downloadDirectory));
            String commonPath1 = String.valueOf(downloadDirectory) + "\\common\\" + "URL.xml";
            logger.debug((Object)("commonPath1:" + commonPath1));
            File f11 = new File(commonPath1);
            if (fileXmlurl.exists()) {
                UrlRead objurl;
                String xmlFileContents = "";
                xmlFileContents = Application.getFileContentsUTF8(xmlFileNameUrl);
                if (fileXmlurl.length() == 0L || xmlFileContents.isEmpty()) {
                    logger.info((Object)"empty string return in URL");
                    if (fileXmlurl.delete()) {
                        logger.debug((Object)"URLXML is deleted successfully ::");
                    } else {
                        logger.debug((Object)"URLXML Not Deleted ::: ");
                    }
                    Application.copyDirectory(f11, fileXmlurl);
                    objXStream = new XStream();
                    objEntity = null;
                    objXStream.alias("URL", UrlRead.class);
                    objEntity = objXStream.fromXML(xmlFileContents);
                    objurl = (UrlRead)objEntity;
                    urlValue = objurl.getUrl();
                    urlVal = urlValue.split("//")[1].split("/")[0];
                } else {
                    objXStream = new XStream();
                    objEntity = null;
                    objXStream.alias("URL", UrlRead.class);
                    objEntity = objXStream.fromXML(xmlFileContents);
                    objurl = (UrlRead)objEntity;
                    urlValue = objurl.getUrl();
                    urlVal = urlValue.split("//")[1].split("/")[0];
                }
            } else {
                logger.info((Object)"File not exist:");
                Application.copyDirectory(f11, fileXmlurl);
            }
            logger.debug((Object)("urlVal:" + urlVal));
            if (urlVal.isEmpty()) {
                String xmlFileContents1 = "";
                logger.info((Object)"URL value is empty");
                xmlFileContents1 = Application.getFileContentsUTF8(xmlFileNameUrl);
                objXStream = new XStream();
                objEntity = null;
                objXStream.alias("URL", UrlRead.class);
                objEntity = objXStream.fromXML(xmlFileContents1);
                UrlRead objurl1 = (UrlRead)objEntity;
                urlValue = objurl1.getUrl();
                urlVal = urlValue.split("//")[1].split("/")[0];
            }
            xmlFileName2 = String.valueOf(xmlFileName2) + urlVal + ".xml";
            logger.debug((Object)("xmlFileName2 url is=" + xmlFileName2));
            File file = new File(xmlFileName2);
            String commonPath = String.valueOf(downloadDirectory) + "\\common\\AccountServiceDetails_" + urlVal + ".xml";
            logger.debug((Object)("commonPath:" + commonPath));
            File f1 = new File(commonPath);
            if (!file.exists()) {
                logger.debug((Object)("file not exist=" + xmlFileName2));
                Application.copyDirectory(f1, file);
            } else {
                logger.info((Object)("file exist to check length" + file.length()));
                if (file.length() == 0L) {
                    logger.info((Object)"empty string return");
                    if (file.delete()) {
                        logger.debug((Object)"IS  deleted successfully ::");
                    } else {
                        logger.debug((Object)"Not Deleted ::: ");
                    }
                    Application.copyDirectory(f1, file);
                }
            }
            ClientXMLThread clientXMLThreadThread = ClientXMLThread.getXMLDetectionthread();
            clientXMLThreadThread.getXML();
            GeneralDao objGeneralDao = GeneralDao.getInstance();
            objGeneralDao.updateConfigParams();
            clientXMLThreadThread.schedule();
            while (!ClientXMLThread.xmlChecked) {
                Thread.sleep(2000L);
            }
            int serviceIdAuth = 0;
            logger.debug((Object)("serviceIdAuth in Aplication to start application:" + ClientXMLThread.xmlChecked));
            logger.debug((Object)("objServiceInfo application:" + objServiceInfo));
            if (objServiceInfo != null && objServiceInfo.getSAuthenticationServicePortForBrowser() != null && !objServiceInfo.getSAuthenticationServicePortForBrowser().equals("")) {
                logger.debug((Object)("service xml ports:" + objServiceInfo.getSAuthenticationServicePortForBrowser()));
                ExecutorService exec = ThreadPool.getThreadPool();
                UISocketListener UISockListener = new UISocketListener();
                exec.execute(UISockListener);
                ServiceVO[] svo = null;
                if (objServiceInfo.getServices() != null && (svo = objServiceInfo.getServices()) != null && svo[0] != null) {
                    serviceIdAuth = svo[0].getIServiceID();
                    logger.debug((Object)("serviceIdAuth in application:" + serviceIdAuth));
                    while (serviceIdAuth == 0) {
                        Thread.sleep(2000L);
                    }
                    if (serviceIdAuth != 0) {
                        logger.info((Object)"Auth Service is just started, Updating status initially as Not Connected to RDS..");
                        InvokeRemoteDevice.getInstance().updateConnectionToRDS(2);
                        GeneralAPI.addDldVersion(serviceIdAuth);
                        SRSocketListener objSRSocketListener = new SRSocketListener();
                        exec.execute(objSRSocketListener);
                        GeneralFailureMessageService objGeneralFailureService = new GeneralFailureMessageService();
                        exec.execute(objGeneralFailureService);
                        SpecificRSTWFailureMessageService objSpecificRSTWFailureService = new SpecificRSTWFailureMessageService();
                        exec.execute(objSpecificRSTWFailureService);
                        CompanyCardDetectionThread detectionThread = CompanyCardDetectionThread.getCompanyCardDetectionThread();
                        detectionThread.schedule();
                        Thread.sleep(1000L);
                        RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                        List<Integer> listRemoteServiceIDs = null;
                        ArrayList<Integer> arrListAccID = new ArrayList<Integer>();
                        AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
                        if (objAccountsVO != null && objAccountsVO.length > 0) {
                            logger.debug((Object)("Accounts ij Account XML:" + objAccountsVO.length));
                            int i = 0;
                            while (i < objAccountsVO.length) {
                                if (objAccountsVO[i].getDeviceType() == 3 || objAccountsVO[i].getDeviceType() == 6 || objAccountsVO[i].getDeviceType() == 5 || objAccountsVO[i].getDeviceType() == 7) {
                                    arrListAccID.add(objAccountsVO[i].getAccountId());
                                }
                                ++i;
                            }
                            logger.debug((Object)("for WR pinging threa acc ids list:" + arrListAccID));
                            if (arrListAccID.size() > 0) {
                                listRemoteServiceIDs = objRemoteServiceDao.getAllRemoteServiceIDs(arrListAccID);
                            }
                            logger.debug((Object)(" for WR pinging threa remote serv ids list:" + listRemoteServiceIDs));
                            if (listRemoteServiceIDs != null) {
                                int j = 0;
                                while (j < listRemoteServiceIDs.size()) {
                                    WRPingingThread.schedule(listRemoteServiceIDs.get(j));
                                    WRFileTransferThread.schedule(listRemoteServiceIDs.get(j));
                                    ++j;
                                }
                            }
                        }
                        GeneralMaintenanceThread.schedule();
                        Thread.sleep(500L);
                        instance.scheduleApplicationAtMidnight();
                        UpdateListThread detectionThreadListUpdate = UpdateListThread.getXMLDetectionthread();
                        detectionThreadListUpdate.schedule();
                    } else {
                        logger.debug((Object)"Service ID does not exist Therefore, XM will be checked after 20 sec:: ");
                    }
                }
                if (strPort.trim().length() > 0 && serviceIdAuth != 0) {
                    logger.debug((Object)("Port(s) already used by some other applcation:::: " + strPort));
                    FailureMessageDao.getInstance().addGenralMessage(serviceIdAuth, "10", strPort, "");
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Runtime Exception while starting application: " + e));
            logger.debug((Object)"Sleeping............");
            Thread.sleep(20000L);
            Application.main(args);
        }
        logger.info((Object)"RTM Authentication Module Started successfully: ");
    }

    public static void controlEventcall() {
        logger.info((Object)"RTM Authentication Module Stopped:");
        try {
            ServiceVO[] objServiceVO = objServiceInfo.getServices();
            ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
            int serviceIdAuth = 0;
            int i = 0;
            while (i < objServiceVO.length) {
                listServicesVO.add(objServiceVO[i].getIServiceID());
                ++i;
            }
            serviceIdAuth = (Integer)listServicesVO.get(0);
            FailureMessageDao.getInstance().addGenralMessage(serviceIdAuth, "12");
            logger.info((Object)"Auth Service is stopped, Updating status as Not Connected to RDS..");
            InvokeRemoteDevice.getInstance().updateConnectionToRDS(2);
            try {
                SRSocketListener.sendServiceStatus(0);
            }
            catch (Exception ex) {
                logger.error((Object)"Exception when calling sendServiceStatus..");
            }
            String machineID = objServiceInfo.getIMachineId();
            logger.info((Object)("Machine id in controlEventcall method is = " + machineID));
            if (machineID != null) {
                Application.updateInProgressTask(machineID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception:", (Throwable)ex);
        }
    }

    private static void updateInProgressTask(String machineID) {
        logger.info((Object)("Before stopping Auth service, marking all the in progress task to failed for the machine id = " + machineID));
        boolean flag = false;
        try {
            logger.debug((Object)"Before calling webservice method updateInProgressTask");
            flag = InvokeRTMWebService.getInstance().updateInProgressTask(GeneralAPI.convertStringToByte(machineID), GeneralAPI.getPassKey());
            logger.debug((Object)("value of flag in updateInProgressTask: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in updateInProgressTask: " + e.getMessage()));
        }
    }

    public void rescheduleApplication(int companyID, String strDownloadTime) {
        try {
            logger.info((Object)("Appliaction Rescheduled to refresh reminder list for company:" + companyID));
            Scheduler objScheduler = refreshRLSchedulerHashMap.get(companyID);
            objScheduler.cancel();
            refreshRLSchedulerHashMap.remove(companyID);
            this.scheduleApplication(companyID, strDownloadTime);
        }
        catch (Exception e) {
            logger.error((Object)"Exception:", (Throwable)e);
        }
    }

    public void scheduleApplication(int companyID, String strDownloadTime) {
        try {
            if (refreshRLSchedulerHashMap.containsKey(companyID)) {
                logger.debug((Object)("Already scheduled for company ID:" + companyID));
                return;
            }
            logger.debug((Object)("Scheduling to refresh reminder list at download time for company ID:" + companyID));
            Scheduler objScheduler = new Scheduler();
            if (strDownloadTime == null || "".equals(strDownloadTime.trim())) {
                logger.error((Object)"downloadTime not specified, hence returning");
                return;
            }
            int hour = 0;
            int min = 0;
            String[] arrTime = strDownloadTime.trim().split(":");
            if (arrTime[0] != null && !"".equals(arrTime[0])) {
                hour = Integer.parseInt(arrTime[0]);
            }
            if (arrTime.length == 2 && arrTime[1] != null && !"".equals(arrTime[1])) {
                min = Integer.parseInt(arrTime[1]);
            }
            objScheduler.schedule(new SchedulerTask(companyID){

                @Override
                public void run() {
                    CompanyDao objCompanyDao = CompanyDao.getInstance();
                    AccountVO objCompanyVO = objCompanyDao.getCompanyDetails(this.companyID);
                    logger.info((Object)("Time to refresh reminder list at download time for company:" + objCompanyVO.getAccountId()));
                    UIFileHandler objUIFileHandler = UIFileHandler.getInstance();
                    try {
                        objUIFileHandler.refreshReminderListProcess(objCompanyVO, false);
                        if (objCompanyVO.getDeviceType() != 3 || objCompanyVO.getDeviceType() != 6 || objCompanyVO.getDeviceType() != 5 || objCompanyVO.getDeviceType() != 7) {
                            String strEntityDetails = objUIFileHandler.intimateToSRComm(null);
                            CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityDetails, -1, null);
                            Thread authExecutor = new Thread(intimationTask);
                            ExecutorService es = ThreadPool.getThreadPool();
                            es.execute(authExecutor);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception while refreshing reminder list at download time:", (Throwable)e);
                    }
                }
            }, new DailyIterator(hour, min, 0));
            refreshRLSchedulerHashMap.put(companyID, objScheduler);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException at download time scheduler:", (Throwable)e);
        }
    }

    public static void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                Application.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                ++i;
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public void scheduleApplicationAtMidnight() {
        logger.debug((Object)"Scheduling to create reminder list at midnight");
        try {
            schedulerMidNight = new Scheduler();
            new App();
            schedulerMidNight.schedule(new SchedulerTask(){

                @Override
                public void run() {
                    Date date = new Date();
                    logger.debug((Object)("Client Date :- " + date));
                    logger.debug((Object)("Server Date :- " + Application.this.getServerDate(date)));
                    new App();
                }
            }, new DailyIterator(0, 5, 0, this.getServerDate(new Date())));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException at midnight scheduler:", (Throwable)e);
        }
    }

    public Date getServerDate(Date clientDate) {
        TimeZone tz = TimeZone.getTimeZone("Europe/Berlin");
        int rawOffset = tz.getRawOffset();
        int offset = rawOffset + tz.getDSTSavings();
        boolean isSystemDayLightSaving = TimeZone.getDefault().inDaylightTime(clientDate);
        long systemOffset = TimeZone.getDefault().getRawOffset();
        if (isSystemDayLightSaving) {
            systemOffset += (long)TimeZone.getDefault().getDSTSavings();
        }
        long lDate = clientDate.getTime() - systemOffset + (long)offset;
        return new Date(lDate);
    }

    public void scheduleNewRefreshReminderListTask(int companyID, String strDownloadTime) {
        if (!refreshRLSchedulerHashMap.containsKey(companyID)) {
            logger.debug((Object)("Scheduling New Refresh Reminder List Task. Size before:" + refreshRLSchedulerHashMap.size()));
            this.scheduleApplication(companyID, strDownloadTime);
        }
    }

    public void cancelsRefreshReminderListTask(int companyID) {
        Scheduler objScheduler = refreshRLSchedulerHashMap.get(companyID);
        objScheduler.cancel();
        refreshRLSchedulerHashMap.remove(companyID);
    }

    public static String getFileContentsUTF8(String strFileName) {
        String strEntities = "";
        logger.debug((Object)("*******File name is********" + strFileName));
        try {
            File file = new File(strFileName);
            if (file.exists()) {
                logger.debug((Object)("File exist:" + strFileName));
            } else {
                logger.debug((Object)("File does not exist:" + strFileName));
            }
            FileInputStream fis = new FileInputStream(new File(strFileName));
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                strEntities = String.valueOf(strEntities) + strLine;
            }
            fis.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getFileContents method of General API", (Throwable)e);
        }
        logger.debug((Object)("string returned from file:" + strEntities));
        return strEntities;
    }
}

