/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.appl;

import com.sisl.dtco.Utility.DailyIterator;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.Scheduler;
import com.sisl.dtco.Utility.SchedulerTask;
import com.sisl.dtco.appl.App;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.FailureMessageDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.integration.ClientXMLThread;
import com.sisl.dtco.integration.GeneralMaintenanceThread;
import com.sisl.dtco.integration.UISocketListener;
import com.sisl.dtco.integration.UpdateListThread;
import com.sisl.dtco.integration.WRFileTransferThread;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.service.GeneralFailureMessageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.ServiceInfo;
import org.tempuri.ServiceVO;

public class TestMain {
    private static final Logger logger = Logger.getLogger(Application.class);
    static TestMain instance = new TestMain();
    static Scheduler schedulerMidNight;
    public static String strPort;
    static Properties prProperty;
    static Properties prPropertyForProxy;
    private static HashMap<Integer, Scheduler> refreshRLSchedulerHashMap;
    public static AccountDetailsXMLParent listAccounts;
    public static boolean proxyServerUsedReg;
    public static String proxyHostReg;
    public static String proxyUserReg;
    public static String proxyPasswordReg;
    public static String proxyPortReg;
    public static ServiceInfo objServiceInfo;

    static {
        strPort = "";
        prProperty = new Properties();
        prPropertyForProxy = new Properties();
        refreshRLSchedulerHashMap = new HashMap();
        listAccounts = new AccountDetailsXMLParent();
        proxyServerUsedReg = false;
        proxyHostReg = "";
        proxyUserReg = "";
        proxyPasswordReg = "";
        proxyPortReg = "";
        objServiceInfo = new ServiceInfo();
    }

    public static TestMain getApplication() {
        if (instance == null) {
            instance = new TestMain();
        }
        return instance;
    }

    public static void main(String[] args) throws Exception {
        WrapperManager.addWrapperEventListener((WrapperEventListener)new WrapperEventListener(){

            public void fired(WrapperEvent event) {
                if (event instanceof WrapperServiceControlEvent) {
                    WrapperServiceControlEvent scEvent = (WrapperServiceControlEvent)event;
                    switch (scEvent.getServiceControlCode()) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 201: {
                            TestMain.controlEventcall();
                        }
                    }
                }
            }
        }, (long)1L);
        try {
            prProperty.load(new Object().getClass().getResourceAsStream("/config/log4j.properties"));
            PropertyConfigurator.configure((Properties)prProperty);
            Thread.sleep(1000L);
            ClientXMLThread clientXMLThreadThread = ClientXMLThread.getXMLDetectionthread();
            clientXMLThreadThread.schedule();
            while (!ClientXMLThread.xmlChecked) {
                Thread.sleep(2000L);
            }
            int serviceIdAuth = 0;
            if (objServiceInfo != null && objServiceInfo.getSAuthenticationServicePortForBrowser() != null && !objServiceInfo.getSAuthenticationServicePortForBrowser().equals("")) {
                ExecutorService exec = Executors.newSingleThreadExecutor();
                UISocketListener UISockListener = new UISocketListener();
                exec.execute(UISockListener);
                ServiceVO[] svo = null;
                if (objServiceInfo.getServices() != null && (svo = objServiceInfo.getServices()) != null && svo[0] != null) {
                    serviceIdAuth = svo[0].getIServiceID();
                    while (serviceIdAuth == 0) {
                        Thread.sleep(2000L);
                    }
                    if (serviceIdAuth != 0) {
                        GeneralAPI.addDldVersion(serviceIdAuth);
                        GeneralFailureMessageService objGeneralFailureService = new GeneralFailureMessageService();
                        exec.execute(objGeneralFailureService);
                        Thread.sleep(1000L);
                        RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                        List<Integer> listRemoteServiceIDs = null;
                        ArrayList<Integer> arrListAccID = new ArrayList<Integer>();
                        AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
                        if (objAccountsVO != null && objAccountsVO.length > 0) {
                            int i = 0;
                            while (i < objAccountsVO.length) {
                                if (objAccountsVO[i].getDeviceType() == 3 || objAccountsVO[i].getDeviceType() == 6 || objAccountsVO[i].getDeviceType() == 5 || objAccountsVO[i].getDeviceType() == 7) {
                                    arrListAccID.add(objAccountsVO[i].getAccountId());
                                }
                                ++i;
                            }
                            if (arrListAccID.size() > 0) {
                                listRemoteServiceIDs = objRemoteServiceDao.getAllRemoteServiceIDs(arrListAccID);
                            }
                            if (listRemoteServiceIDs != null) {
                                int j = 0;
                                while (j < listRemoteServiceIDs.size()) {
                                    WRPingingThread.schedule(listRemoteServiceIDs.get(j));
                                    WRFileTransferThread.schedule(listRemoteServiceIDs.get(j));
                                    ++j;
                                }
                            }
                        }
                        GeneralMaintenanceThread.schedule();
                        Thread.sleep(500L);
                        instance.scheduleApplicationAtMidnight();
                        UpdateListThread detectionThreadListUpdate = UpdateListThread.getXMLDetectionthread();
                        detectionThreadListUpdate.schedule();
                    } else {
                        logger.debug((Object)"Service ID does not exist Therefore, XM will be checked after 20 sec:: ");
                    }
                }
                if (strPort.trim().length() > 0 && serviceIdAuth != 0) {
                    logger.debug((Object)("Port(s) already used by some other applcation:::: " + strPort));
                    FailureMessageDao.getInstance().addGenralMessage(serviceIdAuth, "10", strPort, "");
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("Runtime Exception while starting application: " + e));
            logger.debug((Object)"Sleeping............");
            Thread.sleep(20000L);
            Application.main(args);
        }
    }

    public static void controlEventcall() {
        try {
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
            int serviceIdAuth = 0;
            int i = 0;
            while (i < objServiceVO.length) {
                listServicesVO.add(objServiceVO[i].getIServiceID());
                ++i;
            }
            serviceIdAuth = (Integer)listServicesVO.get(0);
            FailureMessageDao.getInstance().addGenralMessage(serviceIdAuth, "12");
            String machineID = objServiceInfo.getIMachineId();
            if (machineID != null) {
                TestMain.updateInProgressTask(machineID);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private static void updateInProgressTask(String machineID) {
        boolean flag = false;
        try {
            flag = InvokeRTMWebService.getInstance().updateInProgressTask(GeneralAPI.convertStringToByte(machineID), GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            System.out.println("Exception in updateInProgressTask: " + e.getMessage());
        }
    }

    public void scheduleApplicationAtMidnight() {
        logger.debug((Object)"Scheduling to create reminder list at midnight");
        try {
            Application.schedulerMidNight = new Scheduler();
            new App();
            schedulerMidNight.schedule(new SchedulerTask(){

                @Override
                public void run() {
                    Date date = new Date();
                    logger.debug((Object)("Client Date :- " + date));
                    logger.debug((Object)("Server Date :- " + TestMain.this.getServerDate(date)));
                    new App();
                }
            }, new DailyIterator(0, 5, 0, this.getServerDate(new Date())));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException at midnight scheduler:", (Throwable)e);
        }
    }

    public Date getServerDate(Date clientDate) {
        TimeZone tz = TimeZone.getTimeZone("Europe/Berlin");
        int rawOffset = tz.getRawOffset();
        int offset = rawOffset + tz.getDSTSavings();
        boolean isSystemDayLightSaving = TimeZone.getDefault().inDaylightTime(clientDate);
        long systemOffset = TimeZone.getDefault().getRawOffset();
        if (isSystemDayLightSaving) {
            systemOffset += (long)TimeZone.getDefault().getDSTSavings();
        }
        long lDate = clientDate.getTime() - systemOffset + (long)offset;
        return new Date(lDate);
    }
}

