/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.vo.CustomerRequestListVO;
import com.sisl.dtco.vo.DueDownloadVO;
import com.sisl.dtco.vo.RequestListVO;
import com.thoughtworks.xstream.XStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.DAOResponceVO;
import org.tempuri.DueDownloadVORTM;
import org.tempuri.EntityVORTM;
import org.tempuri.SV;
import org.tempuri.VU;

public class CompanyDao {
    private static final Logger logger = Logger.getLogger(CompanyDao.class);
    private static CompanyDao objCompanyDao = new CompanyDao();
    ConnectionPool connectionPool = ConnectionPool.getInstance();

    private CompanyDao() {
    }

    public static CompanyDao getInstance() {
        if (objCompanyDao == null) {
            objCompanyDao = new CompanyDao();
        }
        return objCompanyDao;
    }

    public void updateLastDownloadDate(int companyId, String entityID, String entityName, String timeStamp) {
        boolean flag = false;
        try {
            flag = InvokeRTMWebService.getInstance().updateLastDownloadDate(companyId, GeneralAPI.convertStringToByte(entityID), GeneralAPI.convertStringToByte(entityName), timeStamp, GeneralAPI.getPassKey());
            logger.debug((Object)("value of flag in updateLastDownloadDate: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in while updating last download date: " + e.getMessage()));
        }
    }

    public AccountVO getCompanyDetails(int companyID) {
        AccountVO accVo = new AccountVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                accVo = InvokeRTMWebService.getInstance().getCompanyDetails(String.valueOf(companyID), GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getCompanyDetails:");
                exp = e;
            }
            if (accVo != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getCompanyDetails: " + exp.getMessage()));
        }
        return accVo;
    }

    public List<AccountVO> getCompanyList() {
        ArrayList<AccountVO> listCompanyVO;
        block13: {
            logger.debug((Object)"Getting compnay LIst..........");
            listCompanyVO = new ArrayList<AccountVO>();
            Connection connection = null;
            CallableStatement stmt = null;
            ResultSet result = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call SP_GetCompanyList }");
                    result = stmt.executeQuery();
                    while (result != null && result.next()) {
                        logger.debug((Object)("SP_GetCompanyList" + result.getRow()));
                        AccountVO objCompanyVO = new AccountVO();
                        objCompanyVO.setAccountId(result.getInt("iCompanyID"));
                        objCompanyVO.setAccountName(result.getString("sCompanyName"));
                        objCompanyVO.setDeviceType(result.getInt("iDeviceType"));
                        objCompanyVO.setArchiveMode(result.getInt("iArchiveMode"));
                        objCompanyVO.setUrlTW(result.getString("sUrl"));
                        if (result.getString("ProxyRequired").equals("1")) {
                            objCompanyVO.setSTISOfficeServer(result.getString("sDownloadLocationTO"));
                        }
                        objCompanyVO.setSTISOfficeCompany(result.getString("sTISOfficeCompany"));
                        logger.debug((Object)("iCompanyID:" + objCompanyVO.getAccountId()));
                        logger.debug((Object)("sCompanyName:" + objCompanyVO.getAccountName()));
                        logger.debug((Object)("iDeviceType:" + objCompanyVO.getDeviceType()));
                        logger.debug((Object)("iArchiveMode:" + objCompanyVO.getArchiveMode()));
                        logger.debug((Object)("sUrlTW:" + objCompanyVO.getUrlTW()));
                        logger.debug((Object)("sDownloadLocationTO:" + objCompanyVO.getSTISOfficeServer()));
                        logger.debug((Object)("sTISOfficeCompany:" + objCompanyVO.getSTISOfficeCompany()));
                        listCompanyVO.add(objCompanyVO);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException in while getting Details of all Companies: " + e.getMessage()));
                    try {
                        ConfigUtil.cleanup(connection, stmt, result);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("SQLException: " + e2.getMessage()));
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt, result);
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt, result);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
        return listCompanyVO;
    }

    public void saveTisWebRequestList(String strRequsetList, int companyID, boolean setDefaultValues) {
        block29: {
            logger.debug((Object)("Saving Request List Details in Company table for companyID:" + companyID));
            logger.debug((Object)("Setting Default values:" + setDefaultValues));
            Connection connection = null;
            CallableStatement stmt = null;
            boolean eventsDataBlock = false;
            boolean speedDataBlock = false;
            boolean technicalDataBlock = false;
            boolean activityDataBlock = false;
            boolean svSpecialDataIndicator = false;
            boolean detailedSpeedDataBlock = false;
            boolean multiPurposeDataBlock = false;
            try {
                if (!setDefaultValues) {
                    XStream objXStream1 = new XStream();
                    Object objRequest = null;
                    CustomerRequestListVO objCustomerRequestListVO = null;
                    objXStream1.alias("CustomerRequestListVO", CustomerRequestListVO.class);
                    objXStream1.alias("RequestListVO", RequestListVO.class);
                    objRequest = objXStream1.fromXML(strRequsetList);
                    objCustomerRequestListVO = (CustomerRequestListVO)objRequest;
                    RequestListVO[] objRequestListVO = objCustomerRequestListVO.getRequestList();
                    int q = 0;
                    while (q < objRequestListVO.length) {
                        logger.debug((Object)("Response Data :" + objRequestListVO[q].toString()));
                        byte[] data = objRequestListVO[q].getRequestData();
                        if (data[0] == 3) {
                            logger.debug((Object)"Response Data  is EVENTS_AND_FAULTS ");
                            eventsDataBlock = true;
                        } else if (data[0] == 4) {
                            logger.debug((Object)"Response Data  is DETAILED_SPEED ");
                            speedDataBlock = true;
                        } else if (data[0] == 5) {
                            logger.debug((Object)"Response Data  is TECHNICAL_DATA ");
                            technicalDataBlock = true;
                        } else if (data[0] == 2) {
                            logger.debug((Object)"Response Data  is ACTIVITIES_OF_SPECIFIED_CALENDER_DAY ");
                            activityDataBlock = true;
                        } else if (data[0] == 17) {
                            svSpecialDataIndicator = true;
                            logger.debug((Object)"Response Data  is SPEED_PROFILES ");
                        } else if (data[0] == 25) {
                            detailedSpeedDataBlock = true;
                            logger.debug((Object)"Response Data  is HRS168_VEHICLE_DETAILED_SPEED ");
                        } else if (data[0] == 27) {
                            multiPurposeDataBlock = true;
                            logger.debug((Object)"Response Data  is ADDITIONAL_DATA_1B ");
                        }
                        ++q;
                    }
                }
                connection = this.connectionPool.getConnection();
                stmt = connection.prepareCall("{ call SP_Update_Blocks_Company(?,?,?,?,?,?,?,?,?,?)}");
                stmt.setBoolean(1, eventsDataBlock);
                stmt.setBoolean(2, speedDataBlock);
                stmt.setBoolean(3, technicalDataBlock);
                stmt.setBoolean(4, activityDataBlock);
                stmt.setBoolean(5, svSpecialDataIndicator);
                stmt.setBoolean(6, detailedSpeedDataBlock);
                stmt.setBoolean(7, multiPurposeDataBlock);
                stmt.setInt(8, companyID);
                stmt.setString(9, "AUTH");
                stmt.setBoolean(10, setDefaultValues);
                stmt.execute();
                logger.debug((Object)"Data blocks information saved in Company table.");
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException while saving TisWeb RequestList: " + e.getMessage()));
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.error((Object)("SQLException: " + e2.getMessage()));
                }
                break block29;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("SQLException while saving TisWeb RequestList: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        ConfigUtil.cleanup(connection, stmt);
                    }
                    catch (SQLException e3) {
                        logger.error((Object)("SQLException: " + e3.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e4) {
                    logger.error((Object)("SQLException: " + e4.getMessage()));
                }
                break block29;
            }
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
    }

    public void saveTISOfficeRequestList(DueDownloadVO objReqList, int accountID) {
        logger.debug((Object)"Saving TIS-Office Request List Details in Company table for companyID:");
        SV objSV = new SV();
        VU objVU = new VU();
        DueDownloadVORTM objDueDownloadVORTM = new DueDownloadVORTM();
        try {
            objDueDownloadVORTM.setUserName(objReqList.getUserName());
            logger.debug((Object)("user name: " + objDueDownloadVORTM.getUserName()));
            objDueDownloadVORTM.setAcccountName(objReqList.getAcccountName());
            logger.debug((Object)("account name: " + objDueDownloadVORTM.getAcccountName()));
            objDueDownloadVORTM.setVersion(objReqList.getVersion());
            logger.debug((Object)("version: " + objDueDownloadVORTM.getVersion()));
            objDueDownloadVORTM.setPassword(objReqList.getPassword());
            logger.debug((Object)("password: " + objDueDownloadVORTM.getPassword()));
            objSV.setSVDetailedDataBlock(objReqList.getSV().getSVDetailedDataBlock());
            logger.debug((Object)("setSVDetailedDataBlock: " + objSV.getSVDetailedDataBlock()));
            objSV.setSVMultiPurposeDataBlock(objReqList.getSV().getSVMultiPurposeDataBlock());
            logger.debug((Object)("setSVMultiPurposeDataBlock: " + objSV.getSVMultiPurposeDataBlock()));
            objSV.setSVSplDataBlock(objReqList.getSV().getSVSplDataBlock());
            logger.debug((Object)("setSVSplDataBlock: " + objSV.getSVSplDataBlock()));
            objVU.setVUActivityBlock(objReqList.getVU().getVUActivityBlock());
            logger.debug((Object)("setVUActivityBlock: " + objVU.getVUActivityBlock()));
            objVU.setVUEventFaultBlockArchive(objReqList.getVU().getVUEventFaultBlockArchive());
            logger.debug((Object)("setVUEventFaultBlockArchive: " + objVU.getVUEventFaultBlockArchive()));
            objVU.setVUSpeedBlockArchive(objReqList.getVU().getVUSpeedBlockArchive());
            logger.debug((Object)("setVUSpeedBlockArchive: " + objVU.getVUSpeedBlockArchive()));
            objVU.setVUTechnicalBlockArchive(objReqList.getVU().getVUTechnicalBlockArchive());
            logger.debug((Object)("setVUTechnicalBlockArchive: " + objVU.getVUTechnicalBlockArchive()));
            objDueDownloadVORTM.setSV(objSV);
            objDueDownloadVORTM.setVU(objVU);
            logger.debug((Object)("in dao method due download vo: " + objDueDownloadVORTM));
            InvokeRTMWebService.getInstance().saveTISOfficeRequestList(objDueDownloadVORTM, accountID, GeneralAPI.getPassKey());
            logger.debug((Object)"Data blocks information saved in Company table.");
        }
        catch (Exception e) {
            logger.debug((Object)("Exception while saving TisOffice RequestList: " + e.getMessage()));
        }
    }

    public List<EntityVORTM> createEntityVOs(AccountVO objAccountVO) {
        List<EntityVORTM> listEntityVO1 = new ArrayList<EntityVORTM>();
        try {
            EntityVORTM[] listEntityVO = InvokeRTMWebService.getInstance().createEntityVOs(objAccountVO, GeneralAPI.getPassKey());
            if (listEntityVO != null) {
                logger.debug((Object)("In createEntityVOs... listEntityVO size : " + listEntityVO.length));
            }
            if ((listEntityVO1 = Arrays.asList(listEntityVO)) != null) {
                logger.debug((Object)("In createEntityVOs... Arraylist listEntityVO1 size : " + listEntityVO1.size()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while creating current day reminders:", (Throwable)e);
        }
        return listEntityVO1;
    }

    public AccountVO getCompanyUserType(int companyID) {
        AccountVO objCompanyVO = new AccountVO();
        try {
            objCompanyVO = InvokeRTMWebService.getInstance().getCompanyUserType(companyID, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getCompanyUserType:", (Throwable)e);
        }
        return objCompanyVO;
    }

    public AccountVO getFileExtension(String strFileType, String strSerialID) {
        AccountVO objCompanyVO;
        block11: {
            objCompanyVO = new AccountVO();
            Connection connection = null;
            CallableStatement stmt = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call SP_GetFileExtension(?,?,?,?)}");
                    stmt.setString(1, strFileType);
                    stmt.setString(2, strSerialID);
                    stmt.registerOutParameter(3, 12);
                    stmt.registerOutParameter(4, 12);
                    stmt.execute();
                    objCompanyVO.setAccountName(stmt.getString(4));
                }
                catch (SQLException e) {
                    logger.error((Object)"SQLException in while getting Company Details:", (Throwable)e);
                    try {
                        ConfigUtil.cleanup(connection, stmt);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)"SQLException:", (Throwable)e2);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e) {
                    logger.error((Object)"SQLException:", (Throwable)e);
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException:", (Throwable)e);
            }
        }
        return objCompanyVO;
    }

    public String getDownloadTime(int companyID) {
        String strDownloadTime = "";
        Connection connection = null;
        CallableStatement stmt = null;
        try {
            try {
                connection = this.connectionPool.getConnection();
                stmt = connection.prepareCall("{call SP_GetDownloadTime(?,?)}");
                stmt.setInt(1, companyID);
                stmt.registerOutParameter(2, 12);
                stmt.execute();
                strDownloadTime = stmt.getString(2);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException in while getting daownload time:", (Throwable)e);
                String string = strDownloadTime;
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.error((Object)"SQLException:", (Throwable)e2);
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException:", (Throwable)e);
            }
            throw throwable;
        }
        try {
            ConfigUtil.cleanup(connection, stmt);
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException:", (Throwable)e);
        }
        return strDownloadTime;
    }

    public DAOResponceVO getCompanyID(String sSerialID, int iRemoteServiceID) {
        DAOResponceVO objDAOResponceVO = new DAOResponceVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objDAOResponceVO = InvokeRTMWebService.getInstance().getCompanyID(sSerialID, iRemoteServiceID, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getCompanyID:");
                exp = e;
            }
            if (objDAOResponceVO.getICompanyID() != 0 && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getCompanyID: " + exp.getMessage()));
        }
        return objDAOResponceVO;
    }

    public ArrayList<String> getListOfTISOfficeURLs() {
        ArrayList<String> arTISOfficeURLs = null;
        try {
            arTISOfficeURLs = this.getListOfURLs(2);
        }
        catch (Exception e) {
            logger.error((Object)("SQLException: " + e.getMessage()));
        }
        return arTISOfficeURLs;
    }

    public ArrayList<String> getListOfURLs(int iArchiveMode) {
        ArrayList<String> arTISURLs;
        block12: {
            arTISURLs = new ArrayList<String>();
            Connection connection = null;
            CallableStatement stmt = null;
            ResultSet result = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call RTM_getListOfTISURLs(?,?)}");
                    stmt.setInt(1, iArchiveMode);
                    stmt.setString(2, "AUTH");
                    result = stmt.executeQuery();
                    while (result != null && result.next()) {
                        arTISURLs.add(result.getString("sURL"));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                    try {
                        ConfigUtil.cleanup(connection, stmt, result);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("SQLException: " + e2.getMessage()));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt, result);
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt, result);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
        return arTISURLs;
    }

    public ArrayList<DAOResponceVO> getListOfTISWebURLs(String csvCompany, boolean serviceStartedTW) {
        ArrayList<DAOResponceVO> alDAOResponceVO;
        block12: {
            alDAOResponceVO = new ArrayList<DAOResponceVO>();
            DAOResponceVO objResponceVO = null;
            Connection connection = null;
            CallableStatement stmt = null;
            ResultSet result = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call RTM_getListOfTISWebURLs(?,?,?)}");
                    stmt.setString(1, csvCompany);
                    stmt.setBoolean(2, serviceStartedTW);
                    stmt.setString(3, "AUTH");
                    result = stmt.executeQuery();
                    while (result != null && result.next()) {
                        logger.debug((Object)"In while of RTM_getListOfTISWebURLs.");
                        objResponceVO = new DAOResponceVO();
                        objResponceVO.setICompanyID(result.getInt("iCompanyID"));
                        objResponceVO.setURL(result.getString("sURL"));
                        objResponceVO.setAccountIdTW(result.getString("sAccountTW"));
                        objResponceVO.setUserNameTW(result.getString("sUserName"));
                        objResponceVO.setPasswordTW(result.getString("sPassword"));
                        objResponceVO.setProxyRequired(result.getString("ProxyRequired"));
                        objResponceVO.setProxyHost(result.getString("ProxyHost"));
                        objResponceVO.setProxyPort(result.getString("ProxyPort"));
                        objResponceVO.setProxyUser(result.getString("ProxyUser"));
                        objResponceVO.setProxyPassword(result.getString("ProxyPassword"));
                        alDAOResponceVO.add(objResponceVO);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                    try {
                        ConfigUtil.cleanup(connection, stmt, result);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("SQLException: " + e2.getMessage()));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt, result);
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt, result);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
        return alDAOResponceVO;
    }

    public ArrayList<DAOResponceVO> getListOfTISWebURLsForAccessCheck() {
        ArrayList<DAOResponceVO> alDAOResponceVO;
        block12: {
            alDAOResponceVO = new ArrayList<DAOResponceVO>();
            DAOResponceVO objResponceVO = null;
            Connection connection = null;
            CallableStatement stmt = null;
            ResultSet result = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call RTM_getListOfTISWebURLsForAccessCheck()}");
                    result = stmt.executeQuery();
                    while (result != null && result.next()) {
                        logger.debug((Object)"In while of RTM_getListOfTISWebURLsForAccessCheck.");
                        objResponceVO = new DAOResponceVO();
                        objResponceVO.setURL(result.getString("sURL"));
                        objResponceVO.setProxyRequired(result.getString("ProxyRequired"));
                        objResponceVO.setProxyHost(result.getString("ProxyHost"));
                        objResponceVO.setProxyPort(result.getString("ProxyPort"));
                        objResponceVO.setProxyUser(result.getString("ProxyUser"));
                        objResponceVO.setProxyPassword(result.getString("ProxyPassword"));
                        alDAOResponceVO.add(objResponceVO);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                    try {
                        ConfigUtil.cleanup(connection, stmt, result);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("SQLException: " + e2.getMessage()));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt, result);
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt, result);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
        return alDAOResponceVO;
    }

    public int getCompanyDetails(String strSerialID) {
        int companyId = 0;
        try {
            AccountVO objAccVO = new AccountVO();
            objAccVO = InvokeRTMWebService.getInstance().getCompanyDetails(strSerialID, GeneralAPI.getPassKey());
            companyId = objAccVO.getAccountId();
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getCompanyDetails:", (Throwable)e);
        }
        return companyId;
    }

    public boolean updateAuthRDSStatus_1b1(int serviceId, int authServiceStatusId) {
        boolean flag = false;
        try {
            logger.debug((Object)("serviceId : " + serviceId + " authServiceStatusId : " + authServiceStatusId));
            flag = InvokeRTMWebService.getInstance().updateAuthRDSStatus_1b1(serviceId, authServiceStatusId, GeneralAPI.getPassKey());
            logger.debug((Object)("value of flag in updateAuthRDSStatus_1b1: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in updateAuthRDSStatus_1b1: " + ConfigUtil.getStackTraceAsString(e)));
        }
        return flag;
    }
}

