/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.InvokeRTMWebService;
import org.apache.log4j.Logger;
import org.tempuri.FileTransferStatusVO;

public class DTCOFileTransferStatusDao {
    private static DTCOFileTransferStatusDao objFileTransferStatusDao = new DTCOFileTransferStatusDao();
    ConnectionPool connectionPool = ConnectionPool.getInstance();
    private static final Logger logger = Logger.getLogger(DTCOFileTransferStatusDao.class);

    private DTCOFileTransferStatusDao() {
    }

    public static DTCOFileTransferStatusDao getInstance() {
        if (objFileTransferStatusDao == null) {
            objFileTransferStatusDao = new DTCOFileTransferStatusDao();
        }
        return objFileTransferStatusDao;
    }

    public boolean insertStatus(FileTransferStatusVO objFileTransferStatusVO, int remoteServiceId) {
        boolean inserted = false;
        try {
            logger.info((Object)("remoteServiceId = " + remoteServiceId));
            if (remoteServiceId == -1) {
                objFileTransferStatusVO.setIsFileAvailable(false);
            } else {
                objFileTransferStatusVO.setIsFileAvailable(true);
            }
            inserted = InvokeRTMWebService.getInstance().insertStatusWR(objFileTransferStatusVO, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in insertStatusWR:", (Throwable)e);
            inserted = false;
            return inserted;
        }
        return inserted;
    }

    public synchronized FileTransferStatusVO updateStatus(FileTransferStatusVO objFileTransferStatusVO) {
        try {
            objFileTransferStatusVO = InvokeRTMWebService.getInstance().UpdateFileTransferStatus(objFileTransferStatusVO, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateStatus", (Throwable)e);
        }
        return objFileTransferStatusVO;
    }

    public synchronized boolean updateSpecialDataDownloadStatus(int companyID, String vrn) {
        boolean updatedFlag = false;
        try {
            updatedFlag = InvokeRTMWebService.getInstance().updateSpecialDataDownloadStatus(companyID, GeneralAPI.convertStringToByte(vrn), GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateSpecialDataDownloadStatus:", (Throwable)e);
        }
        return updatedFlag;
    }

    public synchronized int getReminderIdForFileTransfer(FileTransferStatusVO objFileTransferStatusVO) {
        int reminderId = 0;
        try {
            reminderId = InvokeRTMWebService.getInstance().getReminderIdForFileTransfer(objFileTransferStatusVO, GeneralAPI.getPassKey());
            logger.debug((Object)("value of reminderId in getReminderIdForFileTransfer: " + reminderId));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getReminderIdForFileTransfer:", (Throwable)e);
            e.printStackTrace();
        }
        return reminderId;
    }
}

