/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.vo.DiagnosticLogVO;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class DiagnosticLogsDao {
    private static DiagnosticLogsDao objDiagnosticLogsDao = new DiagnosticLogsDao();
    private static final Logger logger = Logger.getLogger(DiagnosticLogsDao.class);
    ConnectionPool connectionPool = ConnectionPool.getInstance();

    private DiagnosticLogsDao() {
    }

    public static DiagnosticLogsDao getInstance() {
        if (objDiagnosticLogsDao == null) {
            objDiagnosticLogsDao = new DiagnosticLogsDao();
        }
        return objDiagnosticLogsDao;
    }

    public void saveLogs(ArrayList<DiagnosticLogVO> listDiagnosticLogVO) {
        Connection connection = null;
        CallableStatement stmt = null;
        try {
            try {
                connection = this.connectionPool.getConnection();
                int i = 0;
                while (i < listDiagnosticLogVO.size()) {
                    DiagnosticLogVO objDiagnosticLogVO = listDiagnosticLogVO.get(i);
                    stmt = connection.prepareCall("{call RTM_addLogs(?,?,?,?,?)}");
                    stmt.setString(1, objDiagnosticLogVO.getSerialID());
                    stmt.setInt(2, objDiagnosticLogVO.getErrorCode());
                    stmt.setInt(3, objDiagnosticLogVO.getErrorType());
                    Date lastDownloadDate = new Date((long)objDiagnosticLogVO.getTimeStamp() * 1000L);
                    stmt.setTimestamp(4, new Timestamp(lastDownloadDate.getTime()));
                    stmt.setString(5, "AUTH");
                    stmt.execute();
                    ++i;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException: while getting value from master table", (Throwable)e);
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.debug((Object)"SQLException:", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.debug((Object)"SQLException:", (Throwable)e);
            }
        }
    }
}

