/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.tempuri.ConfigParameter;

public class GeneralDao {
    private static final Logger logger = Logger.getLogger(CompanyDao.class);
    private static GeneralDao objGeneralDao = new GeneralDao();
    ConnectionPool connectionPool = ConnectionPool.getInstance();
    private static int AuthSocketTimeoutSec;
    private static int AuthRTMMessageIntervalSec;
    private static int AuthCompanyCardDetectionFreqSec;
    private static int AuthUnexpectedAuthenticationInProgressFreqMin;
    private static int AuthXmlUpdateIntervalMin;
    private static int AuthRDSPingFreqSec;
    private static int AuthCSVSRetryPeriodFreqSec;

    public static int getAuthSocketTimeoutSec() {
        return AuthSocketTimeoutSec;
    }

    public static int getAuthRTMMessageIntervalSec() {
        return AuthRTMMessageIntervalSec;
    }

    public static int getAuthCompanyCardDetectionFreqSec() {
        return AuthCompanyCardDetectionFreqSec;
    }

    public static int getAuthUnexpectedAuthenticationInProgressFreqMin() {
        return AuthUnexpectedAuthenticationInProgressFreqMin;
    }

    public static int getAuthXmlUpdateIntervalMin() {
        return AuthXmlUpdateIntervalMin;
    }

    public static int getAuthRDSPingFreqSec() {
        return AuthRDSPingFreqSec;
    }

    public static int getAuthCSVSRetryPeriodFreqSec() {
        return AuthCSVSRetryPeriodFreqSec;
    }

    private GeneralDao() {
    }

    public static GeneralDao getInstance() {
        if (objGeneralDao == null) {
            objGeneralDao = new GeneralDao();
        }
        return objGeneralDao;
    }

    public void purgeFiles() {
        block14: {
            Connection connection = null;
            CallableStatement stmt = null;
            try {
                connection = this.connectionPool.getConnection();
                stmt = connection.prepareCall("{ call RTM_PurgeData(?,?,?)}");
                stmt.setInt(1, Integer.parseInt(ConfigUtil.getValue("PURGINGDAYS")));
                stmt.setInt(2, Integer.parseInt(ConfigUtil.getValue("FileTransferPurgingDays")));
                stmt.setInt(3, Integer.parseInt(ConfigUtil.getValue("DiagnosticsPurgingDays")));
                stmt.execute();
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException in while Purging :", (Throwable)e);
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.error((Object)"SQLException:", (Throwable)e2);
                }
                break block14;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"SQLException in while Purging :", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        ConfigUtil.cleanup(connection, stmt);
                    }
                    catch (SQLException e3) {
                        logger.error((Object)"SQLException:", (Throwable)e3);
                    }
                    throw throwable;
                }
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e4) {
                    logger.error((Object)"SQLException:", (Throwable)e4);
                }
                break block14;
            }
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException:", (Throwable)e);
            }
        }
    }

    public String getSystemSettingValue(int accountId, String tableName, String columnName) {
        String keyValue = "";
        try {
            keyValue = InvokeRTMWebService.getInstance().getSystemSettingValue(accountId, tableName, columnName, GeneralAPI.getPassKey());
        }
        catch (Exception exp) {
            logger.error((Object)("General Exception occurred while getting data from database:" + exp));
        }
        return keyValue;
    }

    public boolean UploadFile(int id, String fileName, String lastupdateduserName, byte[] log) {
        boolean uploadLog = false;
        try {
            uploadLog = InvokeRTMWebService.getInstance().UploadFile(id, fileName, lastupdateduserName, log, GeneralAPI.getPassKey());
        }
        catch (Exception exp) {
            logger.error((Object)("General Exception occurred while getting data from database in UploadFile():" + exp));
        }
        return uploadLog;
    }

    public void setProxySettings(String proxyHost, String proxyPort) {
        block11: {
            Connection connection = null;
            CallableStatement stmt = null;
            try {
                try {
                    logger.debug((Object)("Proxy Host.." + proxyHost));
                    logger.debug((Object)("Proxy Port.." + proxyPort));
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{call SP_SetProxySettings(?,?)}");
                    stmt.setString(1, proxyHost);
                    stmt.setString(2, proxyPort);
                    stmt.execute();
                }
                catch (SQLException e) {
                    logger.error((Object)"Exception occurred while setting proxy values in SystemSettings table:", (Throwable)e);
                    try {
                        ConfigUtil.cleanup(connection, stmt);
                    }
                    catch (SQLException ex) {
                        ex.fillInStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException ex) {
                    ex.fillInStackTrace();
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException ex) {
                ex.fillInStackTrace();
            }
        }
    }

    public void updateConfigParams() {
        logger.debug((Object)"inside updateConfigParams()");
        try {
            try {
                ConfigParameter objConfigParams = InvokeRTMWebService.getInstance().GetConfigParameterValues(ConfigUtil.getPassKey());
                AuthCompanyCardDetectionFreqSec = Integer.parseInt(objConfigParams.getAuthCompanyCardDetectionFreqSec());
                AuthCSVSRetryPeriodFreqSec = Integer.parseInt(objConfigParams.getAuthCSVSRetryPeriodFreqSec());
                AuthRDSPingFreqSec = Integer.parseInt(objConfigParams.getAuthRDSPingFreqSec());
                AuthRTMMessageIntervalSec = Integer.parseInt(objConfigParams.getAuthRTMMessageIntervalSec());
                AuthSocketTimeoutSec = Integer.parseInt(objConfigParams.getAuthSocketTimeoutSec());
                AuthUnexpectedAuthenticationInProgressFreqMin = Integer.parseInt(objConfigParams.getAuthUnexpectedAuthenticationInProgressFreqMin());
                AuthXmlUpdateIntervalMin = Integer.parseInt(objConfigParams.getAuthXmlUpdateIntervalMin());
            }
            catch (Exception e) {
                logger.error((Object)("Exception in calling GetConfigParameterValues " + ConfigUtil.getStackTraceAsString(e)));
                AuthXmlUpdateIntervalMin = Integer.parseInt(ConfigUtil.getValue("min"));
                AuthRTMMessageIntervalSec = Integer.parseInt(ConfigUtil.getValue("RTMMessageInterval"));
                AuthCompanyCardDetectionFreqSec = Integer.parseInt(ConfigUtil.getValue("CheckingCompanyCardAvailabilityInterval"));
                AuthSocketTimeoutSec = Integer.parseInt(ConfigUtil.getValue("SocketTimeout"));
                AuthUnexpectedAuthenticationInProgressFreqMin = Integer.parseInt(ConfigUtil.getValue("UnexpectedAuthenticationInProgress"));
                AuthRDSPingFreqSec = Integer.parseInt(ConfigUtil.getValue("RDSPingTimeIntervalSecs"));
                AuthCSVSRetryPeriodFreqSec = Integer.parseInt(ConfigUtil.getValue("CSVSRetryPeriodFreqSec"));
                logger.info((Object)("AuthCompanyCardDetectionFreqSec:" + AuthCompanyCardDetectionFreqSec + " AuthCSVSRetryPeriodFreqSec:" + AuthCSVSRetryPeriodFreqSec + " AuthRDSPingFreqSec:" + AuthRDSPingFreqSec + " AuthRTMMessageIntervalSec:" + AuthRTMMessageIntervalSec + " AuthSocketTimeoutSec:" + AuthSocketTimeoutSec + " AuthUnexpectedAuthenticationInProgressFreqMin:" + AuthUnexpectedAuthenticationInProgressFreqMin + " AuthXmlUpdateIntervalMin:" + AuthXmlUpdateIntervalMin));
            }
        }
        finally {
            logger.info((Object)("AuthCompanyCardDetectionFreqSec:" + AuthCompanyCardDetectionFreqSec + " AuthCSVSRetryPeriodFreqSec:" + AuthCSVSRetryPeriodFreqSec + " AuthRDSPingFreqSec:" + AuthRDSPingFreqSec + " AuthRTMMessageIntervalSec:" + AuthRTMMessageIntervalSec + " AuthSocketTimeoutSec:" + AuthSocketTimeoutSec + " AuthUnexpectedAuthenticationInProgressFreqMin:" + AuthUnexpectedAuthenticationInProgressFreqMin + " AuthXmlUpdateIntervalMin:" + AuthXmlUpdateIntervalMin));
        }
    }
}

