/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.vo.DTCOCommandVO;
import com.sisl.dtco.vo.EntityVO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.DAOResponceVO;
import org.tempuri.DTCOVO;
import org.tempuri.EntityVORTM;
import org.tempuri.FileTransferStatusVO;
import org.tempuri.RemoteDeviceRegistrationVO;

public class ReminderListDao {
    private static final Logger logger = Logger.getLogger(ReminderListDao.class);
    private static ReminderListDao objReminderListDao = new ReminderListDao();
    ConnectionPool connectionPool = ConnectionPool.getInstance();

    public static ReminderListDao getInstance() {
        if (objReminderListDao == null) {
            objReminderListDao = new ReminderListDao();
        }
        return objReminderListDao;
    }

    public int checkReminders(AccountVO objAccountVO) {
        int codeValue = 0;
        try {
            codeValue = InvokeRTMWebService.getInstance().checkReminders(objAccountVO, GeneralAPI.getPassKey());
            logger.debug((Object)("Got Return form web service" + codeValue));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while cheking current day reminders:", (Throwable)e);
            e.printStackTrace();
        }
        return codeValue;
    }

    public AccountVO processXMLtoRefreshReminderList(AccountVO objAccountVO) throws Exception {
        AccountVO objAccountVO1 = new AccountVO();
        try {
            objAccountVO1 = InvokeRTMWebService.getInstance().processXMLtoRefreshReminderList(objAccountVO, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while refreshing current day reminder list:", (Throwable)e);
        }
        return objAccountVO1;
    }

    public List<EntityVO> getDeletedManualRemindersDetails(ArrayList<String> reminderIdList) {
        ArrayList<EntityVO> entityVOList = new ArrayList<EntityVO>();
        String strIDs = "";
        int i = 0;
        while (i < reminderIdList.size()) {
            strIDs = strIDs.equals("") ? reminderIdList.get(i) : String.valueOf(strIDs) + "#" + reminderIdList.get(i);
            ++i;
        }
        try {
            EntityVORTM[] listEntityVORTM = InvokeRTMWebService.getInstance().getDeletedManualRemindersDetails(strIDs, GeneralAPI.getPassKey());
            EntityVO objEntityVO = null;
            int i2 = 0;
            while (i2 < listEntityVORTM.length) {
                objEntityVO = new EntityVO();
                objEntityVO.setEntityId(GeneralAPI.byteToString(listEntityVORTM[i2].getEntityId()));
                objEntityVO.setEntityName(GeneralAPI.byteToString(listEntityVORTM[i2].getEntityName()));
                objEntityVO.setFromDate(listEntityVORTM[i2].getFromDate());
                objEntityVO.setDeviceType(listEntityVORTM[i2].getDeviceType());
                objEntityVO.setCompanyId(listEntityVORTM[i2].getCompanyId());
                objEntityVO.setToDate(listEntityVORTM[i2].getToDate());
                objEntityVO.setRecurrence(listEntityVORTM[i2].getRecurrence());
                objEntityVO.setRequestDataBlock(listEntityVORTM[i2].getRequestDataBlock());
                entityVOList.add(objEntityVO);
                ++i2;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getDeletedManualRemindersDetails:", (Throwable)e);
            return null;
        }
        return entityVOList;
    }

    public EntityVO getDriverManualEntityDetails(int iReminderID) throws Exception {
        EntityVORTM objEntityVORTM = new EntityVORTM();
        EntityVO objEntityVO = new EntityVO();
        try {
            objEntityVORTM = InvokeRTMWebService.getInstance().getDriverManualEntityDetails(iReminderID, GeneralAPI.getPassKey());
            objEntityVO.setCompanyId(objEntityVORTM.getCompanyId());
            objEntityVO.setEntityId(GeneralAPI.byteToString(objEntityVORTM.getEntityId()));
            objEntityVO.setEntityName(GeneralAPI.byteToString(objEntityVORTM.getEntityName()));
            objEntityVO.setFromDate(objEntityVORTM.getFromDate());
            objEntityVO.setToDate(objEntityVORTM.getToDate());
            objEntityVO.setRecurrence(objEntityVORTM.getRecurrence());
            objEntityVO.setDeviceType(objEntityVORTM.getDeviceType());
            objEntityVO.setRequestDataBlock(objEntityVORTM.getRequestDataBlock());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Exception in getDriverManualEntityDetails :", (Throwable)e);
        }
        return objEntityVO;
    }

    public FileTransferStatusVO getEntityName(Date reminderDate, int companyID, String strEntiyID, int statusCheck) throws Exception {
        FileTransferStatusVO objFileTransferStatusVO = new FileTransferStatusVO();
        Calendar cal = Calendar.getInstance();
        cal.setTime(reminderDate);
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objFileTransferStatusVO = InvokeRTMWebService.getInstance().getEntityName(cal, companyID, GeneralAPI.convertStringToByte(strEntiyID), statusCheck, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getEntityName:");
                exp = e;
            }
            if (objFileTransferStatusVO != null && objFileTransferStatusVO.getEntityName() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getEntityName: " + exp.getMessage()));
        }
        return objFileTransferStatusVO;
    }

    public DAOResponceVO checkEntityReminderList(String sMassMemoryEntityID, String sSpecialDataEntityID, String sDriverEntityID, String sCoDriverEntityID, int iCompanyID) {
        DAOResponceVO objDAOResponceVO = new DAOResponceVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objDAOResponceVO = InvokeRTMWebService.getInstance().checkEntityReminderList(GeneralAPI.convertStringToByte(sMassMemoryEntityID), GeneralAPI.convertStringToByte(sSpecialDataEntityID), GeneralAPI.convertStringToByte(sDriverEntityID), GeneralAPI.convertStringToByte(sCoDriverEntityID), iCompanyID, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in checkEntityReminderList:");
                exp = e;
            }
            if (objDAOResponceVO.getMassMemoryType() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in checkEntityReminderList: " + exp.getMessage()));
            return null;
        }
        return objDAOResponceVO;
    }

    public String checkAuthenticationState(String strEntityId, int iCompanyID, String strDTCOVersion, String strManufactureCode) {
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                strEntityId = InvokeRTMWebService.getInstance().checkAuthenticationState(GeneralAPI.convertStringToByte(strEntityId), iCompanyID, strDTCOVersion, strManufactureCode, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in checkAuthenticationState:");
                exp = e;
            }
            if (strEntityId != null && !strEntityId.trim().isEmpty() && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in checkAuthenticationState: " + exp.getMessage()));
        }
        return strEntityId;
    }

    public int addReminder(int iCompanyID, String sEntityID, String sEntityName, int sDueDownloadDate, String serialID, int status, int dldType, int intiatingApplication, int manualIndicator, String strDTCOVersion, int manufatureCode) throws Exception {
        int reminderId = 0;
        Exception exp = null;
        int i = 0;
        while (i <= 0) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                reminderId = InvokeRTMWebService.getInstance().addReminder(iCompanyID, GeneralAPI.convertStringToByte(sEntityID), GeneralAPI.convertStringToByte(sEntityName), sDueDownloadDate, serialID, status, dldType, intiatingApplication, manualIndicator, strDTCOVersion, manufatureCode, GeneralAPI.getPassKey());
                logger.debug((Object)("reminderId returned from webservice method addReminder =" + reminderId));
            }
            catch (Exception e) {
                logger.error((Object)"Exception in addReminder:");
                exp = e;
            }
            if (reminderId != 0 && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in addReminder: " + exp.getMessage()));
        }
        return reminderId;
    }

    public void updateReminder(int iCompanyID, String sEntityID, int status, int intiatingApplication, int manualIndicator, String strDTCOVersion, int manufatureCode) throws Exception {
        boolean flag = false;
        try {
            flag = InvokeRTMWebService.getInstance().updateReminder(iCompanyID, GeneralAPI.convertStringToByte(sEntityID), status, intiatingApplication, manualIndicator, strDTCOVersion, manufatureCode, GeneralAPI.getPassKey());
            logger.debug((Object)("value of flag in updateReminder: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateReminder:", (Throwable)e);
        }
    }

    public synchronized int updateRetryCount(DTCOCommandVO objDTCOCommandVO) {
        int iRetryCount = 0;
        try {
            String orignailEntityID = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
            logger.debug((Object)("Inside updateRetryCount... orignailEntityID =" + orignailEntityID));
            String[] arrEntityId = orignailEntityID.split("#", -1);
            String strEntityIdsReminderID = "";
            boolean driver = false;
            arrEntityId = orignailEntityID.split("#", -1);
            strEntityIdsReminderID = "";
            int j = 0;
            while (j < arrEntityId.length) {
                if (arrEntityId[j].startsWith("V")) {
                    strEntityIdsReminderID = String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDVU());
                } else if (arrEntityId[j].startsWith("S")) {
                    strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDSV()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDSV());
                } else if (arrEntityId[j].startsWith("D") && !driver) {
                    if (objDTCOCommandVO.isDriverIndicator() && objDTCOCommandVO.isCodriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDDriver());
                    } else if (objDTCOCommandVO.isDriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDDriver());
                    } else if (objDTCOCommandVO.isCodriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver());
                    }
                    driver = true;
                } else if (arrEntityId[j].startsWith("D") && driver) {
                    strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver());
                }
                ++j;
            }
            logger.debug((Object)("Inside updateRetryCount... strEntityIdsReminderID =" + strEntityIdsReminderID));
            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(strEntityIdsReminderID));
            logger.debug((Object)("objDTCOCommandVO.getEntityId(:" + GeneralAPI.byteToString(objDTCOCommandVO.getEntityId())));
            logger.debug((Object)("objDTCOCommandVO.getCompanyID()(:" + objDTCOCommandVO.getCompanyID()));
            iRetryCount = InvokeRTMWebService.getInstance().updateRetryCount(GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()), objDTCOCommandVO.getCompanyID(), GeneralAPI.getPassKey());
            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(orignailEntityID));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateRetryCount:", (Throwable)e);
        }
        logger.debug((Object)("iRetryCount(:" + iRetryCount));
        return iRetryCount;
    }

    public void AddReminderForDriver(int iCompanyID, String sEntityID, String sEntityName, String sDueDownloadDate) throws Exception {
        Connection connection = null;
        CallableStatement stmt = null;
        connection = this.connectionPool.getConnection();
        try {
            try {
                stmt = connection.prepareCall("{ call RTM_AddReminderForDriver(?,?,?,?,?)}");
                stmt.setInt(1, iCompanyID);
                stmt.setString(2, sEntityID);
                stmt.setString(3, sEntityName);
                stmt.setTimestamp(4, Timestamp.valueOf(sDueDownloadDate));
                stmt.setString(5, "AUTH");
                stmt.execute();
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException:", (Throwable)e);
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.error((Object)"SQLException:", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e) {
                logger.error((Object)"SQLException:", (Throwable)e);
            }
        }
    }

    public synchronized void updateStatusLocalAuthentication(DTCOCommandVO objDTCOCommandVO) {
        DTCOVO objDTCOVO = new DTCOVO();
        try {
            boolean updateStatusFlag = false;
            objDTCOVO.setEntityId(objDTCOCommandVO.getEntityId());
            objDTCOVO.setCompanyID(objDTCOCommandVO.getCompanyID());
            logger.debug((Object)("objDTCOCommandVO.getEntityId():" + GeneralAPI.byteToString(objDTCOCommandVO.getEntityId())));
            logger.debug((Object)("objDTCOCommandVO.getStatus():" + objDTCOCommandVO.getStatus()));
            objDTCOVO.setStatus(objDTCOCommandVO.getStatus());
            objDTCOVO.setRetryCount(objDTCOCommandVO.getRetryCount());
            objDTCOVO.setDldType(objDTCOCommandVO.getDldType());
            objDTCOVO.setTimeStamp(objDTCOCommandVO.getTimeStamp());
            objDTCOVO.setFailureCode((short)objDTCOCommandVO.getFailureCode());
            objDTCOVO.setRemoteDeviceSerialNumber(objDTCOCommandVO.getRemoteDeviceSerialNumber());
            objDTCOVO.setAuthType(objDTCOCommandVO.getAuthType());
            objDTCOVO.setTimeStampAuthenticationStarted(objDTCOCommandVO.getTimeStampAuthenticationStarted());
            objDTCOVO.setStrDTCOVersion(objDTCOCommandVO.getStrDTCOVersion());
            String machineID = Application.objServiceInfo.getIMachineId();
            logger.debug((Object)("machineID =" + machineID));
            objDTCOVO.setMachineID(GeneralAPI.convertStringToByte(machineID));
            Exception exp = null;
            int i = 0;
            while (i <= 3) {
                try {
                    if (i != 0) {
                        logger.debug((Object)("Retry attempt = " + i));
                        Thread.sleep(1000L);
                    }
                    exp = null;
                    logger.debug((Object)("Before updateStatus method... status to be set is =" + objDTCOVO.getStatus()));
                    logger.debug((Object)("Before updateStatus method... Failure code to be set is =" + objDTCOVO.getFailureCode()));
                    updateStatusFlag = InvokeRTMWebService.getInstance().updateStatus(objDTCOVO, GeneralAPI.getPassKey());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception in updateStatusLocalAuthentication:");
                    exp = e;
                }
                if (updateStatusFlag && exp == null) break;
                ++i;
            }
            if (exp != null) {
                logger.error((Object)("Exception in updateStatusLocalAuthentication: " + exp.getMessage()));
            }
            logger.debug((Object)("update status flag value:" + updateStatusFlag));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateStatus:", (Throwable)e);
        }
    }

    public void updateStatusRemoteAuthentication(DTCOCommandVO objDTCOCommandVO) {
        DTCOVO objDTCOVO = new DTCOVO();
        try {
            String orignailEntityID = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
            logger.debug((Object)("Inside updateStatusRemoteAuthentication... orignailEntityID =" + orignailEntityID));
            String[] arrEntityId = orignailEntityID.split("#", -1);
            String strEntityIdsReminderID = "";
            boolean driver = false;
            arrEntityId = orignailEntityID.split("#", -1);
            strEntityIdsReminderID = "";
            int j = 0;
            while (j < arrEntityId.length) {
                if (arrEntityId[j].startsWith("V")) {
                    strEntityIdsReminderID = String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDVU());
                } else if (arrEntityId[j].startsWith("S")) {
                    strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDSV()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDSV());
                } else if (arrEntityId[j].startsWith("D") && !driver) {
                    if (objDTCOCommandVO.isDriverIndicator() && objDTCOCommandVO.isCodriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDDriver());
                    } else if (objDTCOCommandVO.isDriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDDriver());
                    } else if (objDTCOCommandVO.isCodriverIndicator()) {
                        strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver());
                    }
                    driver = true;
                } else if (arrEntityId[j].startsWith("D") && driver) {
                    strEntityIdsReminderID = strEntityIdsReminderID.length() != 0 ? String.valueOf(strEntityIdsReminderID) + "#" + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver()) : String.valueOf(strEntityIdsReminderID) + String.valueOf(objDTCOCommandVO.getReminderIDCoDriver());
                }
                ++j;
            }
            logger.debug((Object)("Inside updateStatusRemoteAuthentication... strEntityIdsReminderID =" + strEntityIdsReminderID));
            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(strEntityIdsReminderID));
            boolean updateStatusFlag = false;
            objDTCOVO.setEntityId(objDTCOCommandVO.getEntityId());
            objDTCOVO.setCompanyID(objDTCOCommandVO.getCompanyID());
            logger.debug((Object)("objDTCOCommandVO.getEntityId():" + GeneralAPI.byteToString(objDTCOCommandVO.getEntityId())));
            logger.debug((Object)("objDTCOCommandVO.getStatus():" + objDTCOCommandVO.getStatus() + " companyID:" + objDTCOCommandVO.getCompanyID() + " Serial ID:" + objDTCOCommandVO.getRemoteDeviceSerialNumber()));
            objDTCOVO.setStatus(objDTCOCommandVO.getStatus());
            objDTCOVO.setRetryCount(objDTCOCommandVO.getRetryCount());
            objDTCOVO.setDldType(objDTCOCommandVO.getDldType());
            objDTCOVO.setTimeStamp(objDTCOCommandVO.getTimeStamp());
            objDTCOVO.setFailureCode((short)objDTCOCommandVO.getFailureCode());
            objDTCOVO.setRemoteDeviceSerialNumber(objDTCOCommandVO.getRemoteDeviceSerialNumber());
            objDTCOVO.setAuthType(objDTCOCommandVO.getAuthType());
            objDTCOVO.setTimeStampAuthenticationStarted(objDTCOCommandVO.getTimeStampAuthenticationStarted());
            objDTCOVO.setStrDTCOVersion(objDTCOCommandVO.getStrDTCOVersion());
            String machineID = Application.objServiceInfo.getIMachineId();
            logger.debug((Object)("machineID =" + machineID));
            objDTCOVO.setMachineID(GeneralAPI.convertStringToByte(machineID));
            Exception exp = null;
            int i = 0;
            while (i <= 3) {
                try {
                    if (i != 0) {
                        logger.debug((Object)("Retry attempt = " + i));
                        Thread.sleep(1000L);
                    }
                    exp = null;
                    logger.debug((Object)("Before updateStatus method... status to be set is =" + objDTCOVO.getStatus()));
                    logger.debug((Object)("Before updateStatus method... Failure code to be set is =" + objDTCOVO.getFailureCode()));
                    updateStatusFlag = InvokeRTMWebService.getInstance().updateStatus(objDTCOVO, GeneralAPI.getPassKey());
                }
                catch (Exception e) {
                    logger.error((Object)"Exception in updateStatusRemoteAuthentication:");
                    exp = e;
                }
                if (updateStatusFlag && exp == null) break;
                ++i;
            }
            if (exp != null) {
                logger.error((Object)("Exception in updateStatusRemoteAuthentication: " + exp.getMessage()));
            }
            logger.debug((Object)("update status flag value:" + updateStatusFlag));
            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(orignailEntityID));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateStatus:", (Throwable)e);
        }
    }

    public DTCOCommandVO requestListManualEntry(DTCOCommandVO objDTCOCommandVO, int CommType) throws Exception {
        DTCOVO objDTCOVO = new DTCOVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objDTCOVO = InvokeRTMWebService.getInstance().requestListManualEntry(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), objDTCOCommandVO.getStrDTCOVersion(), CommType, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in requestListManualEntry:");
                exp = e;
            }
            if (objDTCOVO.getArReminderList() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in requestListManualEntry: " + exp.getMessage()));
        }
        logger.debug((Object)("objDTCOVO.getActivityFromDate()():" + objDTCOVO.getActivityFromDate()));
        logger.debug((Object)("objDTCOVO.getActivityToDate()():" + objDTCOVO.getActivityToDate()));
        if (objDTCOVO.getArReminderList() != null) {
            logger.debug((Object)("objDTCOVO.getArReminderList():" + objDTCOVO.getArReminderList().length));
        }
        objDTCOCommandVO.setActivityFromDate(objDTCOVO.getActivityFromDate());
        objDTCOCommandVO.setActivityToDate(objDTCOVO.getActivityToDate());
        logger.debug((Object)("objDTCOVO.getSpecialFromDate()():" + objDTCOVO.getSpecialFromDate()));
        logger.debug((Object)("objDTCOVO.getSpecialToDate()():" + objDTCOVO.getSpecialToDate()));
        objDTCOCommandVO.setSpecialFromDate(objDTCOVO.getSpecialFromDate());
        objDTCOCommandVO.setSpecialToDate(objDTCOVO.getSpecialToDate());
        objDTCOCommandVO.setArReminderList(Arrays.asList(objDTCOVO.getArReminderList()));
        return objDTCOCommandVO;
    }

    public DTCOCommandVO requestListManualEntry_1b5(DTCOCommandVO objDTCOCommandVO, int CommType) throws Exception {
        DTCOVO objDTCOVO = new DTCOVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                logger.debug((Object)("Parameters passed:: VehicleRegistrationNumber:" + objDTCOCommandVO.getVehicleRegistrationNumber() + ", CompanyID:" + objDTCOCommandVO.getCompanyID() + ", StrDTCOVersion:" + objDTCOCommandVO.getStrDTCOVersion() + ", CommType:" + CommType));
                objDTCOVO = InvokeRTMWebService.getInstance().requestListManualEntry_1b5(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), objDTCOCommandVO.getStrDTCOVersion(), CommType, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in requestListManualEntry_1b5:");
                exp = e;
            }
            if (objDTCOVO.getArReminderList() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in requestListManualEntry_1b5: " + ConfigUtil.getStackTraceAsString(exp)));
        }
        logger.debug((Object)("objDTCOVO.getActivityFromDate()():" + objDTCOVO.getActivityFromDate()));
        logger.debug((Object)("objDTCOVO.getActivityToDate()():" + objDTCOVO.getActivityToDate()));
        if (objDTCOVO.getArReminderList() != null) {
            logger.debug((Object)("objDTCOVO.getArReminderList():" + objDTCOVO.getArReminderList().length));
        }
        objDTCOCommandVO.setActivityFromDate(objDTCOVO.getActivityFromDate());
        objDTCOCommandVO.setActivityToDate(objDTCOVO.getActivityToDate());
        logger.debug((Object)("objDTCOVO.getSpecialFromDate()():" + objDTCOVO.getSpecialFromDate()));
        logger.debug((Object)("objDTCOVO.getSpecialToDate()():" + objDTCOVO.getSpecialToDate()));
        objDTCOCommandVO.setSpecialFromDate(objDTCOVO.getSpecialFromDate());
        objDTCOCommandVO.setSpecialToDate(objDTCOVO.getSpecialToDate());
        objDTCOCommandVO.setArReminderList(Arrays.asList(objDTCOVO.getArReminderList()));
        return objDTCOCommandVO;
    }

    public DTCOCommandVO requestListAutomaticEntry(DTCOCommandVO objDTCOCommandVO, int CommType) throws Exception {
        DTCOVO objDTCOVO = new DTCOVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objDTCOVO = InvokeRTMWebService.getInstance().requestListAutomaticEntry_VrnWithBytes(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), objDTCOCommandVO.getStrDTCOVersion(), CommType, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in requestListAutomaticEntry:");
                exp = e;
            }
            if (objDTCOVO.getArReminderList() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in requestListAutomaticEntry: " + exp.getMessage()));
            throw exp;
        }
        objDTCOCommandVO.setArReminderList(Arrays.asList(objDTCOVO.getArReminderList()));
        return objDTCOCommandVO;
    }

    public DTCOCommandVO requestListAutomaticEntry_1b5(DTCOCommandVO objDTCOCommandVO, int CommType) throws Exception {
        DTCOVO objDTCOVO = new DTCOVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                logger.debug((Object)("Parameters passed:: VehicleRegistrationNumber:" + objDTCOCommandVO.getVehicleRegistrationNumber() + ", CompanyID:" + objDTCOCommandVO.getCompanyID() + ", StrDTCOVersion:" + objDTCOCommandVO.getStrDTCOVersion() + ", CommType:" + CommType));
                objDTCOVO = InvokeRTMWebService.getInstance().requestListAutomaticEntry_VrnWithBytes_1b5(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), objDTCOCommandVO.getStrDTCOVersion(), CommType, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in requestListAutomaticEntry_1b5:");
                exp = e;
            }
            if (objDTCOVO.getArReminderList() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in requestListAutomaticEntry_1b5: " + ConfigUtil.getStackTraceAsString(exp)));
            throw exp;
        }
        objDTCOCommandVO.setArReminderList(Arrays.asList(objDTCOVO.getArReminderList()));
        return objDTCOCommandVO;
    }

    public void updateReminderForDTCO(int reminderID) {
        logger.debug((Object)("Updating status for reminderID:" + reminderID));
        try {
            InvokeRTMWebService.getInstance().updateReminderForDTCO(reminderID, GeneralAPI.getPassKey());
            logger.debug((Object)("Status updated for reminderID:" + reminderID));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in updateReminder:", (Throwable)e);
        }
    }

    private byte[] getDriverData() {
        logger.debug((Object)"Adding Driver Data");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(1);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception while flushing ByteArrayOutputStream in getDriverData method of DTCOCommandHelper class", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private byte[] getCoDriverData() {
        logger.debug((Object)"Adding Co-Driver Data");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(2);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception while flushing ByteArrayOutputStream in getCoDriverData method of DTCOCommandHelper class", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private static byte[] getBytes(byte hexcode) {
        ByteArrayOutputStream bs1 = new ByteArrayOutputStream();
        bs1.write(hexcode);
        try {
            bs1.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception in get bytes method of DTCOCommandHelper:", (Throwable)e);
        }
        byte[] remMessage1 = bs1.toByteArray();
        return remMessage1;
    }

    private byte[] getActivitiesData(int dataType) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(2);
        bs.write(dataType);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getActivitiesData method of DTCOCommandHelper:", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private byte[] getDriverCoDriverData() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(3);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception in getDriverCoDriverData method of DTCOCommandHelper:", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    public void deleteManualReminders(String reminderIdList) {
        boolean result = false;
        try {
            logger.debug((Object)("In deleteManualReminders... Reminders ids passed are : " + reminderIdList));
            result = InvokeRTMWebService.getInstance().DeleteManualReminders(reminderIdList, GeneralAPI.getPassKey());
            if (result) {
                logger.debug((Object)"In deleteManualReminders... Reminders deleted successfully...");
            } else {
                logger.debug((Object)"In deleteManualReminders... Reminders not deleted...");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in deleteManualReminders:", (Throwable)ex);
        }
    }

    public RemoteDeviceRegistrationVO getDetails(String serialId) {
        RemoteDeviceRegistrationVO objRemoteDeviceRegistrationVO = new RemoteDeviceRegistrationVO();
        logger.debug((Object)("In getDetails passed serialid is:" + serialId));
        logger.info((Object)("In getDetails calling getDetailsWRForCTL passed serialid is:" + serialId));
        Exception exp = null;
        int i = 0;
        while (i <= 0) {
            try {
                if (i != 0) {
                    Thread.sleep(1000L);
                }
                exp = null;
                objRemoteDeviceRegistrationVO = InvokeRTMWebService.getInstance().getDetailsWRForCTL(serialId, ConfigUtil.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getDetails:");
                exp = e;
            }
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getDetails: " + exp.getMessage()));
        }
        logger.info((Object)("In getDetails After calling getDetailsWRForCTL passed serialid is:" + serialId));
        return objRemoteDeviceRegistrationVO;
    }
}

