/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.vo.DTCOCommandVO;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.tempuri.DAOResponceVO;
import org.tempuri.DTCOVO;
import org.tempuri.RemoteServiceVO;

public class RemoteServiceDao {
    private static final Logger logger = Logger.getLogger(RemoteServiceDao.class);
    private static RemoteServiceDao objRemoteServiceDao = new RemoteServiceDao();
    ConnectionPool connectionPool = ConnectionPool.getInstance();

    private RemoteServiceDao() {
    }

    public static RemoteServiceDao getInstance() {
        if (objRemoteServiceDao == null) {
            objRemoteServiceDao = new RemoteServiceDao();
        }
        return objRemoteServiceDao;
    }

    public RemoteServiceVO getRemoteServiceDetails(int accountID) {
        RemoteServiceVO objRemoteServiceVO = new RemoteServiceVO();
        try {
            objRemoteServiceVO = InvokeRTMWebService.getInstance().getRemoteServiceDetails(accountID, GeneralAPI.getPassKey());
            if (objRemoteServiceVO != null) {
                logger.debug((Object)("remote service id in getRemoteServiceDetails: " + objRemoteServiceVO.getRemoteServiceId()));
            } else {
                logger.debug((Object)"remote service id in getRemoteServiceDetails() is Null");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while getting Remote Service Details:", (Throwable)e);
        }
        return objRemoteServiceVO;
    }

    public void updateTDDLStatus(int iRemoteServiceID) {
        boolean flag = false;
        try {
            flag = InvokeRTMWebService.getInstance().updateTDDLStatus(iRemoteServiceID, GeneralAPI.getPassKey());
            logger.debug((Object)("flag value in updateTDDLStatus: " + flag));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while updating Remote Service TDDL status:", (Throwable)e);
        }
    }

    public RemoteServiceVO getRemoteServiceVO(int iRemoteServiceID) {
        RemoteServiceVO objRemoteServiceVO = new RemoteServiceVO();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objRemoteServiceVO = InvokeRTMWebService.getInstance().getRemoteServiceVO(iRemoteServiceID, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getRemoteServiceVO:");
                exp = e;
            }
            if (objRemoteServiceVO.getUserNameRS() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getRemoteServiceVO: " + exp.getMessage()));
        }
        return objRemoteServiceVO;
    }

    public List<Integer> getAllRemoteServiceIDs(ArrayList<Integer> accId) {
        ArrayList<Integer> listRemoteServiceIDs = new ArrayList<Integer>();
        Object[] listRemoteServiceIDs1 = null;
        try {
            listRemoteServiceIDs1 = InvokeRTMWebService.getInstance().getAllRemoteServiceIDs(accId.toArray(), GeneralAPI.getPassKey());
            int i = 0;
            while (i < listRemoteServiceIDs1.length) {
                listRemoteServiceIDs.add((Integer)listRemoteServiceIDs1[i]);
                ++i;
            }
            logger.debug((Object)("remote service ids from getAllRemoteServiceIDs() for Accounts:" + accId + "=" + listRemoteServiceIDs1));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getAllRemoteServiceIDs: ", (Throwable)e);
            e.printStackTrace();
            return listRemoteServiceIDs;
        }
        return listRemoteServiceIDs;
    }

    public String getPollingFrequency(int iRemoteServiceID) {
        String keyValue = "";
        logger.debug((Object)("iRemoteServiceID in getPollingFrequency() :" + iRemoteServiceID));
        try {
            keyValue = InvokeRTMWebService.getInstance().getPollingFrequency(iRemoteServiceID, GeneralAPI.getPassKey());
            logger.debug((Object)("key value in getPollingFrequency() :" + keyValue));
        }
        catch (Exception e) {
            logger.error((Object)"Exception in while getting Polling frequency:", (Throwable)e);
            e.printStackTrace();
        }
        return keyValue;
    }

    public DTCOCommandVO getRemoteServiceCompany(DTCOCommandVO objDTCOCommandVO) {
        DTCOVO objDTCOVO = new DTCOVO();
        try {
            objDTCOVO.setRemoteServiceID(objDTCOCommandVO.getRemoteServiceID());
            objDTCOVO = InvokeRTMWebService.getInstance().getRemoteServiceCompany(objDTCOVO, GeneralAPI.getPassKey());
            objDTCOCommandVO.setCompanyID(objDTCOVO.getCompanyID());
            objDTCOCommandVO.setDldType(objDTCOVO.getDldType());
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getRemoteServiceCompany:", (Throwable)e);
        }
        return objDTCOCommandVO;
    }

    public List<DAOResponceVO> getListOfRSURLs(String csvCompanyID, boolean serviceStartedTW) {
        DAOResponceVO[] alDAOResponceVO = null;
        List<DAOResponceVO> objDAOResponceVOList = new ArrayList<DAOResponceVO>();
        try {
            alDAOResponceVO = InvokeRTMWebService.getInstance().getListOfRSURLs(csvCompanyID, serviceStartedTW, GeneralAPI.getPassKey());
            logger.debug((Object)("in dao of getListOfRSURLs() alDAOResponceVO:" + alDAOResponceVO));
            objDAOResponceVOList = Arrays.asList(alDAOResponceVO);
            logger.debug((Object)("in dao of getListOfRSURLs() objDAOResponceVOList:" + objDAOResponceVOList.size()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getListOfRSURLs : " + e.getMessage()));
        }
        return objDAOResponceVOList;
    }

    public ArrayList<DAOResponceVO> getListOfRSURLsForAccessCheck(int iServiceDefinitionID) {
        ArrayList<DAOResponceVO> alDAOResponceVO;
        block12: {
            DAOResponceVO objDAOResponceVO = new DAOResponceVO();
            alDAOResponceVO = new ArrayList<DAOResponceVO>();
            Connection connection = null;
            CallableStatement stmt = null;
            ResultSet result = null;
            try {
                try {
                    connection = this.connectionPool.getConnection();
                    stmt = connection.prepareCall("{ call RTM_getListOfRSURLsForAccessCheck(?)}");
                    stmt.setInt(1, iServiceDefinitionID);
                    result = stmt.executeQuery();
                    while (result != null && result.next()) {
                        logger.debug((Object)"In while of RTM_getListOfRSURLsForAccessCheck.");
                        objDAOResponceVO.setURL(result.getString("sURL"));
                        objDAOResponceVO.setURL(result.getString("sURL"));
                        objDAOResponceVO.setProxyRequired(result.getString("ProxyRequired"));
                        objDAOResponceVO.setProxyIP(result.getString("ProxyIP"));
                        objDAOResponceVO.setProxyPort(result.getString("ProxyPort"));
                        objDAOResponceVO.setProxyUser(result.getString("ProxyUser"));
                        objDAOResponceVO.setProxyPassword(result.getString("ProxyPassword"));
                        alDAOResponceVO.add(objDAOResponceVO);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                    try {
                        ConfigUtil.cleanup(connection, stmt, result);
                    }
                    catch (SQLException e2) {
                        logger.error((Object)("SQLException: " + e2.getMessage()));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt, result);
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt, result);
            }
            catch (SQLException e) {
                logger.error((Object)("SQLException: " + e.getMessage()));
            }
        }
        return alDAOResponceVO;
    }
}

