/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.card.dao.ConnectionPool;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.vo.DTCOCommandVO;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.tempuri.CompanyCardDetails;
import org.tempuri.CompanyCardVO;

public class VehicleDetailsDao {
    ConnectionPool connectionPool = ConnectionPool.getInstance();
    private static VehicleDetailsDao objVehicleDetailsDao = new VehicleDetailsDao();
    private static final Logger logger = Logger.getLogger(CompanyDao.class);

    public static VehicleDetailsDao getInstance() {
        if (objVehicleDetailsDao == null) {
            objVehicleDetailsDao = new VehicleDetailsDao();
        }
        return objVehicleDetailsDao;
    }

    public boolean checkEntryinVehicleDetails(String sVRN, int iCompanyID) {
        Exception exp = null;
        boolean flag = false;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                flag = InvokeRTMWebService.getInstance().checkEntryinVehicleDetails(GeneralAPI.convertStringToByte(sVRN), iCompanyID, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.error((Object)"Exception in checkEntryinVehicleDetails:");
                exp = e;
            }
            if (flag && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in checkEntryinVehicleDetails: " + exp.getMessage()));
            return false;
        }
        return flag;
    }

    public int findLastDownloadDate(String sVRN, int iCompanyID) {
        return this.findLastDownloadDate(sVRN, iCompanyID, 0);
    }

    public int findLastDownloadDate(String sVRN, int accountID, int iDataDownloadDays) {
        try {
            int lLastDownloadDate = InvokeRTMWebService.getInstance().findLastDownloadDate(GeneralAPI.convertStringToByte(sVRN), accountID, iDataDownloadDays, GeneralAPI.getPassKey());
            return lLastDownloadDate;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in findLastDownloadDate :", (Throwable)e);
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * Loose catch block
     */
    public boolean IsCompanyCardforVehicleValid(String sVRN, int iCompanyCardNo) {
        Connection connection = null;
        CallableStatement stmt = null;
        connection = this.connectionPool.getConnection();
        stmt = connection.prepareCall("{ call RTM_IsCompanyCardforVehicleValid(?,?,?)}");
        stmt.setString(1, sVRN);
        stmt.setInt(2, iCompanyCardNo);
        stmt.registerOutParameter(3, 16);
        stmt.execute();
        boolean bl = stmt.getBoolean(3);
        try {
            ConfigUtil.cleanup(connection, stmt);
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException:", (Throwable)e);
        }
        return bl;
        catch (SQLException e) {
            try {
                logger.error((Object)"SQLException:", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    ConfigUtil.cleanup(connection, stmt);
                }
                catch (SQLException e2) {
                    logger.error((Object)"SQLException:", (Throwable)e2);
                }
                throw throwable;
            }
            try {
                ConfigUtil.cleanup(connection, stmt);
            }
            catch (SQLException e3) {
                logger.error((Object)"SQLException:", (Throwable)e3);
            }
            return false;
        }
    }

    public DTCOCommandVO getCompanyCard(DTCOCommandVO objDTCOCommandVO) {
        try {
            logger.info((Object)("VRN passed in getCompanyCard:" + objDTCOCommandVO.getVehicleRegistrationNumber()));
            logger.info((Object)("accountid passed in getCompanyCard:" + objDTCOCommandVO.getCompanyID()));
            CompanyCardVO objCompanyCardVO = InvokeRTMWebService.getInstance().getCompanyCardWR(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), GeneralAPI.getPassKey());
            CompanyCardDetails[] objCompanyCardDetails = objCompanyCardVO.getLstCompanyCardDetails();
            if (objCompanyCardDetails != null) {
                CompanyCardDetails[] companyCardDetailsArray = objCompanyCardDetails;
                int n = objCompanyCardDetails.length;
                int n2 = 0;
                while (n2 < n) {
                    CompanyCardDetails objCompanyCardDetailsKey = companyCardDetailsArray[n2];
                    objDTCOCommandVO.setCompanyCardNo(objCompanyCardDetailsKey.getStrCompanyCardNumber());
                    ++n2;
                }
            } else {
                logger.debug((Object)"objCompanyCardDetails is NULL...");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getCompanyCard :", (Throwable)e);
        }
        return objDTCOCommandVO;
    }

    public List<String> getCompanyCardWR_1b1(DTCOCommandVO objDTCOCommandVO) {
        ArrayList<String> companyCardNumberList = new ArrayList<String>();
        try {
            CompanyCardVO objCompanyCardVO = InvokeRTMWebService.getInstance().getComapanyCardWR_1b1(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), GeneralAPI.getPassKey());
            CompanyCardDetails[] objCompanyCardDetails = objCompanyCardVO.getLstCompanyCardDetails();
            if (objCompanyCardDetails != null) {
                CompanyCardDetails[] companyCardDetailsArray = objCompanyCardDetails;
                int n = objCompanyCardDetails.length;
                int n2 = 0;
                while (n2 < n) {
                    CompanyCardDetails objCompanyCardDetailsKey = companyCardDetailsArray[n2];
                    companyCardNumberList.add(objCompanyCardDetailsKey.getStrCompanyCardNumber());
                    logger.info((Object)("Adding company card no. " + objCompanyCardDetailsKey.getStrCompanyCardNumber() + " in list"));
                    ++n2;
                }
            } else {
                logger.debug((Object)"objCompanyCardDetails is NULL...");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getCompanyCard :" + ConfigUtil.getStackTraceAsString(e)));
        }
        return companyCardNumberList;
    }

    public List<String> getComapanyCardWR_1b1_MachineIDbased(DTCOCommandVO objDTCOCommandVO) {
        ArrayList<String> companyCardNumberList = new ArrayList<String>();
        try {
            CompanyCardVO objCompanyCardVO = InvokeRTMWebService.getInstance().getComapanyCardWR_1b1_MachineIDbased(objDTCOCommandVO.getVehicleRegistrationNumber(), objDTCOCommandVO.getCompanyID(), GeneralAPI.getPassKey());
            logger.info((Object)(" in getComapanyCardWR_1b1_MachineIDbased() VRN passed:" + objDTCOCommandVO.getVehicleRegistrationNumber()));
            logger.info((Object)(" in getComapanyCardWR_1b1_MachineIDbased() CompanyID Passed: " + objDTCOCommandVO.getCompanyID()));
            CompanyCardDetails[] objCompanyCardDetails = objCompanyCardVO.getLstCompanyCardDetails();
            if (objCompanyCardDetails != null) {
                CompanyCardDetails[] companyCardDetailsArray = objCompanyCardDetails;
                int n = objCompanyCardDetails.length;
                int n2 = 0;
                while (n2 < n) {
                    CompanyCardDetails objCompanyCardDetailsKey = companyCardDetailsArray[n2];
                    companyCardNumberList.add(objCompanyCardDetailsKey.getStrCompanyCardNumber());
                    logger.info((Object)("Adding Company card no. " + objCompanyCardDetailsKey.getStrCompanyCardNumber() + " in list"));
                    ++n2;
                }
            } else {
                logger.debug((Object)"objCompanyCardDetails is NULL...");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getCompanyCard :" + ConfigUtil.getStackTraceAsString(e)));
        }
        return companyCardNumberList;
    }
}

