/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.dao;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountVO;
import org.tempuri.DueDownloadVORTM;
import org.tempuri.ServiceInfo;
import org.tempuri.ServiceVO;
import org.tempuri.WRAccountsVO;

public class WebServiceXMLDetailsDao {
    private static final Logger logger = Logger.getLogger(CompanyDao.class);
    private static WebServiceXMLDetailsDao objWebServiceXMLDetailsDao = new WebServiceXMLDetailsDao();

    private WebServiceXMLDetailsDao() {
    }

    public static WebServiceXMLDetailsDao getInstance() {
        if (objWebServiceXMLDetailsDao == null) {
            objWebServiceXMLDetailsDao = new WebServiceXMLDetailsDao();
        }
        return objWebServiceXMLDetailsDao;
    }

    public ArrayList<ServiceVO> createServices(ArrayList<ServiceVO> serviceVOList) {
        ArrayList serviceVOList1 = new ArrayList();
        return serviceVOList;
    }

    public String updateServiceIdStatus(int serviceId1, int serviceId2, int accountId) {
        String result = "";
        try {
            result = InvokeRTMWebService.getInstance().updateServiceIdStatus(serviceId1, serviceId2, accountId, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)("Exception in updateServiceIdStatus in WebServiceXMLDetailsDao : " + e.getMessage()));
        }
        return result;
    }

    public AccountDetailsXMLParent getAccountsFromServiceID(int serviceIDAuth, int commServiceId) throws Exception {
        AccountDetailsXMLParent accParent = new AccountDetailsXMLParent();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                logger.debug((Object)("Auth Service ad BEFORE INVOKING WEBSERVICE:" + serviceIDAuth));
                logger.debug((Object)("Comm Service ad BEFORE INVOKING WEBSERVICE:" + commServiceId));
                accParent = InvokeRTMWebService.getInstance().getAccountsFromServiceIDWR(serviceIDAuth, commServiceId, GeneralAPI.getPassKey());
            }
            catch (Exception e) {
                logger.debug((Object)"Exception in getAccountsFromServiceID(int serviceIDAuth) method...");
                exp = e;
            }
            if (accParent != null && accParent.getAccounts() != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getAccountsFromServiceID in WebServiceXMLDetailsDao : " + exp.getMessage()));
            throw exp;
        }
        if (accParent != null) {
            logger.debug((Object)(" accParent length in dao:" + accParent.getAccounts()));
        } else {
            logger.debug((Object)"accParent is null");
        }
        return accParent;
    }

    public ServiceInfo refreshServiceXMLServiceIDExist(int serviceId1, boolean proxyUsed, String host, String port, String user, String password) {
        logger.info((Object)"Start of refreshServiceXMLServiceIDExist....");
        ServiceInfo result = new ServiceInfo();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                result = InvokeRTMWebService.getInstance().refreshServiceXML1WR(serviceId1, proxyUsed, host, port, user, password, GeneralAPI.getPassKey());
                logger.info((Object)(" in web serv xml dao refreshServiceXMLServiceIDExist:" + result));
            }
            catch (Exception e) {
                logger.error((Object)"Exception in refreshServiceXMLServiceIDExist in WebServiceXMLDetailsDao");
                exp = e;
            }
            if (result != null && result.getServices() != null && exp == null && this.validateReceivedServiceID(result)) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in refreshServiceXMLServiceIDExist in WebServiceXMLDetailsDao : " + exp.getMessage()));
            result = null;
        }
        return result;
    }

    public ServiceInfo refreshServiceXMLServiceIDNotExist(ServiceInfo servInfo) {
        logger.info((Object)"**Start of refreshServiceXMLServiceIDNotExist....");
        logger.info((Object)("****************** servInfo = .... " + servInfo));
        ServiceInfo result = new ServiceInfo();
        Exception exp = null;
        int i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                result = InvokeRTMWebService.getInstance().refreshServiceXML2WR(servInfo, GeneralAPI.getPassKey());
                logger.info((Object)(" in web serv xml dao refreshServiceXMLServiceIDNotExist:" + result));
            }
            catch (Exception e) {
                logger.error((Object)"Exception in refreshServiceXMLServiceIDNotExist in WebServiceXMLDetailsDao");
                exp = e;
            }
            if (result != null && result.getServices() != null && exp == null && this.validateReceivedServiceID(result)) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in refreshServiceXMLServiceIDNotExist in WebServiceXMLDetailsDao : " + exp.getMessage()));
            result = null;
        }
        return result;
    }

    private boolean validateReceivedServiceID(ServiceInfo serviceInfo) {
        logger.info((Object)"Start of validateReceivedServiceID...");
        boolean validData = false;
        ServiceVO[] objServiceVO = null;
        if (serviceInfo != null && serviceInfo.getServices() != null) {
            objServiceVO = serviceInfo.getServices();
            int authServiceId = 0;
            int commServiceId = 0;
            int i = 0;
            while (i < objServiceVO.length) {
                if (i == 0) {
                    authServiceId = objServiceVO[i].getIServiceID();
                    logger.info((Object)("authServiceId in validateReceivedServiceID =" + authServiceId));
                } else {
                    commServiceId = objServiceVO[i].getIServiceID();
                    logger.info((Object)("commServiceId in validateReceivedServiceID =" + commServiceId));
                }
                ++i;
            }
            if (authServiceId != 0 && commServiceId != 0) {
                validData = true;
            }
        }
        logger.info((Object)("End of validateReceivedServiceID..... return value =" + validData));
        return validData;
    }

    public void refreshSiteData(DueDownloadVORTM objDueDownloadVORTM, int archMode, int accId) {
        try {
            InvokeRTMWebService.getInstance().getMasterDataOfSite(objDueDownloadVORTM, accId, archMode, GeneralAPI.getPassKey());
        }
        catch (Exception e) {
            logger.error((Object)("Exception in refreshSiteData in WebServiceXMLDetailsDao : " + e.getMessage()));
        }
    }

    public AccountVO[] getAccountsDetailsToUpdateList(ArrayList<Integer> accIDs) {
        WRAccountsVO objWRAccountsVO = null;
        AccountVO[] objAccountVO = null;
        Exception exp = null;
        String strIDs = "";
        int i = 0;
        while (i < accIDs.size()) {
            strIDs = strIDs.equals("") ? "" + accIDs.get(i) : String.valueOf(strIDs) + "#" + accIDs.get(i);
            ++i;
        }
        i = 0;
        while (i <= 3) {
            try {
                if (i != 0) {
                    logger.debug((Object)("Retry attempt = " + i));
                    Thread.sleep(1000L);
                }
                exp = null;
                objWRAccountsVO = InvokeRTMWebService.getInstance().getAccountDetailsToUpdateListWR(strIDs, GeneralAPI.getPassKey());
                objAccountVO = objWRAccountsVO.getWRAccounts();
            }
            catch (Exception e) {
                logger.error((Object)"Exception in getAccountsDetailsToUpdateList:");
                exp = e;
            }
            if (objAccountVO != null && exp == null) break;
            ++i;
        }
        if (exp != null) {
            logger.error((Object)("Exception in getAccountsDetailsToUpdateList in WebServiceXMLDetailsDao: " + exp.getMessage()));
        }
        return objAccountVO;
    }

    public int getListUpdateTime(int serviceID) {
        int interval = 5;
        try {
            logger.debug((Object)("Inside getListUpdateTime... serviceID = " + serviceID));
            interval = InvokeRTMWebService.getInstance().getListUpdateTime(serviceID, GeneralAPI.getPassKey());
            logger.debug((Object)("Inside getListUpdateTime... interval = " + interval));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getListUpdateTime in WebServiceXMLDetailsDao : " + e.getMessage()));
        }
        return interval;
    }
}

