/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.fileTransfer.state;

import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownloadSoap;
import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownload_Impl;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.DTCOFileTransferStatusDao;
import com.sisl.dtco.fileTransfer.state.GenericFileTransferState;
import com.sisl.dtco.fileTransfer.state.RetryState;
import com.sisl.dtco.fileTransfer.state.SetFileListStatusState;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.vo.FileDetails;
import com.sisl.dtco.vo.FileListVO;
import com.sisl.dtco.vo.FileTransferStateVO;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.tempuri.FileTransferStatusVO;
import org.tempuri.GetFileList;
import org.tempuri.GetFileListResponse;

public class GetFileListState
extends GenericFileTransferState {
    String sessionId = "";
    int returnValue = 0;
    FileTransferStateVO objFileTransferStateVO;
    FileTransferTask objFileTransferTask;
    int retryCount = 0;
    FileDetails[] fileDetails;
    private static final Logger logger = Logger.getLogger(GetFileListState.class);

    public GetFileListState(FileTransferStateVO objFileTransferStateVO, FileTransferTask objFileTransferTask) {
        this.objFileTransferStateVO = objFileTransferStateVO;
        this.objFileTransferTask = objFileTransferTask;
    }

    @Override
    public void processState() {
        try {
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            RemoteServiceFileDownload_Impl objRemoteService = new RemoteServiceFileDownload_Impl();
            RemoteServiceFileDownloadSoap objRemoteServiceSoap = null;
            objRemoteServiceSoap = objRemoteService.getRemoteServiceFileDownloadSoap();
            String url = this.objFileTransferStateVO.getUrl();
            ((Stub)objRemoteServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
            GetFileList objGetFileList = new GetFileList();
            objGetFileList.setSessionId(this.objFileTransferStateVO.getSessionId());
            objGetFileList.setMode(0);
            GetFileListResponse objGetFileListResponse = objRemoteServiceSoap.GetFileList(objGetFileList);
            this.returnValue = objGetFileListResponse.getGetFileListResult();
            logger.info((Object)(" return value from RS:" + this.returnValue));
            if (this.returnValue == 0) {
                XStream objXStream = new XStream();
                Object objFileList = null;
                objXStream.alias("FileListVO", FileListVO.class);
                objXStream.alias("FileDetails", FileDetails.class);
                String xmlFromRS = objGetFileListResponse.getFileList();
                logger.debug((Object)("XML string as received from RS ID:" + this.objFileTransferStateVO.getRemoteServiceID() + " is: " + xmlFromRS));
                objFileList = objXStream.fromXML(xmlFromRS);
                FileListVO fileListVO = (FileListVO)objFileList;
                fileListVO = this.removeColonFromFileListVO(fileListVO);
                this.fileDetails = fileListVO.getFiles();
                this.objFileTransferStateVO.setFileListId(objGetFileListResponse.getFileListId());
            }
            this.processResponse(this.returnValue);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not connect to remote service", (Throwable)ex);
            this.objFileTransferStateVO.setStateId(1);
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (ServiceException ex) {
            logger.info((Object)"Remote Service exception", (Throwable)ex);
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(1);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception Occured", (Throwable)ex);
            return;
        }
    }

    @Override
    public void processResponse(int response) {
        try {
            if (response == 0) {
                int i = 0;
                while (i < this.fileDetails.length) {
                    logger.debug((Object)("File number: " + i));
                    FileTransferStatusVO objFileTransferStatusVO = new FileTransferStatusVO();
                    String entityType = this.fileDetails[i].getEntityType().toString();
                    String entityId = this.fileDetails[i].getEntityId();
                    if (entityId == null) {
                        logger.error((Object)"Entity Id is null so moving to next file");
                    } else {
                        entityId = entityId.trim();
                        if (entityType.equalsIgnoreCase("1")) {
                            entityId = "D" + entityId;
                        } else if (entityType.equalsIgnoreCase("2")) {
                            entityId = "V" + entityId;
                        } else if (entityType.equalsIgnoreCase("3")) {
                            entityId = "S" + entityId;
                        }
                        objFileTransferStatusVO.setSerialId(this.fileDetails[i].getDLDSerialId());
                        objFileTransferStatusVO.setInitTimeStamp(this.fileDetails[i].getTimestamp());
                        objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                        objFileTransferStatusVO.setStatusCode((short)Byte.parseByte(this.fileDetails[i].getStatus()));
                        objFileTransferStatusVO.setEntityName(GeneralAPI.convertStringToByte(this.fileDetails[i].getEntityName()));
                        objFileTransferStatusVO.setFileName(GeneralAPI.convertStringToByte(this.fileDetails[i].getFileName()));
                        objFileTransferStatusVO.setCompanyID(this.objFileTransferStateVO.getCompanyID());
                        objFileTransferStatusVO.setDldType(this.objFileTransferStateVO.getDldType());
                        logger.debug((Object)("File Name and status: " + this.fileDetails[i].getFileName() + ":" + this.fileDetails[i].getStatus()));
                        DTCOFileTransferStatusDao objFileTransferStatusDao = DTCOFileTransferStatusDao.getInstance();
                        this.objFileTransferStateVO.setFileListStatus(0);
                        int reminderID = objFileTransferStatusDao.getReminderIdForFileTransfer(objFileTransferStatusVO);
                        objFileTransferStatusVO.setReminderID(reminderID);
                        objFileTransferStatusVO = objFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        short status = objFileTransferStatusVO.getStatusCode();
                        logger.debug((Object)("objFileTransferStatusVO.getUpdatedStatus():" + objFileTransferStatusVO.getUpdatedStatus()));
                        logger.debug((Object)("File status:" + status));
                        CompanyDao objCompanyDao = CompanyDao.getInstance();
                        if (objFileTransferStatusVO.getUpdatedStatus() == -1) {
                            logger.debug((Object)("Entry for id : " + objFileTransferStatusVO.getEntityId() + "not found so going to insert"));
                            boolean lineInserted = objFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objFileTransferStateVO.getRemoteServiceID());
                            if (lineInserted && status != 2 && status != 6 && status != 7) {
                                objCompanyDao.updateLastDownloadDate(objFileTransferStatusVO.getCompanyID(), entityId, GeneralAPI.byteToString(objFileTransferStatusVO.getEntityName()), objFileTransferStatusVO.getInitTimeStamp());
                            }
                            if (status == 3 && entityId.startsWith("S")) {
                                logger.debug((Object)("Update Special Data Download Status for :" + entityId));
                                objFileTransferStatusDao.updateSpecialDataDownloadStatus(objFileTransferStatusVO.getCompanyID(), entityId.substring(1));
                            }
                        } else if (objFileTransferStatusVO.getUpdatedStatus() == 1) {
                            int previousStatus = objFileTransferStatusVO.getPreviousStatus();
                            logger.debug((Object)("before Previous code:" + previousStatus));
                            if (previousStatus == 1 || previousStatus == 0) {
                                previousStatus = 8;
                            } else if (previousStatus == 3) {
                                previousStatus = 2;
                            }
                            logger.debug((Object)("after Previous code:" + previousStatus));
                            if (!(status != 1 && status != 5 && status != 4 || previousStatus != 0 && previousStatus != 8 && previousStatus != 2)) {
                                logger.debug((Object)("going to update vehicle/codriver details file for :" + entityId));
                                objCompanyDao.updateLastDownloadDate(objFileTransferStatusVO.getCompanyID(), entityId, GeneralAPI.byteToString(objFileTransferStatusVO.getEntityName()), objFileTransferStatusVO.getInitTimeStamp());
                            }
                            if (status == 3 && entityId.startsWith("S")) {
                                logger.debug((Object)("Update Special Data Download Status for :" + entityId));
                                objFileTransferStatusDao.updateSpecialDataDownloadStatus(objFileTransferStatusVO.getCompanyID(), entityId.substring(1));
                            }
                        }
                    }
                    ++i;
                }
                logger.info((Object)("Going to set the fileListStatus with status: " + this.objFileTransferStateVO.getFileListStatus()));
                logger.debug((Object)("Setting current state to SetFileListStatusState for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
                this.objFileTransferTask.setCurrentState(new SetFileListStatusState(this.objFileTransferStateVO, this.objFileTransferTask));
                this.objFileTransferTask.processState();
            } else {
                logger.info((Object)("Setting current state to Retry State for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
                this.objFileTransferStateVO.setStateId(1);
                this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
                this.objFileTransferTask.processState();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileListVO removeColonFromFileListVO(FileListVO fileListVo) {
        if (fileListVo != null && fileListVo.getFiles() != null) {
            int i = 0;
            while (i < fileListVo.getFiles().length) {
                String entityName = fileListVo.getFiles()[i].getEntityName();
                if (entityName != null && entityName.contains("; ")) {
                    logger.debug((Object)("Inside removeColonFromFileListVO.... Entity name contains (; ).... Entity name is = " + entityName));
                    entityName = entityName.replace("; ", ", ");
                    fileListVo.getFiles()[i].setEntityName(entityName);
                    logger.debug((Object)("Inside removeColonFromFileListVO.... Entity name changed to = " + entityName));
                }
                ++i;
            }
        }
        return fileListVo;
    }
}

