/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.fileTransfer.state;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.fileTransfer.state.GenericFileTransferState;
import com.sisl.dtco.fileTransfer.state.GetFileListState;
import com.sisl.dtco.fileTransfer.state.SetFileListStatusState;
import com.sisl.dtco.fileTransfer.state.SignOffState;
import com.sisl.dtco.fileTransfer.state.SignOnState;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.vo.FileTransferStateVO;
import org.apache.log4j.Logger;

public class RetryState
extends GenericFileTransferState {
    String sessionId = "";
    int maxNumberOfRetry = 0;
    int waitTimeForNextRetry = 0;
    FileTransferStateVO objFileTransferStateVO;
    FileTransferTask objFileTransferTask;
    int retryCount = 0;
    private static final Logger logger = Logger.getLogger(SignOnState.class);

    public RetryState(FileTransferStateVO objFileTransferStateVO, FileTransferTask objFileTransferTask) {
        this.objFileTransferStateVO = objFileTransferStateVO;
        this.objFileTransferTask = objFileTransferTask;
        this.maxNumberOfRetry = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfRetry"));
        this.waitTimeForNextRetry = Integer.parseInt(ConfigUtil.getValue("WaitTimeForNextRetry"));
        if (this.maxNumberOfRetry > 5 || this.maxNumberOfRetry < 1) {
            this.maxNumberOfRetry = 3;
        }
    }

    @Override
    public void processState() {
        logger.debug((Object)("Current state Retry State for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
        switch (this.objFileTransferStateVO.getStateId()) {
            case 0: {
                this.retryCount = this.objFileTransferStateVO.getSignOnRetryCount();
                if (this.objFileTransferStateVO.getSignOnRetryCount() < this.maxNumberOfRetry) {
                    try {
                        Thread.sleep(this.waitTimeForNextRetry * 1000);
                    }
                    catch (InterruptedException ex) {
                        logger.error((Object)"thread interrupted:", (Throwable)ex);
                        return;
                    }
                    logger.info((Object)("Going to retry signOn: retry number " + this.retryCount + 1));
                    this.objFileTransferStateVO.setSignOnRetryCount(this.retryCount + 1);
                    this.objFileTransferTask.setCurrentState(new SignOnState(this.objFileTransferStateVO, this.objFileTransferTask));
                    this.objFileTransferTask.processState();
                    break;
                }
                logger.error((Object)"Max number of retries for signOn exhausted, process for file transfer terminited");
                break;
            }
            case 1: {
                this.retryCount = this.objFileTransferStateVO.getGetFileListRetryCount();
                if (this.retryCount < this.maxNumberOfRetry) {
                    try {
                        Thread.sleep(this.waitTimeForNextRetry * 1000);
                    }
                    catch (InterruptedException ex) {
                        logger.error((Object)"thread interrupted:", (Throwable)ex);
                        return;
                    }
                    logger.info((Object)"Going to retry getFileList");
                    logger.info((Object)("Going to retry getFileList: retry number " + this.retryCount + 1));
                    this.objFileTransferStateVO.setGetFileListRetryCount(this.retryCount + 1);
                    this.objFileTransferTask.setCurrentState(new GetFileListState(this.objFileTransferStateVO, this.objFileTransferTask));
                    this.objFileTransferTask.processState();
                    break;
                }
                logger.info((Object)("Max number of retries exhausted for GetFileList, so setting status to failed for FileListId:" + this.objFileTransferStateVO.getFileListId()));
                this.objFileTransferStateVO.setFileListStatus(1);
                this.objFileTransferTask.setCurrentState(new SetFileListStatusState(this.objFileTransferStateVO, this.objFileTransferTask));
                this.objFileTransferTask.processState();
                break;
            }
            case 2: {
                this.retryCount = this.objFileTransferStateVO.getSetFileListStatusRetryCount();
                if (this.retryCount < this.maxNumberOfRetry) {
                    try {
                        Thread.sleep(this.waitTimeForNextRetry * 1000);
                    }
                    catch (InterruptedException ex) {
                        logger.error((Object)"thread interrupted: ", (Throwable)ex);
                        return;
                    }
                    logger.info((Object)("Going to retry setFileListStatus: retry number " + this.retryCount + 1));
                    this.objFileTransferStateVO.setSetFileListStatusRetryCount(this.retryCount + 1);
                    this.objFileTransferTask.setCurrentState(new SetFileListStatusState(this.objFileTransferStateVO, this.objFileTransferTask));
                    this.objFileTransferTask.processState();
                    break;
                }
                logger.info((Object)"Max number of retries exhausted for SetFileListStatus");
                break;
            }
            case 3: {
                this.retryCount = this.objFileTransferStateVO.getSignOffRetryCount();
                if (this.retryCount < this.maxNumberOfRetry) {
                    try {
                        Thread.sleep(this.waitTimeForNextRetry * 1000);
                    }
                    catch (InterruptedException ex) {
                        logger.error((Object)"thread interrupted: ", (Throwable)ex);
                        return;
                    }
                    logger.info((Object)("Going to retry SignOff retry number " + this.retryCount + 1));
                    this.objFileTransferStateVO.setSetFileListStatusRetryCount(this.retryCount + 1);
                    this.objFileTransferTask.setCurrentState(new SignOffState(this.objFileTransferStateVO, this.objFileTransferTask));
                    this.objFileTransferTask.processState();
                    break;
                }
                logger.info((Object)"Max number of retries exhausted for SignOff");
            }
        }
    }
}

