/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.fileTransfer.state;

import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownloadSoap;
import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownload_Impl;
import com.sisl.dtco.fileTransfer.state.GenericFileTransferState;
import com.sisl.dtco.fileTransfer.state.RetryState;
import com.sisl.dtco.fileTransfer.state.SignOffState;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.vo.FileTransferStateVO;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.tempuri.SetFileListStatus;
import org.tempuri.SetFileListStatusResponse;

public class SetFileListStatusState
extends GenericFileTransferState {
    FileTransferStateVO objFileTransferStateVO;
    FileTransferTask objFileTransferTask;
    int returnValue;
    String url = null;
    private static final Logger logger = Logger.getLogger(SetFileListStatus.class);

    public SetFileListStatusState(FileTransferStateVO objFileTransferStateVO, FileTransferTask objFileTransferTask) {
        this.objFileTransferStateVO = objFileTransferStateVO;
        this.objFileTransferTask = objFileTransferTask;
    }

    @Override
    public void processState() {
        try {
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            RemoteServiceFileDownload_Impl objRemoteService = new RemoteServiceFileDownload_Impl();
            RemoteServiceFileDownloadSoap objRemoteServiceSoap = null;
            SetFileListStatus objSetFileListStatus = new SetFileListStatus();
            objSetFileListStatus.setSessionId(this.objFileTransferStateVO.getSessionId());
            objSetFileListStatus.setFileListStatus(this.objFileTransferStateVO.getFileListStatus());
            objSetFileListStatus.setFileListId(this.objFileTransferStateVO.getFileListId());
            objRemoteServiceSoap = objRemoteService.getRemoteServiceFileDownloadSoap();
            this.url = this.objFileTransferStateVO.getUrl();
            ((Stub)objRemoteServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            SetFileListStatusResponse objSetFileListStatusResponse = objRemoteServiceSoap.SetFileListStatus(objSetFileListStatus);
            this.returnValue = objSetFileListStatusResponse.getSetFileListStatusResult();
            logger.debug((Object)("RS ID:" + this.objFileTransferStateVO.getRemoteServiceID() + " ; Return Value:" + this.returnValue));
            this.processResponse(this.returnValue);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not connect to remote service", (Throwable)ex);
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(2);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (ServiceException ex) {
            logger.info((Object)"Remote Service exception", (Throwable)ex);
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(2);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (Exception ex) {
            logger.info((Object)"Exception occured: ", (Throwable)ex);
            return;
        }
    }

    @Override
    public void processResponse(int response) {
        if (response == 0) {
            logger.debug((Object)("Setting current state to SignOffState for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
            this.objFileTransferTask.setCurrentState(new SignOffState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        } else {
            logger.info((Object)("Setting current state to Retry State for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
            this.objFileTransferStateVO.setStateId(2);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
    }
}

