/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.fileTransfer.state;

import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownloadSoap;
import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownload_Impl;
import com.sisl.dtco.fileTransfer.state.GenericFileTransferState;
import com.sisl.dtco.fileTransfer.state.RetryState;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.vo.FileTransferStateVO;
import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.tempuri.SetFileListStatus;
import org.tempuri.SignOff;
import org.tempuri.SignOffResponse;

public class SignOffState
extends GenericFileTransferState {
    FileTransferStateVO objFileTransferStateVO;
    FileTransferTask objFileTransferTask;
    int returnValue;
    String url = null;
    private static final Logger logger = Logger.getLogger(SetFileListStatus.class);

    public SignOffState(FileTransferStateVO objFileTransferStateVO, FileTransferTask objFileTransferTask) {
        this.objFileTransferStateVO = objFileTransferStateVO;
        this.objFileTransferTask = objFileTransferTask;
    }

    @Override
    public void processState() {
        try {
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            RemoteServiceFileDownload_Impl objRemoteService = new RemoteServiceFileDownload_Impl();
            RemoteServiceFileDownloadSoap objRemoteServiceSoap = null;
            SignOff objSignOff = new SignOff();
            objSignOff.setSessionId(this.objFileTransferStateVO.getSessionId());
            objRemoteServiceSoap = objRemoteService.getRemoteServiceFileDownloadSoap();
            this.url = this.objFileTransferStateVO.getUrl();
            ((Stub)objRemoteServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url);
            SignOffResponse objSignOffResponse = objRemoteServiceSoap.SignOff(objSignOff);
            this.returnValue = objSignOffResponse.getSignOffResult();
            logger.debug((Object)("RS ID:" + this.objFileTransferStateVO.getRemoteServiceID() + " ; Return Value:" + this.returnValue));
            this.processResponse(this.returnValue);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not connect to remote service");
            ex.printStackTrace();
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(3);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (ServiceException ex) {
            logger.info((Object)"Remote Service exception");
            ex.printStackTrace();
            logger.info((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(3);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
    }

    @Override
    public void processResponse(int response) {
        if (response == 0) {
            logger.info((Object)("SignOff for session: " + this.objFileTransferStateVO.getSessionId() + " :successful"));
            logger.debug((Object)("Sign off from RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
        } else {
            logger.info((Object)("Setting current state to Retry State for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
            this.objFileTransferStateVO.setStateId(3);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
    }
}

