/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.fileTransfer.state;

import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownloadSoap;
import com.siemens.remoteservice.webservice.client.remote.RemoteServiceFileDownload_Impl;
import com.sisl.dldcomm.util.SSLUtilities;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.fileTransfer.state.GenericFileTransferState;
import com.sisl.dtco.fileTransfer.state.GetFileListState;
import com.sisl.dtco.fileTransfer.state.RetryState;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.vo.FileTransferStateVO;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.tempuri.RemoteServiceVO;
import org.tempuri.SignOn;
import org.tempuri.SignOnResponse;

public class SignOnState
extends GenericFileTransferState {
    String sessionId = "";
    int returnValue = 0;
    FileTransferStateVO objFileTransferStateVO;
    FileTransferTask objFileTransferTask;
    private static final Logger logger = Logger.getLogger(SignOnState.class);

    public SignOnState(FileTransferStateVO objFileTransferStateVO, FileTransferTask objFileTransferTask) {
        this.objFileTransferStateVO = objFileTransferStateVO;
        this.objFileTransferTask = objFileTransferTask;
    }

    @Override
    public void processState() {
        String url = null;
        try {
            SSLUtilities.trustAllHostnames();
            SSLUtilities.trustAllHttpsCertificates();
            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
            RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceVO(this.objFileTransferStateVO.getRemoteServiceID());
            logger.debug((Object)("SigninOn to RS :" + this.objFileTransferStateVO.getDldType()));
            RemoteServiceFileDownload_Impl objRemoteService = new RemoteServiceFileDownload_Impl();
            RemoteServiceFileDownloadSoap objRemoteServiceSoap = null;
            SignOn objSignOn = new SignOn();
            objRemoteServiceSoap = objRemoteService.getRemoteServiceFileDownloadSoap();
            url = GeneralAPI.getRSURL(objRemoteServiceVO.getUrlRS());
            this.objFileTransferStateVO.setUrl(url);
            this.objFileTransferStateVO.setDldType(objRemoteServiceVO.getDldType());
            this.objFileTransferStateVO.setCompanyID(objRemoteServiceVO.getCompanyID());
            logger.debug((Object)("going to sign on to WR2 with URL: " + url));
            ((Stub)objRemoteServiceSoap)._setProperty("javax.xml.rpc.service.endpoint.address", (Object)url);
            objSignOn.setAccount(objRemoteServiceVO.getAccountNameRS());
            objSignOn.setUserName(objRemoteServiceVO.getUserNameRS());
            String pwdFromDataBase = objRemoteServiceVO.getPasswordRS();
            if (pwdFromDataBase != null) {
                objSignOn.setPassword(GeneralAPI.jumbleString(pwdFromDataBase));
            } else {
                objSignOn.setPassword(pwdFromDataBase);
            }
            boolean proxyRequiredforService = Application.proxyServerUsedReg;
            if (proxyRequiredforService) {
                String proxyHost = Application.proxyHostReg;
                int proxyPort = 0;
                if (Application.proxyPortReg.length() > 0) {
                    proxyPort = Integer.parseInt(Application.proxyPortReg);
                }
                final String proxyUser = Application.proxyUserReg;
                final String proxyPassword = Application.proxyPasswordReg;
                if (url.split("//")[0].equalsIgnoreCase("https:")) {
                    System.setProperty("https.proxySet", "true");
                    System.setProperty("https.proxyHost", proxyHost);
                    System.setProperty("https.proxyPort", String.valueOf(proxyPort));
                }
                if (url.split("//")[0].equalsIgnoreCase("http:")) {
                    System.setProperty("http.proxySet", "true");
                    System.setProperty("http.proxyHost", proxyHost);
                    System.setProperty("http.proxyPort", String.valueOf(proxyPort));
                }
                if (proxyUser != null && proxyUser.trim().length() > 0 && proxyPassword != null && proxyPassword.trim().length() > 0) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            logger.debug((Object)("Feeding username and password for " + this.getRequestingScheme()));
                            return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                        }
                    });
                }
            }
            SignOnResponse objSignOnResponse = objRemoteServiceSoap.SignOn(objSignOn);
            this.returnValue = objSignOnResponse.getSignOnResult();
            if (this.returnValue == 0) {
                this.objFileTransferStateVO.setSessionId(objSignOnResponse.getSessionId());
            }
            logger.debug((Object)("RS ID:" + this.objFileTransferStateVO.getRemoteServiceID() + " ; Return Value:" + this.returnValue));
            this.processResponse(this.returnValue);
        }
        catch (IOException ex) {
            logger.error((Object)"Could not connect to remote service: ", (Throwable)ex);
            logger.error((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(0);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (ServiceException ex) {
            logger.error((Object)"Remote Service exception: ", (Throwable)ex);
            logger.error((Object)"Setting current state to retryState");
            this.objFileTransferStateVO.setStateId(0);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception occured: ", (Throwable)ex);
            return;
        }
    }

    @Override
    public void processResponse(int response) {
        if (this.returnValue == 0) {
            logger.debug((Object)("Setting current state to GetFileListState for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
            this.objFileTransferTask.setCurrentState(new GetFileListState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        } else {
            logger.info((Object)("Setting current state to Retry State for RS ID:" + this.objFileTransferStateVO.getRemoteServiceID()));
            this.objFileTransferStateVO.setStateId(0);
            this.objFileTransferTask.setCurrentState(new RetryState(this.objFileTransferStateVO, this.objFileTransferTask));
            this.objFileTransferTask.processState();
        }
    }
}

