/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.dao.WebServiceXMLDetailsDao;
import com.sisl.dtco.integration.AccountServiceUpdation;
import com.sisl.dtco.integration.ClientXMLThread;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.vo.ResponseMessage;
import com.sisl.dtco.vo.UrlRead;
import com.sisl.dtco.vo.XMLObject;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.ServiceInfo;
import org.tempuri.ServiceVO;

public class AccountManagement {
    private static final Logger logger = Logger.getLogger(AccountManagement.class);
    String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
    public static AccountDetailsXMLParent objAccDetailsVO = new AccountDetailsXMLParent();
    public static ServiceInfo objServiceDetailsVO = new ServiceInfo();

    public ResponseMessage add(int accID, String accName, int archvMode, int deviceType, String sTISOfficeServer, boolean bSVSpecificDataIndicator, String sTISOfficeCompany, boolean bIsActivityDataBlock, boolean bIsEventandFaultsDataBlock, boolean bIsDetailedSpeedblock, boolean bIsTechnicalDataBlock, boolean bIsDCFilesDownloadWithVUFile, boolean bIs168HrsDetailedSpeedDataBlock, boolean bIsMulipurposeDataBlock, String iDCFileExtensionID, String iVUFileExtensionID, String iVDOFileExtensionID) {
        iDCFileExtensionID = this.getExtensionDesc(iDCFileExtensionID);
        iVUFileExtensionID = this.getExtensionDesc(iVUFileExtensionID);
        iVDOFileExtensionID = this.getExtensionDesc(iVDOFileExtensionID);
        AccountDetailsXMLParent objAccountDetailsVO = Application.listAccounts;
        if (objAccountDetailsVO == null) {
            objAccountDetailsVO = new AccountDetailsXMLParent();
        }
        ResponseMessage objResponseMessage = new ResponseMessage();
        ArrayList<AccountsDetailsXMLChild> listAccountsVO = new ArrayList<AccountsDetailsXMLChild>();
        boolean serviceMappingCalling = false;
        try {
            File fileXml = new File(this.xmlFileName);
            if (fileXml.exists()) {
                int i;
                AccountsDetailsXMLChild[] objAccountsVO = objAccountDetailsVO.getAccounts();
                boolean exist = false;
                if (objAccountsVO != null) {
                    i = 0;
                    while (i < objAccountsVO.length) {
                        if (objAccountsVO[i].getAccountId() == accID) {
                            exist = true;
                            serviceMappingCalling = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (exist) {
                    logger.debug((Object)"Account id already exists in add method");
                    objResponseMessage.setStatusCode("1");
                } else {
                    if (objAccountsVO != null) {
                        i = 0;
                        while (i < objAccountsVO.length) {
                            listAccountsVO.add(objAccountsVO[i]);
                            ++i;
                        }
                    }
                    AccountsDetailsXMLChild objAccVO = new AccountsDetailsXMLChild();
                    objAccVO.setAccountId(accID);
                    objAccVO.setAccountName(accName);
                    objAccVO.setArchiveMode(archvMode);
                    objAccVO.setDeviceType(deviceType);
                    objAccVO.setSTISOfficeServer(sTISOfficeServer);
                    objAccVO.setBSVSpecificDataIndicator(bSVSpecificDataIndicator);
                    objAccVO.setSTISOfficeCompany(sTISOfficeCompany);
                    objAccVO.setBIsActivityDataBlock(bIsActivityDataBlock);
                    objAccVO.setBIsEventandFaultsDataBlock(bIsEventandFaultsDataBlock);
                    objAccVO.setBIsDetailedSpeedblock(bIsDetailedSpeedblock);
                    objAccVO.setBIsTechnicalDataBlock(bIsTechnicalDataBlock);
                    objAccVO.setBIsDCFilesDownloadWithVUFile(bIsDCFilesDownloadWithVUFile);
                    objAccVO.setBIs168HrsDetailedSpeedDataBlock(bIs168HrsDetailedSpeedDataBlock);
                    objAccVO.setBIsMulipurposeDataBlock(bIsMulipurposeDataBlock);
                    objAccVO.setIDCFileExtensionID(iDCFileExtensionID);
                    objAccVO.setIVUFileExtensionID(iVUFileExtensionID);
                    objAccVO.setIVDOFileExtensionID(iVDOFileExtensionID);
                    listAccountsVO.add(objAccVO);
                    this.createAccoutnXML(listAccountsVO, objAccountDetailsVO);
                    logger.debug((Object)"Account id added in add method");
                    objResponseMessage.setStatusCode("1");
                    serviceMappingCalling = false;
                }
            } else {
                File xmlFile = new File(this.xmlFileName);
                xmlFile.createNewFile();
                AccountsDetailsXMLChild obj1AccountsVO = new AccountsDetailsXMLChild();
                obj1AccountsVO.setAccountId(accID);
                obj1AccountsVO.setAccountName(accName);
                obj1AccountsVO.setArchiveMode(archvMode);
                obj1AccountsVO.setDeviceType(deviceType);
                obj1AccountsVO.setSTISOfficeServer(sTISOfficeServer);
                obj1AccountsVO.setBSVSpecificDataIndicator(bSVSpecificDataIndicator);
                obj1AccountsVO.setSTISOfficeCompany(sTISOfficeCompany);
                obj1AccountsVO.setBIsActivityDataBlock(bIsActivityDataBlock);
                obj1AccountsVO.setBIsEventandFaultsDataBlock(bIsEventandFaultsDataBlock);
                obj1AccountsVO.setBIsDetailedSpeedblock(bIsDetailedSpeedblock);
                obj1AccountsVO.setBIsTechnicalDataBlock(bIsTechnicalDataBlock);
                obj1AccountsVO.setBIsDCFilesDownloadWithVUFile(bIsDCFilesDownloadWithVUFile);
                obj1AccountsVO.setBIs168HrsDetailedSpeedDataBlock(bIs168HrsDetailedSpeedDataBlock);
                obj1AccountsVO.setBIsMulipurposeDataBlock(bIsMulipurposeDataBlock);
                obj1AccountsVO.setIDCFileExtensionID(iDCFileExtensionID);
                obj1AccountsVO.setIVUFileExtensionID(iVUFileExtensionID);
                obj1AccountsVO.setIVDOFileExtensionID(iVDOFileExtensionID);
                listAccountsVO.add(obj1AccountsVO);
                this.createAccoutnXML(listAccountsVO, objAccountDetailsVO);
                objResponseMessage.setStatusCode("1");
                serviceMappingCalling = false;
            }
            if (!serviceMappingCalling) {
                AccountServiceUpdation accountServiceUpdationTask = new AccountServiceUpdation(accID);
                Thread authExecutor = new Thread(accountServiceUpdationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            objResponseMessage.setStatusCode("0");
            logger.error((Object)("Exception in add in AccountManagement: " + e));
        }
        return objResponseMessage;
    }

    public ResponseMessage addAccountInDB(int accID) {
        ResponseMessage objResponseMessage = new ResponseMessage();
        int authServiceId = 0;
        int commServiceId = 0;
        ArrayList<Object> listServicesVO = new ArrayList();
        try {
            listServicesVO = this.getAuthCommServiceID();
            authServiceId = (Integer)listServicesVO.get(0);
            commServiceId = (Integer)listServicesVO.get(1);
            logger.debug((Object)("In addAccountInDB method....authServiceId = " + authServiceId));
            logger.debug((Object)("In addAccountInDB method....commServiceId = " + commServiceId));
            logger.debug((Object)("In addAccountInDB method....account id = " + accID));
            String returnStr = WebServiceXMLDetailsDao.getInstance().updateServiceIdStatus(authServiceId, commServiceId, accID);
            logger.debug((Object)("Response from updateServiceIdStatus in addAccountInDB method = " + returnStr));
            if (returnStr == "") {
                logger.debug((Object)"****set 0 status in blank case***");
                objResponseMessage.setStatusCode("0");
            } else {
                objResponseMessage.setStatusCode("1");
            }
            logger.debug((Object)("Calling handleAccountXML method of ClientXMLThread with authServiceId = " + authServiceId));
            ClientXMLThread.getXMLDetectionthread().handleAccountXML(authServiceId, commServiceId);
        }
        catch (Exception ex) {
            objResponseMessage.setStatusCode("0");
            logger.debug((Object)("Exception in addAccountInDB:: " + ConfigUtil.getStackTraceAsString(ex)));
        }
        return objResponseMessage;
    }

    private ArrayList<Integer> getAuthCommServiceID() {
        ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
        ServiceInfo objServiceDetailsVO = new ServiceInfo();
        try {
            String urlVal = "";
            String programDataPath = System.getenv("ProgramData");
            String xmlFileNameUrl = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\URL.xml";
            File fileXmlurl = new File(xmlFileNameUrl);
            String urlValue = "";
            if (fileXmlurl.exists()) {
                String xmlFileContents = "";
                xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileNameUrl);
                XStream objXStream = new XStream();
                Object objEntity = null;
                objXStream.alias("URL", UrlRead.class);
                objEntity = objXStream.fromXML(xmlFileContents);
                UrlRead objurl = (UrlRead)objEntity;
                urlValue = objurl.getUrl();
                urlVal = urlValue.split("//")[1].split("/")[0];
            }
            logger.debug((Object)("url value :" + urlVal));
            String servicePath = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
            String xmlFileName2 = String.valueOf(servicePath) + urlVal + ".xml";
            logger.debug((Object)("xml: " + xmlFileName2));
            String xmlFileContents2 = GeneralAPI.getFileContentsUTF8(xmlFileName2);
            XStream objXStream2 = new XStream();
            Object objEntity2 = null;
            objXStream2.alias("ServiceInfo", ServiceInfo.class);
            objXStream2.alias("ServiceVO", ServiceVO.class);
            objEntity2 = objXStream2.fromXML(xmlFileContents2);
            objServiceDetailsVO = (ServiceInfo)objEntity2;
            ServiceVO[] objServiceVO = objServiceDetailsVO.getServices();
            int i = 0;
            while (i < objServiceVO.length) {
                listServicesVO.add(objServiceVO[i].getIServiceID());
                ++i;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in getAuthCommServiceID:: ", (Throwable)e);
        }
        return listServicesVO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseMessage check(int accID) {
        ResponseMessage objResponseMessage = new ResponseMessage();
        AccountDetailsXMLParent objAccountDetailsVO = Application.listAccounts;
        try {
            File fileXml = new File(this.xmlFileName);
            if (!fileXml.exists()) {
                logger.debug((Object)"Xml file name doesn't exist in Check method");
                objResponseMessage.setStatusCode("0");
                return objResponseMessage;
            }
            if (objAccountDetailsVO == null) {
                return null;
            }
            AccountsDetailsXMLChild[] objAccountsVO = objAccountDetailsVO.getAccounts();
            boolean exist = false;
            if (objAccountsVO != null) {
                int i = 0;
                while (i < objAccountsVO.length) {
                    if (objAccountsVO[i].getAccountId() == accID) {
                        exist = true;
                        break;
                    }
                    ++i;
                }
            }
            if (exist) {
                logger.debug((Object)"Account id already exists in check method");
                objResponseMessage.setStatusCode("1");
                return objResponseMessage;
            }
            if (exist) return objResponseMessage;
            logger.debug((Object)"Account id doesnt exists in check method");
            objResponseMessage.setStatusCode("0");
            return objResponseMessage;
        }
        catch (Exception e) {
            e.printStackTrace();
            objResponseMessage.setStatusCode("0");
            logger.error((Object)("Exception in check in AccountManagement: " + e));
        }
        return objResponseMessage;
    }

    public void createAccoutnXML(List<AccountsDetailsXMLChild> listAccountsVO, AccountDetailsXMLParent objAccountDetailsVO) {
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("AccountDetails");
        objXmlObject.setClassName(AccountDetailsXMLParent.class);
        objArr.add(objXmlObject);
        objXmlObject = new XMLObject();
        objXmlObject.setAlias("AccountsVO");
        objXmlObject.setClassName(AccountsDetailsXMLChild.class);
        objArr.add(objXmlObject);
        objAccountDetailsVO.setAccounts(listAccountsVO.toArray(new AccountsDetailsXMLChild[0]));
        logger.debug((Object)("in cretae xml method value of objAccountDetailsVO accounts: " + objAccountDetailsVO.getAccounts()));
        String strAccountDetails = GeneralAPI.objectToXml(objAccountDetailsVO, objArr);
        try {
            File xmlFile = new File(this.xmlFileName);
            xmlFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(this.xmlFileName, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF8");
            out.write(strAccountDetails);
            ((Writer)out).close();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Exception in createAccoutnXML in AccountManagement: " + e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Integer> getAccIdsList() {
        logger.debug((Object)" in getAccIdsList>>>");
        ArrayList<Integer> arrListAccID = new ArrayList<Integer>();
        try {
            String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
            String xmlFileContents = "";
            AccountDetailsXMLParent objAccountDetailsVO = new AccountDetailsXMLParent();
            File file = new File(xmlFileName);
            if (!file.exists()) {
                logger.debug((Object)"Account Xml does  not exist.");
                return arrListAccID;
            }
            xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileName);
            XStream objXStream = new XStream();
            Object objEntity = null;
            objXStream.alias("AccountDetails", AccountDetailsXMLParent.class);
            objXStream.alias("AccountsVO", AccountsDetailsXMLChild.class);
            objEntity = objXStream.fromXML(xmlFileContents);
            objAccountDetailsVO = (AccountDetailsXMLParent)objEntity;
            logger.debug((Object)(" in getAccIdsList objAccountDetailsVO--->>" + objAccountDetailsVO));
            if (objAccountDetailsVO == null) {
                return null;
            }
            AccountsDetailsXMLChild[] objAccountsVO = objAccountDetailsVO.getAccounts();
            logger.debug((Object)(" in getAccIdsList objAccountsVO--->>" + objAccountsVO));
            if (objAccountsVO == null) return arrListAccID;
            int i = 0;
            while (true) {
                if (i >= objAccountsVO.length) {
                    return arrListAccID;
                }
                arrListAccID.add(objAccountsVO[i].getAccountId());
                ++i;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in getAccIdsList of AccountManagement class", (Throwable)e);
        }
        return arrListAccID;
    }

    public AccountDetailsXMLParent readAccountsXML() {
        try {
            String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
            String xmlFileContents = "";
            File file = new File(xmlFileName);
            if (file.exists()) {
                logger.info((Object)("file length in AccouintXML:" + file.length()));
                xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileName);
                if (file.length() == 0L) {
                    logger.info((Object)"empty string in AccouintXML");
                    if (file.delete()) {
                        logger.info((Object)" AccouintXML IS  deleted successfully ::");
                    } else {
                        logger.info((Object)"  AccouintXML Not Deleted ::: ");
                    }
                } else {
                    XStream objXStream = new XStream();
                    Object objEntity = null;
                    objXStream.alias("AccountDetails", AccountDetailsXMLParent.class);
                    objXStream.alias("AccountsVO", AccountsDetailsXMLChild.class);
                    objEntity = objXStream.fromXML(xmlFileContents);
                    objAccDetailsVO = (AccountDetailsXMLParent)objEntity;
                }
            } else {
                logger.debug((Object)"Account Xml does  not exist.");
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in getAccIdsList of AccountManagement class", (Throwable)e);
        }
        return objAccDetailsVO;
    }

    public ResponseMessage updateServiceXMLForINST(int servID, String proxyHost, String proxyPassword, String port, String proxyUser, boolean proxyServreUsed) {
        ResponseMessage objResponseMessage = new ResponseMessage();
        try {
            ArrayList<ServiceVO> listServiceVO = new ArrayList<ServiceVO>();
            ServiceInfo objServiceinfo = Application.objServiceInfo;
            boolean exist = false;
            if (objServiceinfo != null && objServiceinfo.getServices() != null) {
                ServiceVO[] arrserviceVO = null;
                arrserviceVO = objServiceinfo.getServices();
                int i = 0;
                while (i < arrserviceVO.length) {
                    listServiceVO.add(arrserviceVO[i]);
                    if (arrserviceVO[i].getIServiceID() == servID) {
                        logger.debug((Object)(String.valueOf(arrserviceVO[i].getIServiceID()) + "=" + servID));
                        exist = true;
                    }
                    ++i;
                }
                if (exist) {
                    String key = GeneralAPI.jumbleStringEncrypt("ATOSTISWebRTM@4231");
                    int connectionEstablished = InvokeRTMWebService.getInstance().checkValidSource(key, GeneralAPI.getPassKey());
                    logger.debug((Object)("in exist value of connection established:" + connectionEstablished));
                    if (connectionEstablished == 1) {
                        objServiceinfo.setBIsProxyServerUsed(proxyServreUsed);
                        objServiceinfo.setSProxyHost(proxyHost);
                        if (port == null || port.length() == 0 || port.equals("")) {
                            objServiceinfo.setSProxyPort("0");
                        } else {
                            objServiceinfo.setSProxyPort(port);
                        }
                        objServiceinfo.setSProxyUser(proxyUser);
                        objServiceinfo.setSProxyPassword(proxyPassword);
                        if (objServiceinfo != null && objServiceinfo.getServices() != null) {
                            logger.debug((Object)"going in createServiceXMLForINSTAndCHSC--> ");
                            this.createServiceXMLForINSTAndCHSC(listServiceVO, objServiceinfo);
                        }
                        objResponseMessage.setStatusCode("1");
                    } else {
                        logger.debug((Object)"Connection is not established in updateServiceXMLForINST");
                        objResponseMessage.setStatusCode("0");
                    }
                } else {
                    objResponseMessage.setStatusCode("0");
                    logger.debug((Object)("Service id's doesn't match with service xml.." + objResponseMessage.getStatusCode()));
                }
            } else {
                logger.debug((Object)"Service Xml does  not exist.");
                objResponseMessage.setStatusCode("0");
            }
        }
        catch (Exception e) {
            objResponseMessage.setStatusCode("0");
            logger.debug((Object)"Exception in updateServiceXMLForINST of AccountManagement class", (Throwable)e);
        }
        logger.debug((Object)("Returning.." + objResponseMessage.getStatusCode()));
        return objResponseMessage;
    }

    public void createServiceXMLForINSTAndCHSC(List<ServiceVO> listServiceVO, ServiceInfo objServiceInfo) {
        String urlVal = "";
        String programDataPath = System.getenv("ProgramData");
        String xmlFileNameUrl = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\URL.xml";
        File fileXmlurl = new File(xmlFileNameUrl);
        String urlValue = "";
        if (fileXmlurl.exists()) {
            String xmlFileContents = "";
            xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileNameUrl);
            XStream objXStream = new XStream();
            Object objEntity = null;
            objXStream.alias("URL", UrlRead.class);
            objEntity = objXStream.fromXML(xmlFileContents);
            UrlRead objurl = (UrlRead)objEntity;
            urlValue = objurl.getUrl();
            urlVal = urlValue.split("//")[1].split("/")[0];
        }
        logger.debug((Object)("url value :" + urlVal));
        String servicePath = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
        String xmlFileName = String.valueOf(servicePath) + urlVal + ".xml";
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("ServiceInfo");
        objXmlObject.setClassName(ServiceInfo.class);
        objArr.add(objXmlObject);
        objXmlObject = new XMLObject();
        objXmlObject.setAlias("ServiceVO");
        objXmlObject.setClassName(ServiceVO.class);
        objArr.add(objXmlObject);
        objServiceInfo.setServices(listServiceVO.toArray(new ServiceVO[0]));
        logger.debug((Object)("in createServiceXMLForINST method value: " + objServiceInfo));
        String strServicesDetails = GeneralAPI.objectToXml(objServiceInfo, objArr);
        try {
            File xmlFile = new File(xmlFileName);
            xmlFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(xmlFileName, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF8");
            out.write(strServicesDetails);
            ((Writer)out).close();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Exception in createServiceXMLForINSTAndCHSC in AccountManagement: " + e));
        }
    }

    private String getExtensionDesc(String extensionType) {
        String extensionDesc = "";
        int type = 0;
        if (extensionType != null) {
            type = Integer.parseInt(extensionType);
        }
        switch (type) {
            case 1: {
                extensionDesc = "DDD";
                break;
            }
            case 3: {
                extensionDesc = "C1B";
                break;
            }
            case 5: {
                extensionDesc = "TGD";
                break;
            }
            case 8: {
                extensionDesc = "V1B";
                break;
            }
            case 9: {
                extensionDesc = "A1B";
            }
        }
        if (extensionDesc.equals("")) {
            logger.debug((Object)("Inside getExtensionDesc... No match found for extension type :: " + extensionType));
        }
        return extensionDesc;
    }
}

