/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.card.interactor.SmartCardCtl;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.FailureMessageDao;
import com.sisl.dtco.dao.GeneralDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.dao.VehicleDetailsDao;
import com.sisl.dtco.exceptions.AuthenticationModuleException;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.DTCOCommandHelper;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.vo.CommandCCNPData;
import com.sisl.dtco.vo.CommandCMPRData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import com.sisl.dtco.vo.DueDownloadVO;
import com.sisl.dtco.vo.EntityVO;
import com.sisl.dtco.vo.XMLObject;
import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.CompanyCardVO;
import org.tempuri.DueDownloadVORTM;
import org.tempuri.EntityVORTM;
import org.tempuri.RemoteServiceVO;

public class AuthenticationManager {
    static AuthenticationManager instance = new AuthenticationManager();
    DTCOCommandHelper objDTCOCommandHelper;
    CommandCCNPData objCommandCCNPData;
    ArrayList<DTCOCommandVO> TaskList = new ArrayList();
    Map<Integer, ArrayList<DTCOCommandVO>> TaskListMap = new ConcurrentHashMap<Integer, ArrayList<DTCOCommandVO>>();
    Map<String, String> cardSerialIdMap = new HashMap<String, String>();
    Map<String, Integer> cardNoCardTypeMap = new HashMap<String, Integer>();
    String xmlString = null;
    private final Logger logger = Logger.getLogger(AuthenticationManager.class);
    private ArrayList<DTCOCommandVO> dtcoList = null;
    private static HashMap<Integer, ArrayList<CompanyCardVO>> dcConxnList = new HashMap();
    private ConcurrentHashMap<DTCOCommandVO, String> dcActiveConxnPool = new ConcurrentHashMap();
    private ConcurrentHashMap<DTCOCommandVO, Thread> ThreadToDTCOMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> dcActiveConxnPoolCount = new ConcurrentHashMap();
    static SmartCardCtl cardReader = SmartCardCtl.getInstance();
    private int timeOut = 0;
    private static ArrayList<String> serialIDList = new ArrayList();
    InvokeRemoteDevice device = InvokeRemoteDevice.getInstance();

    public static AuthenticationManager getAuthenticationManager() {
        if (instance == null) {
            instance = new AuthenticationManager();
        }
        return instance;
    }

    public void authEvent(DTCOCommandVO objDTCOCommandVO, int status) {
        String entityIdWithHash = "";
        String[] entityId = new String[]{};
        this.logger.debug((Object)"In authEvent method:");
        this.logger.debug((Object)("Status In authEvent method:::::: " + status));
        ReminderListDao objReminderListDao = ReminderListDao.getInstance();
        switch (status) {
            case 2: {
                this.logger.debug((Object)("Authentication is succeded for current DTCO" + objDTCOCommandVO));
                objDTCOCommandVO.setStatus(4);
                if (objDTCOCommandVO.isCreateLocalDownloadStateFlag()) {
                    objDTCOCommandVO.setAuthType(0);
                } else {
                    objDTCOCommandVO.setAuthType(1);
                }
                objReminderListDao.updateStatusRemoteAuthentication(objDTCOCommandVO);
                if (objDTCOCommandVO.getDldType() == 1 || objDTCOCommandVO.getDldType() == 2 || objDTCOCommandVO.getDldType() == 8 || objDTCOCommandVO.getDldType() == 10) {
                    try {
                        this.device.sendRDAGToCOMM(objDTCOCommandVO);
                        GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Exception in authEvent method of Authentication Manager class when Authentication Succeded");
                        GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                    }
                }
                if (!objDTCOCommandVO.isCreateLocalDownloadStateFlag()) {
                    this.returnTerminalConnection(objDTCOCommandVO, 1);
                }
                if (objDTCOCommandVO.getRemoteServiceID() != -1 && objDTCOCommandVO.getRemoteServiceID() != -2) {
                    WRPingingThread.reschedule(objDTCOCommandVO.getRemoteServiceID());
                }
                this.startAuthentication(objDTCOCommandVO.getCompanyID());
                break;
            }
            case 3: {
                this.logger.debug((Object)("Authentication is failed for  DTCO " + objDTCOCommandVO));
                this.logger.debug((Object)("setTimeStamp in objDTCOCommandVO  in FAILED_DTCO Case: " + GeneralAPI.getCurrentDateTimeInt()));
                objDTCOCommandVO.setTimeStamp(GeneralAPI.getCurrentDateTimeInt());
                this.logger.debug((Object)("Authentication is failed for  DTCO and Set Timestamp " + GeneralAPI.getCurrentDateTimeInt()));
                objDTCOCommandVO.setStatus(3);
                objDTCOCommandVO.setCheckRetry("y");
                objDTCOCommandVO.setRetryCount(objDTCOCommandVO.getRetryCount() + 1);
                entityIdWithHash = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
                entityId = entityIdWithHash.split("#", -1);
                this.logger.debug((Object)("the entity id(s) from DTCOCommandVO:" + entityIdWithHash));
                objDTCOCommandVO.setAuthType(1);
                objReminderListDao.updateStatusRemoteAuthentication(objDTCOCommandVO);
                if (!objDTCOCommandVO.isCreateLocalDownloadStateFlag()) {
                    this.logger.debug((Object)" in FAILED_DTCO Case: before call returnTerminalConnection() ");
                    this.returnTerminalConnection(objDTCOCommandVO, 1);
                }
                if (objDTCOCommandVO.getDldType() == 2 || objDTCOCommandVO.getDldType() == 10 || objDTCOCommandVO.getDldType() == 8) {
                    try {
                        GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Exception in authEvent method of Authentication Manager class when Authentication Failed");
                        GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                    }
                }
                if (objDTCOCommandVO.getDldType() == 1) {
                    GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                    int configurableRetryTimes = Integer.parseInt(ConfigUtil.getValue("AuthenticationRetryTimes"));
                    if (objDTCOCommandVO.getRetryCount() < configurableRetryTimes) {
                        int configurableRetryWaitTime = Integer.parseInt(ConfigUtil.getValue("AuthenticationRetryInterval"));
                        this.logger.debug((Object)("Thread will sleep for " + configurableRetryWaitTime + " seconds and then restart authentication."));
                        if (configurableRetryWaitTime < 5 || configurableRetryWaitTime > 360) {
                            configurableRetryWaitTime = 15;
                        }
                        long period = (long)configurableRetryWaitTime * 1000L;
                        CommandCMPRData objCommandCMPRData = new CommandCMPRData();
                        CommandResponseVO objCommandResponseVO = new CommandResponseVO();
                        try {
                            Thread.sleep(period);
                            this.logger.debug((Object)("Retrying authentication for entity(s) after wakeup:" + entityIdWithHash));
                            int j = 0;
                            while (j < entityId.length) {
                                objCommandCMPRData.setVersion(objDTCOCommandVO.getStrDTCOVersion());
                                objCommandCMPRData.setManufacturerCode(objDTCOCommandVO.getStrManufactureCode());
                                if (entityId[j].charAt(0) == 'V' || entityId[j].charAt(0) == 'S') {
                                    objCommandCMPRData.setVehicleRegistrationNumber(entityId[j].substring(1));
                                } else if (entityId[j].charAt(0) == 'D') {
                                    if (objDTCOCommandVO.isDriverIndicator() && !objDTCOCommandVO.isCodriverIndicator()) {
                                        this.logger.debug((Object)"Setting Driver :");
                                        objCommandCMPRData.setDriverCardNumber(entityId[j].substring(1));
                                        break;
                                    }
                                    if (objDTCOCommandVO.isCodriverIndicator() && !objDTCOCommandVO.isDriverIndicator()) {
                                        this.logger.debug((Object)"Setting CoDriver :");
                                        objCommandCMPRData.setCoDriverCardNumber(entityId[j].substring(1));
                                        break;
                                    }
                                    if (objDTCOCommandVO.isCodriverIndicator() && objDTCOCommandVO.isDriverIndicator()) {
                                        this.logger.debug((Object)"Setting Driver and coDriver :");
                                        objCommandCMPRData.setDriverCardNumber(entityId[j].substring(1));
                                        objCommandCMPRData.setCoDriverCardNumber(entityId[j + 1].substring(1));
                                        break;
                                    }
                                }
                                ++j;
                            }
                            String strSerialId = objDTCOCommandVO.getRemoteDeviceSerialNumber();
                            objCommandCMPRData.setSerialId(strSerialId);
                            objCommandCMPRData.setNewVehicle(objDTCOCommandVO.getNewVehicle());
                            objCommandResponseVO.setCommandCMPRData(objCommandCMPRData);
                            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                            XMLObject objXmlObject = new XMLObject();
                            objXmlObject.setAlias("CommandResponseVO");
                            objXmlObject.setClassName(CommandResponseVO.class);
                            objArr.add(objXmlObject);
                            String strXml = GeneralAPI.objectToXml(objCommandResponseVO, objArr);
                            this.updateDTCOList(strXml, -1);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Exception in preparing CommandResponseVO:", (Throwable)e);
                        }
                    } else {
                        this.logger.debug((Object)("Retry Count is equal to configurable retries :" + objDTCOCommandVO.getRetryCount()));
                        this.startAuthentication(objDTCOCommandVO.getCompanyID());
                    }
                }
                if (objDTCOCommandVO.getRemoteServiceID() != -1 && objDTCOCommandVO.getRemoteServiceID() != -2) {
                    WRPingingThread.reschedule(objDTCOCommandVO.getRemoteServiceID());
                }
                if (objDTCOCommandVO.getDldType() != 3) break;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.startAuthentication(objDTCOCommandVO.getCompanyID());
                break;
            }
            case 4: {
                this.logger.debug((Object)("Authentication is failed for  DTCO " + objDTCOCommandVO + " STOP_AUTH"));
                objDTCOCommandVO.setTimeStamp(GeneralAPI.getCurrentDateTimeInt());
                objDTCOCommandVO.setStatus(3);
                objDTCOCommandVO.setCheckRetry("y");
                objDTCOCommandVO.setAuthType(1);
                objReminderListDao.updateStatusRemoteAuthentication(objDTCOCommandVO);
                if (!objDTCOCommandVO.isCreateLocalDownloadStateFlag()) {
                    this.returnTerminalConnection(objDTCOCommandVO, 1);
                }
                if (objDTCOCommandVO.getDldType() == 1 || objDTCOCommandVO.getDldType() == 2 || objDTCOCommandVO.getDldType() == 8 || objDTCOCommandVO.getDldType() == 10) {
                    GeneralAPI.closeSocketConnection(objDTCOCommandVO);
                }
                if (objDTCOCommandVO.getRemoteServiceID() != -1 && objDTCOCommandVO.getRemoteServiceID() != -2) {
                    WRPingingThread.reschedule(objDTCOCommandVO.getRemoteServiceID());
                }
                this.startAuthentication(objDTCOCommandVO.getCompanyID());
            }
        }
    }

    public void initApplication() {
        ArrayList<DTCOCommandVO> removedTaskList = new ArrayList<DTCOCommandVO>();
        int completeMapSize = 0;
        for (ArrayList<DTCOCommandVO> value : this.TaskListMap.values()) {
            completeMapSize += value.size();
            int i = 0;
            while (i < value.size()) {
                if (value.get(i).getStatus() != 2) {
                    removedTaskList.add(value.get(i));
                }
                ++i;
            }
        }
        this.logger.debug((Object)("initApplication() ++removedTaskList Size: " + removedTaskList.size()));
        this.logger.debug((Object)("initApplication() ++TaskList Map Size before removing: " + completeMapSize));
        if (removedTaskList.size() > 0) {
            int i = 0;
            while (i < removedTaskList.size()) {
                int k = 0;
                while (k < this.TaskListMap.get(((DTCOCommandVO)removedTaskList.get(i)).getCompanyID()).size()) {
                    if (removedTaskList.get(i) == this.TaskListMap.get(((DTCOCommandVO)removedTaskList.get(i)).getCompanyID()).get(k)) {
                        this.TaskListMap.get(((DTCOCommandVO)removedTaskList.get(i)).getCompanyID()).remove(removedTaskList.get(i));
                    }
                    ++k;
                }
                ++i;
            }
        }
        completeMapSize = 0;
        for (ArrayList<DTCOCommandVO> value : this.TaskListMap.values()) {
            completeMapSize += value.size();
        }
        this.logger.debug((Object)("initApplication() ++TaskList Map Size after removing: " + completeMapSize));
        this.logger.debug((Object)("initApplication() ++dcActiveConxnPool Size before removing" + this.dcActiveConxnPool.size()));
        int i = 0;
        while (i < removedTaskList.size()) {
            DTCOCommandVO objVO = (DTCOCommandVO)removedTaskList.get(i);
            this.dcActiveConxnPool.remove(objVO);
            ++i;
        }
        removedTaskList.clear();
        this.logger.debug((Object)("initApplication() ++dcActiveConxnPool Size After removing" + this.dcActiveConxnPool.size()));
        if (Application.listAccounts == null) {
            return;
        }
        AccountsDetailsXMLChild[] objAccountsVO = Application.listAccounts.getAccounts();
        ArrayList<AccountVO> accountsList = new ArrayList<AccountVO>();
        if (objAccountsVO != null) {
            int i2 = 0;
            while (i2 < objAccountsVO.length) {
                this.logger.debug((Object)("Getting account ID for account:---->>>>" + objAccountsVO[i2].getAccountId()));
                this.logger.debug((Object)("archive mode from accounts xml: " + objAccountsVO[i2].getArchiveMode()));
                AccountVO saveAccountsVO = new AccountVO();
                saveAccountsVO.setAccountId(objAccountsVO[i2].getAccountId());
                saveAccountsVO.setAccountName(objAccountsVO[i2].getAccountName());
                saveAccountsVO.setArchiveMode(objAccountsVO[i2].getArchiveMode());
                saveAccountsVO.setDeviceType(objAccountsVO[i2].getDeviceType());
                this.logger.debug((Object)("after setting in saveAccountVo device type: " + saveAccountsVO.getDeviceType()));
                saveAccountsVO.setSTISOfficeServer(objAccountsVO[i2].getSTISOfficeServer());
                saveAccountsVO.setBSVSpecificDataIndicator(objAccountsVO[i2].isBSVSpecificDataIndicator());
                saveAccountsVO.setSTISOfficeCompany(objAccountsVO[i2].getSTISOfficeCompany());
                saveAccountsVO.setBIsActivityDataBlock(objAccountsVO[i2].isBIsActivityDataBlock());
                saveAccountsVO.setBIsEventandFaultsDataBlock(objAccountsVO[i2].isBIsEventandFaultsDataBlock());
                saveAccountsVO.setBIsDetailedSpeedblock(objAccountsVO[i2].isBIsDetailedSpeedblock());
                saveAccountsVO.setBIsTechnicalDataBlock(objAccountsVO[i2].isBIsTechnicalDataBlock());
                saveAccountsVO.setBIsDCFilesDownloadWithVUFile(objAccountsVO[i2].isBIsDCFilesDownloadWithVUFile());
                saveAccountsVO.setBIs168HrsDetailedSpeedDataBlock(objAccountsVO[i2].isBIs168HrsDetailedSpeedDataBlock());
                saveAccountsVO.setBIsMulipurposeDataBlock(objAccountsVO[i2].isBIsMulipurposeDataBlock());
                saveAccountsVO.setIDCFileExtensionID(objAccountsVO[i2].getIDCFileExtensionID());
                saveAccountsVO.setIVUFileExtensionID(objAccountsVO[i2].getIVUFileExtensionID());
                saveAccountsVO.setIVDOFileExtensionID(objAccountsVO[i2].getIVDOFileExtensionID());
                accountsList.add(saveAccountsVO);
                ++i2;
            }
        }
        ListIterator listIteratorAccountVO = accountsList.listIterator();
        try {
            while (listIteratorAccountVO.hasNext()) {
                ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                AccountVO objAccountVO = (AccountVO)listIteratorAccountVO.next();
                this.logger.debug((Object)("REMINDER CREATION PROCESS STARTING FOR ACCOUNT ID----->>>>" + objAccountVO.getAccountId()));
                this.logger.debug((Object)("in account vo device type: " + objAccountVO.getDeviceType()));
                this.processReminders(objAccountVO);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception in init application of Authentication Manager " + e));
        }
    }

    public void processReminders(AccountVO objAccountVO) {
        try {
            objAccountVO = this.fetchDownloadList(objAccountVO, 0);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception in processReminders method : ", (Throwable)e);
        }
        this.logger.debug((Object)"Reminders created intimation sent succesffuly...:");
    }

    public AccountVO fetchDownloadList(AccountVO objAccountVO, int reminderList) throws Exception {
        int archiveMode = objAccountVO.getArchiveMode();
        this.logger.debug((Object)("archive mode in fetchDownloadList: " + archiveMode));
        InvokeRemoteDevice device = InvokeRemoteDevice.getInstance();
        String strDownloadListXML = "";
        AccountVO objAccount = new AccountVO();
        try {
            DueDownloadVO objDueDownloadVO = new DueDownloadVO();
            DueDownloadVORTM objDueDownloadVORTM = new DueDownloadVORTM();
            if (archiveMode == 1 || archiveMode == 3) {
                strDownloadListXML = "";
            } else if (archiveMode == 2) {
                String officeLocation = objAccountVO.getSTISOfficeServer();
                officeLocation = officeLocation.trim();
                this.logger.debug((Object)("Location of Tis-Office from User Settings: " + officeLocation));
                objDueDownloadVO = device.getAllDTCOListForTisOffice(officeLocation, reminderList, objAccountVO);
                this.logger.debug((Object)("objDueDownloadVO in Auth managr:" + objDueDownloadVO));
                this.logger.debug((Object)("objDueDownloadVO after dao length: " + objDueDownloadVO.getEntities().length));
                if (objDueDownloadVO != null) {
                    EntityVO[] arrEntityVO = objDueDownloadVO.getEntities();
                    this.logger.debug((Object)("arrEntityVO length:" + arrEntityVO.length));
                    EntityVORTM[] arrEntityVORTM = new EntityVORTM[objDueDownloadVO.getEntities().length];
                    this.logger.debug((Object)(" due download vo entitied length: " + objDueDownloadVO.getEntities().length));
                    int i = 0;
                    while (i < arrEntityVO.length) {
                        EntityVORTM objEntityVORTM = new EntityVORTM();
                        this.logger.debug((Object)"in for loop of authentication mngr");
                        objEntityVORTM.setEntityId(GeneralAPI.convertStringToByte(arrEntityVO[i].getEntityId()));
                        objEntityVORTM.setEntityName(GeneralAPI.convertStringToByte(arrEntityVO[i].getEntityName()));
                        objEntityVORTM.setLastDownloadDate(arrEntityVO[i].getLastDownloadDate());
                        objEntityVORTM.setRecurrence(arrEntityVO[i].getRecurrence());
                        arrEntityVORTM[i] = objEntityVORTM;
                        this.logger.debug((Object)"existing from for loop");
                        ++i;
                    }
                    this.logger.debug((Object)("arrEntityVORTM array length :" + arrEntityVORTM.length));
                    objDueDownloadVORTM.setEntities(arrEntityVORTM);
                    this.logger.debug((Object)("objDueDownloadVORTM entities length: " + objDueDownloadVORTM.getEntities().length));
                }
                this.logger.debug((Object)("objDueDownloadVORTM: " + objDueDownloadVORTM));
                objAccount = InvokeRTMWebService.getInstance().getReminderListWR(objAccountVO.getAccountId(), objAccountVO.getArchiveMode(), objDueDownloadVORTM, reminderList, GeneralAPI.getPassKey());
                objAccountVO.setManualEntities(objAccount.getManualEntities());
                this.logger.debug((Object)("objAccountVO object :" + objAccountVO));
            }
        }
        catch (AuthenticationModuleException ex) {
            this.logger.error((Object)"AuthenticationModuleException in fetchDownloadList method : ", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception in fetchDownloadList method : ", (Throwable)e);
            throw e;
        }
        return objAccountVO;
    }

    public RemoteServiceVO sendIntimation(AccountVO objAccountVO, boolean intimationRequiredForAll) {
        RemoteServiceVO objRemoteServiceVO = null;
        try {
            int deviceType = objAccountVO.getDeviceType();
            this.logger.debug((Object)(" inside send intimation device type: " + deviceType));
            if (deviceType == 3 || deviceType == 6 || deviceType == 5 || deviceType == 7 || deviceType == 10) {
                RemoteServiceDao objRemoteServiceDao;
                this.logger.debug((Object)("Send Intimation to WR for company ID:" + objAccountVO.getAccountId()));
                this.logger.debug((Object)("Intimation required for all RS's:" + intimationRequiredForAll));
                CompanyDao objCompanyDao = CompanyDao.getInstance();
                ArrayList<EntityVO> listEntityVO = new ArrayList<EntityVO>();
                List<EntityVORTM> listEntityVORTM = objCompanyDao.createEntityVOs(objAccountVO);
                if (listEntityVORTM != null) {
                    this.logger.debug((Object)("In sendIntimation method... list size is :" + listEntityVORTM.size()));
                }
                for (EntityVORTM objEntityVORTM : listEntityVORTM) {
                    EntityVO objEntityVO = new EntityVO();
                    objEntityVO.setEntityId(GeneralAPI.byteToString(objEntityVORTM.getEntityId()));
                    objEntityVO.setEntityName(GeneralAPI.byteToString(objEntityVORTM.getEntityName()));
                    objEntityVO.setFromDate(objEntityVORTM.getFromDate());
                    objEntityVO.setRecurrence(objEntityVORTM.getRecurrence());
                    objEntityVO.setToDate(objEntityVORTM.getToDate());
                    objEntityVO.setRequestDataBlock(objEntityVORTM.getRequestDataBlock());
                    listEntityVO.add(objEntityVO);
                }
                DueDownloadVO objDueDownloadVO = new DueDownloadVO();
                objDueDownloadVO.setCmdName("TDDL");
                objDueDownloadVO.setVersion("2.2");
                objDueDownloadVO.setEntities(listEntityVO.toArray(new EntityVO[0]));
                if (objDueDownloadVO.getEntities() != null) {
                    this.logger.debug((Object)("In sendIntimation method... objDueDownloadVO.getEntities is :" + objDueDownloadVO.getEntities().length));
                }
                if ((objRemoteServiceVO = (objRemoteServiceDao = RemoteServiceDao.getInstance()).getRemoteServiceDetails(objAccountVO.getAccountId())) != null) {
                    objDueDownloadVO.setAcccountName(GeneralAPI.convertStringToByte(objRemoteServiceVO.getAccountNameRS()));
                    objDueDownloadVO.setUserName(objRemoteServiceVO.getUserNameRS());
                    if (objRemoteServiceVO.getPasswordRS() != null || !objRemoteServiceVO.getPasswordRS().equals("")) {
                        String decryptpwdFromFile = GeneralAPI.jumbleString(objRemoteServiceVO.getPasswordRS());
                        objDueDownloadVO.setPassword(decryptpwdFromFile);
                    } else {
                        objDueDownloadVO.setPassword(objRemoteServiceVO.getPasswordRS());
                    }
                    ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                    XMLObject objXmlObject = new XMLObject();
                    objXmlObject.setAlias("DueDownloadVO");
                    objXmlObject.setClassName(DueDownloadVO.class);
                    objArr.add(objXmlObject);
                    objXmlObject = new XMLObject();
                    objXmlObject.setAlias("EntityVO");
                    objXmlObject.setClassName(EntityVO.class);
                    objArr.add(objXmlObject);
                    String strEntityXml = GeneralAPI.objectToXml(objDueDownloadVO, objArr);
                    CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityXml, objRemoteServiceVO.getRemoteServiceId(), objRemoteServiceVO);
                    intimationTask.run();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("exception in sendIntimation method : " + e));
        }
        return objRemoteServiceVO;
    }

    public RemoteServiceVO sendAutomaticEntitiesIntimation(AccountVO objAccountVO, boolean intimationRequiredForAll) {
        RemoteServiceVO objRemoteServiceVO;
        block7: {
            EntityVORTM[] arrayEntityVORTM;
            block8: {
                objRemoteServiceVO = null;
                int deviceType = objAccountVO.getDeviceType();
                this.logger.debug((Object)(" inside send intimation device type: " + deviceType));
                if (deviceType != 3 && deviceType != 6 && deviceType != 5 && deviceType != 7 && deviceType != 10) break block7;
                this.logger.debug((Object)("Send Intimation to WR for company ID:" + objAccountVO.getAccountId()));
                this.logger.debug((Object)("Intimation required for all RS's:" + intimationRequiredForAll));
                CompanyDao objCompanyDao = CompanyDao.getInstance();
                this.logger.debug((Object)("automatic entities:" + objAccountVO.getAutomaticEntities()));
                arrayEntityVORTM = objAccountVO.getAutomaticEntities();
                if (objAccountVO.getAutomaticEntities() != null) break block8;
                return null;
            }
            try {
                EntityVO[] arrayEntityVO = new EntityVO[arrayEntityVORTM.length];
                EntityVO objEntityVO = new EntityVO();
                int k = 0;
                while (k < arrayEntityVORTM.length) {
                    objEntityVO = new EntityVO();
                    objEntityVO.setEntityId(GeneralAPI.byteToString(arrayEntityVORTM[k].getEntityId()));
                    objEntityVO.setEntityName(GeneralAPI.byteToString(arrayEntityVORTM[k].getEntityName()));
                    objEntityVO.setFromDate(arrayEntityVORTM[k].getFromDate());
                    objEntityVO.setRecurrence(arrayEntityVORTM[k].getRecurrence());
                    objEntityVO.setToDate(arrayEntityVORTM[k].getToDate());
                    objEntityVO.setRequestDataBlock(arrayEntityVORTM[k].getRequestDataBlock());
                    arrayEntityVO[k] = objEntityVO;
                    ++k;
                }
                DueDownloadVO objDueDownloadVO = new DueDownloadVO();
                objDueDownloadVO.setCmdName("TDDL");
                objDueDownloadVO.setVersion("2.2");
                objDueDownloadVO.setEntities(arrayEntityVO);
                RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(objAccountVO.getAccountId());
                if (objRemoteServiceVO != null) {
                    objDueDownloadVO.setAcccountName(GeneralAPI.convertStringToByte(objRemoteServiceVO.getAccountNameRS()));
                    objDueDownloadVO.setUserName(objRemoteServiceVO.getUserNameRS());
                    if (objRemoteServiceVO.getPasswordRS() != null || !objRemoteServiceVO.getPasswordRS().equals("")) {
                        String decryptpwdFromFile = GeneralAPI.jumbleString(objRemoteServiceVO.getPasswordRS());
                        objDueDownloadVO.setPassword(decryptpwdFromFile);
                    } else {
                        objDueDownloadVO.setPassword(objRemoteServiceVO.getPasswordRS());
                    }
                    ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                    XMLObject objXmlObject = new XMLObject();
                    objXmlObject.setAlias("DueDownloadVO");
                    objXmlObject.setClassName(DueDownloadVO.class);
                    objArr.add(objXmlObject);
                    objXmlObject = new XMLObject();
                    objXmlObject.setAlias("EntityVO");
                    objXmlObject.setClassName(EntityVO.class);
                    objArr.add(objXmlObject);
                    String strEntityXml = GeneralAPI.objectToXml(objDueDownloadVO, objArr);
                    CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityXml, objRemoteServiceVO.getRemoteServiceId(), objRemoteServiceVO);
                    ExecutorService es = Executors.newSingleThreadExecutor();
                    es.execute(intimationTask);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("exception in sendIntimation method : " + e));
                e.printStackTrace();
            }
        }
        return objRemoteServiceVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDTCOList(String strXML, int iRemoteServiceID) {
        block38: {
            String strSerialId = "";
            try {
                ArrayList<Object> arrayList;
                CompanyDao objCompanyDao;
                int companyID;
                boolean index = false;
                this.logger.debug((Object)("serialIDList:" + serialIDList));
                if (iRemoteServiceID == -1) {
                    this.logger.debug((Object)"CMPR is received from SR communicator.");
                } else {
                    this.logger.debug((Object)("CMPR is received from Remote Service ID:" + iRemoteServiceID));
                }
                XStream objXStream = new XStream();
                Object objEntity = null;
                objXStream.alias("CommandResponseVO", CommandResponseVO.class);
                objEntity = objXStream.fromXML(strXML);
                CommandResponseVO objCommandResponseVO = (CommandResponseVO)objEntity;
                CommandCMPRData objResponseData = objCommandResponseVO.getCommandCMPRData();
                strSerialId = objResponseData.getSerialId();
                if (serialIDList == null) {
                    serialIDList = new ArrayList();
                }
                if (strSerialId == null || strSerialId.length() <= 0 || serialIDList.contains(strSerialId)) break block38;
                ArrayList<String> arrayList2 = serialIDList;
                synchronized (arrayList2) {
                    serialIDList.add(strSerialId);
                }
                boolean serailIdExist = false;
                if (iRemoteServiceID == -1 || iRemoteServiceID == -2) {
                    this.logger.debug((Object)("Active Connection Pool Size:" + this.dcActiveConxnPool.size()));
                    for (Object key : this.dcActiveConxnPool.keySet()) {
                        DTCOCommandVO obj = (DTCOCommandVO)key;
                        CompanyDao objCompanyDao2 = CompanyDao.getInstance();
                        int companyID2 = objCompanyDao2.getCompanyDetails(strSerialId);
                        if (!obj.getRemoteDeviceSerialNumber().equalsIgnoreCase(strSerialId) || obj.getCompanyID() != companyID2) continue;
                        serailIdExist = true;
                        this.logger.debug((Object)("Serial Id " + obj.getRemoteDeviceSerialNumber() + " found in dcActiveConxnPool:"));
                        if (!this.dcActiveConxnPoolCount.containsKey(obj.getRemoteDeviceSerialNumber())) {
                            this.dcActiveConxnPoolCount.put(obj.getRemoteDeviceSerialNumber(), 1);
                            this.logger.debug((Object)("Serial Id " + obj.getRemoteDeviceSerialNumber() + " adding in map with count " + this.dcActiveConxnPoolCount.get(obj.getRemoteDeviceSerialNumber())));
                        } else {
                            this.dcActiveConxnPoolCount.put(obj.getRemoteDeviceSerialNumber(), this.dcActiveConxnPoolCount.get(obj.getRemoteDeviceSerialNumber()) + 1);
                            this.logger.debug((Object)("Serial Id " + obj.getRemoteDeviceSerialNumber() + " count increased to " + this.dcActiveConxnPoolCount.get(obj.getRemoteDeviceSerialNumber())));
                        }
                        if (!this.dcActiveConxnPoolCount.get(obj.getRemoteDeviceSerialNumber()).equals(10)) break;
                        this.logger.debug((Object)("Serial Id " + obj.getRemoteDeviceSerialNumber() + " removing from map if count is " + this.dcActiveConxnPoolCount.get(obj.getRemoteDeviceSerialNumber())));
                        this.dcActiveConxnPool.remove(obj);
                        this.dcActiveConxnPoolCount.remove(obj.getRemoteDeviceSerialNumber());
                        break;
                    }
                }
                DTCOCommandHelper objDTCOCommandHelper = null;
                DTCOCommandVO objDTCOCommandVO = null;
                if (!(serailIdExist || (objDTCOCommandVO = (objDTCOCommandHelper = new DTCOCommandHelper()).getDTCOCommandVO(objResponseData, iRemoteServiceID)) == null || objDTCOCommandVO.getDldType() != 1 && objDTCOCommandVO.getDldType() != 2 && objDTCOCommandVO.getDldType() != 10 && objDTCOCommandVO.getDldType() != 8 || (companyID = (objCompanyDao = CompanyDao.getInstance()).getCompanyDetails(objDTCOCommandVO.getRemoteDeviceSerialNumber())) == 0 || objDTCOCommandVO.getCompanyID() == companyID)) {
                    this.logger.debug((Object)("DLD does not belong to company " + objDTCOCommandVO.getCompanyID() + " so removing serial Id " + objDTCOCommandVO.getRemoteDeviceSerialNumber() + " from Active connection pool and task list:"));
                    this.dcActiveConxnPool.remove(objDTCOCommandVO);
                    this.logger.debug((Object)("Active Connection Pool Size:" + this.dcActiveConxnPool.size()));
                    serailIdExist = true;
                }
                if (!serailIdExist) {
                    if (objDTCOCommandVO.getEntityId() != null) {
                        if (this.TaskListMap.containsKey(objDTCOCommandVO.getCompanyID())) {
                            boolean checkSerialIdExist = false;
                            int i = 0;
                            while (i < this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).size()) {
                                try {
                                    DTCOCommandVO existDTCOVO = this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).get(i);
                                    if (objDTCOCommandVO != null && existDTCOVO != null && objDTCOCommandVO.getRemoteDeviceSerialNumber().equals(existDTCOVO.getRemoteDeviceSerialNumber())) {
                                        checkSerialIdExist = true;
                                        if (!objDTCOCommandVO.getVehicleRegistrationNumber().equals(existDTCOVO.getVehicleRegistrationNumber())) {
                                            this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).remove(i);
                                            this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).add(i, objDTCOCommandVO);
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    this.logger.info((Object)this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).get(i).toString());
                                    this.logger.error((Object)("Error message:" + e.getMessage()));
                                }
                                ++i;
                            }
                            if (!checkSerialIdExist) {
                                this.TaskListMap.get(objDTCOCommandVO.getCompanyID()).add(objDTCOCommandVO);
                            }
                        } else {
                            this.dtcoList = new ArrayList();
                            arrayList = this.dtcoList;
                            synchronized (arrayList) {
                                this.dtcoList.add(objDTCOCommandVO);
                            }
                            this.TaskListMap.put(objDTCOCommandVO.getCompanyID(), this.dtcoList);
                        }
                        ArrayList<String> arrayList3 = serialIDList;
                        synchronized (arrayList3) {
                            serialIDList.remove(strSerialId);
                        }
                        this.startAuthentication(objDTCOCommandVO.getCompanyID());
                        break block38;
                    }
                    this.logger.debug((Object)" Entity=null.");
                    arrayList = serialIDList;
                    synchronized (arrayList) {
                        serialIDList.remove(strSerialId);
                        break block38;
                    }
                }
                this.logger.debug((Object)("CMPR Ignored for XML" + strXML));
                arrayList = serialIDList;
                synchronized (arrayList) {
                    serialIDList.remove(strSerialId);
                }
            }
            catch (Exception ex) {
                ArrayList<String> arrayList = serialIDList;
                synchronized (arrayList) {
                    serialIDList.remove(strSerialId);
                }
                this.logger.error((Object)"Invalid CMPR......");
                this.logger.error((Object)("Exception in Authentication manager class and in updateDTCOList Method : " + ConfigUtil.getStackTraceAsString(ex)));
            }
        }
    }

    public void refreshPool() {
        String str = ConfigUtil.getValue("CardTimeOutPeriod");
        this.timeOut = Integer.parseInt(str) * 1000;
        this.logger.debug((Object)("Connection List before ::::::" + dcConxnList));
        dcConxnList = cardReader.getAvailableConnectionList(this.timeOut, dcConxnList, Application.objServiceInfo.getIMachineId());
        this.logger.debug((Object)("Connection List after ::::::" + dcConxnList));
        this.logger.debug((Object)("Size of Available Terminal with Card after is:" + dcConxnList.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAuthentication(int compID) {
        block12: {
            block11: {
                DTCOCommandVO objVO;
                block13: {
                    ArrayList<DTCOCommandVO> alDTCOAcv;
                    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                    objVO = null;
                    this.logger.debug((Object)("Start Authentication for Company ID :" + compID));
                    if (this.TaskListMap.get(compID).isEmpty()) break block11;
                    this.logger.debug((Object)("Tasklist size for " + compID + ":" + this.TaskListMap.get(compID).size()));
                    ArrayList<DTCOCommandVO> arrayList = alDTCOAcv = new ArrayList<DTCOCommandVO>(1);
                    synchronized (arrayList) {
                        alDTCOAcv.clear();
                        alDTCOAcv.add(this.TaskListMap.get(compID).get(0));
                        this.TaskListMap.get(compID).remove(0);
                        objVO = (DTCOCommandVO)alDTCOAcv.get(0);
                    }
                    if (!objVO.isCreateLocalDownloadStateFlag()) {
                        this.logger.debug((Object)("Start Authentication for Company ID :" + compID + "for Serial ID: " + objVO.getRemoteDeviceSerialNumber()));
                        objVO = this.setCompanyCardStatusReserve(objVO);
                    }
                    if (objVO.isCreateLocalDownloadStateFlag()) break block12;
                    if (!objVO.isCardReserved()) break block13;
                    try {
                        this.logger.debug((Object)(String.valueOf(objVO.getCompanyCardNo()) + " Card reserved for Company ID: " + compID + " for serial Id " + objVO.getRemoteDeviceSerialNumber()));
                        if (objVO.getDldType() == 1 || objVO.getDldType() == 2 || objVO.getDldType() == 8 || objVO.getDldType() == 10) {
                            this.device.clientRegistrationSR(objVO);
                        } else {
                            this.device.clientRegistrationWR(objVO);
                        }
                        this.logger.debug((Object)"Creating thread for authentication. ");
                        int commType = objVO.getDldType();
                        this.logger.debug((Object)("commType in Auth Manager class  =" + commType));
                        objVO.setStatus(2);
                        objVO.setFailureCode((byte)0);
                        objVO.setTimeStamp(GeneralAPI.getCurrentDateTimeInt());
                        objVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                        if (objVO.isCreateLocalDownloadStateFlag()) {
                            objVO.setAuthType(0);
                        } else {
                            objVO.setAuthType(1);
                        }
                        objReminderListDao.updateStatusRemoteAuthentication(objVO);
                        AuthenticationTask authTask = new AuthenticationTask(objVO, this.dcActiveConxnPool.get(objVO), this, commType);
                        Thread authExecutor = new Thread(authTask);
                        ExecutorService esTask = ThreadPool.getThreadPool2();
                        esTask.execute(authExecutor);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.logger.error((Object)("Exception while sending Client Registration Request For DTCO:" + objVO.getRemoteDeviceSerialNumber() + e));
                        this.returnTerminalConnectionEx(objVO, 1);
                    }
                    break block12;
                }
                if (!this.cardSerialIdMap.containsValue(objVO.getRemoteDeviceSerialNumber())) break block12;
                this.returnTerminalConnection(objVO, 1);
                break block12;
            }
            for (Integer key : this.TaskListMap.keySet()) {
                if (this.TaskListMap.get(key).isEmpty()) continue;
                this.logger.info((Object)("New Company ID + " + key + " Size: " + this.TaskListMap.get(key).size()));
                this.startAuthentication(key);
                break;
            }
        }
    }

    private boolean returnTerminalConnection(DTCOCommandVO objDTCO, int status) {
        try {
            this.logger.debug((Object)("size of dcActiveConxnPool (before removing) :" + this.dcActiveConxnPool.size()));
            String dcConxn = "";
            dcConxn = this.dcActiveConxnPool.remove(objDTCO);
            cardReader.reconnect(dcConxn, "T=1");
            this.logger.debug((Object)("Returning Terminal Connection with status:" + status));
            if (this.dcActiveConxnPoolCount.contains(objDTCO.getRemoteDeviceSerialNumber())) {
                this.dcActiveConxnPoolCount.remove(objDTCO.getRemoteDeviceSerialNumber());
            }
            String compCardNumber = this.cardSerialIdMap.get(objDTCO.getRemoteDeviceSerialNumber());
            int cardType = this.cardNoCardTypeMap.get(compCardNumber);
            this.logger.debug((Object)("Serial id (Returning Terminal Connection) :" + objDTCO.getRemoteDeviceSerialNumber()));
            this.logger.debug((Object)("Company card number (Returning Terminal Connection) :" + compCardNumber));
            if (cardType == 4) {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Both Vehicle and site specific"));
                this.setCompanyCardStatus(objDTCO.getCompanyID(), compCardNumber, status);
                this.setCompanyCardStatus(-1, compCardNumber, status);
            } else if (cardType == 1) {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Company specific"));
                this.setCompanyCardStatus(objDTCO.getCompanyID(), compCardNumber, status);
            } else {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Vehicle specific"));
                this.setCompanyCardStatus(-1, compCardNumber, status);
            }
            this.logger.debug((Object)("size of dcActiveConxnPool :" + this.dcActiveConxnPool.size()));
            this.logger.debug((Object)(String.valueOf(objDTCO.getCompanyCardNo()) + " Card released for Company ID: " + objDTCO.getCompanyID() + " for serial Id " + objDTCO.getRemoteDeviceSerialNumber()));
            if (!this.cardSerialIdMap.isEmpty()) {
                this.logger.debug((Object)("Size of cardSerialIdMap (before): " + this.cardSerialIdMap.size()));
                this.cardSerialIdMap.remove(objDTCO.getRemoteDeviceSerialNumber());
            }
            if (!this.cardSerialIdMap.isEmpty()) {
                this.logger.debug((Object)("Size of cardSerialIdMap (after) : " + this.cardSerialIdMap.size()));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.debug((Object)("dcConxnList size before removing:" + dcConxnList.size()));
            this.removeCompanyCard(objDTCO.getCompanyID(), objDTCO.getCompanyCardNo());
            this.removeCompanyCard(-1, objDTCO.getCompanyCardNo());
            this.logger.debug((Object)("dcConxnList:" + dcConxnList + " , dcConxnList size:" + dcConxnList.size()));
            this.logger.error((Object)"Exception while reconnecting card reader in returnTerminalConnection method of AuthenticationManager class: ", (Throwable)e);
            return true;
        }
    }

    private boolean returnTerminalConnectionEx(DTCOCommandVO objDTCO, int status) {
        try {
            this.logger.debug((Object)("size of dcActiveConxnPool (before removing) :" + this.dcActiveConxnPool.size()));
            this.dcActiveConxnPool.remove(objDTCO);
            this.logger.debug((Object)("size of dcActiveConxnPool :" + this.dcActiveConxnPool.size()));
            this.logger.debug((Object)("Returning Terminal Connection with status:" + status));
            if (this.dcActiveConxnPoolCount.contains(objDTCO.getRemoteDeviceSerialNumber())) {
                this.dcActiveConxnPoolCount.remove(objDTCO.getRemoteDeviceSerialNumber());
            }
            String compCardNumber = this.cardSerialIdMap.get(objDTCO.getRemoteDeviceSerialNumber());
            int cardType = this.cardNoCardTypeMap.get(compCardNumber);
            this.logger.debug((Object)("Serial id (Returning Terminal Connection) :" + objDTCO.getRemoteDeviceSerialNumber()));
            this.logger.debug((Object)("Company card number (Returning Terminal Connection) :" + compCardNumber));
            if (cardType == 4) {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Both Vehicle and site specific"));
                this.setCompanyCardStatus(objDTCO.getCompanyID(), compCardNumber, status);
                this.setCompanyCardStatus(-1, compCardNumber, status);
            } else if (cardType == 1) {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Company specific"));
                this.setCompanyCardStatus(objDTCO.getCompanyID(), compCardNumber, status);
            } else {
                this.logger.debug((Object)("Company Card Number: " + compCardNumber + "Card type : Vehicle specific"));
                this.setCompanyCardStatus(-1, compCardNumber, status);
            }
            this.logger.debug((Object)(String.valueOf(objDTCO.getCompanyCardNo()) + " Card released for Company ID: " + objDTCO.getCompanyID() + " for serial Id " + objDTCO.getRemoteDeviceSerialNumber()));
            if (!this.cardSerialIdMap.isEmpty()) {
                this.logger.debug((Object)("Size of cardSerialIdMap (before): " + this.cardSerialIdMap.size()));
                this.cardSerialIdMap.remove(objDTCO.getRemoteDeviceSerialNumber());
            }
            if (!this.cardSerialIdMap.isEmpty()) {
                this.logger.debug((Object)("Size of cardSerialIdMap (after) : " + this.cardSerialIdMap.size()));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.debug((Object)("dcConxnList size before removing:" + dcConxnList.size()));
            this.removeCompanyCard(objDTCO.getCompanyID(), objDTCO.getCompanyCardNo());
            this.removeCompanyCard(-1, objDTCO.getCompanyCardNo());
            this.logger.debug((Object)("dcConxnList:" + dcConxnList + " , dcConxnList size:" + dcConxnList.size()));
            this.logger.error((Object)"Exception while reconnecting card reader in returnTerminalConnection method of AuthenticationManager class: ", (Throwable)e);
            return true;
        }
    }

    public String getCompanyIDsFromCardPool() {
        String str = ConfigUtil.getValue("CardTimeOutPeriod");
        this.timeOut = Integer.parseInt(str) * 1000;
        String accAndSiteID = "";
        try {
            Iterator<Map.Entry<Integer, ArrayList<CompanyCardVO>>> itrKeyValuePairs = dcConxnList.entrySet().iterator();
            while (itrKeyValuePairs.hasNext()) {
                String sCompanyIDs = "";
                String siteData = "";
                Map.Entry<Integer, ArrayList<CompanyCardVO>> entry = itrKeyValuePairs.next();
                int iKey = entry.getKey();
                if (iKey == -1) continue;
                ArrayList<CompanyCardVO> cmpVo = entry.getValue();
                Iterator<CompanyCardVO> itrCompanyCardVO = cmpVo.iterator();
                while (itrCompanyCardVO.hasNext()) {
                    CopyOnWriteArrayList<Integer> siteID = new CopyOnWriteArrayList<Integer>();
                    int j = 0;
                    while (j < cmpVo.size()) {
                        siteID.add(cmpVo.get(j).getSiteID());
                        siteData = siteData.equalsIgnoreCase("") ? ((Object)siteID).toString() : String.valueOf(siteData) + "," + ((Integer)siteID.get(j)).toString();
                        ++j;
                    }
                    sCompanyIDs = String.valueOf(String.valueOf(iKey)) + ":" + siteData;
                }
                accAndSiteID = accAndSiteID.equalsIgnoreCase("") ? sCompanyIDs : String.valueOf(accAndSiteID) + "#" + sCompanyIDs;
            }
        }
        catch (Exception exp) {
            this.logger.debug((Object)("Error in find Company having card in card poool: " + exp));
            return accAndSiteID;
        }
        this.logger.debug((Object)("Size of Available Terminal with Card is:" + dcConxnList.size()));
        return accAndSiteID;
    }

    public DTCOCommandVO setCompanyCardStatusReserve(DTCOCommandVO objDTCOCommandVO) {
        int iCompanyID = objDTCOCommandVO.getCompanyID();
        boolean bIscardBusy = false;
        this.logger.debug((Object)("Inside setCompanyCardStatusReserve for CompanyID:" + objDTCOCommandVO.getCompanyID()));
        this.logger.debug((Object)("Company card number DTCOCOmmandVO " + objDTCOCommandVO.getCompanyCardNo()));
        ReminderListDao objRemindwerListDao = ReminderListDao.getInstance();
        try {
            if (GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).startsWith("V")) {
                VehicleDetailsDao objVehicleDetailsDao = VehicleDetailsDao.getInstance();
                objDTCOCommandVO = objVehicleDetailsDao.getCompanyCard(objDTCOCommandVO);
                this.logger.debug((Object)("Company card number DTCOCOmmandVO (from VehicleDetailsDao) " + objDTCOCommandVO.getCompanyCardNo()));
                if (objDTCOCommandVO.getCompanyCardNo().equals("-1")) {
                    iCompanyID = objDTCOCommandVO.getCompanyID();
                    objDTCOCommandVO.setKeyOfMap(iCompanyID);
                } else {
                    iCompanyID = -1;
                    objDTCOCommandVO.setKeyOfMap(-1);
                }
            }
            String str = ConfigUtil.getValue("CardTimeOutPeriod");
            this.timeOut = Integer.parseInt(str) * 1000;
            if (dcConxnList.containsKey(iCompanyID)) {
                List<Object> companyCardNumberList = new ArrayList();
                VehicleDetailsDao objVehicleDetailsDao = VehicleDetailsDao.getInstance();
                companyCardNumberList = objVehicleDetailsDao.getComapanyCardWR_1b1_MachineIDbased(objDTCOCommandVO);
                this.logger.info((Object)("Got " + companyCardNumberList.size() + " suitable company cards for authentication " + " for Company ID " + iCompanyID));
                this.logger.debug((Object)("Connection List before card reserve" + dcConxnList));
                ArrayList<CompanyCardVO> arCompanyCardVO = dcConxnList.get(iCompanyID);
                this.logger.debug((Object)("ArrayList check" + arCompanyCardVO));
                this.logger.info((Object)("Size of ArrayList<CompanyCardVO> (get from dcConxnList) " + arCompanyCardVO.size()));
                for (CompanyCardVO objCompanyCardVO : arCompanyCardVO) {
                    this.logger.debug((Object)("objCompanyCardVO.getCardNumber() = " + objCompanyCardVO.getCardNumber()));
                    if (iCompanyID == -1) {
                        this.logger.debug((Object)("In Company specific card for Card no" + objCompanyCardVO.getCardNumber() + " and Company ID: " + objDTCOCommandVO.getCompanyID()));
                        if (!objCompanyCardVO.getCardNumber().equals(objDTCOCommandVO.getCompanyCardNo())) continue;
                        if (objCompanyCardVO.getCardState() == 1) {
                            if (this.cardSerialIdMap.containsKey(objDTCOCommandVO.getRemoteDeviceSerialNumber())) {
                                this.logger.debug((Object)("cardSerialIdMap already mapped for serial id : " + objDTCOCommandVO.getRemoteDeviceSerialNumber()));
                                this.cardSerialIdMap.remove(objDTCOCommandVO.getRemoteDeviceSerialNumber());
                            }
                            if (this.cardSerialIdMap.containsValue(objCompanyCardVO.getCardNumber())) {
                                this.logger.debug((Object)("cardSerialIdMap already mapped for company card : " + objCompanyCardVO.getCardNumber()));
                                try {
                                    this.cardSerialIdMap.values().removeAll(Collections.singleton(objCompanyCardVO.getCardNumber()));
                                }
                                catch (Exception e) {
                                    this.logger.debug((Object)("Exception -cardSerialIdMap already mapped for company card : " + objCompanyCardVO.getCardNumber()));
                                }
                            }
                            objCompanyCardVO.setCardState(2);
                            int currentTime = (int)(new Date().getTime() / 1000L);
                            objCompanyCardVO.setReservedTimestamp(Integer.toString(currentTime));
                            objDTCOCommandVO.setCardReserved(true);
                            this.dcActiveConxnPool.put(objDTCOCommandVO, objCompanyCardVO.getTermnial());
                            this.logger.debug((Object)("Vehicle specific Card found: " + objCompanyCardVO.getCardNumber() + " and Company ID: " + objDTCOCommandVO.getCompanyID() + " Serial Id( setCompanyCardStatusReserve): " + objDTCOCommandVO.getRemoteDeviceSerialNumber()));
                            this.cardSerialIdMap.put(objDTCOCommandVO.getRemoteDeviceSerialNumber(), objCompanyCardVO.getCardNumber());
                            if (!this.cardNoCardTypeMap.containsKey(objCompanyCardVO.getCardNumber())) {
                                this.cardNoCardTypeMap.put(objCompanyCardVO.getCardNumber(), objCompanyCardVO.getCardType());
                            }
                            String[] strEntityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).split("#");
                            FailureMessageDao.getInstance().addGenralMessage(objDTCOCommandVO.getCompanyID(), "20", strEntityId[0].substring(1, strEntityId[0].length()), objDTCOCommandVO.getCompanyCardNo());
                            return objDTCOCommandVO;
                        }
                        bIscardBusy = true;
                        this.logger.debug((Object)(String.valueOf(objCompanyCardVO.getCardNumber()) + " Company specific Card busy for Company ID:" + objDTCOCommandVO.getCompanyID()));
                        break;
                    }
                    if (GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).startsWith("V") && (!GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).startsWith("V") || !companyCardNumberList.contains(objCompanyCardVO.getCardNumber()))) continue;
                    this.logger.debug((Object)("Site specific card for Card no. :" + objCompanyCardVO.getCardNumber() + " and Company ID: " + objDTCOCommandVO.getCompanyID()));
                    if (objCompanyCardVO.getCardState() == 1) {
                        if (this.cardSerialIdMap.containsKey(objDTCOCommandVO.getRemoteDeviceSerialNumber())) {
                            this.logger.debug((Object)("cardSerialIdMap already mapped for serial id : " + objDTCOCommandVO.getRemoteDeviceSerialNumber()));
                            this.cardSerialIdMap.remove(objDTCOCommandVO.getRemoteDeviceSerialNumber());
                        }
                        if (this.cardSerialIdMap.containsValue(objCompanyCardVO.getCardNumber())) {
                            this.logger.debug((Object)("cardSerialIdMap already mapped for company card : " + objCompanyCardVO.getCardNumber()));
                            try {
                                this.cardSerialIdMap.values().removeAll(Collections.singleton(objCompanyCardVO.getCardNumber()));
                            }
                            catch (Exception e) {
                                this.logger.debug((Object)("Exception -cardSerialIdMap already mapped for company card : " + objCompanyCardVO.getCardNumber()));
                            }
                        }
                        objCompanyCardVO.setCardState(2);
                        objDTCOCommandVO.setCompanyCardNo(objCompanyCardVO.getCardNumber());
                        int currentTime = (int)(new Date().getTime() / 1000L);
                        objCompanyCardVO.setReservedTimestamp(Integer.toString(currentTime));
                        objDTCOCommandVO.setCardReserved(true);
                        this.dcActiveConxnPool.put(objDTCOCommandVO, objCompanyCardVO.getTermnial());
                        this.logger.debug((Object)("Company specific Card found: " + objCompanyCardVO.getCardNumber() + " and Company ID: " + objDTCOCommandVO.getCompanyID() + " Serial Id( setCompanyCardStatusReserve): " + objDTCOCommandVO.getRemoteDeviceSerialNumber()));
                        this.cardSerialIdMap.put(objDTCOCommandVO.getRemoteDeviceSerialNumber(), objCompanyCardVO.getCardNumber());
                        if (!this.cardNoCardTypeMap.containsKey(objCompanyCardVO.getCardNumber())) {
                            this.cardNoCardTypeMap.put(objCompanyCardVO.getCardNumber(), objCompanyCardVO.getCardType());
                        }
                        String[] strEntityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).split("#");
                        FailureMessageDao.getInstance().addGenralMessage(objDTCOCommandVO.getCompanyID(), "20", strEntityId[0].substring(1, strEntityId[0].length()), objDTCOCommandVO.getCompanyCardNo());
                        return objDTCOCommandVO;
                    }
                    bIscardBusy = true;
                    objDTCOCommandVO.setCompanyCardNo(objCompanyCardVO.getCardNumber());
                    this.logger.debug((Object)(String.valueOf(objCompanyCardVO.getCardNumber()) + "Site specific Card busy for Company ID:" + objDTCOCommandVO.getCompanyID()));
                }
            }
            if (bIscardBusy) {
                this.logger.debug((Object)(String.valueOf(objDTCOCommandVO.getCompanyCardNo()) + " Card busy for Company ID:" + objDTCOCommandVO.getCompanyID()));
                if (!(objDTCOCommandVO.getDldType() != 1 && objDTCOCommandVO.getDldType() != 2 && objDTCOCommandVO.getDldType() != 8 && objDTCOCommandVO.getDldType() != 10 || objDTCOCommandVO.isCardBusy())) {
                    objDTCOCommandVO.setCardReserved(false);
                    objDTCOCommandVO.setCardBusy(true);
                    return objDTCOCommandVO;
                }
                if (objDTCOCommandVO.getDldType() != 1 && objDTCOCommandVO.getDldType() != 2 && objDTCOCommandVO.getDldType() != 8 && objDTCOCommandVO.getDldType() != 10 && !objDTCOCommandVO.isCardBusy()) {
                    this.intimateCCNPToComm(1, objDTCOCommandVO);
                    objDTCOCommandVO.setCardReserved(false);
                    objDTCOCommandVO.setCardBusy(true);
                    return objDTCOCommandVO;
                }
            } else {
                this.logger.debug((Object)(String.valueOf(objDTCOCommandVO.getCompanyCardNo()) + " Card not present for Company ID:" + objDTCOCommandVO.getCompanyID()));
                if (!(objDTCOCommandVO.getDldType() != 1 && objDTCOCommandVO.getDldType() != 2 && objDTCOCommandVO.getDldType() != 10 && objDTCOCommandVO.getDldType() != 8 || objDTCOCommandVO.isCardNotPresent())) {
                    int cardTypeForEntity;
                    objDTCOCommandVO.setStatus(1);
                    objDTCOCommandVO.setFailureCode(Byte.parseByte(String.valueOf("11")));
                    objDTCOCommandVO.setTimeStamp(GeneralAPI.getCurrentDateTimeInt());
                    objDTCOCommandVO.setAuthType(1);
                    objRemindwerListDao.updateStatusRemoteAuthentication(objDTCOCommandVO);
                    String[] strEntityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId()).split("#");
                    int n = cardTypeForEntity = objDTCOCommandVO.getCompanyCardNo().equals("-1") ? 1 : 2;
                    if (cardTypeForEntity == 1) {
                        this.logger.debug((Object)(String.valueOf(objDTCOCommandVO.getCompanyCardNo()) + " company specific card not present for company id" + objDTCOCommandVO.getCompanyID()));
                    } else {
                        FailureMessageDao.getInstance().addGenralMessage(objDTCOCommandVO.getCompanyID(), "21", strEntityId[0].substring(1, strEntityId[0].length()), objDTCOCommandVO.getCompanyCardNo());
                    }
                    if (objDTCOCommandVO.getDldType() == 3) {
                        this.intimateCCNPToComm(2, objDTCOCommandVO);
                    }
                    objDTCOCommandVO.setCardReserved(false);
                    objDTCOCommandVO.setCardNotPresent(true);
                    return objDTCOCommandVO;
                }
            }
        }
        catch (Exception exp) {
            this.logger.debug((Object)("Error in find Company Card " + objDTCOCommandVO.getCompanyCardNo()), (Throwable)exp);
            objDTCOCommandVO.setCardReserved(false);
            return objDTCOCommandVO;
        }
        return objDTCOCommandVO;
    }

    private void setCompanyCardStatus(int iCompanyID, String sCompanyCardNo, int iStatus) {
        boolean bUpdated = false;
        try {
            Iterator<Map.Entry<Integer, ArrayList<CompanyCardVO>>> itrKeyValuePairs = dcConxnList.entrySet().iterator();
            while (itrKeyValuePairs.hasNext()) {
                this.logger.info((Object)("iCompanyID set in setCompanyCardStatus() :: " + iCompanyID));
                this.logger.info((Object)("sCompanyCardNo in setCompanyCardStatus() :: " + sCompanyCardNo));
                Map.Entry<Integer, ArrayList<CompanyCardVO>> entry = itrKeyValuePairs.next();
                int iKey = entry.getKey();
                if (iKey != iCompanyID) continue;
                for (CompanyCardVO objCompanyCardVO : entry.getValue()) {
                    if (!objCompanyCardVO.getCardNumber().equals(sCompanyCardNo)) continue;
                    this.logger.info((Object)("Releasing card (setCardState setReservedTimestamp) :: " + sCompanyCardNo));
                    objCompanyCardVO.setCardState(iStatus);
                    objCompanyCardVO.setReservedTimestamp(null);
                    bUpdated = true;
                    break;
                }
                if (bUpdated) break;
            }
            this.logger.debug((Object)("Connection Map after returning terminal:" + dcConxnList));
            for (Map.Entry<Integer, ArrayList<CompanyCardVO>> entry : dcConxnList.entrySet()) {
                int iKey = entry.getKey();
                int p = 1;
                ArrayList<CompanyCardVO> arCompanyCardVO = entry.getValue();
                Iterator<CompanyCardVO> itrCompanyCardVO = arCompanyCardVO.iterator();
                while (itrCompanyCardVO.hasNext()) {
                    this.logger.debug((Object)("Element:" + p++));
                    CompanyCardVO objCompanyCardVO = itrCompanyCardVO.next();
                    this.logger.debug((Object)("TimeStamp  When Card returned :" + objCompanyCardVO.getReservedTimestamp()));
                    this.logger.debug((Object)("CardNumber When Card returned:" + objCompanyCardVO.getCardNumber()));
                    this.logger.debug((Object)("CardState  When Card returned:" + objCompanyCardVO.getCardState()));
                    this.logger.debug((Object)("CardType When Card returned:" + objCompanyCardVO.getCardType()));
                    this.logger.debug((Object)("ID:" + objCompanyCardVO.getSiteID()));
                    this.logger.debug((Object)("Termnial:" + objCompanyCardVO.getTermnial()));
                }
            }
        }
        catch (Exception exp) {
            this.logger.debug((Object)"Error in find Company Card:", (Throwable)exp);
            return;
        }
    }

    private void removeCompanyCard(int iCompanyID, String sCompanyCardNo) {
        boolean bRemoved = false;
        try {
            Iterator<Map.Entry<Integer, ArrayList<CompanyCardVO>>> itrKeyValuePairs = dcConxnList.entrySet().iterator();
            while (itrKeyValuePairs.hasNext()) {
                int iCounter = 0;
                Map.Entry<Integer, ArrayList<CompanyCardVO>> entry = itrKeyValuePairs.next();
                int iKey = entry.getKey();
                if (iKey != iCompanyID) continue;
                Iterator<CompanyCardVO> itrCompanyCardVO = entry.getValue().iterator();
                while (itrCompanyCardVO.hasNext()) {
                    CompanyCardVO objCompanyCardVO = itrCompanyCardVO.next();
                    if (objCompanyCardVO.getCardNumber().equals(sCompanyCardNo)) {
                        if (!itrCompanyCardVO.hasNext() && iCounter == 0) {
                            dcConxnList.entrySet().remove(entry);
                        } else {
                            entry.getValue().remove(objCompanyCardVO);
                        }
                        bRemoved = true;
                        break;
                    }
                    ++iCounter;
                }
                if (!bRemoved) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exp) {
            this.logger.debug((Object)"Error in find Company Card");
        }
    }

    private void intimateCCNPToComm(int iStatus, DTCOCommandVO objDTCOCommandVO) {
        this.logger.debug((Object)"CCNP to Wide Range.........");
        CommandCCNPData objCommandCCNPData = new CommandCCNPData();
        objCommandCCNPData.setSerialId(objDTCOCommandVO.getRemoteDeviceSerialNumber());
        objCommandCCNPData.setStatus(iStatus);
        InvokeRemoteDevice device = InvokeRemoteDevice.getInstance();
        device.sendCCNPToWideRange(objDTCOCommandVO.getRemoteServiceID(), objCommandCCNPData);
    }

    public int getCardStatus(int companyId) {
        this.logger.info((Object)("in getCardStatus companyId recieved:" + companyId));
        int companyCardStatus = 0;
        boolean isBreak = false;
        if (dcConxnList.containsKey(companyId)) {
            this.logger.info((Object)("inside Site..companyId : " + companyId));
            ArrayList<CompanyCardVO> listComapnyCardVO = dcConxnList.get(companyId);
            for (CompanyCardVO objCompanyCardVO : listComapnyCardVO) {
                if (objCompanyCardVO.getCardState() != 1) continue;
                isBreak = true;
                break;
            }
            if (!isBreak) {
                if (dcConxnList.containsKey(-1)) {
                    listComapnyCardVO = dcConxnList.get(companyId);
                    for (CompanyCardVO objCompanyCardVO : listComapnyCardVO) {
                        if (objCompanyCardVO.getCardState() != 1) continue;
                        isBreak = true;
                        break;
                    }
                    if (!isBreak) {
                        companyCardStatus = 1;
                    }
                } else {
                    companyCardStatus = 1;
                }
            }
        } else if (dcConxnList.containsKey(-1)) {
            ArrayList<CompanyCardVO> listComapnyCardVO = dcConxnList.get(-1);
            for (CompanyCardVO objCompanyCardVO : listComapnyCardVO) {
                this.logger.info((Object)("in getCardStatus  companyId recieved:" + companyId));
                this.logger.info((Object)("in getCardStatus objCompanyCardVO.getAccountID():" + objCompanyCardVO.getAccountID()));
                this.logger.info((Object)("in getCardStatus objCompanyCardVO.getCardState():" + objCompanyCardVO.getCardState()));
                if (companyId == objCompanyCardVO.getAccountID()) {
                    this.logger.info((Object)("in getCardStatus contains account in map: " + companyId));
                    if (objCompanyCardVO.getCardState() == 1) {
                        companyCardStatus = 0;
                        break;
                    }
                    if (objCompanyCardVO.getCardState() != 3) continue;
                    companyCardStatus = 1;
                    continue;
                }
                this.logger.info((Object)("Card not present For this company : " + companyId));
                companyCardStatus = 2;
            }
        } else {
            this.logger.info((Object)("inside Card not present for this Account : " + companyId));
            companyCardStatus = 2;
        }
        this.logger.info((Object)("Just before return companyCardStatus, Status is : " + companyCardStatus));
        return companyCardStatus;
    }

    public void releaseBusyCards() {
        CopyOnWriteArrayList listCardNumbersBusy = new CopyOnWriteArrayList();
        this.logger.debug((Object)"In releaseBusyCards() started searching busy cards because of unexpected reason...");
        int minutes = GeneralDao.getAuthUnexpectedAuthenticationInProgressFreqMin();
        for (Map.Entry<Integer, ArrayList<CompanyCardVO>> entry : dcConxnList.entrySet()) {
            for (CompanyCardVO objCompanyCardVO : entry.getValue()) {
                if (objCompanyCardVO.getReservedTimestamp() == null) continue;
                int timestamp = Integer.parseInt(objCompanyCardVO.getReservedTimestamp());
                Date timestampDate = new Date((long)timestamp * 1000L);
                this.logger.debug((Object)("Company card number:" + objCompanyCardVO.getCardNumber()));
                this.logger.debug((Object)("Reserved Date:" + timestampDate));
                this.logger.debug((Object)("Minutes to be added:" + minutes));
                Date result = GeneralAPI.addMinutes(timestampDate, minutes);
                this.logger.debug((Object)("After adding minutes Date:" + result));
                int busy = result.compareTo(new Date());
                if (busy > 0) continue;
                this.logger.debug((Object)("Card " + objCompanyCardVO.getCardNumber() + " busy for unexpected reason."));
                System.out.print("JVM appears hung");
            }
        }
    }
}

