/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.vo.CommandResponseVO;
import com.thoughtworks.xstream.XStream;
import org.apache.log4j.Logger;

public class CMPRThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(CMPRThread.class);
    private String strXML;

    public CMPRThread(String strXml) {
        this.strXML = strXml;
    }

    @Override
    public void run() {
        try {
            logger.info((Object)("Inside CMPR thread : " + Thread.currentThread().getName()));
            logger.info((Object)("CMPR Xml String received from RDS Comm : " + this.strXML));
            if (this.strXML.indexOf("CMPR") != -1) {
                logger.info((Object)"CMPR XML FROM RDS SERVER... ");
                if (this.strXML != null) {
                    XStream objXStream = new XStream();
                    Object objEntity = null;
                    objXStream.alias("CommandResponseVO", CommandResponseVO.class);
                    objEntity = objXStream.fromXML(this.strXML.toString().trim());
                    CommandResponseVO objCommandResponseVO = (CommandResponseVO)objEntity;
                    String commandName = objCommandResponseVO.getCmdName();
                    if (commandName.equalsIgnoreCase("CMPR")) {
                        AuthenticationManager objAuthenticationManager = AuthenticationManager.getAuthenticationManager();
                        logger.info((Object)"Sending CMPR for authentication....");
                        logger.info((Object)("RemoteServiceId...." + objCommandResponseVO.getCommandCMPRData().getRemoteServiceId()));
                        if (objCommandResponseVO.getCommandCMPRData().getRemoteServiceId() != 0) {
                            objAuthenticationManager.updateDTCOList(this.strXML.toString().trim(), objCommandResponseVO.getCommandCMPRData().getRemoteServiceId());
                        } else {
                            objAuthenticationManager.updateDTCOList(this.strXML.toString().trim(), -1);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while deserializing CMPR xml : " + ConfigUtil.getStackTraceAsString(e)));
        }
    }

    public String toString() {
        return this.strXML;
    }
}

