/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.ReadRegistry;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.GeneralDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.dao.WebServiceXMLDetailsDao;
import com.sisl.dtco.integration.WRFileTransferThread;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.vo.UrlRead;
import com.sisl.dtco.vo.XMLObject;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.RemoteServiceVO;
import org.tempuri.ServiceInfo;
import org.tempuri.ServiceVO;

public class ClientXMLThread
extends TimerTask {
    Timer timer = new Timer();
    static ClientXMLThread instance = new ClientXMLThread();
    private static final Logger logger = Logger.getLogger(ClientXMLThread.class);
    public static boolean xmlChecked = false;

    @Override
    public void run() {
        logger.debug((Object)"XML Thread Starts....");
        try {
            this.getXML();
        }
        catch (RuntimeException e) {
            logger.error((Object)"ClientXMLThread:", (Throwable)e);
        }
    }

    public static ClientXMLThread getXMLDetectionthread() {
        if (instance == null) {
            instance = new ClientXMLThread();
        }
        return instance;
    }

    private ClientXMLThread() {
    }

    public void schedule() {
        int interval = GeneralDao.getAuthXmlUpdateIntervalMin();
        long period = (long)(interval * 60) * 1000L;
        Date objDate = new Date(System.currentTimeMillis() + period);
        this.timer = new Timer();
        logger.debug((Object)"ClientXMLThread Timer scheduled.");
        this.timer.schedule((TimerTask)new ClientXMLThread(), objDate, period);
    }

    public void getXML() {
        try {
            ServiceVO[] svo;
            this.handleServiceXML();
            if (Application.objServiceInfo != null && Application.objServiceInfo.getServices() != null && (svo = Application.objServiceInfo.getServices()) != null && svo[0] != null && svo[1] != null) {
                int serviceIdAuth = svo[0].getIServiceID();
                int commServiceId = svo[1].getIServiceID();
                logger.debug((Object)("calling Sp for Accounts xml for service id:" + serviceIdAuth));
                if (serviceIdAuth != 0) {
                    this.handleAccountXML(serviceIdAuth, commServiceId);
                }
            }
            xmlChecked = true;
        }
        catch (Exception e) {
            logger.error((Object)"Exception in getXML of ClientXMLThread", (Throwable)e);
        }
    }

    public void handleServiceXML() {
        logger.debug((Object)" In handleServiceXML ");
        try {
            int serviceId1 = 0;
            String urlVal = "";
            String programDataPath = System.getenv("ProgramData");
            String xmlFileNameUrl = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\URL.xml";
            File fileXmlurl = new File(xmlFileNameUrl);
            String urlValue = "";
            if (fileXmlurl.exists()) {
                String xmlFileContents = "";
                xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileNameUrl);
                XStream objXStream = new XStream();
                Object objEntity = null;
                objXStream.alias("URL", UrlRead.class);
                objEntity = objXStream.fromXML(xmlFileContents);
                UrlRead objurl = (UrlRead)objEntity;
                urlValue = objurl.getUrl();
                urlVal = urlValue.split("//")[1].split("/")[0];
            }
            logger.debug((Object)("url value :" + urlVal));
            String servicePath = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
            String xmlFileName2 = String.valueOf(servicePath) + urlVal + ".xml";
            logger.debug((Object)("xml: " + xmlFileName2));
            String xmlFileContents2 = GeneralAPI.getFileContentsUTF8(xmlFileName2);
            ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
            XStream objXStream2 = new XStream();
            Object objServiceInfoObject = null;
            objXStream2.alias("ServiceInfo", ServiceInfo.class);
            objXStream2.alias("ServiceVO", ServiceVO.class);
            objServiceInfoObject = objXStream2.fromXML(xmlFileContents2);
            Application.objServiceInfo = (ServiceInfo)objServiceInfoObject;
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            boolean proxyUsed = Application.objServiceInfo.getBIsProxyServerUsed();
            String proxyHost = Application.objServiceInfo.getSProxyHost();
            String proxyPort = Application.objServiceInfo.getSProxyPort();
            String proxyUser = Application.objServiceInfo.getSProxyUser();
            String proxyPassword = Application.objServiceInfo.getSProxyPassword();
            String diskVol = ConfigUtil.executeVolCommand();
            logger.debug((Object)("diskVol:" + diskVol));
            String subDiskVal = "";
            if (diskVol.length() > 0) {
                subDiskVal = diskVol.substring(diskVol.lastIndexOf(115) + 1, diskVol.length());
            }
            logger.debug((Object)("subDiskVal:" + subDiskVal.trim()));
            String machineId = String.valueOf(InetAddress.getLocalHost().getHostName()) + ":" + subDiskVal.trim();
            String xmlMachineId = Application.objServiceInfo.getIMachineId() == null ? "" : Application.objServiceInfo.getIMachineId();
            logger.debug((Object)("xmlMachineId:" + xmlMachineId));
            logger.debug((Object)("machineId::" + machineId));
            int i = 0;
            while (i < objServiceVO.length) {
                logger.debug((Object)(" values for service vo: " + objServiceVO[i].getIServiceID()));
                listServicesVO.add(objServiceVO[i].getIServiceID());
                logger.debug((Object)("lenth of listServicesVO: " + listServicesVO));
                ++i;
            }
            serviceId1 = (Integer)listServicesVO.get(0) == null ? 0 : (Integer)listServicesVO.get(0);
            logger.debug((Object)("serviceId1 return is: " + serviceId1));
            if (serviceId1 != 0 && machineId.trim().equals(xmlMachineId.trim())) {
                logger.debug((Object)"machineid and name are equal-->if block");
                logger.debug((Object)(" in serviceId1!=0 part: service id-->" + serviceId1));
                logger.debug((Object)("proxy host not part:" + proxyHost));
                logger.debug((Object)("proxy used not part:" + proxyUsed));
                logger.debug((Object)("proxy port not part:" + proxyPort));
                logger.debug((Object)("proxy user not part:" + proxyUser));
                logger.debug((Object)("proxy password not part:" + proxyPassword));
                ServiceInfo ServiceInfoFromWebService = new ServiceInfo();
                ServiceInfoFromWebService = WebServiceXMLDetailsDao.getInstance().refreshServiceXMLServiceIDExist(serviceId1, proxyUsed, proxyHost, proxyPort, proxyUser, proxyPassword);
                logger.debug((Object)(" in serviceId1!=0 part:" + ServiceInfoFromWebService));
                if (ServiceInfoFromWebService != null && ServiceInfoFromWebService.getServices() != null) {
                    Application.objServiceInfo = ServiceInfoFromWebService;
                    this.createServiceXML(urlVal);
                } else {
                    logger.debug((Object)"ServiceInfoFromWebService and ServiceInfoFromWebService.getServices() is null-->Else block");
                    this.createXml(urlVal, xmlFileName2, proxyHost, proxyUsed, proxyPort, proxyUser, proxyPassword, objServiceVO, machineId);
                }
            } else {
                logger.debug((Object)"machineid and name are not equal-->Else block");
                this.createXml(urlVal, xmlFileName2, proxyHost, proxyUsed, proxyPort, proxyUser, proxyPassword, objServiceVO, machineId);
            }
            Application.proxyServerUsedReg = proxyUsed;
            Application.proxyHostReg = proxyHost;
            Application.proxyUserReg = proxyUser;
            Application.proxyPasswordReg = proxyPassword != null ? GeneralAPI.jumbleString(proxyPassword) : proxyPassword;
            Application.proxyPortReg = String.valueOf(proxyPort);
        }
        catch (Exception ex) {
            logger.error((Object)(" Exception in handleServiceXML.. " + ex));
        }
    }

    public void createXml(String urlVal, String xmlFileName2, String proxyHost, boolean proxyUsed, String proxyPort, String proxyUser, String proxyPassword, ServiceVO[] objServiceVO, String machineId) throws UnknownHostException {
        logger.debug((Object)"Start of deleteservice method...");
        String programDataPath1 = System.getenv("ProgramData");
        String servicePath1 = String.valueOf(programDataPath1) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
        logger.debug((Object)("Xml value path *******" + xmlFileName2));
        String downloadPath = "";
        String uploadPath = "";
        File xmlFile = new File(xmlFileName2);
        if (xmlFile.exists()) {
            downloadPath = Application.objServiceInfo.getSDataDownloadDirectory();
            uploadPath = Application.objServiceInfo.getSDataUploadDirectory();
            logger.debug((Object)("xml exists....downloadPath = " + downloadPath + " uploadPath = " + uploadPath));
        }
        if ((downloadPath == null || downloadPath.equalsIgnoreCase("")) && (uploadPath == null || uploadPath.equalsIgnoreCase(""))) {
            String strCommand = "";
            String downloadDirectory = "";
            String uploadDirectory = "";
            if (System.getProperty("os.arch").equals("x86")) {
                strCommand = "reg query \"HKEY_Local_Machine\\Software\\RTMWeb\" /v InstallationPath";
                downloadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                logger.debug((Object)("fetching download directory:" + downloadDirectory));
                uploadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                logger.debug((Object)("fetching upload directory:" + uploadDirectory));
                downloadPath = String.valueOf(downloadDirectory) + "\\Common\\DTCOData";
                uploadPath = String.valueOf(uploadDirectory) + "\\Common\\DTCOData";
                logger.debug((Object)("** Download directory Path:" + downloadPath));
                logger.debug((Object)("** Upload directory Path:" + uploadPath));
            } else {
                strCommand = "reg query \"HKEY_Local_Machine\\Software\\Wow6432Node\\RTMWeb\" /v InstallationPath";
                downloadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                logger.debug((Object)("fetching download directory:" + downloadDirectory));
                uploadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                logger.debug((Object)("fetching upload directory:" + uploadDirectory));
                downloadPath = String.valueOf(downloadDirectory) + "\\Common\\DTCOData";
                uploadPath = String.valueOf(uploadDirectory) + "\\Common\\DTCOData";
                logger.debug((Object)("** Download directory Path:" + downloadPath));
                logger.debug((Object)("** Upload directory Path:" + uploadPath));
            }
        }
        logger.debug((Object)("proxy host:" + proxyHost));
        logger.debug((Object)("proxy used:" + proxyUsed));
        logger.debug((Object)("proxy port:" + proxyPort));
        logger.debug((Object)("proxy user:" + proxyUser));
        logger.debug((Object)("proxy password:" + proxyPassword));
        String computername = InetAddress.getLocalHost().getHostName();
        Application app = new Application();
        InetSocketAddress addr = null;
        addr = this.detectProxy();
        ServiceVO objServiceVO1 = new ServiceVO();
        ServiceVO[] listServices = new ServiceVO[2];
        int i = 0;
        while (i < objServiceVO.length) {
            logger.debug((Object)("Inside for loop.... i = " + i));
            objServiceVO1 = new ServiceVO();
            objServiceVO1.setSServiceTypeId(objServiceVO[i].getSServiceTypeId());
            objServiceVO1.setSVersion(ConfigUtil.getValue("version"));
            objServiceVO1.setBIsServiceActivated(true);
            objServiceVO1.setBIsServiceInstalled(true);
            objServiceVO1.setIServiceStatusID(1);
            logger.debug((Object)("SServiceTypeId:" + objServiceVO1.getSServiceTypeId()));
            logger.debug((Object)("SVersion:" + objServiceVO1.getSVersion()));
            logger.debug((Object)("BIsServiceActivated:" + objServiceVO1.getBIsServiceActivated()));
            logger.debug((Object)("BIsServiceInstalled:" + objServiceVO1.getBIsServiceInstalled()));
            logger.debug((Object)("IServiceStatusID:" + objServiceVO1.getIServiceStatusID()));
            listServices[i] = objServiceVO1;
            ++i;
        }
        Application.objServiceInfo.setSMachineName(computername);
        Application.objServiceInfo.setSDataDownloadDirectory(downloadPath);
        Application.objServiceInfo.setSDataUploadDirectory(uploadPath);
        Application.objServiceInfo.setIUploadFrequency(4);
        Application.objServiceInfo.setBIsProxyServerUsed(proxyUsed);
        Application.objServiceInfo.setSProxyHost(proxyHost);
        Application.objServiceInfo.setSProxyPort(proxyPort);
        Application.objServiceInfo.setServices(listServices);
        Application.objServiceInfo.setSProxyUser(proxyUser);
        logger.debug((Object)("machineId set:::" + machineId));
        Application.objServiceInfo.setIMachineId(machineId);
        Application.objServiceInfo.setSProxyPassword(proxyPassword);
        Application.objServiceInfo.setSCommunicatorServicePortForDLD("9991");
        Application.objServiceInfo.setSCommunicatorServicePortForBrowserAndAuth("9992");
        Application.objServiceInfo.setSAuthenticationServicePortForCommunicatorService("9993");
        Application.objServiceInfo.setSAuthenticationServicePortForBrowser("9994");
        ServiceInfo ServiceInfoFromWebService = new ServiceInfo();
        ServiceInfoFromWebService = WebServiceXMLDetailsDao.getInstance().refreshServiceXMLServiceIDNotExist(Application.objServiceInfo);
        if (ServiceInfoFromWebService.getSRDSHost() == null || ServiceInfoFromWebService.getSRDSHost().equalsIgnoreCase("") || ServiceInfoFromWebService.getSRDSHost().trim().length() == 0) {
            logger.debug((Object)"********************** host null***************************");
        }
        ServiceInfoFromWebService.getSRDSHost();
        ServiceInfoFromWebService.getSRDSPort();
        if (ServiceInfoFromWebService != null && ServiceInfoFromWebService.getServices() != null) {
            Application.objServiceInfo = ServiceInfoFromWebService;
            logger.debug((Object)(" Service Info returned from Web service = " + ServiceInfoFromWebService));
            if (xmlFile.exists()) {
                if (xmlFile.delete()) {
                    logger.debug((Object)"service xml file is deleted successfully");
                } else {
                    logger.debug((Object)"service xml file is not deleted");
                }
            }
            this.createServiceXML(urlVal);
        } else {
            logger.debug((Object)" Service Info returned from Web service is null.. ");
        }
    }

    public void handleAccountXML(int serviceIDAuth, int commServiceId) {
        logger.debug((Object)"In handleAccountXML ");
        try {
            this.readAccountsXML();
            HashMap<String, Integer> hmapBefore = new HashMap<String, Integer>();
            String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
            File file = new File(xmlFileName);
            if (file.exists()) {
                AccountsDetailsXMLChild[] objAccountsVO = Application.listAccounts.getAccounts();
                int i = 0;
                while (i < objAccountsVO.length) {
                    hmapBefore.put(String.valueOf(objAccountsVO[i].getAccountId()), objAccountsVO[i].getDeviceType());
                    ++i;
                }
                for (String key : hmapBefore.keySet()) {
                    logger.debug((Object)"********* hmapBefore Refresh AccountXML ***************");
                    logger.debug((Object)("Key(AccountId):  " + key + "    Value(DeviceType): " + hmapBefore.get(key)));
                }
            } else {
                logger.debug((Object)".....Account Xml does not exist.....");
            }
            AccountDetailsXMLParent objAccountDetailsXMLParent = WebServiceXMLDetailsDao.getInstance().getAccountsFromServiceID(serviceIDAuth, commServiceId);
            if (objAccountDetailsXMLParent != null && objAccountDetailsXMLParent.getAccounts() != null) {
                Application.listAccounts = objAccountDetailsXMLParent;
                logger.debug((Object)("*********** List of Accounts**********" + Application.listAccounts.getAccounts()));
                this.createAccountXMLForRefresh(Application.listAccounts);
                logger.debug((Object)("new account list after refresh:" + objAccountDetailsXMLParent));
                HashMap<String, Integer> hmapAfter = new HashMap<String, Integer>();
                AccountsDetailsXMLChild[] objAccountsVOAfter = Application.listAccounts.getAccounts();
                int i = 0;
                while (i < objAccountsVOAfter.length) {
                    hmapAfter.put(String.valueOf(objAccountsVOAfter[i].getAccountId()), objAccountsVOAfter[i].getDeviceType());
                    ++i;
                }
                for (String key : hmapAfter.keySet()) {
                    logger.debug((Object)"********* hmapAfter Refresh AccountXML ***************");
                    logger.debug((Object)("Key(AccountId):  " + key + "    Value(DeviceType): " + hmapAfter.get(key)));
                }
                ClientXMLThread.mapsAreEqual(hmapBefore, hmapAfter);
            } else {
                logger.debug((Object)" Account XML received from web service is null.. ");
                this.deleteAccountXmlFile();
            }
        }
        catch (Exception ex) {
            logger.error((Object)(" Exception in handleAccountXML.. " + ex));
        }
    }

    public static void mapsAreEqual(Map<String, Integer> mapBefore, Map<String, Integer> hmapAfter) {
        try {
            logger.debug((Object)"------- Inside mapsAreEqual ------------ ");
            if (hmapAfter.equals(mapBefore)) {
                logger.debug((Object)"maps are equal");
            } else {
                RemoteServiceVO objRemoteServiceVO;
                RemoteServiceDao objRemoteServiceDao;
                int value;
                logger.debug((Object)"maps are not equal");
                for (String key : hmapAfter.keySet()) {
                    logger.debug((Object)("hmapAfter.get(key):" + hmapAfter.get(key)));
                    logger.debug((Object)("mapBefore.get(key):" + mapBefore.get(key)));
                    if (hmapAfter.get(key) == mapBefore.get(key)) continue;
                    value = hmapAfter.get(key);
                    logger.debug((Object)"Going to Start WRping for new account...");
                    logger.debug((Object)(" AccountId : " + key + "  Device type  : " + value));
                    if (value == 3 || value == 5 || value == 6 || value == 7) {
                        objRemoteServiceDao = RemoteServiceDao.getInstance();
                        objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(Integer.parseInt(key));
                        logger.debug((Object)("Start WRpining for  AccountId : " + key + "   ServiceId :" + objRemoteServiceVO.getRemoteServiceId()));
                        WRPingingThread.schedule(objRemoteServiceVO.getRemoteServiceId());
                        WRFileTransferThread.schedule(objRemoteServiceVO.getRemoteServiceId());
                        continue;
                    }
                    logger.debug((Object)("Device type for Account : " + key + " not WR-I..No need to Start WRPing "));
                }
                for (String y : mapBefore.keySet()) {
                    if (hmapAfter.containsKey(y)) continue;
                    logger.debug((Object)"Going to Stop WRping for old account bz association removed ...");
                    value = mapBefore.get(y);
                    objRemoteServiceDao = RemoteServiceDao.getInstance();
                    objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(Integer.parseInt(y));
                    logger.debug((Object)(" AccountId : " + y + "  Device type  : " + value));
                    if (value == 3 || value == 5 || value == 6 || value == 7) {
                        logger.debug((Object)("Stop WRpining for  AccountId : " + y + "   ServiceId :" + objRemoteServiceVO.getRemoteServiceId()));
                        WRPingingThread.cancelPingingTask(objRemoteServiceVO.getRemoteServiceId());
                        WRFileTransferThread.cancelFileTransferTask(objRemoteServiceVO.getRemoteServiceId());
                        continue;
                    }
                    logger.debug((Object)("Device type for Account : " + y + " not WR-I..No need to Stop WRPing "));
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Exception in mapsAreEqual:" + ConfigUtil.getStackTraceAsString(e)));
        }
    }

    private void readAccountsXML() {
        try {
            String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
            String xmlFileContents = "";
            File file = new File(xmlFileName);
            if (file.exists()) {
                logger.info((Object)("file length in AccouintXML:" + file.length()));
                xmlFileContents = GeneralAPI.getFileContentsUTF8(xmlFileName);
                if (file.length() == 0L || xmlFileContents.isEmpty() || xmlFileContents.length() == 0) {
                    logger.info((Object)"Empty String in AccouintXML");
                    if (file.delete()) {
                        logger.info((Object)" AccouintXML IS  deleted successfully ::");
                    } else {
                        logger.info((Object)"  AccouintXML Not Deleted ::: ");
                    }
                } else {
                    logger.info((Object)"None Empty string in AccouintXML");
                    XStream objXStream = new XStream();
                    Object objEntity = null;
                    objXStream.alias("AccountDetails", AccountDetailsXMLParent.class);
                    objXStream.alias("AccountsVO", AccountsDetailsXMLChild.class);
                    objEntity = objXStream.fromXML(xmlFileContents);
                    Application.listAccounts = (AccountDetailsXMLParent)objEntity;
                    logger.debug((Object)("**** in readAccountsXML : xmlFileContents : *** " + xmlFileContents));
                }
            } else {
                logger.debug((Object)"Account Xml does  not exist.");
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in getAccIdsList of AccountManagement class", (Throwable)e);
        }
    }

    public void createServiceXML(String urlVal) {
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("ServiceInfo");
        objXmlObject.setClassName(ServiceInfo.class);
        objArr.add(objXmlObject);
        objXmlObject = new XMLObject();
        objXmlObject.setAlias("ServiceVO");
        objXmlObject.setClassName(ServiceVO.class);
        objArr.add(objXmlObject);
        String strAccountDetails = GeneralAPI.objectToXml(Application.objServiceInfo, objArr);
        String programDataPath = System.getenv("ProgramData");
        String servicePath = String.valueOf(programDataPath) + "\\RTMTrayIconProxySettings\\AccountServiceDetails_";
        String xmlFileName = String.valueOf(servicePath) + urlVal + ".xml";
        try {
            File xmlFile = new File(xmlFileName);
            xmlFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(xmlFileName, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF8");
            out.write(strAccountDetails);
            logger.debug((Object)("in createServiceXML:" + strAccountDetails));
            ((Writer)out).close();
            fout.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in createServiceXML of Application", (Throwable)e);
        }
    }

    private void deleteAccountXmlFile() {
        logger.debug((Object)"Start of deleteAccountXmlFile method...");
        String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
        File xmlFile = new File(xmlFileName);
        if (xmlFile.exists()) {
            if (xmlFile.delete()) {
                logger.debug((Object)"Account xml file is deleted successfully");
            } else {
                logger.debug((Object)"Account xml file is not deleted");
            }
        } else {
            logger.debug((Object)"Account xml does not exist.. hence could not be deleted");
        }
        logger.debug((Object)"End of deleteAccountXmlFile method...");
    }

    public void createAccountXMLForRefresh(AccountDetailsXMLParent parentTag) {
        String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("AccountDetails");
        objXmlObject.setClassName(AccountDetailsXMLParent.class);
        objArr.add(objXmlObject);
        objXmlObject = new XMLObject();
        objXmlObject.setAlias("AccountsVO");
        objXmlObject.setClassName(AccountsDetailsXMLChild.class);
        objArr.add(objXmlObject);
        String strAccountDetails = GeneralAPI.objectToXml(parentTag, objArr);
        try {
            File xmlFile = new File(xmlFileName);
            xmlFile.createNewFile();
            FileOutputStream fout = new FileOutputStream(xmlFileName, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF8");
            out.write(strAccountDetails);
            ((Writer)out).close();
            fout.close();
            byte[] erorFileContents = new byte[(int)xmlFile.length()];
            FileInputStream fileInputStream = new FileInputStream(xmlFile);
            fileInputStream.read(erorFileContents);
            logger.debug((Object)("**** in createAccountXMLForRefresh : xmlFileContents after refresh : *** " + new String(erorFileContents)));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("Exception in createAccoutnXML in AccountManagement: " + e));
        }
    }

    public InetSocketAddress detectProxy() {
        InetSocketAddress addr = null;
        try {
            int n;
            List<Proxy> l = ProxySelector.getDefault().select(new URI("https://www.my-fis.com/"));
            String proxyHost = "";
            for (Proxy proxy : l) {
                addr = (InetSocketAddress)proxy.address();
                if (addr == null) continue;
                proxyHost = addr.getHostName();
                n = addr.getPort();
            }
            if (addr == null) {
                logger.debug((Object)"HTTPS proxy not available, therefore trying to get HTTP proxy settings..........");
                l = ProxySelector.getDefault().select(new URI("http://www.google.co.in/"));
                for (Proxy proxy : l) {
                    addr = (InetSocketAddress)proxy.address();
                    if (addr == null) continue;
                    proxyHost = addr.getHostName();
                    n = addr.getPort();
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception in detectProxy of Application", (Throwable)e);
        }
        return addr;
    }
}

