/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.dao.GeneralDao;
import com.sisl.dtco.integration.AuthenticationManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class CompanyCardDetectionThread
extends TimerTask {
    Timer timer = new Timer();
    static CompanyCardDetectionThread instance = new CompanyCardDetectionThread();
    private static final Logger logger = Logger.getLogger(CompanyCardDetectionThread.class);

    @Override
    public void run() {
        logger.debug((Object)"Detecting free card reader with valid company card to start authentication");
        try {
            AuthenticationManager authController = AuthenticationManager.getAuthenticationManager();
            authController.releaseBusyCards();
            authController.refreshPool();
        }
        catch (RuntimeException e) {
            logger.error((Object)("CompanyCardDetectionThread:" + ConfigUtil.getStackTraceAsString(e)));
        }
    }

    public static CompanyCardDetectionThread getCompanyCardDetectionThread() {
        if (instance == null) {
            instance = new CompanyCardDetectionThread();
        }
        return instance;
    }

    private CompanyCardDetectionThread() {
    }

    public void schedule() {
        Date objDate = new Date(System.currentTimeMillis());
        int interval = GeneralDao.getAuthCompanyCardDetectionFreqSec();
        long period = (long)interval * 1000L;
        this.timer = new Timer();
        logger.debug((Object)"CompanyCardDetection Timer scheduled.");
        this.timer.schedule((TimerTask)new CompanyCardDetectionThread(), objDate, period);
    }
}

