/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.vo.CommandResponseVO;
import org.apache.log4j.Logger;
import org.tempuri.RemoteServiceVO;

public class CreateIntimationTask
implements Runnable {
    private final Logger logger = Logger.getLogger(CreateIntimationTask.class);
    private String strXMLToBeSent;
    private int iRemoteServiceID;
    private RemoteServiceVO objRemoteServiceVO;

    public CreateIntimationTask(String strXMLToBeSent, int iRemoteServiceID, RemoteServiceVO objRemoteServiceVO) {
        this.strXMLToBeSent = strXMLToBeSent;
        this.iRemoteServiceID = iRemoteServiceID;
        this.objRemoteServiceVO = objRemoteServiceVO;
    }

    @Override
    public void run() {
        block22: {
            if (this.iRemoteServiceID == -2) {
                try {
                    if (this.strXMLToBeSent.indexOf("CSVS") != -1) {
                        this.logger.debug((Object)"Intimating RDS Server......");
                        InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
                        InvokeRemoteDevice.CSVSXml = this.strXMLToBeSent;
                        if (InvokeRemoteDevice.connect == null) {
                            this.logger.info((Object)"First time sending CSVS..");
                            objInvokeRemoteDevice.sendReceiveRequestToRDSServer();
                        } else {
                            this.logger.info((Object)"Need to send updated CSVS..Stopping old AUTH - RDS ping thread");
                            InvokeRemoteDevice.connect.close();
                        }
                        break block22;
                    }
                    this.logger.info((Object)"Any XML other than CSVS will not be sent to RDS..");
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception in run() of CreateIntimationTask class.." + ConfigUtil.getStackTraceAsString(e)));
                }
            } else if (this.iRemoteServiceID == -1) {
                this.logger.debug((Object)"Intimating Short Range......");
                InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
                objInvokeRemoteDevice.sendReceiveRequestTMDLSRCOMM(this.strXMLToBeSent);
            } else {
                this.logger.debug((Object)("Intimating Wide Range... Remote Service ID is:" + this.iRemoteServiceID));
                InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
                try {
                    if (this.strXMLToBeSent.indexOf("<cmdName>TDDL</cmdName>") == -1 && this.strXMLToBeSent.indexOf("<cmdName>TMDL</cmdName>") == -1) {
                        CommandResponseVO objCommandResponseVO = objInvokeRemoteDevice.sendReceiveRequestToCOMM(this.strXMLToBeSent, null, this.iRemoteServiceID, this.objRemoteServiceVO);
                        this.logger.debug((Object)("RS=" + this.iRemoteServiceID + ":Status=" + objCommandResponseVO.getStatus()));
                        this.logger.debug((Object)"Command Not TDDL and TMDL");
                        break block22;
                    }
                    int retryIntervalSec = Integer.parseInt(ConfigUtil.getValue("RetryIntervalForCommandsSentToRS").trim());
                    long retryIntervalMS = (long)retryIntervalSec * 1000L;
                    int numberOfRetries = Integer.parseInt(ConfigUtil.getValue("RetriesForCommandsSentToRS").trim());
                    int retry = 0;
                    while (retry <= numberOfRetries) {
                        CommandResponseVO objCommandResponseVO = objInvokeRemoteDevice.sendReceiveRequestToCOMM(this.strXMLToBeSent, null, this.iRemoteServiceID, this.objRemoteServiceVO);
                        this.logger.debug((Object)("RS=" + this.iRemoteServiceID + ":Status=" + objCommandResponseVO.getStatus()));
                        if (objCommandResponseVO.getStatus() == 0) {
                            if (this.strXMLToBeSent.indexOf("<cmdName>TDDL</cmdName>") != -1) {
                                this.logger.debug((Object)("TDDL sent successfully. Status 0 is received for RS:" + this.iRemoteServiceID));
                                RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                                this.logger.debug((Object)("Updating TDDL Status for RS ID.........." + this.iRemoteServiceID));
                                objRemoteServiceDao.updateTDDLStatus(this.iRemoteServiceID);
                                break;
                            }
                            if (this.strXMLToBeSent.indexOf("<cmdName>TMDL</cmdName>") != -1) {
                                this.logger.debug((Object)("TMDL sent successfully. Status 0 is received for RS:" + this.iRemoteServiceID));
                                break;
                            }
                        } else {
                            if (this.strXMLToBeSent.indexOf("<cmdName>TDDL</cmdName>") != -1) {
                                this.logger.debug((Object)("TDDL Status Received is not 0 for Remote ServiceID :" + this.iRemoteServiceID));
                            } else if (this.strXMLToBeSent.indexOf("<cmdName>TMDL</cmdName>") != -1) {
                                this.logger.debug((Object)("TMDL Status Received is not 0 for Remote ServiceID :" + this.iRemoteServiceID));
                            }
                            try {
                                Thread.sleep(retryIntervalMS);
                            }
                            catch (RuntimeException e) {
                                this.logger.error((Object)("RuntimeException: " + e));
                            }
                        }
                        ++retry;
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)"Exception in Create Intimation Task:", (Throwable)e);
                }
            }
        }
    }
}

