/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.DriverDetailsDao;
import com.sisl.dtco.dao.InvokeRTMWebService;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.dao.VehicleDetailsDao;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.UIFileHandler;
import com.sisl.dtco.vo.CommandATNPData;
import com.sisl.dtco.vo.CommandCMPRData;
import com.sisl.dtco.vo.DTCOCommandVO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.tempuri.DAOResponceVO;
import org.tempuri.RemoteDeviceRegistrationVO;
import org.tempuri.RemoteServiceVO;

public class DTCOCommandHelper {
    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
    VehicleDetailsDao objVehicleDetailsDao = VehicleDetailsDao.getInstance();
    DriverDetailsDao objDriverDetailsDao = DriverDetailsDao.getInstance();
    private static final Logger logger = Logger.getLogger(DTCOCommandHelper.class);
    public static HashMap<String, String> manualEntitiesHaspMap = new HashMap();

    public DTCOCommandVO getDTCOCommandVO(CommandCMPRData objResponseData, int iRemoteServiceID) throws Exception {
        DTCOCommandVO objDTCOCommandVO;
        block120: {
            objDTCOCommandVO = new DTCOCommandVO();
            CompanyDao objCompanyDao = CompanyDao.getInstance();
            DAOResponceVO objDAOResponceVO = null;
            int iArchiveMode = 0;
            int reminderID = 0;
            int CommType = 0;
            logger.debug((Object)("Serail ID:" + objResponseData.getSerialId()));
            logger.debug((Object)("iRemoteServiceID ID:" + iRemoteServiceID));
            try {
                int intDate;
                int iCompanyID = 0;
                boolean bSVSpecificDataIndicator = false;
                boolean isDTCO2ndGenProcessingRequired = false;
                boolean is2ndGenStoneridge = false;
                objDAOResponceVO = objCompanyDao.getCompanyID(objResponseData.getSerialId(), iRemoteServiceID);
                iCompanyID = objDAOResponceVO.getICompanyID();
                CommType = objDAOResponceVO.getCommType();
                if (CommType == 8 && objResponseData.getManufacturerCode().trim().equalsIgnoreCase("?")) {
                    objResponseData.setManufacturerCode("00");
                }
                logger.debug((Object)("Command type in DTCOCommandHelper class = " + CommType));
                if (iCompanyID == 0 && (CommType == 2 || CommType == 8 || CommType == 10)) {
                    objDTCOCommandVO.setEntityId(null);
                    UIFileHandler.getInstance().sendNOATToCOMM(objResponseData.getSerialId(), CommType, iRemoteServiceID);
                    return objDTCOCommandVO;
                }
                if (CommType == 3) {
                    RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                    RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceVO(iRemoteServiceID);
                    if (objRemoteServiceVO.getUrlRS() == null || objRemoteServiceVO.getUserNameRS() == null || objRemoteServiceVO.getPasswordRS() == null || objRemoteServiceVO.getAccountNameRS() == null) {
                        logger.debug((Object)"Returning from getDTCOCommandVO()");
                        objDTCOCommandVO.setEntityId(null);
                        return objDTCOCommandVO;
                    }
                    objDTCOCommandVO.setRemoteServiceVo(objRemoteServiceVO);
                }
                iArchiveMode = objDAOResponceVO.getIArchiveMode();
                bSVSpecificDataIndicator = objDAOResponceVO.isBSVSpecificDataIndicator();
                String companyName = objDAOResponceVO.getCompanyName();
                logger.debug((Object)("CompanyID:" + iCompanyID));
                logger.debug((Object)("Archive Mode:" + iArchiveMode));
                logger.debug((Object)("SVSpecificDataIndicator:" + bSVSpecificDataIndicator));
                logger.debug((Object)("Company Name:" + companyName));
                logger.debug((Object)("CommType:" + CommType));
                objDAOResponceVO = null;
                objDTCOCommandVO.setRemoteServiceID(iRemoteServiceID);
                objDTCOCommandVO.setCompanyID(iCompanyID);
                objDTCOCommandVO.setCompanyName(companyName);
                String strVin = null;
                String strVrn = null;
                String strDTCOVersion = "";
                String strManufactureCode = "";
                String strDriverCardNo = null;
                String strCoDriverCardNo = null;
                String strNewVehicle = "";
                int manulTaskByRS = 0;
                boolean driverIndicator = false;
                boolean codriverIndicator = false;
                boolean checkVrnForATNPCommand = false;
                boolean checkDriverForATNPCommand = false;
                boolean checkCoDriverForATNPCommand = false;
                boolean entityExistInCMPR = false;
                if (objResponseData != null) {
                    strVin = objResponseData.getVehicleIdentificationNumber();
                    strVrn = objResponseData.getVehicleRegistrationNumber();
                    if (!strVrn.matches("[a-zA-Z0-9 -]*") && CommType != 3) {
                        RemoteDeviceRegistrationVO objRemoteDeviceRegistrationVO = new RemoteDeviceRegistrationVO();
                        objRemoteDeviceRegistrationVO = this.objReminderListDao.getDetails(objResponseData.getSerialId());
                        logger.debug((Object)("In case of junk character vVRN retuirned:" + GeneralAPI.byteToString(objRemoteDeviceRegistrationVO.getVrnConnected())));
                        strVrn = GeneralAPI.byteToString(objRemoteDeviceRegistrationVO.getVrnConnected());
                    } else {
                        logger.debug((Object)"In Else case of junk character vVRN :");
                    }
                    logger.debug((Object)("sss...VRN: " + strVrn));
                    strManufactureCode = objResponseData.getManufacturerCode();
                    if (strManufactureCode == null) {
                        strManufactureCode = "00";
                    }
                    if ((strDTCOVersion = objResponseData.getVersion()) == null) {
                        strDTCOVersion = "0000";
                    }
                    try {
                        int iDTCOVersion;
                        if (CommType != 3) {
                            iDTCOVersion = Integer.parseInt(strDTCOVersion, 16);
                        } else {
                            iDTCOVersion = Integer.parseInt(strDTCOVersion);
                            strDTCOVersion = Integer.toHexString(iDTCOVersion);
                        }
                        if (iDTCOVersion >= 16384) {
                            isDTCO2ndGenProcessingRequired = true;
                        }
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Error while converting TCO version to decimal format" + e));
                        bSVSpecificDataIndicator = false;
                        is2ndGenStoneridge = InvokeRTMWebService.getInstance().checkDTCOVersionInRTM(strDTCOVersion, ConfigUtil.getPassKey());
                        logger.info((Object)("A Stoneridge tachograph therefore set SVSpecificDataIndicator false:" + bSVSpecificDataIndicator));
                    }
                    if (is2ndGenStoneridge) {
                        logger.debug((Object)"2nd Gen Stoneridge DTCO so setting isDTCO2ndGenProcessingRequired true");
                        isDTCO2ndGenProcessingRequired = true;
                    }
                    logger.warn((Object)("strDTCOVersion :" + strDTCOVersion + ", isDTCO2ndGenProcessingRequired :" + isDTCO2ndGenProcessingRequired + ", is2ndGenStoneridge :" + is2ndGenStoneridge));
                    strDriverCardNo = objResponseData.getDriverCardNumber();
                    strCoDriverCardNo = objResponseData.getCoDriverCardNumber();
                    if (strVrn != null && strVrn.trim().length() > 0) {
                        strVrn = strVrn.trim();
                        checkVrnForATNPCommand = true;
                        entityExistInCMPR = true;
                    }
                    if (strDriverCardNo != null && strDriverCardNo.trim().length() > 0) {
                        strDriverCardNo = strDriverCardNo.trim();
                        checkDriverForATNPCommand = true;
                        entityExistInCMPR = true;
                    }
                    if (strCoDriverCardNo != null && strCoDriverCardNo.trim().length() > 0) {
                        strCoDriverCardNo = strCoDriverCardNo.trim();
                        checkCoDriverForATNPCommand = true;
                        entityExistInCMPR = true;
                    }
                    strNewVehicle = objResponseData.getNewVehicle();
                    manulTaskByRS = objResponseData.getManualTask() == null || objResponseData.getManualTask().equals("") ? 0 : Integer.parseInt(objResponseData.getManualTask());
                    logger.debug((Object)("New Vehicle Y/N :" + strNewVehicle));
                    logger.debug((Object)("Manul Task by RS 1/0 :" + manulTaskByRS));
                    logger.debug((Object)("Vehicle Identification Number : " + strVin));
                    logger.debug((Object)("Vehicle Registration number:" + strVrn));
                    logger.debug((Object)("Driver Card Number:" + strDriverCardNo));
                    logger.debug((Object)("Co-Driver Card Number:" + strCoDriverCardNo));
                }
                boolean entitiesPresent = false;
                boolean vehiclePresent = false;
                boolean driverPresent = false;
                boolean coDriverPresent = false;
                boolean manualEntryMassMemoryTask = false;
                boolean manualEntrySpecialDataTask = false;
                String strMassMemoryTaskType = "";
                String strSpecialDataTaskType = "";
                boolean massMemoryReminderPresent = false;
                boolean specialDataReminderPresent = false;
                objDAOResponceVO = this.objReminderListDao.checkEntityReminderList("V" + strVrn, "S" + strVrn, "D" + strDriverCardNo, "D" + strCoDriverCardNo, iCompanyID);
                if (strVrn != null && strVrn.trim().length() > 0) {
                    if (objDAOResponceVO != null) {
                        strMassMemoryTaskType = objDAOResponceVO.getMassMemoryType();
                    }
                    logger.debug((Object)("strMassMemoryTaskType: " + strMassMemoryTaskType));
                    if (!strMassMemoryTaskType.equals("-1")) {
                        entitiesPresent = true;
                        vehiclePresent = true;
                        massMemoryReminderPresent = true;
                        logger.debug((Object)("Mass Memory task type Automatic/Manual: " + strMassMemoryTaskType));
                        if (strMassMemoryTaskType.equals("M")) {
                            manualEntryMassMemoryTask = true;
                        } else if (strMassMemoryTaskType.equals("A")) {
                            manualEntryMassMemoryTask = false;
                        }
                        logger.debug((Object)("objDAOResponceVO.getReminderIDVU():" + objDAOResponceVO.getReminderIDVU()));
                        objDTCOCommandVO.setReminderIDVU(objDAOResponceVO.getReminderIDVU());
                        logger.debug((Object)("Manual Entry True/False for Mass Memory Task: " + manualEntryMassMemoryTask));
                    }
                    if (objDAOResponceVO != null) {
                        strSpecialDataTaskType = objDAOResponceVO.getSpecialDataType();
                    }
                    logger.debug((Object)("strSpecialDataTaskType: " + strSpecialDataTaskType));
                    if (CommType != 8 && !strSpecialDataTaskType.equals("-1") && bSVSpecificDataIndicator) {
                        entitiesPresent = true;
                        vehiclePresent = true;
                        specialDataReminderPresent = true;
                        logger.debug((Object)("Special Data task type Automatic/Manual: " + strMassMemoryTaskType));
                        if (strSpecialDataTaskType.equals("M")) {
                            manualEntrySpecialDataTask = true;
                        } else if (strSpecialDataTaskType.equals("A")) {
                            manualEntrySpecialDataTask = false;
                        }
                        logger.debug((Object)("objDAOResponceVO.getReminderIDSV:" + objDAOResponceVO.getReminderIDSV()));
                        objDTCOCommandVO.setReminderIDSV(objDAOResponceVO.getReminderIDSV());
                        logger.debug((Object)("Manual Entry True/False for Special Data Task: " + manualEntrySpecialDataTask));
                    }
                    if (CommType == 3 && !vehiclePresent) {
                        strNewVehicle = "Y";
                    }
                }
                if (!vehiclePresent && strNewVehicle != null && strNewVehicle.equalsIgnoreCase("Y") && strVrn.trim().length() > 0) {
                    logger.debug((Object)"Checking new vehicle in vehicle details list.");
                    boolean isTaskPresent = this.objVehicleDetailsDao.checkEntryinVehicleDetails(String.valueOf('V') + strVrn, iCompanyID);
                    logger.debug((Object)("isvuFileTaskPresent:" + isTaskPresent));
                    try {
                        if (!isTaskPresent) {
                            objDTCOCommandVO.setNewVehicle(strNewVehicle);
                            logger.debug((Object)"Adding new vehicle in reminder list.");
                            int intDate2 = GeneralAPI.getCurrentDateTimeInt();
                            String vrnMassMemoryTask = "V" + strVrn;
                            logger.debug((Object)("Adding new vehicle in reminder list." + vrnMassMemoryTask));
                            reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnMassMemoryTask, strVin != null ? strVin : "", intDate2, "", 1, CommType, 1, 0, strDTCOVersion, Integer.parseInt(strManufactureCode));
                            logger.debug((Object)("new vehicle reminder ID V type" + reminderID));
                            objDTCOCommandVO.setReminderIDVU(reminderID);
                            entitiesPresent = true;
                            vehiclePresent = true;
                            massMemoryReminderPresent = true;
                        }
                        if (CommType != 8) {
                            boolean isvdoTaskPresent = this.objVehicleDetailsDao.checkEntryinVehicleDetails(String.valueOf('S') + strVrn, iCompanyID);
                            logger.debug((Object)("isvdoTaskPresent:" + isvdoTaskPresent));
                            if (!isvdoTaskPresent && bSVSpecificDataIndicator) {
                                int intDate3 = GeneralAPI.getCurrentDateTimeInt();
                                String vrnSpecialTask = "S" + strVrn;
                                logger.debug((Object)("Adding new vehicle in reminder list." + vrnSpecialTask));
                                reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnSpecialTask, strVin != null ? strVin : "", intDate3, "", 1, CommType, 1, 0, strDTCOVersion, Integer.parseInt(strManufactureCode));
                                specialDataReminderPresent = true;
                                logger.debug((Object)("new vehicle reminder ID S type" + reminderID));
                                objDTCOCommandVO.setReminderIDSV(reminderID);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                logger.debug((Object)("Vehiclepresent :" + vehiclePresent));
                logger.debug((Object)("strVrn :" + strVrn));
                logger.debug((Object)("manulTaskByRS :" + manulTaskByRS));
                if (!vehiclePresent && strVrn != null && strVrn.trim().length() > 0 && manulTaskByRS == 1) {
                    intDate = GeneralAPI.getCurrentDateTimeInt();
                    String vrnMassMemoryTask = "V" + strVrn;
                    logger.debug((Object)("Adding new vehicle in reminder list for WR." + vrnMassMemoryTask));
                    reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnMassMemoryTask, strVin != null ? strVin : "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                    logger.debug((Object)("new vehicle reminder ID V type" + reminderID));
                    objDTCOCommandVO.setReminderIDVU(reminderID);
                    logger.debug((Object)("VU Manual Task initiated by RS..:" + strVrn));
                    if (bSVSpecificDataIndicator) {
                        String vrnSpecialTask = "S" + strVrn;
                        logger.debug((Object)("Adding new vehicle in reminder list for WR." + vrnSpecialTask));
                        reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnSpecialTask, strVin != null ? strVin : "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                        logger.debug((Object)("new vehicle reminder ID S type" + reminderID));
                        objDTCOCommandVO.setReminderIDSV(reminderID);
                        logger.debug((Object)("VDO Manual Task initiated by RS..:" + strVrn));
                        specialDataReminderPresent = true;
                    }
                    entitiesPresent = true;
                    vehiclePresent = true;
                    massMemoryReminderPresent = true;
                }
                if (vehiclePresent && manulTaskByRS == 1 && massMemoryReminderPresent && !specialDataReminderPresent && bSVSpecificDataIndicator) {
                    logger.debug((Object)("VDO Manual Task initiated by RS:" + strVrn));
                    intDate = GeneralAPI.getCurrentDateTimeInt();
                    String vrnSpecialTask = "S" + strVrn;
                    logger.debug((Object)("VDO Manual Task initiated by RS:" + vrnSpecialTask));
                    reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnSpecialTask, strVin != null ? strVin : "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                    logger.debug((Object)("new vehicle reminder ID S type" + reminderID));
                    objDTCOCommandVO.setReminderIDSV(reminderID);
                    entitiesPresent = true;
                    vehiclePresent = true;
                    specialDataReminderPresent = true;
                }
                if (vehiclePresent && manulTaskByRS == 1 && !massMemoryReminderPresent && specialDataReminderPresent) {
                    logger.debug((Object)("VU Manual Task initiated by RS:" + strVrn));
                    intDate = GeneralAPI.getCurrentDateTimeInt();
                    String vrnMassMemoryTask = "V" + strVrn;
                    logger.debug((Object)("VU Manual Task initiated by RS:" + vrnMassMemoryTask));
                    reminderID = this.objReminderListDao.addReminder(iCompanyID, vrnMassMemoryTask, strVin != null ? strVin : "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                    logger.debug((Object)("new vehicle reminder ID V type" + reminderID));
                    objDTCOCommandVO.setReminderIDVU(reminderID);
                    entitiesPresent = true;
                    vehiclePresent = true;
                    massMemoryReminderPresent = true;
                }
                if (strDriverCardNo != null && strDriverCardNo.trim().length() > 0) {
                    if (objDAOResponceVO != null && !objDAOResponceVO.getDriverType().equals("-1")) {
                        entitiesPresent = true;
                        driverPresent = true;
                        objDTCOCommandVO.setReminderIDDriver(objDAOResponceVO.getReminderIDDriver());
                        logger.debug((Object)("Updating existing Driver task.." + objDAOResponceVO.getReminderIDDriver()));
                    } else if (!this.objDriverDetailsDao.checkEntryinDriverDetails(strDriverCardNo, iCompanyID)) {
                        logger.debug((Object)("New Driver:" + strDriverCardNo));
                        intDate = GeneralAPI.getCurrentDateTimeInt();
                        reminderID = this.objReminderListDao.addReminder(iCompanyID, "D" + strDriverCardNo, "", intDate, "", 1, CommType, 1, 0, strDTCOVersion, Integer.parseInt(strManufactureCode));
                        objDTCOCommandVO.setReminderIDDriver(reminderID);
                        entitiesPresent = true;
                        driverPresent = true;
                    } else if (manulTaskByRS == 1) {
                        logger.debug((Object)("Driver Manual Task initiated by RS:" + strDriverCardNo));
                        intDate = GeneralAPI.getCurrentDateTimeInt();
                        reminderID = this.objReminderListDao.addReminder(iCompanyID, "D" + strDriverCardNo, "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                        objDTCOCommandVO.setReminderIDDriver(reminderID);
                        entitiesPresent = true;
                        driverPresent = true;
                    }
                }
                if (strCoDriverCardNo != null && strCoDriverCardNo.trim().length() > 0) {
                    if (objDAOResponceVO != null && !objDAOResponceVO.getCoDriverType().equals("-1")) {
                        entitiesPresent = true;
                        coDriverPresent = true;
                        objDTCOCommandVO.setReminderIDCoDriver(objDAOResponceVO.getReminderIDCoDriver());
                        logger.debug((Object)("Updating existing Co Driver task.." + objDAOResponceVO.getReminderIDCoDriver()));
                    } else if (!this.objDriverDetailsDao.checkEntryinDriverDetails(strCoDriverCardNo, iCompanyID)) {
                        logger.debug((Object)("New CoDriver:" + strCoDriverCardNo));
                        intDate = GeneralAPI.getCurrentDateTimeInt();
                        reminderID = this.objReminderListDao.addReminder(iCompanyID, "D" + strCoDriverCardNo, "", intDate, "", 1, CommType, 1, 0, strDTCOVersion, Integer.parseInt(strManufactureCode));
                        objDTCOCommandVO.setReminderIDCoDriver(reminderID);
                        entitiesPresent = true;
                        coDriverPresent = true;
                    } else if (manulTaskByRS == 1) {
                        logger.debug((Object)("Co Driver Manual Task initiated by RS:" + strCoDriverCardNo));
                        intDate = GeneralAPI.getCurrentDateTimeInt();
                        reminderID = this.objReminderListDao.addReminder(iCompanyID, "D" + strCoDriverCardNo, "", intDate, "", 1, CommType, 2, 1, strDTCOVersion, Integer.parseInt(strManufactureCode));
                        objDTCOCommandVO.setReminderIDCoDriver(reminderID);
                        entitiesPresent = true;
                        coDriverPresent = true;
                    }
                }
                logger.debug((Object)("Entities Present True/False :" + entitiesPresent));
                logger.debug((Object)("Vehicle Present True/False :" + vehiclePresent));
                logger.debug((Object)("Co-Driver Present True/False :" + coDriverPresent));
                logger.debug((Object)("Driver Present True/False :" + driverPresent));
                logger.debug((Object)("Entity Exist In CMPR:" + entityExistInCMPR));
                if (entityExistInCMPR && CommType == 3) {
                    logger.debug((Object)("Check Vrn For ATNPCommand:" + checkVrnForATNPCommand));
                    logger.debug((Object)("Check Driver For ATNPCommand:" + checkDriverForATNPCommand));
                    logger.debug((Object)("Check CoDriver For ATNPCommand:" + checkCoDriverForATNPCommand));
                    boolean sendCommandATNPToRemoteService = false;
                    CommandATNPData objCommandATNPData = new CommandATNPData();
                    if (checkVrnForATNPCommand && !vehiclePresent) {
                        objCommandATNPData.setVehicleRegistrationNumber(strVrn);
                        sendCommandATNPToRemoteService = true;
                        logger.debug((Object)"Vehicle Added in ATNP.");
                    }
                    if (checkDriverForATNPCommand && !driverPresent) {
                        objCommandATNPData.setDriverCardNumber(strDriverCardNo);
                        sendCommandATNPToRemoteService = true;
                        logger.debug((Object)"Driver Added in ATNP.");
                    }
                    if (checkCoDriverForATNPCommand && !coDriverPresent) {
                        objCommandATNPData.setCoDriverCardNumber(strCoDriverCardNo);
                        sendCommandATNPToRemoteService = true;
                        logger.debug((Object)"CoDriver Added in ATNP.");
                    }
                    if (sendCommandATNPToRemoteService) {
                        objCommandATNPData.setSerialId(objResponseData.getSerialId());
                        logger.debug((Object)"Serial ID Added in ATNP.");
                        InvokeRemoteDevice device = InvokeRemoteDevice.getInstance();
                        device.sendATNPToWideRange(objDTCOCommandVO.getRemoteServiceID(), objCommandATNPData);
                    } else {
                        logger.debug((Object)"All Authentication Task exists in RTM.");
                    }
                }
                if (!(entitiesPresent || CommType != 2 && CommType != 8 && CommType != 10)) {
                    UIFileHandler.getInstance().sendNOATToCOMM(objResponseData.getSerialId(), CommType, iRemoteServiceID);
                    objDTCOCommandVO.setEntityId(null);
                    return objDTCOCommandVO;
                }
                if (entitiesPresent) {
                    String strEntityId = "";
                    if (massMemoryReminderPresent) {
                        strEntityId = "V" + strVrn.trim();
                        logger.debug((Object)("EntityId in MassMemoryReminderPresent:" + strEntityId));
                    }
                    if (specialDataReminderPresent && bSVSpecificDataIndicator) {
                        strEntityId = strEntityId.length() > 0 ? String.valueOf(strEntityId) + "#" + "S" + strVrn.trim() : "S" + strVrn.trim();
                        logger.debug((Object)("EntityId in specialDataReminderPresent:" + strEntityId));
                    }
                    if (driverPresent) {
                        strEntityId = strEntityId.length() > 0 ? String.valueOf(strEntityId) + "#" + "D" + strDriverCardNo.trim() : "D" + strDriverCardNo.trim();
                        logger.debug((Object)("EntityId in driverPresent;" + strEntityId));
                    }
                    if (coDriverPresent) {
                        strEntityId = strEntityId.length() > 0 ? String.valueOf(strEntityId) + "#" + "D" + strCoDriverCardNo.trim() : "D" + strCoDriverCardNo.trim();
                        logger.debug((Object)("EntityId in codriverPresent;" + strEntityId));
                    }
                    logger.debug((Object)("checkAuthenticationState;" + strEntityId));
                    logger.debug((Object)("strManufactureCode;" + strManufactureCode));
                    strEntityId = this.objReminderListDao.checkAuthenticationState(strEntityId, iCompanyID, strDTCOVersion, strManufactureCode);
                    if (strEntityId.trim().length() == 0) {
                        throw new Exception("Entity already in list and authentication of this entity is already Started");
                    }
                    String[] entityId = strEntityId.split("#", -1);
                    int j = 0;
                    while (j < entityId.length) {
                        if (entityId[j].charAt(0) == 'D') {
                            if (strDriverCardNo != null && strDriverCardNo.trim().length() > 0 && entityId[j].equalsIgnoreCase("D" + strDriverCardNo.trim())) {
                                logger.debug((Object)"Setting driver indicator true.");
                                driverIndicator = true;
                            } else if (strCoDriverCardNo != null && strCoDriverCardNo.trim().length() > 0 && entityId[j].equalsIgnoreCase("D" + strCoDriverCardNo.trim())) {
                                logger.debug((Object)"Setting co driver indicator true.");
                                codriverIndicator = true;
                            }
                        }
                        ++j;
                    }
                    Date reminderDate = new Date((long)GeneralAPI.getCurrentDateTimeInt() * 1000L);
                    logger.debug((Object)("ReminderDate" + reminderDate));
                    objDTCOCommandVO.setReminderDate(reminderDate);
                    if (is2ndGenStoneridge) {
                        objDTCOCommandVO.setStrDTCOVersion(Integer.toHexString(16384));
                    } else {
                        objDTCOCommandVO.setStrDTCOVersion(strDTCOVersion);
                    }
                    objDTCOCommandVO.setStrManufactureCode(strManufactureCode);
                    logger.debug((Object)("EntityId after checking Authentication State:" + strEntityId));
                    String[] arrEntityId = strEntityId.split("#", -1);
                    massMemoryReminderPresent = false;
                    specialDataReminderPresent = false;
                    vehiclePresent = false;
                    driverPresent = false;
                    coDriverPresent = false;
                    int j2 = 0;
                    while (j2 < arrEntityId.length) {
                        if (arrEntityId[j2].equalsIgnoreCase("V" + strVrn)) {
                            massMemoryReminderPresent = true;
                            vehiclePresent = true;
                        } else if (arrEntityId[j2].equalsIgnoreCase("S" + strVrn)) {
                            specialDataReminderPresent = true;
                            vehiclePresent = true;
                        } else if (arrEntityId[j2].equalsIgnoreCase("D" + strDriverCardNo)) {
                            driverPresent = true;
                        } else if (arrEntityId[j2].equalsIgnoreCase("D" + strCoDriverCardNo)) {
                            coDriverPresent = true;
                        }
                        ++j2;
                    }
                    logger.debug((Object)("After checking Authentication State Co-Driver Present True/False :" + coDriverPresent));
                    logger.debug((Object)("After checking Authentication State Driver Present True/False :" + driverPresent));
                    logger.debug((Object)("After checking Authentication State Vehicle Present True/False :" + vehiclePresent));
                    logger.debug((Object)("After checking Authentication State MassMemoryReminderPresent True/False :" + massMemoryReminderPresent));
                    logger.debug((Object)("After checking Authentication State specialDataReminderPresentt True/False :" + specialDataReminderPresent));
                    ArrayList<byte[]> requestList = new ArrayList<byte[]>();
                    if (vehiclePresent) {
                        List<Object> requestListMassMemory = new ArrayList();
                        List<Object> requestListSpecialData = new ArrayList();
                        objDTCOCommandVO.setVehicleRegistrationNumber(GeneralAPI.convertStringToByte("V" + strVrn.trim()));
                        logger.debug((Object)("MassMemoryReminderPresent:" + massMemoryReminderPresent));
                        logger.debug((Object)("specialDataReminderPresent:" + specialDataReminderPresent));
                        logger.debug((Object)("manualEntryMassMemoryTask:" + manualEntryMassMemoryTask));
                        logger.debug((Object)("manualEntrySpecialDataTask:" + manualEntrySpecialDataTask));
                        byte[] data = null;
                        if (isDTCO2ndGenProcessingRequired) {
                            data = DTCOCommandHelper.getBytes((byte)33);
                            logger.warn((Object)("Adding Overview for DTCO second generation, strDTCOVersion:" + objDTCOCommandVO.getStrDTCOVersion() + ", CommType:" + CommType));
                        } else {
                            data = DTCOCommandHelper.getBytes((byte)1);
                            logger.warn((Object)("Adding Overview for DTCO old generation, strDTCOVersion:" + objDTCOCommandVO.getStrDTCOVersion() + ", CommType:" + CommType));
                        }
                        requestList.add(data);
                        if (massMemoryReminderPresent) {
                            if (!isDTCO2ndGenProcessingRequired || CommType != 3 && CommType != 1) {
                                objDTCOCommandVO.setVehicleRegistrationNumber(GeneralAPI.convertStringToByte("V" + strVrn.trim()));
                                if (manualEntryMassMemoryTask) {
                                    logger.debug((Object)"Request list(TIS-Web/ThirdParty) for manual mass memory entry is being prepared.");
                                    logger.debug((Object)("COMM-TYPE: " + CommType));
                                    objDTCOCommandVO = isDTCO2ndGenProcessingRequired ? this.objReminderListDao.requestListManualEntry_1b5(objDTCOCommandVO, CommType) : this.objReminderListDao.requestListManualEntry(objDTCOCommandVO, CommType);
                                    requestListMassMemory = objDTCOCommandVO.getArReminderList();
                                } else {
                                    logger.debug((Object)"Request list(TIS-Web/ThirdParty) for automatic mass memory entry is being prepared.");
                                    logger.debug((Object)("COMM-TYPE: " + CommType));
                                    objDTCOCommandVO = isDTCO2ndGenProcessingRequired ? this.objReminderListDao.requestListAutomaticEntry_1b5(objDTCOCommandVO, CommType) : this.objReminderListDao.requestListAutomaticEntry(objDTCOCommandVO, CommType);
                                    requestListMassMemory = objDTCOCommandVO.getArReminderList();
                                }
                            } else {
                                logger.warn((Object)("Could not start because DTCO version is 4.0 or above and CommType:" + CommType + " for reminderID:" + objDTCOCommandVO.getReminderIDVU()));
                                this.objReminderListDao.updateReminderForDTCO(reminderID);
                            }
                        }
                        if (requestListMassMemory != null && requestListMassMemory.size() > 0) {
                            logger.debug((Object)("Size of Mass Memory List:" + requestListMassMemory.size()));
                            requestList.addAll(requestListMassMemory);
                            logger.debug((Object)"Mass memory blocks added in request list.");
                        }
                        if (specialDataReminderPresent) {
                            objDTCOCommandVO.setVehicleRegistrationNumber(GeneralAPI.convertStringToByte("S" + strVrn.trim()));
                            if (manualEntrySpecialDataTask) {
                                logger.debug((Object)"Request list(TIS-Web/ThirdParty) for manual special data entry is being prepared.");
                                logger.debug((Object)("COMM-TYPE: " + CommType));
                                objDTCOCommandVO = this.objReminderListDao.requestListManualEntry(objDTCOCommandVO, CommType);
                                requestListSpecialData = objDTCOCommandVO.getArReminderList();
                            } else {
                                logger.debug((Object)"Request list(TIS-Web/ThirdParty) for automatic special data entry is being prepared.");
                                logger.debug((Object)("COMM-TYPE: " + CommType));
                                objDTCOCommandVO = this.objReminderListDao.requestListAutomaticEntry(objDTCOCommandVO, CommType);
                                requestListSpecialData = objDTCOCommandVO.getArReminderList();
                            }
                        }
                        if (requestListSpecialData != null && requestListSpecialData.size() > 0) {
                            logger.debug((Object)("Size of Special data List:" + requestListSpecialData.size()));
                            requestList.addAll(requestListSpecialData);
                            logger.debug((Object)"Special data blocks added in request list:");
                        }
                        objDTCOCommandVO.setVehicleRegistrationNumber(GeneralAPI.convertStringToByte("V" + strVrn.trim()));
                        boolean cardDownloadPresent = false;
                        int q = 0;
                        while (q < requestList.size()) {
                            byte[] dataFromRequestList = requestList.get(q);
                            if (dataFromRequestList[0] == 6) {
                                cardDownloadPresent = true;
                                objDTCOCommandVO.setCardDownloadIndicator(true);
                                break;
                            }
                            ++q;
                        }
                        if (CommType == 1) {
                            int index = -1;
                            int q2 = 0;
                            while (q2 < requestList.size()) {
                                byte[] dataFromRequestList = requestList.get(q2);
                                if (dataFromRequestList[0] == 26) {
                                    index = q2;
                                    break;
                                }
                                ++q2;
                            }
                            if (index != -1) {
                                requestList.remove(index);
                            }
                        }
                        if (!cardDownloadPresent) {
                            if (driverPresent && coDriverPresent) {
                                requestList.add(this.getDriverCoDriverData());
                            } else if (driverPresent) {
                                requestList.add(this.getDriverData());
                            } else if (coDriverPresent) {
                                requestList.add(this.getCoDriverData());
                            }
                        }
                    } else if (driverPresent && coDriverPresent) {
                        logger.debug((Object)"Request list(TIS-Web/ThirdParty) for Driver and CoDriver Entry is being prepared:");
                        requestList.add(this.getDriverCoDriverData());
                    } else if (driverPresent) {
                        logger.debug((Object)"Request list(TIS-Web/ThirdParty) for Driver Entry is being prepared:");
                        requestList.add(this.getDriverData());
                    } else if (coDriverPresent) {
                        logger.debug((Object)"Request list(TIS-Web/ThirdParty) for CoDriver Entry is being prepared:");
                        requestList.add(this.getCoDriverData());
                    }
                    objDTCOCommandVO.setRequestList(requestList);
                    int i = 0;
                    while (i < requestList.size()) {
                        byte[] temp;
                        byte[] byArray = temp = requestList.get(i);
                        int n = temp.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            logger.warn((Object)("requestList[" + i + "]::" + String.format("%02x", b)));
                            ++n2;
                        }
                        ++i;
                    }
                    int lastDownloadDate = 0;
                    if (massMemoryReminderPresent) {
                        lastDownloadDate = this.objVehicleDetailsDao.findLastDownloadDate("V" + strVrn.trim(), iCompanyID, Integer.parseInt(ConfigUtil.getValue("DATADOWNLOADDAYS")));
                        logger.debug((Object)("Last download date: " + lastDownloadDate));
                        objDTCOCommandVO.setDownloadDate(lastDownloadDate);
                    }
                    int lastDownloadDateForSpecial = 0;
                    if (specialDataReminderPresent) {
                        lastDownloadDateForSpecial = this.objVehicleDetailsDao.findLastDownloadDate("S" + strVrn.trim(), iCompanyID, Integer.parseInt(ConfigUtil.getValue("DATADOWNLOADDAYS")));
                        logger.debug((Object)("Last download date for special: " + lastDownloadDateForSpecial));
                        objDTCOCommandVO.setDownloadDateForSpecial(lastDownloadDateForSpecial);
                    }
                    logger.debug((Object)("strEntityId == " + strEntityId));
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(strEntityId));
                    objDTCOCommandVO.setArchiveMode(iArchiveMode);
                    objDTCOCommandVO.setRemoteDeviceSerialNumber(objResponseData.getSerialId());
                    objDTCOCommandVO.setDldType(CommType);
                    objDTCOCommandVO.setDriverIndicator(driverIndicator);
                    objDTCOCommandVO.setCodriverIndicator(codriverIndicator);
                    objDTCOCommandVO.setRetryCount(this.objReminderListDao.updateRetryCount(objDTCOCommandVO));
                    if (CommType == 8 && objDTCOCommandVO.getReminderIDSV() == 0 && objDTCOCommandVO.getReminderIDVU() == 0 && objDTCOCommandVO.getReminderIDCoDriver() == 0 && objDAOResponceVO.getReminderIDDriver() > 0) {
                        objDTCOCommandVO.setCreateLocalDownloadStateFlag(true);
                    }
                    break block120;
                }
                objDTCOCommandVO.setEntityId(null);
                return objDTCOCommandVO;
            }
            catch (Exception ex) {
                logger.error((Object)"Exception in getDTCOCommandVO method of class DTCOCommandHelper :", (Throwable)ex);
                String strEntityDetails = UIFileHandler.getInstance().intimateToSRCommAtServiceStart(null);
                logger.info((Object)("CommType = " + CommType + " remoteServiceId = " + iRemoteServiceID));
                if (CommType == 8 || CommType == 10 && iRemoteServiceID == -2) {
                    UIFileHandler.getInstance().sendNOATToCOMM(objResponseData.getSerialId(), CommType, iRemoteServiceID);
                } else {
                    CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityDetails, -1, null);
                    Thread authExecutor = new Thread(intimationTask);
                    ExecutorService es = ThreadPool.getThreadPool();
                    es.execute(authExecutor);
                }
                throw ex;
            }
        }
        return objDTCOCommandVO;
    }

    private static byte[] getBytes(byte hexcode) {
        ByteArrayOutputStream bs1 = new ByteArrayOutputStream();
        bs1.write(hexcode);
        try {
            bs1.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception in get bytes method of DTCOCommandHelper:", (Throwable)e);
        }
        byte[] remMessage1 = bs1.toByteArray();
        return remMessage1;
    }

    private byte[] getDriverCoDriverData() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(3);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.debug((Object)"Exception in getDriverCoDriverData method of DTCOCommandHelper", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private byte[] getDriverData() {
        logger.debug((Object)"Adding Driver Data");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(1);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception while flushing ByteArrayOutputStream in getDriverData method of DTCOCommandHelper class", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }

    private byte[] getCoDriverData() {
        logger.debug((Object)"Adding Co-Driver Data");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        bs.write(6);
        bs.write(2);
        try {
            bs.flush();
        }
        catch (IOException e) {
            logger.error((Object)"Exception while flushing ByteArrayOutputStream in getCoDriverData method of DTCOCommandHelper class", (Throwable)e);
        }
        byte[] remMessage2 = bs.toByteArray();
        return remMessage2;
    }
}

