/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.PingThreadForRDSServer;
import com.sisl.dtco.Utility.ReadRegistry;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.GeneralDao;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.dao.WebServiceXMLDetailsDao;
import com.sisl.dtco.exceptions.AuthenticationModuleException;
import com.sisl.dtco.integration.AccountManagement;
import com.sisl.dtco.integration.CMPRThread;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.vo.CommandATNPData;
import com.sisl.dtco.vo.CommandCCADData;
import com.sisl.dtco.vo.CommandCCNPData;
import com.sisl.dtco.vo.CommandCMRGData;
import com.sisl.dtco.vo.CommandCMRRData;
import com.sisl.dtco.vo.CommandDTADData;
import com.sisl.dtco.vo.CommandLAUTData;
import com.sisl.dtco.vo.CommandLocalAuthenticationsData;
import com.sisl.dtco.vo.CommandRDAGData;
import com.sisl.dtco.vo.CommandRequestVO;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import com.sisl.dtco.vo.DueDownloadVO;
import com.sisl.dtco.vo.EntityVO;
import com.sisl.dtco.vo.SV;
import com.sisl.dtco.vo.VU;
import com.sisl.dtco.vo.XMLObject;
import com.sun.net.ssl.internal.ssl.Provider;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.DueDownloadVORTM;
import org.tempuri.FileTransferStatusVO;
import org.tempuri.RemoteServiceVO;
import org.tempuri.ServiceVO;
import org.tempuri.SiteVO;
import org.tempuri.UserSiteMappingVO;

public class InvokeRemoteDevice {
    private static final Logger logger = Logger.getLogger(InvokeRemoteDevice.class);
    static Object lockObject = new Object();
    static InvokeRemoteDevice instance;
    static String CSVSXml;
    static Socket connect;
    Timer timer = null;
    static boolean isConnectedToRDS;
    static List<String> cmprList;

    static {
        isConnectedToRDS = false;
        cmprList = new CopyOnWriteArrayList<String>();
    }

    private InvokeRemoteDevice() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvokeRemoteDevice getInstance() {
        if (instance == null) {
            Object object = lockObject;
            synchronized (object) {
                if (instance == null) {
                    instance = new InvokeRemoteDevice();
                }
            }
        }
        return instance;
    }

    public void getAllSitesListForTISOffice() {
        logger.debug((Object)"Getting All Sites List For TisOffice:");
        String strTISOfficeLocation = "";
        try {
            AccountManagement am = new AccountManagement();
            am.readAccountsXML();
            DueDownloadVORTM objDueDownloadVORTM = null;
            if (AccountManagement.objAccDetailsVO == null) {
                return;
            }
            AccountsDetailsXMLChild[] objAccountsVO = AccountManagement.objAccDetailsVO.getAccounts();
            File fileXml = null;
            if (objAccountsVO != null) {
                int i = 0;
                while (i < objAccountsVO.length) {
                    if (objAccountsVO[i].getArchiveMode() == 2) {
                        strTISOfficeLocation = objAccountsVO[i].getSTISOfficeServer();
                        String hostName = InetAddress.getLocalHost().getHostName();
                        logger.debug((Object)("Machine Name:" + hostName));
                        String hostIP = InetAddress.getLocalHost().getHostAddress();
                        logger.debug((Object)("Machine IP:" + hostIP));
                        if (strTISOfficeLocation.equalsIgnoreCase("\\\\" + hostName) || strTISOfficeLocation.equalsIgnoreCase("\\\\" + hostIP)) {
                            String strCommand = "";
                            String officeLocation = "";
                            strCommand = "reg query \"HKLM\\Software\\VDO\\TisOffice\\Common\" /v TisOfficeService_HOME";
                            officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                            if (officeLocation == null || officeLocation.equals("")) {
                                strCommand = "reg query \"HKLM\\Software\\Siemens VDO Trading\\TisOffice\\Common\" /v TisOfficeService_HOME";
                                officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                            }
                            if (officeLocation != null && officeLocation != "") {
                                strTISOfficeLocation = officeLocation;
                            }
                        }
                        String strXmlFile = String.valueOf(strTISOfficeLocation) + "//DLListLocation//SiteXML.xml";
                        logger.debug((Object)("Location of xml file:" + strXmlFile));
                        fileXml = new File(strXmlFile);
                        logger.debug((Object)("File canExecute:" + fileXml.canExecute()));
                        logger.debug((Object)("File canRead():" + fileXml.canRead()));
                        logger.debug((Object)("File canWrite():" + fileXml.canWrite()));
                        String xmlFileContents = "";
                        if (fileXml.exists()) {
                            objDueDownloadVORTM = new DueDownloadVORTM();
                            xmlFileContents = GeneralAPI.getFileContentsUTF8(strXmlFile);
                            XStream objXStream = new XStream();
                            Object objEntity = null;
                            objXStream.alias("SiteDetails", DueDownloadVORTM.class);
                            objXStream.alias("SitesVO", SiteVO.class);
                            objXStream.alias("UserSites", UserSiteMappingVO.class);
                            objEntity = objXStream.fromXML(xmlFileContents);
                            objDueDownloadVORTM = (DueDownloadVORTM)objEntity;
                        } else if (!fileXml.exists()) {
                            logger.debug((Object)" Site Xml not found at Tis-Office location.");
                        }
                    }
                    if (objAccountsVO[i].getArchiveMode() == 1 || objAccountsVO[i].getArchiveMode() == 2) {
                        WebServiceXMLDetailsDao webServiceDao = WebServiceXMLDetailsDao.getInstance();
                        webServiceDao.refreshSiteData(objDueDownloadVORTM, objAccountsVO[i].getArchiveMode(), objAccountsVO[i].getAccountId());
                    }
                    ++i;
                }
            }
        }
        catch (AuthenticationModuleException e) {
            logger.error((Object)"AuthenticationModuleException in getAllDtcoListForThirdParty in InvokeRemoteDevice:");
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getAllDtcoListForThirdParty in InvokeRemoteDevice: " + e));
        }
    }

    public DueDownloadVO getAllDTCOListForTisOffice(String strTISOfficeLocation, int reminderList, AccountVO objCompanyVO) throws Exception {
        String strCompanyname = objCompanyVO.getSTISOfficeCompany();
        logger.debug((Object)"Getting All DTCO List For TisOffice:");
        DueDownloadVO objDueDownloadVO = null;
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            logger.debug((Object)("Machine Name:" + hostName));
            String hostIP = InetAddress.getLocalHost().getHostAddress();
            logger.debug((Object)("Machine IP:" + hostIP));
            if (strTISOfficeLocation.equalsIgnoreCase("\\\\" + hostName) || strTISOfficeLocation.equalsIgnoreCase("\\\\" + hostIP)) {
                String strCommand = "";
                String officeLocation = "";
                strCommand = "reg query \"HKLM\\Software\\VDO\\TisOffice\\Common\" /v TisOfficeService_HOME";
                officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                if (officeLocation == null || officeLocation.equals("")) {
                    strCommand = "reg query \"HKLM\\Software\\Siemens VDO Trading\\TisOffice\\Common\" /v TisOfficeService_HOME";
                    officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                }
                if (officeLocation != null && officeLocation != "") {
                    strTISOfficeLocation = officeLocation;
                }
            }
            String pathDLListLocation = String.valueOf(strTISOfficeLocation) + "\\DLListLocation";
            File dirDLListLocation = new File(pathDLListLocation);
            if (reminderList == 1 && !dirDLListLocation.exists()) {
                throw new AuthenticationModuleException("Could not refresh reminder list as TIS-Office location is not accessible.:25");
            }
            String strXmlFile = String.valueOf(strTISOfficeLocation) + "//DLListLocation//PersistEntityXMLFileNew.xml";
            logger.debug((Object)("Location of xml file:" + strXmlFile));
            File fileXml = new File(strXmlFile);
            logger.debug((Object)("File canExecute:" + fileXml.canExecute()));
            logger.debug((Object)("File canRead():" + fileXml.canRead()));
            logger.debug((Object)("File canWrite():" + fileXml.canWrite()));
            logger.debug((Object)("fileXml exists :" + fileXml.exists()));
            logger.debug((Object)("reminder list :" + reminderList));
            String strXmlRequestList = String.valueOf(strTISOfficeLocation) + "//DLListLocation//DataBlocksXMLFile.xml";
            logger.debug((Object)("Location of xml file:" + strXmlRequestList));
            File fileXmlRequestList = new File(strXmlRequestList);
            logger.debug((Object)("File canExecute:" + fileXmlRequestList.canExecute()));
            logger.debug((Object)("File canRead():" + fileXmlRequestList.canRead()));
            logger.debug((Object)("fileXmlRequestList exists :" + fileXmlRequestList.exists()));
            if (fileXmlRequestList.exists()) {
                logger.debug((Object)"in exists part of fileXmlRequestList");
                String strRequestDataBlocks = GeneralAPI.getFileContents(strXmlRequestList);
                strRequestDataBlocks = strRequestDataBlocks.replace("<entities>", "");
                strRequestDataBlocks = strRequestDataBlocks.replace("</entities>", "");
                DueDownloadVO objDueDownloadVOs = new DueDownloadVO();
                if (!strRequestDataBlocks.equals("")) {
                    logger.debug((Object)"in not strRequestDataBlocks equals to blank");
                    CompanyDao objCompanyDao = CompanyDao.getInstance();
                    XStream objXStream = new XStream();
                    Object objReqList = null;
                    objXStream.alias("DueDownloadVO", DueDownloadVO.class);
                    objXStream.alias("VU", VU.class);
                    objXStream.alias("SV", SV.class);
                    objReqList = objXStream.fromXML(strRequestDataBlocks);
                    objDueDownloadVOs = (DueDownloadVO)objReqList;
                    logger.debug((Object)("before passing into method due download vo: " + objDueDownloadVOs));
                    objCompanyDao.saveTISOfficeRequestList(objDueDownloadVOs, objCompanyVO.getAccountId());
                }
            }
            if (reminderList == 1 && !fileXml.exists()) {
                throw new AuthenticationModuleException("Entity list is not found at TIS-Office location. Please generate Download list via TIS-Office toolbox.:26");
            }
            if (reminderList == 1 && fileXml.exists() || reminderList == 0 && fileXml.exists()) {
                logger.debug((Object)"Fetching entity xml from Tis-Office location.");
                String strEntityDetailsFetched = GeneralAPI.getFileContents(strXmlFile);
                String strFileName = String.valueOf(ConfigUtil.getValue("PersistEntityXMLFile")) + ".xml";
                FileOutputStream fout = new FileOutputStream(strFileName, false);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF8");
                out.write(strEntityDetailsFetched);
                ((Writer)out).close();
                fout.close();
                strEntityDetailsFetched = GeneralAPI.getFileContentsUTF8(strFileName);
                File file = new File(strFileName);
                file.delete();
                logger.debug((Object)("strEntityDetailsFetched: " + strEntityDetailsFetched + "\n"));
                XStream objXStream = new XStream();
                Object objEntity = null;
                objXStream.alias("DueDownloadVO", DueDownloadVO.class);
                objXStream.alias("EntityVO", EntityVO.class);
                objEntity = objXStream.fromXML(strEntityDetailsFetched);
                objDueDownloadVO = (DueDownloadVO)objEntity;
                EntityVO[] objEntityVO = objDueDownloadVO.getEntities();
                logger.debug((Object)("objEntityVO =" + objEntityVO));
                ArrayList<EntityVO> listEntityVO = new ArrayList<EntityVO>();
                logger.debug((Object)("objEntityVO length: " + objEntityVO.length));
                int i = 0;
                while (i < objEntityVO.length) {
                    logger.debug((Object)("company name in loop:" + objEntityVO[i].getCompanyName() + "\n"));
                    if (objEntityVO[i].getCompanyName().equalsIgnoreCase(strCompanyname)) {
                        listEntityVO.add(objEntityVO[i]);
                    }
                    ++i;
                }
                logger.debug((Object)("listEntityVO: " + listEntityVO));
                ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                XMLObject objXmlObject = new XMLObject();
                objXmlObject.setAlias("DueDownloadVO");
                objXmlObject.setClassName(DueDownloadVO.class);
                objArr.add(objXmlObject);
                objXmlObject = new XMLObject();
                objXmlObject.setAlias("EntityVO");
                objXmlObject.setClassName(EntityVO.class);
                objArr.add(objXmlObject);
                objDueDownloadVO.setEntities(listEntityVO.toArray(new EntityVO[0]));
            } else if (reminderList == 0 && !fileXml.exists()) {
                logger.debug((Object)"Xml not found at Tis-Office location.");
            }
        }
        catch (AuthenticationModuleException e) {
            logger.error((Object)"AuthenticationModuleException in getAllDtcoListForThirdParty in InvokeRemoteDevice:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("Exception in getAllDtcoListForThirdParty in InvokeRemoteDevice: " + e));
            throw new AuthenticationModuleException("Could not refresh reminder list as exception occurred at RTM-Authentication service.:23");
        }
        return objDueDownloadVO;
    }

    public void clientRegistrationWR(DTCOCommandVO objCommandVO) throws Exception {
        CommandRequestVO objCommandRequestVO = new CommandRequestVO();
        ArrayList<String> arrEntityId = new ArrayList<String>();
        RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
        RemoteServiceVO objRemoteServiceVO = objCommandVO.getRemoteServiceVo();
        String strUser = objRemoteServiceVO.getUserNameRS();
        String pwdFromDataBase = objRemoteServiceVO.getPasswordRS();
        String strPass = GeneralAPI.jumbleString(pwdFromDataBase);
        String strAccountName = objRemoteServiceVO.getAccountNameRS();
        String[] strEntityId = GeneralAPI.byteToString(objCommandVO.getEntityId()).split("#");
        arrEntityId.add(strEntityId[0]);
        objCommandRequestVO.setVersion("1.0");
        objCommandRequestVO.setCmdName("CMRG");
        CommandCMRGData objCMRGData = new CommandCMRGData();
        objCMRGData.setUserName(strUser);
        objCMRGData.setPassword(strPass);
        objCMRGData.setAccountName(strAccountName);
        objCMRGData.setEntityId(arrEntityId);
        objCMRGData.setCommMode(0);
        objCMRGData.setType(0);
        objCommandRequestVO.setCommandCMRGData(objCMRGData);
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("CommandRequestVO");
        objXmlObject.setClassName(CommandRequestVO.class);
        objArr.add(objXmlObject);
        String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
        CommandResponseVO objCommandResponseVO = this.sendReceiveRequestToCOMM(strXmlString, null, objCommandVO.getRemoteServiceID(), objRemoteServiceVO);
        if (objCommandResponseVO.getCmdName().equals("RESP")) {
            logger.error((Object)"Exception in clientRegistrationWR in InvokeRemoteDevice ::Exception in CMRG: Session ID Received is -1");
            throw new Exception("Sessionid Received From COMM in CMRG is -1");
        }
        CommandCMRRData objCommandCMRRData = objCommandResponseVO.getCommandCMRRData();
        String strSessionId = objCommandCMRRData.getSessionId();
        objCommandVO.setSessionId(strSessionId);
    }

    public void sendAuthenticationDataToWRCOMM(DTCOCommandVO objCommandVO, byte[] authData) throws Exception {
        CommandRequestVO objCommandRequestVO = new CommandRequestVO();
        ArrayList<String> arrEntityId = new ArrayList<String>();
        String[] strEntityId = GeneralAPI.byteToString(objCommandVO.getEntityId()).split("#");
        arrEntityId.add(strEntityId[0]);
        objCommandRequestVO.setVersion("1.0");
        objCommandRequestVO.setCmdName("CCAD");
        CommandCCADData objCommandCCADData = new CommandCCADData();
        objCommandCCADData.setEntityId(arrEntityId);
        objCommandCCADData.setCommMode(0);
        objCommandCCADData.setType(0);
        objCommandCCADData.setAuthData(authData);
        objCommandRequestVO.setCommandCCADData(objCommandCCADData);
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("CommandRequestVO");
        objXmlObject.setClassName(CommandRequestVO.class);
        objArr.add(objXmlObject);
        String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
        RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
        RemoteServiceVO objRemoteServiceVO = objCommandVO.getRemoteServiceVo();
        CommandResponseVO objCommandResponseVO = this.sendReceiveRequestToCOMM(strXmlString, objCommandVO.getSessionId(), objCommandVO.getRemoteServiceID(), objRemoteServiceVO);
        if (objCommandResponseVO.getStatus() != 0) {
            logger.error((Object)"Exception in sendAuthenticationDataToWRCOMM in InvokeRemoteDevice ::Exception in CCAD: Status Received is not 0");
            throw new Exception("Error Status Received from COMM in CCAD is:" + objCommandResponseVO.getStatus());
        }
    }

    public CommandResponseVO sendReceiveRequestToCOMM(String strXmlRequest1, String jsessionid, int iRemoteServiceID, RemoteServiceVO objRemoteServiceVO) throws Exception {
        String strXmlRequest;
        logger.debug((Object)("Wide Range Remote Service:" + iRemoteServiceID));
        Security.addProvider((java.security.Provider)new Provider());
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        String url = "";
        url = String.valueOf(objRemoteServiceVO.getUrlRS()) + "/" + ConfigUtil.getValue("VirtualDirectoryRSIF01");
        logger.debug((Object)("url:" + url));
        logger.debug((Object)("proxyRequired:" + objRemoteServiceVO.isProxyRequired()));
        String strEncrypted = strXmlRequest1;
        if (strXmlRequest1.contains("<password>")) {
            int initial = strEncrypted.indexOf("<password>");
            int last = strEncrypted.indexOf("</password>");
            String subValue = strEncrypted.substring(initial + 10, last);
            String strEncryptedPassword = GeneralAPI.jumbleString(subValue);
            String strReplacePassword = strEncrypted.replace(subValue, strEncryptedPassword);
            String string = GeneralAPI.addXmlHeader(strReplacePassword);
        }
        if ((strXmlRequest = GeneralAPI.addXmlHeader(strXmlRequest1)).indexOf("<cmdName>CCAD</cmdName>") != -1) {
            logger.info((Object)("XmlRequest Sent to Remote Service : " + strXmlRequest));
        } else {
            logger.info((Object)("XmlRequest Sent to Remote Service : " + strXmlRequest.substring(strXmlRequest.indexOf("</password>"))));
        }
        String responseAddress = null;
        responseAddress = jsessionid == null ? url : String.valueOf(url) + "?jsessionid=" + jsessionid;
        logger.debug((Object)("RESPONSE ADDRESS:" + responseAddress));
        PostMethod post = new PostMethod(responseAddress);
        post.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
        StringRequestEntity entity = new StringRequestEntity(strXmlRequest, "text/xml", "UTF-8");
        post.setRequestEntity((RequestEntity)entity);
        try {
            post.setFollowRedirects(true);
        }
        catch (Exception e) {
            logger.error((Object)("Exception in sendReceiveRequestToCOMM(String):" + e));
        }
        CommandResponseVO objCommandResponseVO = null;
        try {
            try {
                HttpClient client = new HttpClient();
                if (Application.proxyServerUsedReg) {
                    String proxyHost = Application.proxyHostReg;
                    int proxyPort = 0;
                    if (Application.proxyPortReg.length() > 0) {
                        proxyPort = Integer.parseInt(Application.proxyPortReg);
                    }
                    String proxyUser = Application.proxyUserReg;
                    String proxyPassword = Application.proxyPasswordReg;
                    client.getHostConfiguration().setProxy(proxyHost, proxyPort);
                    if (proxyUser != null && proxyUser.trim().length() > 0 && proxyPassword != null && proxyPassword.trim().length() > 0) {
                        client.getState().setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                        client.getState().setAuthenticationPreemptive(true);
                    }
                }
                HttpConnectionManager connectionManager = client.getHttpConnectionManager();
                HttpConnectionManagerParams connectionParam = new HttpConnectionManagerParams();
                connectionParam.setSoTimeout(Integer.parseInt(ConfigUtil.getValue("COMMTimeoutPeriod")) * 1000);
                connectionManager.setParams(connectionParam);
                int returnCode = -1;
                returnCode = client.executeMethod((HttpMethod)post);
                InputStream is = post.getResponseBodyAsStream();
                logger.debug((Object)("Return Code = " + returnCode + " for RS ID= " + iRemoteServiceID));
                StringBuffer sb = new StringBuffer();
                BufferedReader bin = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String lineRead = null;
                while ((lineRead = bin.readLine()) != null) {
                    sb.append(lineRead);
                }
                String xmlStringRecvd1 = sb.toString();
                logger.debug((Object)("Xml String received From Remote Service : " + xmlStringRecvd1 + " for RS ID= " + iRemoteServiceID));
                String xmlStringRecvd = GeneralAPI.removeXmlHeader(xmlStringRecvd1);
                XStream objXStream = new XStream();
                objXStream.alias("CommandResponseVO", CommandResponseVO.class);
                if (xmlStringRecvd.contains("LAUT")) {
                    objXStream.alias("CommandLocalAuthenticationsData", CommandLocalAuthenticationsData.class);
                    objXStream.alias("CommandLAUTData", CommandLAUTData.class);
                }
                Object obj = objXStream.fromXML(xmlStringRecvd);
                objCommandResponseVO = (CommandResponseVO)obj;
                bin.close();
            }
            catch (Exception e) {
                logger.error((Object)("Exception in sendReceiveRequestToCOMM(String):" + e));
                throw e;
            }
        }
        finally {
            post.releaseConnection();
        }
        strXmlRequest = null;
        return objCommandResponseVO;
    }

    public byte[] pingCommServer(DTCOCommandVO objCommandVO, long currentTime) throws Exception {
        String xmlStringRecvd = "";
        String strSessionId = objCommandVO.getSessionId();
        HttpURLConnection objHttpURLConnection = null;
        byte[] authResponseData = null;
        FilterInputStream dis = null;
        BufferedReader bin = null;
        Security.addProvider((java.security.Provider)new Provider());
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        RemoteServiceVO objRemoteServiceVO = objCommandVO.getRemoteServiceVo();
        try {
            HttpClient hc = new HttpClient();
            boolean proxyRequired = Application.proxyServerUsedReg;
            if (proxyRequired) {
                String proxyHost = Application.proxyHostReg;
                int proxyPort = 0;
                if (Application.proxyPortReg.length() > 0) {
                    proxyPort = Integer.parseInt(Application.proxyPortReg);
                }
                hc.getHostConfiguration().setProxy(proxyHost, proxyPort);
                String proxyUser = Application.proxyUserReg;
                String proxyPassword = Application.proxyPasswordReg;
                if (proxyUser != null && proxyUser.trim().length() > 0 && proxyPassword != null && proxyPassword.trim().length() > 0) {
                    hc.getState().setProxyCredentials(null, null, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                    hc.getState().setAuthenticationPreemptive(true);
                }
            }
            String strUrl = String.valueOf(objRemoteServiceVO.getUrlRS()) + "/" + ConfigUtil.getValue("VirtualDirectoryRSIF01");
            strUrl = String.valueOf(strUrl) + "?jsessionid=" + strSessionId;
            logger.debug((Object)("URL of Comm :" + strUrl + "?jsessionid=" + strSessionId));
            GetMethod httpget = new GetMethod(strUrl);
            httpget.setRequestHeader("CONTENT-TYPE", "text/xml;charset=UTF-8");
            hc.executeMethod((HttpMethod)httpget);
            if (dis == null) {
                dis = new DataInputStream(httpget.getResponseBodyAsStream());
            }
            StringBuffer sb = new StringBuffer();
            bin = new BufferedReader(new InputStreamReader((InputStream)dis, "UTF-8"));
            String lineRead = null;
            while ((lineRead = bin.readLine()) != null) {
                sb.append(lineRead);
            }
            xmlStringRecvd = sb.toString();
            logger.info((Object)("XML String received while Pinging : " + xmlStringRecvd));
            if (xmlStringRecvd == null || xmlStringRecvd.equalsIgnoreCase("") || xmlStringRecvd.trim().length() == 0) {
                return null;
            }
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            Object obj = objXStream.fromXML(sb.toString());
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            if (objCommandResponseVO.getCmdName().equalsIgnoreCase("RESP") && objCommandResponseVO.getStatus() == 0) {
                return null;
            }
            try {
                if (objCommandResponseVO.getCmdName().equalsIgnoreCase("RESP") && objCommandResponseVO.getStatus() != 0) {
                    logger.error((Object)("CCAD Response Received with RESP with status code in pingCommServer method:" + objCommandResponseVO.getStatus()));
                    throw new Exception("CCAD Response Received with RESP with status code in pingCommServer method");
                }
                CommandDTADData objCommandDTADData = objCommandResponseVO.getCommandDTADData();
                authResponseData = objCommandDTADData.getAuthData();
            }
            catch (Exception e) {
                logger.error((Object)"Exception in pingCommServer in InvokeRemoteDevice :: Exception is::", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (objHttpURLConnection != null) {
                objHttpURLConnection.disconnect();
            }
            if (dis != null) {
                dis.close();
            }
            if (bin != null) {
                bin.close();
            }
        }
        return authResponseData;
    }

    public void clientRegistrationSR(DTCOCommandVO objCommandVO) throws Exception {
        String strXmlString = "";
        try {
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            ArrayList<String> arrSerialId = new ArrayList<String>();
            logger.debug((Object)("clientRegistrationSR...: " + objCommandVO.getRemoteDeviceSerialNumber()));
            arrSerialId.add(objCommandVO.getRemoteDeviceSerialNumber());
            CommandCMRGData objCMRGData = new CommandCMRGData();
            objCommandRequestVO.setVersion("1.0");
            objCommandRequestVO.setCmdName("CMRG");
            objCMRGData.setSerialId(arrSerialId);
            objCMRGData.setCommMode(0);
            objCMRGData.setType(1);
            objCommandRequestVO.setCommandCMRGData(objCMRGData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            logger.debug((Object)("strXmlString...: " + strXmlString));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in clientRegistrationSR in InvokeRemoteDevice ::" + e));
            throw e;
        }
        try {
            CommandResponseVO objCommandResponseVO;
            logger.info((Object)("DLD Type = " + objCommandVO.getDldType() + " remoteServiceId = " + objCommandVO.getRemoteServiceID()));
            if (objCommandVO.getDldType() == 8 || objCommandVO.getDldType() == 10 && objCommandVO.getRemoteServiceID() == -2) {
                Socket connection = GeneralAPI.getRDSServerConnectionForAuthentication();
                if (connection != null) {
                    logger.debug((Object)("Connection " + connection + " is established while sending CMRG command to communicator."));
                    objCommandVO.setConnection(connection);
                    PingThreadForRDSServer pingThread = new PingThreadForRDSServer(connection);
                    Thread t = new Thread(pingThread);
                    logger.info((Object)"Pinging Thread for RDS for CMRG .....");
                    t.start();
                } else {
                    logger.error((Object)"Exception in clientRegistrationSR for RDS server in InvokeRemoteDevice :: Connection is null. Server is not running");
                }
                objCommandResponseVO = this.sendReceiveRequestToSRCOMM(strXmlString, objCommandVO);
            } else {
                Socket connection = GeneralAPI.getClientSocketConnection();
                if (connection != null) {
                    logger.debug((Object)("Connection " + connection + " is established while sending CMRG command to communicator."));
                    objCommandVO.setConnection(connection);
                } else {
                    logger.error((Object)"Exception in clientRegistrationSR for SR server in InvokeRemoteDevice :: Connection is null. Server is not running");
                }
                objCommandResponseVO = this.sendReceiveRequestToSRCOMM(strXmlString, objCommandVO);
            }
            CommandCMRRData objCommandCMRRData = objCommandResponseVO.getCommandCMRRData();
            String strSessionId = objCommandCMRRData.getSessionId();
            if (strSessionId != null && strSessionId.equals("-1")) {
                logger.error((Object)"Exception in clientRegistrationSR in InvokeRemoteDevice ::Exception in CMRG: Session ID Received is -1");
                throw new Exception("Sessionid Received From COMM in CMRG is -1");
            }
            objCommandVO.setSessionId(strSessionId);
        }
        catch (Exception e) {
            logger.error((Object)("Exception in clientRegistrationSR in InvokeRemoteDevice ::" + e));
            throw e;
        }
    }

    public CommandResponseVO sendAuthenticationDataToSRCOMM(DTCOCommandVO objCommandVO, byte[] authData) throws Exception {
        CommandRequestVO objCommandRequestVO = new CommandRequestVO();
        ArrayList<String> arrEntityId = new ArrayList<String>();
        CommandResponseVO objCommandResponseVO = null;
        arrEntityId.add(objCommandVO.getRemoteDeviceSerialNumber());
        objCommandRequestVO.setVersion("1.0");
        objCommandRequestVO.setCmdName("CCAD");
        CommandCCADData objCommandCCADData = new CommandCCADData();
        objCommandCCADData.setSerialId(arrEntityId);
        objCommandCCADData.setCommMode(0);
        objCommandCCADData.setType(1);
        if (authData != null) {
            logger.debug((Object)("Authdata in CCAD: " + Arrays.toString(authData)));
        } else {
            logger.debug((Object)"Authdata in CCAD: null");
        }
        objCommandCCADData.setAuthData(authData);
        objCommandRequestVO.setCommandCCADData(objCommandCCADData);
        ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
        XMLObject objXmlObject = new XMLObject();
        objXmlObject.setAlias("CommandRequestVO");
        objXmlObject.setClassName(CommandRequestVO.class);
        objArr.add(objXmlObject);
        String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
        try {
            objCommandResponseVO = this.sendReceiveRequestToSRCOMM(strXmlString, objCommandVO);
            if (objCommandResponseVO.getCmdName().equalsIgnoreCase("RESP") && objCommandResponseVO.getStatus() != 1) {
                logger.error((Object)"Exception in sendAuthenticationDataToSRCOMM in InvokeRemoteDevice ::Exception in CCAD: Status Received is not 1");
                throw new Exception("Error Status Received from COMM in CCAD is:" + objCommandResponseVO.getStatus());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception in sendAuthenticationDataToSRCOMM in InvokeRemoteDevice :: " + e));
            throw e;
        }
        return objCommandResponseVO;
    }

    /*
     * Exception decompiling
     */
    public CommandResponseVO sendReceiveRequestToSRCOMM(String strXmlRequest, DTCOCommandVO objDTCOCommandVO) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendReceiveRequestTMDLSRCOMM(String strXmlRequest) {
        block9: {
            Socket connect = GeneralAPI.getClientSocketConnection();
            logger.debug((Object)("Connection " + connect + " is established while sending TMDL  command."));
            logger.info((Object)("Sending string to SR Comm : " + strXmlRequest));
            if (connect != null) {
                try {
                    int c;
                    connect.setSoTimeout(GeneralDao.getAuthSocketTimeoutSec() * 1000);
                    DataOutputStream outs = new DataOutputStream(connect.getOutputStream());
                    strXmlRequest = String.valueOf(strXmlRequest) + '\r';
                    int len = strXmlRequest.length() + 4;
                    outs.writeInt(len);
                    outs.write(strXmlRequest.getBytes());
                    outs.flush();
                    StringBuffer xmlStringRecvd = new StringBuffer();
                    BufferedInputStream bis = new BufferedInputStream(connect.getInputStream());
                    InputStreamReader isr = new InputStreamReader((InputStream)bis, "US-ASCII");
                    while ((c = isr.read()) != 13) {
                        xmlStringRecvd.append((char)c);
                    }
                    logger.info((Object)("Xml String received from SR Comm : " + xmlStringRecvd));
                    if (xmlStringRecvd.indexOf("RESP") != -1 && xmlStringRecvd.indexOf("<status>1</status>") != -1) {
                        logger.debug((Object)"WE GOT RESP FROM COMM");
                        break block9;
                    }
                    logger.debug((Object)"WE GOT OTHER THEN RESP FROM COMM");
                }
                catch (SocketTimeoutException timeout) {
                    logger.error((Object)("Exception in sendReceiveRequestTMDLSRCOMM in InvokeRemoteDevice :: Socket Time out " + timeout));
                }
                catch (SocketException se) {
                    logger.error((Object)("Exception in sendReceiveRequestTMDLSRCOMM in InvokeRemoteDevice :: Socket Exception. Connection might be closed " + se));
                    connect = null;
                }
                catch (IOException f) {
                    logger.error((Object)("Exception in sendReceiveRequestTMDLSRCOMM in InvokeRemoteDevice :: IOException: " + f));
                }
                catch (Exception g) {
                    logger.error((Object)("Exception in sendReceiveRequestTMDLSRCOMM in InvokeRemoteDevice :: Exception: " + g));
                }
            } else {
                logger.error((Object)"Exception in sendReceiveRequestTMDLSRCOMM in InvokeRemoteDevice :: Connection is null. Server is not running");
            }
        }
    }

    public void sendRDAGToCOMM(DTCOCommandVO objCommandVO) throws Exception {
        objCommandVO.setBreakRequired(true);
        CommandRequestVO objCommandRequestVO = new CommandRequestVO();
        ArrayList<String> arrSerialId = new ArrayList<String>();
        CommandResponseVO objCommandResponseVO = null;
        CommandRDAGData objCommandRDAGData = new CommandRDAGData();
        try {
            arrSerialId.add(objCommandVO.getRemoteDeviceSerialNumber());
            objCommandRequestVO.setVersion("1.0");
            objCommandRequestVO.setCmdName("RDAG");
            String entityIdWithHash = GeneralAPI.byteToString(objCommandVO.getEntityId());
            String[] entityId = entityIdWithHash.split("#", -1);
            logger.debug((Object)("entityid: " + entityIdWithHash));
            int count = 1;
            int j = 0;
            while (j < entityId.length) {
                objCommandVO.getReminderDate();
                ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                FileTransferStatusVO objFileTransfer = new FileTransferStatusVO();
                int statusCheck = 1;
                logger.debug((Object)("Serching for Entity ID :" + entityId[j]));
                if (entityId[j].charAt(0) == 'V') {
                    byte[] downloadRequest;
                    objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDVU()), statusCheck);
                    objCommandRDAGData.setVehicleRegistrationNumber(entityId[j].substring(1));
                    objCommandRDAGData.setVehicleIdentificationNumber(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                    objCommandRDAGData.setvReminderId(String.valueOf(objCommandVO.getReminderIDVU()));
                    objCommandRDAGData.setVuSpecificDataRequired("Y");
                    boolean cardDownloadChecked = false;
                    boolean svSet = false;
                    int i = 0;
                    while (i < objCommandVO.getRequestList().size()) {
                        downloadRequest = objCommandVO.getRequestList().get(i);
                        if (downloadRequest[0] == 6 && objCommandVO.isCardDownloadIndicator() && !cardDownloadChecked) {
                            objCommandRDAGData.setDcSpecificDataRequired("Y");
                            cardDownloadChecked = true;
                        }
                        ++i;
                    }
                    objCommandRDAGData.setVuSpecificDataRequiredforRTMWeb("Y");
                    i = 0;
                    while (i < objCommandVO.getRequestList().size()) {
                        downloadRequest = objCommandVO.getRequestList().get(i);
                        if (downloadRequest[0] == 3 || downloadRequest[0] == 35 || downloadRequest[0] == 4 || downloadRequest[0] == 36 || downloadRequest[0] == 5 || downloadRequest[0] == 37 || downloadRequest[0] == 2 || downloadRequest[0] == 34) {
                            objCommandRDAGData.setVuSpecificDataRequiredforRTMWeb("N");
                            break;
                        }
                        ++i;
                    }
                } else if (entityId[j].charAt(0) == 'S') {
                    objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDSV()), statusCheck);
                    objCommandRDAGData.setVehicleRegistrationNumber(entityId[j].substring(1));
                    objCommandRDAGData.setVehicleIdentificationNumber(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                    objCommandRDAGData.setSvSpecificDataRequired("Y");
                    objCommandRDAGData.setsReminderId(String.valueOf(objCommandVO.getReminderIDSV()));
                } else if (entityId[j].charAt(0) == 'D') {
                    if (count == 1 && objCommandVO.isDriverIndicator() && objCommandVO.isCodriverIndicator()) {
                        logger.debug((Object)"Setting Driver :");
                        objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDDriver()), statusCheck);
                        objCommandRDAGData.setDriverName(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                        objCommandRDAGData.setDriverCardNumber(entityId[j].substring(1));
                        objCommandRDAGData.setdReminderId(String.valueOf(objCommandVO.getReminderIDDriver()));
                        ++count;
                    } else if (count == 1 && !objCommandVO.isDriverIndicator() && objCommandVO.isCodriverIndicator()) {
                        logger.debug((Object)"Setting Co Driver only:");
                        objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDCoDriver()), statusCheck);
                        objCommandRDAGData.setCoDriverName(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                        objCommandRDAGData.setCoDriverCardNumber(entityId[j].substring(1));
                        objCommandRDAGData.setCoDriverReminderId(String.valueOf(objCommandVO.getReminderIDCoDriver()));
                    } else if (count == 1 && objCommandVO.isDriverIndicator() && !objCommandVO.isCodriverIndicator()) {
                        logger.debug((Object)"Setting Driver Only :");
                        objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDDriver()), statusCheck);
                        objCommandRDAGData.setDriverName(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                        objCommandRDAGData.setDriverCardNumber(entityId[j].substring(1));
                        objCommandRDAGData.setdReminderId(String.valueOf(objCommandVO.getReminderIDDriver()));
                    } else {
                        logger.debug((Object)"Setting Co Driver :");
                        objFileTransfer = objReminderListDao.getEntityName(objCommandVO.getReminderDate(), objCommandVO.getCompanyID(), String.valueOf(objCommandVO.getReminderIDCoDriver()), statusCheck);
                        objCommandRDAGData.setCoDriverName(GeneralAPI.byteToString(objFileTransfer.getEntityName()));
                        objCommandRDAGData.setCoDriverCardNumber(entityId[j].substring(1));
                        objCommandRDAGData.setCoDriverReminderId(String.valueOf(objCommandVO.getReminderIDCoDriver()));
                    }
                }
                ++j;
            }
            if (objCommandRDAGData.getDcSpecificDataRequired() != null && objCommandRDAGData.getDcSpecificDataRequired().equals("Y")) {
                logger.debug((Object)"DC required is set.");
            } else {
                objCommandRDAGData.setDcSpecificDataRequired("");
            }
            if (objCommandRDAGData.getVuSpecificDataRequired() != null && objCommandRDAGData.getVuSpecificDataRequired().equals("Y")) {
                logger.debug((Object)"VU required is set.");
            } else {
                objCommandRDAGData.setVuSpecificDataRequired("");
            }
            if (objCommandRDAGData.getSvSpecificDataRequired() != null && objCommandRDAGData.getSvSpecificDataRequired().equals("Y")) {
                logger.debug((Object)"SV required is set.");
            } else {
                objCommandRDAGData.setSvSpecificDataRequired("");
            }
            objCommandRDAGData.setTimeStampRDAG(objCommandVO.getTimeStamp());
            objCommandRDAGData.setSerialId(arrSerialId);
            objCommandRDAGData.setSessionId(objCommandVO.getSessionId());
            objCommandRequestVO.setCommandRDAGData(objCommandRDAGData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            objCommandResponseVO = this.sendReceiveRequestToSRCOMM(strXmlString, objCommandVO);
            if (objCommandResponseVO.getStatus() != 1) {
                logger.error((Object)"Exception in sendRDAGToCOMM in InvokeRemoteDevice :: Exception in RESP: Status Received is not 1 .... sendRDAGToCOMM method");
                throw new Exception("Error Status Received from COMM in RESP is:" + objCommandResponseVO.getStatus());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception in sendRDAGToCOMM in InvokeRemoteDevice ::" + e));
            throw e;
        }
    }

    public void sendATNPToWideRange(int RemoteServiceID, CommandATNPData objCommandATNPData) {
        logger.debug((Object)"Preparing ATNP command to send to remote service.");
        try {
            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
            RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceVO(RemoteServiceID);
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion("1.0");
            objCommandRequestVO.setCmdName("ATNP");
            String decryptpwdFrom = GeneralAPI.jumbleString(objRemoteServiceVO.getPasswordRS());
            objCommandATNPData.setUserName(objRemoteServiceVO.getUserNameRS());
            objCommandATNPData.setPassword(decryptpwdFrom);
            objCommandATNPData.setAccountName(objRemoteServiceVO.getAccountNameRS());
            objCommandRequestVO.setCommandATNPData(objCommandATNPData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, RemoteServiceID, objRemoteServiceVO);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception e) {
            logger.error((Object)"Exception In getWREntityDetails() method of class WRPingingThread : ", (Throwable)e);
        }
    }

    public void sendCCNPToWideRange(int RemoteServiceID, CommandCCNPData objCommandCCNPData) {
        logger.debug((Object)"Preparing CCNP command to send to remote service.");
        try {
            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
            RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceVO(RemoteServiceID);
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion("1.0");
            objCommandRequestVO.setCmdName("CCNP");
            String decryptpwdFrom = GeneralAPI.jumbleString(objRemoteServiceVO.getPasswordRS());
            objCommandCCNPData.setUserName(objRemoteServiceVO.getUserNameRS());
            objCommandCCNPData.setPassword(decryptpwdFrom);
            objCommandCCNPData.setAccountName(objRemoteServiceVO.getAccountNameRS());
            objCommandRequestVO.setCommandCCNPData(objCommandCCNPData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, RemoteServiceID, objRemoteServiceVO);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception e) {
            logger.error((Object)"Exception In getWREntityDetails() method of class WRPingingThread : ", (Throwable)e);
        }
    }

    public void sendReceiveRequestToRDSServer() {
        block13: {
            if (cmprList != null) {
                cmprList = null;
            }
            cmprList = new CopyOnWriteArrayList<String>();
            logger.info((Object)"cmprList cleared...");
            String strXmlRequest = CSVSXml;
            connect = GeneralAPI.getRDSServerConnection();
            boolean disconnectFlag = false;
            logger.info((Object)("Connection in sendReceiveRequestToRDSServer()= " + connect + " is established while sending CSVS  command."));
            logger.info((Object)("Sending string to RDS Comm : " + strXmlRequest));
            BufferedInputStream bis = null;
            InputStreamReader isr = null;
            DataOutputStream outs = null;
            if (connect != null) {
                try {
                    int c;
                    outs = new DataOutputStream(connect.getOutputStream());
                    logger.info((Object)("XMl Size:  " + strXmlRequest.length() + "\n"));
                    strXmlRequest = String.valueOf(strXmlRequest) + '\r';
                    logger.info((Object)("XMl Size +char(13): " + strXmlRequest.length() + "\n"));
                    ByteBuffer b = ByteBuffer.allocate(4);
                    b.putInt(strXmlRequest.length());
                    byte[] result = b.array();
                    logger.info((Object)("Size Array Length :: " + result.length));
                    logger.info((Object)("XML Length in bytes :::" + strXmlRequest.getBytes().length));
                    outs.write(result);
                    outs.write(strXmlRequest.getBytes());
                    outs.flush();
                    connect.setKeepAlive(true);
                    Thread pingThread = new Thread(){
                        private volatile boolean running = true;

                        @Override
                        public void run() {
                            while (this.running) {
                                try {
                                    int interval = GeneralDao.getAuthRDSPingFreqSec();
                                    byte[] pingArray = new byte[4];
                                    Thread.sleep(interval * 1000);
                                    DataOutputStream pingOutputSteam = new DataOutputStream(connect.getOutputStream());
                                    pingOutputSteam.write(pingArray);
                                    pingOutputSteam.flush();
                                    logger.info((Object)"Ping Thread Sent");
                                }
                                catch (Exception e) {
                                    logger.error((Object)("Exception in PingThreadForRDSServer for CMPR : " + ConfigUtil.getStackTraceAsString(e)));
                                    logger.info((Object)"Inside PingThreadForRDSServer for CMPR");
                                    logger.info((Object)"******* Auth service is up but RDS might be down..trying to establish a new connection and send CSVS again ***********");
                                    this.running = false;
                                    if (InvokeRemoteDevice.this.timer == null) {
                                        InvokeRemoteDevice.this.scheduleCSVS();
                                        continue;
                                    }
                                    logger.info((Object)"CSVS is already scheduled..");
                                }
                            }
                        }
                    };
                    pingThread.start();
                    StringBuffer xmlStringRecvd = new StringBuffer();
                    bis = new BufferedInputStream(connect.getInputStream());
                    isr = new InputStreamReader(bis);
                    while ((c = isr.read()) != 13) {
                        if (c == -1) {
                            logger.debug((Object)"end of char received while reading RESP for CSVS");
                            disconnectFlag = true;
                            break;
                        }
                        xmlStringRecvd.append((char)c);
                    }
                    if (!disconnectFlag) {
                        if (xmlStringRecvd.indexOf("RESP") != -1 && xmlStringRecvd.indexOf("<status>1</status>") != -1) {
                            logger.info((Object)"WE GOT RESP FROM COMM");
                            logger.info((Object)"Updating status as Connected to RDS..");
                            this.updateConnectionToRDS(1);
                        } else {
                            logger.info((Object)"WE GOT CMPR FROM COMM");
                            logger.info((Object)("does string contains CommandResponseVO = " + (xmlStringRecvd.indexOf("CommandResponseVO") != -1)));
                            logger.info((Object)("does string contains CMPR = " + (xmlStringRecvd.indexOf("CMPR") != -1)));
                        }
                        logger.info((Object)"Waiting to read CMPR..");
                        this.readCMPRRequestFromRDS(connect);
                    }
                }
                catch (Exception g) {
                    logger.error((Object)("Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Exception: " + ConfigUtil.getStackTraceAsString(g)));
                    logger.info((Object)"Connection is broken with RDS********* ");
                    logger.info((Object)"******* Auth service is up but RDS might be down..trying to establish a new connection and send CSVS again ***********");
                    if (this.timer == null) {
                        this.scheduleCSVS();
                        break block13;
                    }
                    logger.info((Object)"CSVS is already scheduled..");
                }
            } else {
                logger.error((Object)"Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Connection is null. Server is not running");
                logger.info((Object)"Trying to establish a new connection and send CSVS again ***********");
                if (this.timer == null) {
                    this.scheduleCSVS();
                } else {
                    logger.info((Object)"CSVS is already scheduled..");
                }
            }
        }
    }

    public void scheduleCSVS() {
        logger.info((Object)"inside scheduleCSVS");
        if (isConnectedToRDS) {
            logger.info((Object)"Updating status as Not Connected to RDS..");
            this.updateConnectionToRDS(2);
        } else {
            logger.info((Object)"Status is already updated as Not Connected to RDS..");
        }
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                logger.info((Object)"going to call sendReceiveRequestToRDSServer");
                logger.info((Object)("timer = " + InvokeRemoteDevice.this.timer));
                InvokeRemoteDevice.this.timer.cancel();
                InvokeRemoteDevice.this.timer.purge();
                InvokeRemoteDevice.this.timer = null;
                InvokeRemoteDevice.this.sendReceiveRequestToRDSServer();
                logger.info((Object)"Method work done.. Going to cancel timer ****");
            }
        };
        this.timer.schedule(timerTask, new Date(new Date().getTime() + (long)(GeneralDao.getAuthCSVSRetryPeriodFreqSec() * 1000)));
        logger.info((Object)("timer scheduled for " + GeneralDao.getAuthCSVSRetryPeriodFreqSec() + " min after "));
    }

    private void readCMPRRequestFromRDS(Socket connect) {
        boolean disconnectFlag = false;
        ExecutorService execCMPR = ThreadPool.getThreadPool();
        logger.info((Object)("Connection in readCMPRRequestFromRDS()= " + connect + " is established while sending CSVS  command."));
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        if (connect != null) {
            try {
                boolean isXmlcorrect = false;
                StringBuffer xmlStringRecvd = new StringBuffer();
                block5: do {
                    int c;
                    bis = new BufferedInputStream(connect.getInputStream());
                    isr = new InputStreamReader((InputStream)bis, "UTF-8");
                    while ((c = isr.read()) != -1) {
                        if (c == -1) {
                            logger.debug((Object)"end of char received while reading CMPR from RDS");
                            disconnectFlag = true;
                            continue block5;
                        }
                        xmlStringRecvd.append((char)c);
                        if (xmlStringRecvd.indexOf("<CommandResponseVO>") < 0 || xmlStringRecvd.indexOf("</CommandResponseVO>") < 0) continue;
                        this.delegatetask(xmlStringRecvd, execCMPR);
                        xmlStringRecvd = new StringBuffer();
                    }
                } while (!disconnectFlag);
                logger.debug((Object)"Connection closed by RDS while reading CMPR");
            }
            catch (SocketTimeoutException timeout) {
                logger.error((Object)("Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Socket Time out " + timeout));
                timeout.printStackTrace();
            }
            catch (SocketException se) {
                logger.error((Object)("Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Socket Exception. Connection might be closed " + se));
                se.printStackTrace();
            }
            catch (IOException f) {
                logger.error((Object)("Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: IOException: " + f));
                f.printStackTrace();
            }
            catch (Exception g) {
                logger.error((Object)("Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Exception: " + g));
                g.printStackTrace();
            }
        } else {
            logger.error((Object)"Exception in sendReceiveRequestToRDSServer in InvokeRemoteDevice :: Connection is null. Server is not running");
        }
    }

    private void delegatetask(StringBuffer xmlStringRecvd, ExecutorService execCMPR) {
        String strXML = xmlStringRecvd.toString();
        if (cmprList != null && cmprList.contains(strXML)) {
            logger.info((Object)("cmpr exists in list : size : " + cmprList.size()));
        } else {
            if (cmprList == null) {
                cmprList = new CopyOnWriteArrayList<String>();
            }
            cmprList.add(strXML);
            logger.info((Object)("\t" + cmprList.size()));
            CMPRThread worker = new CMPRThread(strXML);
            execCMPR.execute(worker);
        }
        cmprList.remove(strXML);
        logger.info((Object)"cmpr xml removed from list");
    }

    private StringBuffer readDTADRequestFromRDS(Socket connect) {
        boolean disconnectFlag = false;
        Exception exp = null;
        logger.info((Object)("Connection in readDTADRequestFromRDS()= " + connect + " is established while sending CSVS  command."));
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        if (connect != null) {
            try {
                int c;
                logger.error((Object)"In readDTADRequestFromRDS While reading DTAD message from RDS Server ::");
                StringBuffer xmlStringRecvd = new StringBuffer();
                bis = new BufferedInputStream(connect.getInputStream());
                isr = new InputStreamReader(bis);
                while ((c = isr.read()) != 13) {
                    if (c == -1) {
                        logger.debug((Object)"end of char received while reading DTAD from RDS");
                        disconnectFlag = true;
                        break;
                    }
                    xmlStringRecvd.append((char)c);
                }
                logger.info((Object)("DTAD Xml String received from RDS Comm : " + xmlStringRecvd));
                StringBuffer stringBuffer = xmlStringRecvd;
                return stringBuffer;
            }
            catch (SocketTimeoutException timeout) {
                logger.error((Object)("Exception in readDTADRequestFromRDS in InvokeRemoteDevice :: Socket Time out " + timeout));
                timeout.printStackTrace();
                exp = timeout;
            }
            catch (SocketException se) {
                logger.error((Object)("Exception in readDTADRequestFromRDS in InvokeRemoteDevice :: Socket Exception. Connection might be closed " + se));
                se.printStackTrace();
                exp = se;
            }
            catch (IOException f) {
                logger.error((Object)("Exception in readDTADRequestFromRDS in InvokeRemoteDevice :: IOException: " + f));
                f.printStackTrace();
                exp = f;
            }
            catch (Exception g) {
                logger.error((Object)("Exception in readDTADRequestFromRDS in InvokeRemoteDevice :: Exception: " + g));
                g.printStackTrace();
                exp = g;
            }
            finally {
                try {
                    if (exp != null && connect != null) {
                        connect.close();
                        connect = null;
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)("Exception in finally block of readDTADRequestFromRDS in InvokeRemoteDevice :: Exception:: " + ConfigUtil.getStackTraceAsString(ex)));
                }
            }
        } else {
            logger.error((Object)"Exception in readDTADRequestFromRDS in InvokeRemoteDevice :: Connection is null. Server is not running");
        }
        return null;
    }

    public void updateConnectionToRDS(int connectionStatus) {
        try {
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            int serviceIdAuth = 0;
            int i = 0;
            while (i < objServiceVO.length) {
                if (objServiceVO[i].getSServiceTypeId() == 2) {
                    serviceIdAuth = objServiceVO[i].getIServiceID();
                    break;
                }
                ++i;
            }
            logger.debug((Object)("serviceIdAuth passed is :" + serviceIdAuth));
            if (serviceIdAuth != 0) {
                CompanyDao objCompanyDao = CompanyDao.getInstance();
                boolean flag = objCompanyDao.updateAuthRDSStatus_1b1(serviceIdAuth, connectionStatus);
                logger.debug((Object)("flag updated : " + flag));
                if (flag) {
                    isConnectedToRDS = connectionStatus == 1;
                    logger.debug((Object)("isConnectedToRDS : " + isConnectedToRDS));
                }
            } else {
                logger.debug((Object)"Service is maybe not yet associated..");
            }
        }
        catch (Exception excp) {
            logger.error((Object)("Expection while marking status as Connected to RDS.." + ConfigUtil.getStackTraceAsString(excp)));
        }
    }
}

