/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.doSRCommunications;
import com.sisl.dtco.vo.CommandCSVSData;
import com.sisl.dtco.vo.CommandRequestVO;
import com.sisl.dtco.vo.XMLObject;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.ServiceVO;

public class SRSocketListener
extends Thread {
    private static final Logger logger = Logger.getLogger(SRSocketListener.class);
    private static int port = Integer.parseInt(Application.objServiceInfo.getSAuthenticationServicePortForCommunicatorService());

    @Override
    public void run() {
        try {
            logger.debug((Object)("SRSocketListener:: SR Port is :: " + port));
            ServerSocket listener = new ServerSocket(port);
            try {
                logger.debug((Object)"Calling sendServiceStatus()......");
                AccountsDetailsXMLChild[] objAccountsVOAfter = Application.listAccounts.getAccounts();
                int i = 0;
                while (i < objAccountsVOAfter.length) {
                    logger.info((Object)("Account Name : " + objAccountsVOAfter[i].getAccountName() + "  Device Type: " + objAccountsVOAfter[i].getDeviceType()));
                    logger.info((Object)(" WR2 & SmartLink Selected:: " + objAccountsVOAfter[i].getBIsDLDWRIIAvailable() + " & " + objAccountsVOAfter[i].getBIsSmartLinkAvailable()));
                    if (objAccountsVOAfter[i].getBIsDLDWRIIAvailable() || objAccountsVOAfter[i].getBIsSmartLinkAvailable()) {
                        logger.info((Object)"Sending CSVS Status:: ");
                        SRSocketListener.sendServiceStatus(1);
                        logger.debug((Object)"After sendServiceStatus.");
                        break;
                    }
                    logger.info((Object)"Updating Serviced status as Green in case SR2..");
                    InvokeRemoteDevice.getInstance().updateConnectionToRDS(1);
                    ++i;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception in sendServiceStatus.. ");
            }
            while (true) {
                Socket client = listener.accept();
                doSRCommunications conn_sr = new doSRCommunications(client);
                Thread t = new Thread(conn_sr);
                ExecutorService exec = ThreadPool.getThreadPool();
                logger.info((Object)"SR Listener started.");
                exec.execute(t);
            }
        }
        catch (BindException b) {
            logger.error((Object)("Ports already Used : " + Application.strPort));
            Application.strPort = Application.strPort.trim().length() > 0 ? String.valueOf(Application.strPort) + "," + port : String.valueOf(port);
            logger.error((Object)"Exception in run method of SRSocketListener:: Exception while establishing connection :Binding Exception");
        }
        catch (Exception ioe) {
            logger.error((Object)"Exception in SRSocketListener class::::: ", (Throwable)ioe);
        }
    }

    public static void sendServiceStatus(int status) {
        logger.debug((Object)"Inside sendServiceStatus.");
        CommandRequestVO objCommandRequestVO = new CommandRequestVO();
        CommandCSVSData objCommandCSVSData = new CommandCSVSData();
        objCommandRequestVO.setVersion("1.0");
        objCommandRequestVO.setCmdName("CSVS");
        int serviceIdAuth = 0;
        try {
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            if (objServiceVO == null) {
                logger.debug((Object)"Service VO is Null...");
            }
            int i = 0;
            while (i < objServiceVO.length) {
                if (objServiceVO[i].getSServiceTypeId() == 2) {
                    serviceIdAuth = objServiceVO[i].getIServiceID();
                    break;
                }
                ++i;
            }
            String computername = null;
            try {
                computername = InetAddress.getLocalHost().getHostName();
                computername = Application.objServiceInfo.getIMachineId();
                logger.debug((Object)("HOST/Computer Name: " + computername));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            objCommandCSVSData.setServiceId(serviceIdAuth);
            objCommandCSVSData.setStatus(status);
            objCommandCSVSData.setPort(port);
            if (Application.listAccounts == null) {
                logger.debug((Object)"listAccounts is null..");
                objCommandCSVSData.setAccountList(null);
            } else {
                AccountDetailsXMLParent listAccountsforCSVS = new AccountDetailsXMLParent();
                AccountsDetailsXMLChild[] objAccountsVOForcheck = Application.listAccounts.getAccounts();
                ArrayList<AccountsDetailsXMLChild> arrListAccObj = new ArrayList<AccountsDetailsXMLChild>();
                int i2 = 0;
                while (i2 < objAccountsVOForcheck.length) {
                    logger.info((Object)("For CheckCSVS Account Name : " + objAccountsVOForcheck[i2].getAccountName() + " WR2 & SmartLink Selected: " + objAccountsVOForcheck[i2].getBIsDLDWRIIAvailable() + " & " + objAccountsVOForcheck[i2].getBIsSmartLinkAvailable()));
                    if (objAccountsVOForcheck[i2].getBIsDLDWRIIAvailable() || objAccountsVOForcheck[i2].getBIsSmartLinkAvailable()) {
                        arrListAccObj.add(objAccountsVOForcheck[i2]);
                        logger.info((Object)("Account Name that added in list For CSVS  : " + objAccountsVOForcheck[i2].getAccountName()));
                    }
                    ++i2;
                }
                logger.info((Object)("arrListAccObj Size  : " + arrListAccObj.size()));
                AccountsDetailsXMLChild[] objAccountsVOForCsvs = new AccountsDetailsXMLChild[arrListAccObj.size()];
                int i3 = 0;
                while (i3 < arrListAccObj.size()) {
                    try {
                        objAccountsVOForCsvs[i3] = new AccountsDetailsXMLChild();
                        objAccountsVOForCsvs[i3].setAccountId(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getAccountId());
                        objAccountsVOForCsvs[i3].setAccountName(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getAccountName());
                        objAccountsVOForCsvs[i3].setArchiveMode(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getArchiveMode());
                        objAccountsVOForCsvs[i3].setBIs168HrsDetailedSpeedDataBlock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsDetailedSpeedblock());
                        objAccountsVOForCsvs[i3].setBIsActivityDataBlock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsActivityDataBlock());
                        objAccountsVOForCsvs[i3].setBIsDCFilesDownloadWithVUFile(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsDCFilesDownloadWithVUFile());
                        objAccountsVOForCsvs[i3].setBIsDetailedSpeedblock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsDetailedSpeedblock());
                        objAccountsVOForCsvs[i3].setBIsDLDWRIIAvailable(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsDLDWRIIAvailable());
                        objAccountsVOForCsvs[i3].setBIsEventandFaultsDataBlock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsEventandFaultsDataBlock());
                        objAccountsVOForCsvs[i3].setBIsMulipurposeDataBlock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsMulipurposeDataBlock());
                        objAccountsVOForCsvs[i3].setBIsSmartLinkAvailable(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsSmartLinkAvailable());
                        objAccountsVOForCsvs[i3].setBIsTechnicalDataBlock(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBIsTechnicalDataBlock());
                        objAccountsVOForCsvs[i3].setBSVSpecificDataIndicator(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getBSVSpecificDataIndicator());
                        objAccountsVOForCsvs[i3].setDeviceType(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getDeviceType());
                        objAccountsVOForCsvs[i3].setIDCFileExtensionID(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getIDCFileExtensionID());
                        objAccountsVOForCsvs[i3].setIVDOFileExtensionID(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getIVDOFileExtensionID());
                        objAccountsVOForCsvs[i3].setIVUFileExtensionID(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getIVUFileExtensionID());
                        objAccountsVOForCsvs[i3].setSTISOfficeCompany(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getSTISOfficeCompany());
                        objAccountsVOForCsvs[i3].setSTISOfficeServer(((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getSTISOfficeServer());
                        logger.info((Object)(" After Set arrListAccObj  : " + ((AccountsDetailsXMLChild)arrListAccObj.get(i3)).getAccountName()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)("e.getMessage(): " + e.getMessage()));
                        logger.error((Object)("e.getStackTrace() :" + e.getStackTrace()));
                    }
                    ++i3;
                }
                listAccountsforCSVS.setAccounts(objAccountsVOForCsvs);
                logger.info((Object)("Size Of listAccountsforCSVS  : " + listAccountsforCSVS.getAccounts().length));
                objCommandCSVSData.setAccountList(listAccountsforCSVS);
            }
            objCommandCSVSData.setClientMachineName(computername);
            objCommandRequestVO.setCommandCSVSData(objCommandCSVSData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            if (objCommandCSVSData.getAccountList() != null && objCommandCSVSData.getAccountList().getAccounts().length > 0) {
                logger.debug((Object)"WRII specific accounts found..");
                CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -2, null);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            } else {
                logger.debug((Object)"No WRII specific accounts found..i.e., will not make connection with RDS!!");
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Exception whle getting ServiceVO in sendServiceStatus():: " + e));
        }
    }
}

