/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dldcomm.util.RLEBWTNative;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.ReadRegistry;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.DiagnosticLogsDao;
import com.sisl.dtco.dao.ManualEntryDetailsDao;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.exceptions.AuthenticationModuleException;
import com.sisl.dtco.integration.AccountManagement;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.ClientXMLThread;
import com.sisl.dtco.integration.CreateIntimationTask;
import com.sisl.dtco.integration.SRSocketListener;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.WRFileTransferThread;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.vo.AccountIdUI;
import com.sisl.dtco.vo.CommandDCDLData;
import com.sisl.dtco.vo.CommandDSDLData;
import com.sisl.dtco.vo.CommandDSUGData;
import com.sisl.dtco.vo.CommandEMOIData;
import com.sisl.dtco.vo.CommandGPSLData;
import com.sisl.dtco.vo.CommandNOATData;
import com.sisl.dtco.vo.CommandRequestVO;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.CommandSDCFData;
import com.sisl.dtco.vo.CommandSDDAData;
import com.sisl.dtco.vo.CommandSDFLData;
import com.sisl.dtco.vo.DiagnosticLogVO;
import com.sisl.dtco.vo.DriverDetailsUIVO;
import com.sisl.dtco.vo.DueDownloadVO;
import com.sisl.dtco.vo.EntityVO;
import com.sisl.dtco.vo.FileTransferVO;
import com.sisl.dtco.vo.ReminderListUIVO;
import com.sisl.dtco.vo.ResponseMessage;
import com.sisl.dtco.vo.ServiceDetailsUI;
import com.sisl.dtco.vo.UserTaskUIVO;
import com.sisl.dtco.vo.VehicleDetailsUIVO;
import com.sisl.dtco.vo.XMLObject;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.tempuri.AccountDetailsXMLParent;
import org.tempuri.AccountVO;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.EntityVORTM;
import org.tempuri.RemoteServiceVO;

public class UIFileHandler {
    private static final Logger logger = Logger.getLogger(UIFileHandler.class);
    static Object lockObject = new Object();
    static UIFileHandler instance;
    static boolean commandRERLWorking;
    static boolean RERLAlreadyInProgress;
    public static ArrayList<Integer> companyList;

    static {
        commandRERLWorking = false;
        RERLAlreadyInProgress = false;
        companyList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIFileHandler getInstance() {
        if (instance == null) {
            Object object = lockObject;
            synchronized (object) {
                if (instance == null) {
                    instance = new UIFileHandler();
                }
            }
        }
        return instance;
    }

    public ResponseMessage xmlRequestHandler(String strXMLreceived) throws Exception {
        try {
            logger.debug((Object)"xmlRequestHandler........");
            String strXML = strXMLreceived.substring(1);
            XStream objXStream = new XStream();
            ResponseMessage objResponseMessage = new ResponseMessage();
            objResponseMessage.setDescription("Success");
            objResponseMessage.setStatusCode("1");
            if (strXML.indexOf("VehicleDetailsUIVO") != -1) {
                objXStream.alias("VehicleDetailsUIVO", VehicleDetailsUIVO.class);
                Object obj = objXStream.fromXML(strXML);
                VehicleDetailsUIVO objVehicleDetailsUIVO = (VehicleDetailsUIVO)obj;
                String strCmdName = objVehicleDetailsUIVO.getCmdName();
                if (strCmdName.equalsIgnoreCase("VDME")) {
                    this.addVehicleMnualEntry(objVehicleDetailsUIVO);
                } else if (strCmdName.equalsIgnoreCase("DME")) {
                    this.deleteManualEntry(objVehicleDetailsUIVO);
                } else if (strCmdName.equalsIgnoreCase("RST")) {
                    this.resetStatus(objVehicleDetailsUIVO);
                }
            } else if (strXML.indexOf("DriverDetailsUIVO") != -1) {
                objXStream.alias("DriverDetailsUIVO", DriverDetailsUIVO.class);
                Object obj = objXStream.fromXML(strXML);
                DriverDetailsUIVO objDriverDetailsUIVO = (DriverDetailsUIVO)obj;
                String strCmdName = objDriverDetailsUIVO.getCmdName();
                if (strCmdName.equalsIgnoreCase("DDME")) {
                    this.addDriverManualEntry(objDriverDetailsUIVO);
                }
            } else if (strXML.indexOf("FileTransferVO") != -1) {
                objXStream.alias("FileTransferVO", FileTransferVO.class);
                Object obj = objXStream.fromXML(strXML);
                FileTransferVO objFileTransferVO = (FileTransferVO)obj;
                this.fileTransfer(objFileTransferVO);
            } else if (strXML.indexOf("ReminderListUIVO") != -1) {
                objXStream.alias("ReminderListUIVO", ReminderListUIVO.class);
                Object obj = objXStream.fromXML(strXML);
                ReminderListUIVO objReminderListUIVO = (ReminderListUIVO)obj;
                this.reminderList(objReminderListUIVO);
            } else if (strXML.indexOf("UserTaskUIVO") != -1) {
                objXStream.alias("UserTaskUIVO", UserTaskUIVO.class);
                Object obj = objXStream.fromXML(strXML);
                UserTaskUIVO objUserTaskUIVO = (UserTaskUIVO)obj;
                this.userTaskHandler(objUserTaskUIVO);
            } else if (strXML.indexOf("ServiceDetailsUI") != -1) {
                objXStream.alias("ServiceDetailsUI", ServiceDetailsUI.class);
                Object obj = objXStream.fromXML(strXML);
                ServiceDetailsUI objServiceUIInfo = (ServiceDetailsUI)obj;
                AccountManagement accountDetails = new AccountManagement();
                logger.debug((Object)"going to update internet settings");
                objResponseMessage = accountDetails.updateServiceXMLForINST(objServiceUIInfo.getiServiceID(), objServiceUIInfo.getsProxyHost(), objServiceUIInfo.getsProxyPassword(), objServiceUIInfo.getsProxyPort(), objServiceUIInfo.getsProxyUser(), objServiceUIInfo.isbIsProxyServerUsed());
                logger.debug((Object)("response in strXML ServiceDetailsUI:" + objResponseMessage));
            } else if (strXML.indexOf("AccountIdUI") != -1) {
                logger.debug((Object)" going in add metd");
                objXStream.alias("AccountIdUI", AccountIdUI.class);
                Object obj = objXStream.fromXML(strXML);
                AccountIdUI objAccountIdUI = (AccountIdUI)obj;
                String strCmdName = objAccountIdUI.getCommandName();
                AccountManagement accountDetails = new AccountManagement();
                if (strCmdName.equals("ADAC")) {
                    logger.debug((Object)" going in add metd now-->>");
                    objResponseMessage = accountDetails.addAccountInDB(objAccountIdUI.getAccountId());
                    logger.info((Object)("StatusCode:  " + objResponseMessage.getStatusCode()));
                    logger.info((Object)"Send CSVS with new Associated Account Details");
                    SRSocketListener.sendServiceStatus(1);
                } else if (strCmdName.equals("CHAC")) {
                    objResponseMessage = accountDetails.check(objAccountIdUI.getAccountId());
                } else if (strCmdName.equals("UPAC")) {
                    logger.debug((Object)"UPAC command received from UI.... Going to call getXML method..");
                    ClientXMLThread.getXMLDetectionthread().getXML();
                    logger.debug((Object)"After getXML method..");
                    logger.info((Object)"Send CSVS with current Associated Account Details");
                    SRSocketListener.sendServiceStatus(0);
                }
            }
            logger.debug((Object)("returning response in UIFileHandler:" + objResponseMessage));
            return objResponseMessage;
        }
        catch (AuthenticationModuleException amex) {
            logger.error((Object)("AuthenticationModuleException in xmlRequestHandler of UIFileHandler class :" + amex));
            throw amex;
        }
        catch (Exception e) {
            logger.debug((Object)("Exception in xmlRequestHandler of UIFileHandler class : " + e));
            throw new Exception("Some other Exception:3");
        }
    }

    public void resetStatus(VehicleDetailsUIVO obj) {
        try {
            AccountDetailsXMLParent listAccounts = Application.listAccounts;
            if (listAccounts == null) {
                return;
            }
            AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int j = 0;
                while (j < objAccountsVO.length) {
                    if (objAccountsVO[j].getAccountId() == obj.getAccID()) {
                        logger.debug((Object)(" in method reset status: " + objAccountsVO[j].getAccountId() + "=" + obj.getAccID()));
                        String strXML = this.intimateToSRComm(null);
                        CreateIntimationTask intimationTask = new CreateIntimationTask(strXML, -1, null);
                        Thread authExecutor = new Thread(intimationTask);
                        ExecutorService es = ThreadPool.getThreadPool();
                        es.execute(authExecutor);
                    }
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in reseting the status in UI File handler class: ", (Throwable)ex);
        }
    }

    public void sendDSDLToCOMM(String strXML) {
        logger.info((Object)"DSDL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandDSDLData", CommandDSDLData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandDSDLData objCommandDSDLData = objCommandResponseVO.getCommandDSDLData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandDSDLData(objCommandDSDLData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendDCDLToCOMM(String strXML) {
        logger.info((Object)"DCDL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandDCDLData", CommandDCDLData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandDCDLData objCommandDCDLData = objCommandResponseVO.getCommandDCDLData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandDCDLData(objCommandDCDLData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendEMOIToCOMM(String strXML) {
        logger.info((Object)"DCDL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandEMOIData", CommandEMOIData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandEMOIData objCommandEMOIData = objCommandResponseVO.getCommandEMOIData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandEMOIData(objCommandEMOIData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendDSUGToCOMM(String strXML) {
        logger.info((Object)"DSUG received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandDSUGData", CommandDSUGData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandDSUGData objCommandDSUGData = objCommandResponseVO.getCommandDSUGData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandDSUGData(objCommandDSUGData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendGPSLToCOMM(String strXML) {
        logger.info((Object)"GPSL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandGPSLData", CommandGPSLData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandGPSLData objCommandGPSLData = objCommandResponseVO.getCommandGPSLData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandGPSLData(objCommandGPSLData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendSDCFToCOMM(String strXML) {
        logger.info((Object)"GPSL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandSDCFData", CommandSDCFData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandSDCFData objCommandSDCFData = objCommandResponseVO.getCommandSDCFData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandSDCFData(objCommandSDCFData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendSDFLToCOMM(String strXML) {
        logger.info((Object)"GPSL received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandSDFLData", CommandSDFLData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandSDFLData objCommandSDFLData = objCommandResponseVO.getCommandSDFLData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandSDFLData(objCommandSDFLData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendSDDAToCOMM(String strXML) {
        logger.info((Object)"SDDA received from SR Comm");
        try {
            XStream objXStream = new XStream();
            objXStream.alias("CommandResponseVO", CommandResponseVO.class);
            objXStream.alias("CommandSDDAData", CommandSDDAData.class);
            Object obj = objXStream.fromXML(strXML);
            CommandResponseVO objCommandResponseVO = (CommandResponseVO)obj;
            CommandSDDAData objCommandSDDAData = objCommandResponseVO.getCommandSDDAData();
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion(objCommandResponseVO.getVersion());
            objCommandRequestVO.setCmdName(objCommandResponseVO.getCmdName());
            objCommandRequestVO.setCommandSDDAData(objCommandSDDAData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
            Thread authExecutor = new Thread(intimationTask);
            ExecutorService es = ThreadPool.getThreadPool();
            es.execute(authExecutor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void sendNOATToCOMM(String serialIdID, int commType, int iRemoteServiceID) {
        logger.info((Object)"NOAT to be sent to SR Comm becuase no task for authentication.");
        try {
            CommandRequestVO objCommandRequestVO = new CommandRequestVO();
            objCommandRequestVO.setVersion("1.0");
            objCommandRequestVO.setCmdName("NOAT");
            String[] arrSerialId = new String[]{serialIdID};
            CommandNOATData objCommandNOATData = new CommandNOATData();
            objCommandNOATData.setSerialId(arrSerialId);
            objCommandRequestVO.setCommandNOATData(objCommandNOATData);
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            String strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            if (commType == 2 || commType == 10 && iRemoteServiceID == -1) {
                CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -1, null);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            } else if (commType == 8 || commType == 10 && iRemoteServiceID == -2) {
                CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlString, -2, null);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)"Exception in modifyDriverSR method of UIfileHandler : ", (Throwable)ex);
        }
    }

    public void userTaskHandler(UserTaskUIVO objUserTaskUIVO) throws Exception {
        try {
            String strCmdName = objUserTaskUIVO.getCommandName();
            if (strCmdName.equals("ADCY")) {
                CompanyDao objCompanyDao = CompanyDao.getInstance();
                ArrayList arrListCompany = (ArrayList)objUserTaskUIVO.getCYID();
                AccountVO objCompanyVO = objCompanyDao.getCompanyDetails(Integer.parseInt((String)arrListCompany.get(0)));
                companyList.add(Integer.parseInt((String)arrListCompany.get(0)));
                AuthenticationManager objAuthenticationManager = AuthenticationManager.getAuthenticationManager();
                objAuthenticationManager.processReminders(objCompanyVO);
                if (objCompanyVO.getDeviceType() != 1 || objCompanyVO.getDeviceType() != 2 || objCompanyVO.getDeviceType() != 1) {
                    RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                    RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(Integer.parseInt((String)arrListCompany.get(0)));
                    WRPingingThread.schedule(objRemoteServiceVO.getRemoteServiceId());
                    WRFileTransferThread.schedule(objRemoteServiceVO.getRemoteServiceId());
                }
            } else if (strCmdName.equals("DLCY")) {
                ArrayList arrListRS2;
                ArrayList arrListCompany = (ArrayList)objUserTaskUIVO.getCYID();
                logger.debug((Object)("Handling deleted company:" + objUserTaskUIVO.getCYID()));
                companyList.add(Integer.parseInt((String)arrListCompany.get(0)));
                Application instance = Application.getApplication();
                instance.cancelsRefreshReminderListTask(Integer.parseInt((String)arrListCompany.get(0)));
                ArrayList<Integer> listRemoteServiceIDs = new ArrayList<Integer>();
                ArrayList arrListRS1 = (ArrayList)objUserTaskUIVO.getR1ID();
                if (Integer.parseInt((String)arrListRS1.get(0)) != 0) {
                    listRemoteServiceIDs.add(Integer.parseInt((String)arrListRS1.get(0)));
                }
                if (Integer.parseInt((String)(arrListRS2 = (ArrayList)objUserTaskUIVO.getR2ID()).get(0)) != 0) {
                    listRemoteServiceIDs.add(Integer.parseInt((String)arrListRS2.get(0)));
                }
                WRPingingThread.removeTasksNotRequired(listRemoteServiceIDs, "DLCY");
                WRFileTransferThread.removeTasksNotRequired(listRemoteServiceIDs, "DLCY");
            } else if (strCmdName.equals("MDCY")) {
                ArrayList arrListCompany = (ArrayList)objUserTaskUIVO.getCYID();
                companyList.add(Integer.parseInt((String)arrListCompany.get(0)));
                RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                RemoteServiceVO objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(Integer.parseInt((String)arrListCompany.get(0)));
                WRPingingThread.scheduleNewPingingTask(objRemoteServiceVO.getRemoteServiceId());
                WRFileTransferThread.scheduleNewFileTransferTask(objRemoteServiceVO.getRemoteServiceId());
            } else if (strCmdName.equals("ULTM")) {
                String strUploadXML = this.intimateUploadTimeToSRCOMM();
                CreateIntimationTask intimationTask = new CreateIntimationTask(strUploadXML, -1, null);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            } else if (strCmdName.equals("MDDB")) {
                this.DBServerChange(objUserTaskUIVO.getDBServer().get(0), objUserTaskUIVO.getDBName().get(0));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("RuntimeException in User task Handler: " + e));
        }
    }

    public void DBServerChange(String strServerName, String strDBName) {
        try {
            logger.debug((Object)"About to do DBServer Changes: ");
            RandomAccessFile raf = null;
            raf = new RandomAccessFile(ConfigUtil.getValue("DataBaseInfomationFilePath"), "rw");
            long pointer = raf.getFilePointer();
            String strLineData = "";
            while ((strLineData = raf.readLine()) != null) {
                int i;
                int difference;
                String[] tknLineData;
                pointer = raf.getFilePointer() - (long)strLineData.length() - 1L;
                if (pointer == -1L) {
                    pointer = 0L;
                }
                String replacingString = "";
                String newline = System.getProperty("line.separator");
                logger.debug((Object)("Line Data:" + strLineData));
                if (strLineData.indexOf("DBServerName") >= 0) {
                    raf.seek(pointer - 1L);
                    tknLineData = strLineData.split("=", -1);
                    replacingString = String.valueOf(tknLineData[0]) + "=" + strServerName.trim();
                    raf.write(replacingString.getBytes("UTF-8"));
                    if (replacingString.length() < strLineData.length()) {
                        difference = strLineData.length() - replacingString.length() + 1;
                        i = 1;
                        while (i < difference) {
                            raf.writeBytes(" ");
                            ++i;
                        }
                        raf.writeBytes(newline);
                        logger.debug((Object)("DBServerName Changed : " + replacingString));
                    }
                }
                if (strLineData.indexOf("Database") < 0) continue;
                raf.seek(pointer - 1L);
                tknLineData = strLineData.split("=", -1);
                replacingString = String.valueOf(tknLineData[0]) + "=" + strDBName.trim();
                raf.write(replacingString.getBytes("UTF-8"));
                if (replacingString.length() >= strLineData.length()) continue;
                difference = strLineData.length() - replacingString.length() + 1;
                i = 1;
                while (i < difference) {
                    raf.writeBytes(" ");
                    ++i;
                }
                raf.writeBytes(newline);
                logger.debug((Object)("Database Changed : " + replacingString));
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Exception in updateUserSettingsFile method of UIFileHandler Class" + e));
        }
    }

    public void addVehicleMnualEntry(VehicleDetailsUIVO objVehicleDetailsUIVO) {
        List<Object> arrList = new ArrayList();
        try {
            arrList = objVehicleDetailsUIVO.getReminderId();
            logger.debug((Object)(" arrList of reminders for addVehicleManualEnt:" + arrList.size()));
            AccountDetailsXMLParent listAccounts = Application.listAccounts;
            if (listAccounts == null) {
                return;
            }
            AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int j = 0;
                while (j < objAccountsVO.length) {
                    if (objAccountsVO[j].getAccountId() == objVehicleDetailsUIVO.getAccID()) {
                        logger.debug((Object)(" in method addVehicleMnualEntry : " + objAccountsVO[j].getAccountId() + "=" + objVehicleDetailsUIVO.getAccID()));
                        int i = 0;
                        while (i < arrList.size()) {
                            int iReminderID = Integer.parseInt((String)arrList.get(i));
                            ManualEntryDetailsDao objManualEntryDetailsDao = ManualEntryDetailsDao.getInstance();
                            EntityVO objEntityVO = objManualEntryDetailsDao.getVehicleManualEntityDetails(iReminderID);
                            if (Integer.parseInt(objEntityVO.getDeviceType()) == 1 || Integer.parseInt(objEntityVO.getDeviceType()) == 2 || Integer.parseInt(objEntityVO.getDeviceType()) == 4 || Integer.parseInt(objEntityVO.getDeviceType()) == 6 || Integer.parseInt(objEntityVO.getDeviceType()) == 5 || Integer.parseInt(objEntityVO.getDeviceType()) == 7) {
                                this.intimate(null);
                            }
                            if (Integer.parseInt(objEntityVO.getDeviceType()) == 3 || Integer.parseInt(objEntityVO.getDeviceType()) == 6 || Integer.parseInt(objEntityVO.getDeviceType()) == 5 || Integer.parseInt(objEntityVO.getDeviceType()) == 7) {
                                this.intimate(objEntityVO);
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException while adding vehicle manual entry: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while adding vehicle manual entry: ", (Throwable)e);
        }
    }

    public void addDriverManualEntry(DriverDetailsUIVO objDriverDetailsUIVO) throws AuthenticationModuleException {
        EntityVO objEntityVO = new EntityVO();
        ArrayList arrList = new ArrayList();
        try {
            arrList = (ArrayList)objDriverDetailsUIVO.getReminderId();
            AccountDetailsXMLParent listAccounts = Application.listAccounts;
            if (listAccounts == null) {
                return;
            }
            AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int j = 0;
                while (j < objAccountsVO.length) {
                    if (objAccountsVO[j].getAccountId() == objDriverDetailsUIVO.getAccID()) {
                        logger.debug((Object)(" in method addDriverManualEntry : " + objAccountsVO[j].getAccountId() + "=" + objDriverDetailsUIVO.getAccID()));
                        int i = 0;
                        while (i < arrList.size()) {
                            int iReminderID = Integer.parseInt((String)arrList.get(i));
                            ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                            objEntityVO = objReminderListDao.getDriverManualEntityDetails(iReminderID);
                            logger.debug((Object)("Device Type from getDriverManualEntityDetails method" + objEntityVO.getDeviceType()));
                            if (Integer.parseInt(objEntityVO.getDeviceType()) == 1 || Integer.parseInt(objEntityVO.getDeviceType()) == 2 || Integer.parseInt(objEntityVO.getDeviceType()) == 4 || Integer.parseInt(objEntityVO.getDeviceType()) == 6 || Integer.parseInt(objEntityVO.getDeviceType()) == 5 || Integer.parseInt(objEntityVO.getDeviceType()) == 7) {
                                this.intimate(null);
                            }
                            if (Integer.parseInt(objEntityVO.getDeviceType()) == 3 || Integer.parseInt(objEntityVO.getDeviceType()) == 6 || Integer.parseInt(objEntityVO.getDeviceType()) == 5 || Integer.parseInt(objEntityVO.getDeviceType()) == 7) {
                                this.intimate(objEntityVO);
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException while adding driver manual entry: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while adding driver manual entry: ", (Throwable)e);
        }
    }

    public void intimate(EntityVO objEntityVO) {
        try {
            if (objEntityVO == null) {
                logger.debug((Object)"In intimate method... if(objEntityVO==null)...");
                UIFileHandler objUIFileHandler = UIFileHandler.getInstance();
                String strEntityDetails = objUIFileHandler.intimateToSRComm(null);
                logger.debug((Object)("In intimate method...strEntityDetails = " + strEntityDetails));
                CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityDetails, -1, null);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            }
            if (objEntityVO != null) {
                logger.debug((Object)"In intimate method... if(objEntityVO != null)...");
                RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                RemoteServiceVO objRemoteServiceVO = new RemoteServiceVO();
                objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(Integer.parseInt(objEntityVO.getCompanyId()));
                objEntityVO.setCompanyId(null);
                objEntityVO.setDeviceType(null);
                String strXmlTMDL = this.intimateToComm(objEntityVO, objRemoteServiceVO);
                logger.debug((Object)("In intimate method...strXmlTMDL = " + strXmlTMDL));
                CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlTMDL, objRemoteServiceVO.getRemoteServiceId(), objRemoteServiceVO);
                Thread authExecutor = new Thread(intimationTask);
                ExecutorService es = ThreadPool.getThreadPool();
                es.execute(authExecutor);
            }
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException while creating intimation task for TMDL", (Throwable)e);
        }
    }

    public void fileTransfer(FileTransferVO objFileTransferVO) throws Exception {
        String cmdName = objFileTransferVO.getCmdName();
        logger.debug((Object)("Command name : " + cmdName));
        String fileName = objFileTransferVO.getFileName();
        byte[] fileData = objFileTransferVO.getFileData();
        logger.debug((Object)("fileData: " + fileData));
        logger.debug((Object)("fileData Lenght: " + fileData.length));
        FileOutputStream fos = null;
        GZIPInputStream gzis = null;
        try {
            if (cmdName.equalsIgnoreCase("DLOG")) {
                int lenght;
                String serialID = fileName.split("_")[1].split(".")[0];
                gzis = new GZIPInputStream(new ByteArrayInputStream(fileData));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while ((lenght = gzis.read()) != -1) {
                    os.write(lenght);
                }
                String str = os.toString();
                BufferedReader reader = new BufferedReader(new StringReader(str.toString()));
                ArrayList<DiagnosticLogVO> listDiagnosticLogVO = new ArrayList<DiagnosticLogVO>();
                try {
                    String lineRead;
                    while ((lineRead = reader.readLine()) != null) {
                        logger.debug((Object)("lineRead:" + lineRead));
                        String[] tokens = lineRead.split(",");
                        DiagnosticLogVO objDiagnosticLogVO = new DiagnosticLogVO();
                        objDiagnosticLogVO.setSerialID(serialID);
                        objDiagnosticLogVO.setTimeStamp(Integer.parseInt(tokens[0]));
                        objDiagnosticLogVO.setErrorCode(Integer.parseInt(tokens[1]));
                        objDiagnosticLogVO.setErrorType(Integer.parseInt(tokens[2]));
                        listDiagnosticLogVO.add(objDiagnosticLogVO);
                    }
                    DiagnosticLogsDao objDiagnosticLogsDao = DiagnosticLogsDao.getInstance();
                    objDiagnosticLogsDao.saveLogs(listDiagnosticLogVO);
                }
                catch (RuntimeException e) {
                    logger.error((Object)"Exception in reading or writing:", (Throwable)e);
                }
            }
            if (cmdName.equalsIgnoreCase("DDTR")) {
                int len;
                int lenght;
                String strCommand = "reg query \"HKLM\\Software\\RTM\" /v InstallationPath";
                String strRegTempPath = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                String strTempPath = String.valueOf(strRegTempPath) + "\\Common\\TempFolder\\";
                File strTempDir = new File(strTempPath);
                if (!strTempDir.isDirectory()) {
                    strTempDir.mkdir();
                }
                String strTempFileName = String.valueOf(strTempPath) + fileName;
                File sourceFile = new File(strTempFileName);
                fos = new FileOutputStream(sourceFile, false);
                gzis = new GZIPInputStream(new ByteArrayInputStream(fileData));
                ByteArrayOutputStream is = new ByteArrayOutputStream();
                while ((lenght = gzis.read()) != -1) {
                    is.write(lenght);
                }
                byte[] fileDataByteArray = is.toByteArray();
                byte[] uncompressedData = RLEBWTNative.decode(fileDataByteArray, fileDataByteArray.length);
                ByteArrayInputStream bais = new ByteArrayInputStream(uncompressedData);
                byte[] buf = new byte[1024];
                while ((len = bais.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                String strSerialID = objFileTransferVO.getSerialId();
                logger.debug((Object)("objFileTransferVO.getSerialId(): " + objFileTransferVO.getSerialId()));
                logger.debug((Object)("objFileTransferVO.getCmdName(): " + objFileTransferVO.getCmdName()));
                logger.debug((Object)("objFileTransferVO.getFileName(): " + objFileTransferVO.getFileName()));
                logger.debug((Object)("objFileTransferVO.getAccountName(): " + objFileTransferVO.getAccName()));
                boolean fileRenamedSuccessfully = GeneralAPI.renameDownloadedFile(strTempPath, fileName, strSerialID, objFileTransferVO.getAccName());
                if (fileRenamedSuccessfully) {
                    logger.debug((Object)("File renamed successfully:" + fileName));
                } else {
                    logger.debug((Object)("File is not renamed by DLL properly:" + fileName));
                    throw new AuthenticationModuleException("Error While renaming file:2");
                }
            }
            if (cmdName.equalsIgnoreCase("CFUG")) {
                int len;
                fileName = String.valueOf(ConfigUtil.getValue("ConfigPatchesFilePath")) + fileName;
                logger.debug((Object)("fileName " + fileName));
                fos = new FileOutputStream(fileName, false);
                gzis = new GZIPInputStream(new ByteArrayInputStream(fileData));
                byte[] buf = new byte[1024];
                while ((len = gzis.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fos.close();
            }
        }
        catch (AuthenticationModuleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in fileTransfer method of UIFileHandler Class:", (Throwable)ex);
            throw new Exception("Some other Exception:3");
        }
    }

    public void deleteManualEntry(VehicleDetailsUIVO objVechileDetailsUIVO) throws Exception {
        logger.info((Object)"Start process to delete Manual Entry:");
        ArrayList reminderIdList = new ArrayList();
        reminderIdList = (ArrayList)objVechileDetailsUIVO.getReminderId();
        logger.debug((Object)("Number of Entities to be deleted:" + reminderIdList.size()));
        ReminderListDao objReminderListDao = ReminderListDao.getInstance();
        List<EntityVO> arrListEntityVO = objReminderListDao.getDeletedManualRemindersDetails(reminderIdList);
        try {
            AccountDetailsXMLParent listAccounts = Application.listAccounts;
            if (listAccounts == null) {
                return;
            }
            AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int i = 0;
                while (i < objAccountsVO.length) {
                    if (objAccountsVO[i].getAccountId() == objVechileDetailsUIVO.getAccID()) {
                        logger.debug((Object)(" in method deleteManualEntry : " + objAccountsVO[i].getAccountId() + "=" + objVechileDetailsUIVO.getAccID()));
                        int j = 0;
                        while (j < arrListEntityVO.size()) {
                            EntityVO objEntityVO = arrListEntityVO.get(j);
                            if (!(objEntityVO.getDeviceType().equals("") || Integer.parseInt(objEntityVO.getDeviceType()) != 1 && Integer.parseInt(objEntityVO.getDeviceType()) != 2 && Integer.parseInt(objEntityVO.getDeviceType()) != 4 && Integer.parseInt(objEntityVO.getDeviceType()) != 6 && Integer.parseInt(objEntityVO.getDeviceType()) != 5 && Integer.parseInt(objEntityVO.getDeviceType()) != 7)) {
                                this.intimate(null);
                            }
                            if (!(objEntityVO.getDeviceType().equals("") || Integer.parseInt(objEntityVO.getDeviceType()) != 3 && Integer.parseInt(objEntityVO.getDeviceType()) != 6 && Integer.parseInt(objEntityVO.getDeviceType()) != 5 && Integer.parseInt(objEntityVO.getDeviceType()) != 7)) {
                                this.intimate(objEntityVO);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (AuthenticationModuleException amex) {
            throw amex;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception in deleteVehicleDetails method of UIFileHandler : ", (Throwable)ex);
        }
    }

    public String intimateToComm(EntityVO objEntityVO, RemoteServiceVO objRemoteServiceVO) {
        String strEntityDetails = "";
        String strEncryptedFile = "";
        try {
            logger.info((Object)"Intimating Remote Service : ");
            if (objEntityVO != null) {
                logger.debug((Object)("objEntityVO in intimateToComm = " + objEntityVO.toString()));
            }
            String pwdFromFile = "";
            String decryptpwdFromFile = "";
            ArrayList<EntityVO> entityList = new ArrayList<EntityVO>();
            if (objEntityVO != null) {
                entityList.add(objEntityVO);
            }
            DueDownloadVO objDueDownloadVO = new DueDownloadVO();
            objDueDownloadVO.setCmdName("TMDL");
            objDueDownloadVO.setUserName(objRemoteServiceVO.getUserNameRS());
            pwdFromFile = objRemoteServiceVO.getPasswordRS();
            decryptpwdFromFile = GeneralAPI.jumbleString(pwdFromFile);
            objDueDownloadVO.setPassword(decryptpwdFromFile);
            objDueDownloadVO.setAcccountName(GeneralAPI.convertStringToByte(objRemoteServiceVO.getAccountNameRS()));
            objDueDownloadVO.setVersion("2.2");
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("DueDownloadVO");
            objXmlObject.setClassName(DueDownloadVO.class);
            objArr.add(objXmlObject);
            objXmlObject = new XMLObject();
            objXmlObject.setAlias("EntityVO");
            objXmlObject.setClassName(EntityVO.class);
            objArr.add(objXmlObject);
            DueDownloadVO objDueDownloadVO1 = new DueDownloadVO();
            objDueDownloadVO1.setCmdName("TMDL");
            objDueDownloadVO1.setUserName(objRemoteServiceVO.getUserNameRS());
            pwdFromFile = objRemoteServiceVO.getPasswordRS();
            logger.debug((Object)("pwdFromFile:" + pwdFromFile));
            objDueDownloadVO1.setPassword(pwdFromFile);
            objDueDownloadVO1.setAcccountName(GeneralAPI.convertStringToByte(objRemoteServiceVO.getAccountNameRS()));
            objDueDownloadVO1.setVersion("2.2");
            ArrayList<XMLObject> objArr1 = new ArrayList<XMLObject>();
            XMLObject objXmlObject1 = new XMLObject();
            objXmlObject1.setAlias("DueDownloadVO");
            objXmlObject1.setClassName(DueDownloadVO.class);
            objArr1.add(objXmlObject1);
            objXmlObject1 = new XMLObject();
            objXmlObject1.setAlias("EntityVO");
            objXmlObject1.setClassName(EntityVO.class);
            objArr1.add(objXmlObject1);
            objDueDownloadVO.setEntities(entityList.toArray(new EntityVO[0]));
            objDueDownloadVO1.setEntities(entityList.toArray(new EntityVO[0]));
            logger.debug((Object)"Preparing TMDL:");
            strEntityDetails = GeneralAPI.objectToXml(objDueDownloadVO, objArr);
            strEncryptedFile = GeneralAPI.objectToXml(objDueDownloadVO1, objArr1);
            logger.info((Object)"About to send TMDL COMMAND to Remote Service : ");
        }
        catch (Exception e) {
            logger.error((Object)"Exception in intimateToComm method of UIFileHandler Class:", (Throwable)e);
        }
        logger.debug((Object)("Returned strEntityDetails from intimateToComm*** = " + strEncryptedFile));
        return strEntityDetails;
    }

    public String intimateUploadTimeToSRCOMM() {
        String strUploadXML = "";
        logger.info((Object)"Intimating Upload Time To COMM : ");
        try {
            CommandRequestVO objCommandRequestVo = new CommandRequestVO();
            objCommandRequestVo.setCmdName("RESH");
            objCommandRequestVo.setVersion("1.0");
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("CommandRequestVO");
            objXmlObject.setClassName(CommandRequestVO.class);
            objArr.add(objXmlObject);
            strUploadXML = GeneralAPI.objectToXml(objCommandRequestVo, objArr);
        }
        catch (RuntimeException e) {
            logger.error((Object)"RuntimeException while intimating upload time to SR COMM: ", (Throwable)e);
        }
        return strUploadXML;
    }

    public String intimateToSRCommAtServiceStart(EntityVO objEntityVO) {
        String strEntityDetails = "";
        try {
            logger.info((Object)"Preparing xml to intimate Short Range Communicator : ");
            DueDownloadVO objDueDownloadVO = new DueDownloadVO();
            objDueDownloadVO.setCmdName("TMDL");
            objDueDownloadVO.setVersion("servicestart");
            if (objEntityVO != null) {
                ArrayList<EntityVO> entityList = new ArrayList<EntityVO>();
                entityList.add(objEntityVO);
                objDueDownloadVO.setEntities(entityList.toArray(new EntityVO[0]));
            }
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("DueDownloadVO");
            objXmlObject.setClassName(DueDownloadVO.class);
            objArr.add(objXmlObject);
            objXmlObject = new XMLObject();
            objXmlObject.setAlias("EntityVO");
            objXmlObject.setClassName(EntityVO.class);
            objArr.add(objXmlObject);
            strEntityDetails = GeneralAPI.objectToXml(objDueDownloadVO, objArr);
        }
        catch (Exception e) {
            logger.error((Object)"Exception in intimateToSRComm method of UIFileHandler Class", (Throwable)e);
        }
        return strEntityDetails;
    }

    public String intimateToSRComm(EntityVO objEntityVO) {
        String strEntityDetails = "";
        try {
            logger.info((Object)"Preparing xml to intimate Short Range Communicator : ");
            DueDownloadVO objDueDownloadVO = new DueDownloadVO();
            objDueDownloadVO.setCmdName("TMDL");
            objDueDownloadVO.setVersion("2.2");
            if (objEntityVO != null) {
                ArrayList<EntityVO> entityList = new ArrayList<EntityVO>();
                entityList.add(objEntityVO);
                objDueDownloadVO.setEntities(entityList.toArray(new EntityVO[0]));
            }
            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
            XMLObject objXmlObject = new XMLObject();
            objXmlObject.setAlias("DueDownloadVO");
            objXmlObject.setClassName(DueDownloadVO.class);
            objArr.add(objXmlObject);
            objXmlObject = new XMLObject();
            objXmlObject.setAlias("EntityVO");
            objXmlObject.setClassName(EntityVO.class);
            objArr.add(objXmlObject);
            strEntityDetails = GeneralAPI.objectToXml(objDueDownloadVO, objArr);
        }
        catch (Exception e) {
            logger.error((Object)"Exception in intimateToSRComm method of UIFileHandler Class", (Throwable)e);
        }
        return strEntityDetails;
    }

    public ResponseMessage reminderList(ReminderListUIVO objReminderListUIVO) {
        String cmdName = objReminderListUIVO.getCmdName();
        String accountID = objReminderListUIVO.getAccID();
        ResponseMessage responeStatus = new ResponseMessage();
        try {
            String xmlFileName = ConfigUtil.getValue("AccountXMLPath");
            AccountDetailsXMLParent listAccounts = Application.listAccounts;
            if (listAccounts == null) {
                return null;
            }
            try {
                AccountsDetailsXMLChild[] objAccountsVO = listAccounts.getAccounts();
                if (objAccountsVO != null) {
                    int j = 0;
                    while (j < objAccountsVO.length) {
                        if (objAccountsVO[j].getAccountId() == Integer.parseInt(objReminderListUIVO.getAccID())) {
                            if (cmdName.equalsIgnoreCase("RERL") && !commandRERLWorking) {
                                logger.debug((Object)"reminderList........");
                                commandRERLWorking = true;
                                File file = new File(xmlFileName);
                                if (file.exists()) {
                                    int archvMode = -99;
                                    String fileLocation = "";
                                    String cmpnyName = "";
                                    int i = 0;
                                    while (i < objAccountsVO.length) {
                                        if (objAccountsVO[i].getAccountId() == Integer.parseInt(accountID)) {
                                            archvMode = objAccountsVO[i].getArchiveMode();
                                            fileLocation = objAccountsVO[i].getSTISOfficeServer();
                                            cmpnyName = objAccountsVO[i].getSTISOfficeCompany();
                                        } else if (objAccountsVO[i].getAccountId() != Integer.parseInt(accountID)) {
                                            responeStatus.setStatusCode("0");
                                            break;
                                        }
                                        ++i;
                                    }
                                    AccountVO objAccountVO = new AccountVO();
                                    objAccountVO.setAccountId(Integer.parseInt(accountID));
                                    objAccountVO.setArchiveMode(archvMode);
                                    objAccountVO.setSTISOfficeServer(fileLocation);
                                    objAccountVO.setSTISOfficeCompany(cmpnyName);
                                    this.refreshReminderListProcess(objAccountVO, false);
                                    responeStatus.setStatusCode("1");
                                } else if (!file.exists()) {
                                    responeStatus.setStatusCode("0");
                                }
                                UIFileHandler objUIFileHandler = UIFileHandler.getInstance();
                                String strEntityDetails = objUIFileHandler.intimateToSRComm(null);
                                CreateIntimationTask intimationTask = new CreateIntimationTask(strEntityDetails, -1, null);
                                Thread authExecutor = new Thread(intimationTask);
                                ExecutorService es = ThreadPool.getThreadPool();
                                es.execute(authExecutor);
                                commandRERLWorking = false;
                            }
                            if (cmdName.equalsIgnoreCase("RERL") && commandRERLWorking) {
                                RERLAlreadyInProgress = true;
                                logger.debug((Object)"Refresh reminder list process already going on.");
                                throw new AuthenticationModuleException("Refresh reminder list request is already in progress.:22");
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (AuthenticationModuleException e) {
                logger.error((Object)"AuthenticationModuleException in refresh rminder List Method:", (Throwable)e);
                responeStatus.setDescription("Failure");
                responeStatus.setStatusCode("0");
            }
            catch (Exception e) {
                logger.error((Object)"Exception in refresh rminder List Method:", (Throwable)e);
                responeStatus.setDescription("Failure");
                responeStatus.setStatusCode("0");
            }
        }
        finally {
            logger.debug((Object)"In finally");
            if (RERLAlreadyInProgress) {
                RERLAlreadyInProgress = false;
                commandRERLWorking = true;
            } else {
                commandRERLWorking = false;
                logger.debug((Object)"In finally at end");
            }
        }
        return responeStatus;
    }

    public void refreshReminderListProcess(AccountVO objCompanyVO, boolean refreshAtServiceStart) {
        block11: {
            try {
                AuthenticationManager objAuthenticationManager = AuthenticationManager.getAuthenticationManager();
                logger.debug((Object)("Company ID........." + objCompanyVO.getAccountId()));
                int archiveMode = objCompanyVO.getArchiveMode();
                if (archiveMode == 2 || archiveMode == 1) {
                    objAuthenticationManager.fetchDownloadList(objCompanyVO, 1);
                }
                ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                objCompanyVO = objReminderListDao.processXMLtoRefreshReminderList(objCompanyVO);
                logger.debug((Object)("Reminder List modified::" + objCompanyVO.isModifiedRL()));
                RemoteServiceVO objRemoteServiceVO = new RemoteServiceVO();
                EntityVORTM[] arrayEntityVORTM = objCompanyVO.getManualEntities();
                EntityVO[] arrayEntityVO = new EntityVO[arrayEntityVORTM.length];
                EntityVO objEntityVO = new EntityVO();
                int i = 0;
                while (i < arrayEntityVORTM.length) {
                    objEntityVO.setEntityId(GeneralAPI.byteToString(arrayEntityVORTM[i].getEntityId()));
                    objEntityVO.setReminderID(arrayEntityVORTM[i].getReminderID());
                    arrayEntityVO[i] = objEntityVO;
                    ++i;
                }
                if (objCompanyVO.isModifiedRL()) {
                    objAuthenticationManager.sendIntimation(objCompanyVO, true);
                    if ((objCompanyVO.getDeviceType() != 1 || objCompanyVO.getDeviceType() != 2 || objCompanyVO.getDeviceType() != 4 || objCompanyVO.getDeviceType() != 6 || objCompanyVO.getDeviceType() != 5 || objCompanyVO.getDeviceType() != 7) && arrayEntityVO != null && arrayEntityVO.length > 0) {
                        logger.debug((Object)("Number of manual entities:" + arrayEntityVO.length));
                        if (arrayEntityVO.length > 0) {
                            Thread.sleep(1000L);
                            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                            objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceDetails(objCompanyVO.getAccountId());
                            this.sendManualTasksToRS(objRemoteServiceVO, arrayEntityVO);
                        }
                    }
                } else {
                    objRemoteServiceVO = objAuthenticationManager.sendIntimation(objCompanyVO, false);
                    if ((objCompanyVO.getDeviceType() != 1 || objCompanyVO.getDeviceType() != 2 || objCompanyVO.getDeviceType() != 4 || objCompanyVO.getDeviceType() != 6 || objCompanyVO.getDeviceType() != 5 || objCompanyVO.getDeviceType() != 7) && arrayEntityVO != null && arrayEntityVO.length > 0 && objRemoteServiceVO != null) {
                        logger.debug((Object)("Number of manual entities:" + arrayEntityVO.length));
                        if (arrayEntityVO.length > 0) {
                            Thread.sleep(1000L);
                            this.sendManualTasksToRS(objRemoteServiceVO, arrayEntityVO);
                        }
                    }
                }
            }
            catch (AuthenticationModuleException e) {
                logger.error((Object)"AuthenticationModuleException in refresh rminder List Method.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Exception in refresh rminder List Method:", (Throwable)e);
                if (refreshAtServiceStart) break block11;
                logger.error((Object)("Could not refresh reminder list as exception occurred at RTM-Authentication service.:23" + e));
            }
        }
    }

    public void sendManualTasksToRS(RemoteServiceVO objRemoteServiceVO, EntityVO[] arrayEntityVO) {
        try {
            int i = 0;
            while (i < arrayEntityVO.length) {
                EntityVO objEntityVO = new EntityVO();
                logger.debug((Object)("arrayEntityVO[i].getEntityId():" + arrayEntityVO[i].getEntityId()));
                if (arrayEntityVO[i].getEntityId().startsWith("V") || arrayEntityVO[i].getEntityId().startsWith("S")) {
                    ManualEntryDetailsDao objManualEntryDetailsDao = ManualEntryDetailsDao.getInstance();
                    logger.debug((Object)("arrayEntityVO[i].getReminderID():" + arrayEntityVO[i].getReminderID()));
                    logger.debug((Object)("Integer.parseInt(arrayEntityVO[i].getReminderID())" + Integer.parseInt(arrayEntityVO[i].getReminderID())));
                    objEntityVO = objManualEntryDetailsDao.getVehicleManualEntityDetails(Integer.parseInt(arrayEntityVO[i].getReminderID()));
                    logger.debug((Object)("objEntityVO:" + objEntityVO));
                    if (objEntityVO == null) {
                        return;
                    }
                    logger.debug((Object)("objEntityVO.getDeviceType()" + objEntityVO.getDeviceType()));
                } else {
                    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                    objEntityVO = objReminderListDao.getDriverManualEntityDetails(Integer.parseInt(arrayEntityVO[i].getReminderID()));
                    if (objEntityVO == null) {
                        return;
                    }
                    logger.debug((Object)("objEntityVO.getDeviceType()-->" + objEntityVO.getDeviceType()));
                }
                if (Integer.parseInt(objEntityVO.getDeviceType()) == 3 || Integer.parseInt(objEntityVO.getDeviceType()) == 6 || Integer.parseInt(objEntityVO.getDeviceType()) == 5 || Integer.parseInt(objEntityVO.getDeviceType()) == 7) {
                    logger.debug((Object)("inside...device type:" + objEntityVO.getDeviceType()));
                    logger.debug((Object)("Size:" + objRemoteServiceVO));
                    objEntityVO.setCompanyId(null);
                    objEntityVO.setDeviceType(null);
                    objEntityVO.setReminderID(null);
                    String strXmlTMDL = this.intimateToComm(objEntityVO, objRemoteServiceVO);
                    logger.debug((Object)("xml:" + strXmlTMDL));
                    CreateIntimationTask intimationTask = new CreateIntimationTask(strXmlTMDL, objRemoteServiceVO.getRemoteServiceId(), objRemoteServiceVO);
                    Thread authExecutor = new Thread(intimationTask);
                    ExecutorService es = ThreadPool.getThreadPool();
                    es.execute(authExecutor);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Exception in sending manual list task.." + ex));
            ex.printStackTrace();
        }
    }
}

