/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.FailureMessageDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.service.PersistListReader;
import com.sisl.dtco.vo.CommandCMPGData;
import com.sisl.dtco.vo.CommandRequestVO;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.XMLObject;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.tempuri.RemoteServiceVO;
import org.tempuri.ServiceVO;

public class WRCMPRThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(WRCMPRThread.class);
    int iRemoteServiceID;
    RemoteServiceVO objRemoteServiceVO;

    public WRCMPRThread(int iRemoteServiceID) {
        this.iRemoteServiceID = iRemoteServiceID;
    }

    @Override
    public void run() {
        FailureMessageDao objMessageDao;
        boolean bAuthentiacationFailure;
        boolean bAccessFailure;
        block16: {
            bAccessFailure = false;
            bAuthentiacationFailure = false;
            objMessageDao = FailureMessageDao.getInstance();
            try {
                InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
                String strXML = this.createCMPGxml(this.iRemoteServiceID);
                if (strXML != "-1") {
                    try {
                        logger.debug((Object)("Pinging Remote Service ID :" + this.iRemoteServiceID));
                        CommandResponseVO strWRResponse = objInvokeRemoteDevice.sendReceiveRequestToCOMM(strXML, null, this.iRemoteServiceID, this.objRemoteServiceVO);
                        logger.debug((Object)("Remote Service ID=" + this.iRemoteServiceID + "; CMPG Response Command Name is :" + strWRResponse.getCmdName() + "; Status is :" + strWRResponse.getStatus()));
                        if (strWRResponse != null && !strWRResponse.getCmdName().equals("RESP")) {
                            ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                            XMLObject objXmlObject = new XMLObject();
                            objXmlObject.setAlias("CommandResponseVO");
                            objXmlObject.setClassName(CommandResponseVO.class);
                            objArr.add(objXmlObject);
                            String strEntityDetails = GeneralAPI.objectToXml(strWRResponse, objArr);
                            if (strWRResponse.getCmdName().equals("CMPR")) {
                                logger.info((Object)("Received CMPR from Remote Service so going for remote authentication:" + this.iRemoteServiceID));
                                AuthenticationManager objAuthenticationmanager = AuthenticationManager.getAuthenticationManager();
                                objAuthenticationmanager.updateDTCOList(strEntityDetails, this.iRemoteServiceID);
                            } else if (strWRResponse.getCmdName().equals("LAUT")) {
                                logger.info((Object)("Received LAUT from Remote Service so going to update status of local authentications:" + this.iRemoteServiceID));
                                PersistListReader listReader = PersistListReader.getPersistListReader();
                                listReader.processLAUTData(strWRResponse, this.iRemoteServiceID);
                            }
                        } else if (strWRResponse != null && strWRResponse.getCmdName().equals("RESP") && strWRResponse.getStatus() == 1) {
                            bAuthentiacationFailure = true;
                        } else if (strWRResponse != null && strWRResponse.getCmdName().equals("RESP") && strWRResponse.getStatus() == 3) {
                            bAccessFailure = true;
                        }
                        break block16;
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Exception IN CMPG RESPONSE: ", (Throwable)ex);
                        bAccessFailure = true;
                    }
                    break block16;
                }
                logger.error((Object)(" Not able to send CMPG because Download due does not exist for current day." + strXML));
            }
            catch (Exception e) {
                logger.error((Object)"EXCEPTION IN Run Method of Remote Service 1 Pinging Thread ", (Throwable)e);
                bAccessFailure = true;
            }
        }
        try {
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
            int serviceIdAuth = 0;
            int j = 0;
            while (j < objServiceVO.length) {
                listServicesVO.add(objServiceVO[j].getIServiceID());
                ++j;
            }
            serviceIdAuth = (Integer)listServicesVO.get(0);
            objMessageDao.addRSAccessFailure(this.iRemoteServiceID, bAccessFailure, bAuthentiacationFailure, serviceIdAuth);
        }
        catch (Exception exp) {
            logger.error((Object)"Error while adding failure message for RS access.", (Throwable)exp);
        }
    }

    public String createCMPGxml(int iRemoteServiceID) {
        String strXmlString = "-1";
        try {
            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
            this.objRemoteServiceVO = objRemoteServiceDao.getRemoteServiceVO(iRemoteServiceID);
            if (this.objRemoteServiceVO != null) {
                String WRUserName = this.objRemoteServiceVO.getUserNameRS();
                String pwdFromDatabase = this.objRemoteServiceVO.getPasswordRS();
                String WRPassword = GeneralAPI.jumbleString(pwdFromDatabase);
                String WRAccountName = this.objRemoteServiceVO.getAccountNameRS();
                CommandRequestVO objCommandRequestVO = new CommandRequestVO();
                objCommandRequestVO.setVersion("4.0");
                objCommandRequestVO.setCmdName("CMPG");
                CommandCMPGData objCMPGData = new CommandCMPGData();
                objCMPGData.setUserName(WRUserName);
                objCMPGData.setPassword(WRPassword);
                objCMPGData.setAccountName(WRAccountName);
                AuthenticationManager objAuthenticationManager = AuthenticationManager.getAuthenticationManager();
                int companyCardStatus = objAuthenticationManager.getCardStatus(this.objRemoteServiceVO.getCompanyID());
                objCMPGData.setCompanyCardStatus(companyCardStatus);
                objCommandRequestVO.setCommandCMPGData(objCMPGData);
                ArrayList<XMLObject> objArr = new ArrayList<XMLObject>();
                XMLObject objXmlObject = new XMLObject();
                objXmlObject.setAlias("CommandRequestVO");
                objXmlObject.setClassName(CommandRequestVO.class);
                objArr.add(objXmlObject);
                strXmlString = GeneralAPI.objectToXml(objCommandRequestVO, objArr);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception while creating CMPG XML for Remote Service ID:" + iRemoteServiceID + " ; "), (Throwable)e);
        }
        return strXmlString;
    }
}

