/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.fileTransfer.task.FileTransferTask;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.vo.FileTransferStateVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class WRFileTransferThread
extends TimerTask {
    private static final Logger logger = Logger.getLogger(WRFileTransferThread.class);
    int iRemoteServiceID;
    private static HashMap<Integer, Timer> fileTransferTaskHaspMap = new HashMap();

    private WRFileTransferThread(int iRemoteServiceID) {
        this.iRemoteServiceID = iRemoteServiceID;
    }

    @Override
    public void run() {
        FileTransferStateVO objFileTransferStateVO = new FileTransferStateVO();
        objFileTransferStateVO.setRemoteServiceID(this.iRemoteServiceID);
        FileTransferTask fileTransferTask = new FileTransferTask(objFileTransferStateVO);
        Thread fileTransferExecutor = new Thread(fileTransferTask);
        try {
            ExecutorService es = ThreadPool.getThreadPool();
            logger.info((Object)("FileTransferTask initiated for Remote Service ID:" + this.iRemoteServiceID));
            es.execute(fileTransferExecutor);
        }
        catch (RuntimeException e) {
            logger.error((Object)"RuntimeException:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(int iRemoteServiceID) {
        Date objDate = new Date(System.currentTimeMillis());
        try {
            int pollingFrequencyFromConfigFile = Integer.parseInt(ConfigUtil.getValue("CheckingFileDownloadStatusInterval").trim());
            logger.debug((Object)("value recieved from config file:" + pollingFrequencyFromConfigFile));
            int pollingFrequencyFromFile = pollingFrequencyFromConfigFile * 60;
            long pollingFrequency = (long)pollingFrequencyFromFile * 1000L;
            Timer timer = new Timer();
            timer.schedule((TimerTask)new WRFileTransferThread(iRemoteServiceID), objDate, pollingFrequency);
            HashMap<Integer, Timer> hashMap = fileTransferTaskHaspMap;
            synchronized (hashMap) {
                fileTransferTaskHaspMap.put(iRemoteServiceID, timer);
            }
            logger.debug((Object)("FileTransfer Timer scheduled for Remote Service ID:" + iRemoteServiceID));
        }
        catch (NumberFormatException e) {
            logger.error((Object)"NumberFormatException: ", (Throwable)e);
        }
    }

    public static void cancelFileTransferTask(int iRemoteServiceID) {
        try {
            Timer timerCancel = fileTransferTaskHaspMap.get(iRemoteServiceID);
            timerCancel.cancel();
            logger.debug((Object)("File Transfer Timer Cancelled for Remote Service ID:" + iRemoteServiceID));
        }
        catch (RuntimeException e) {
            logger.error((Object)("RuntimeException while cancelling FileTransfer timer for Remote service ID:" + iRemoteServiceID + " :"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTasksNotRequired(List<Integer> listRemoteServiceIDs, String CommandName) {
        try {
            ArrayList<Integer> temp = new ArrayList<Integer>();
            Iterator<Map.Entry<Integer, Timer>> itrFileTransferTaskHaspMap = fileTransferTaskHaspMap.entrySet().iterator();
            if (CommandName == "") {
                while (itrFileTransferTaskHaspMap.hasNext()) {
                    Map.Entry<Integer, Timer> entry = itrFileTransferTaskHaspMap.next();
                    boolean idExists = false;
                    int i = 0;
                    while (i < listRemoteServiceIDs.size()) {
                        if (entry.getKey() == listRemoteServiceIDs.get(i)) {
                            idExists = true;
                            break;
                        }
                        ++i;
                    }
                    if (idExists) continue;
                    WRFileTransferThread.cancelFileTransferTask(entry.getKey());
                    temp.add(entry.getKey());
                }
            } else if (CommandName.equals("DLCY")) {
                int i = 0;
                while (i < listRemoteServiceIDs.size()) {
                    if (fileTransferTaskHaspMap.containsKey(listRemoteServiceIDs.get(i))) {
                        WRFileTransferThread.cancelFileTransferTask(listRemoteServiceIDs.get(i));
                        temp.add(listRemoteServiceIDs.get(i));
                    }
                    ++i;
                }
            }
            HashMap<Integer, Timer> hashMap = fileTransferTaskHaspMap;
            synchronized (hashMap) {
                int j = temp.size() - 1;
                while (j >= 0) {
                    logger.debug((Object)("Removing RS ID:" + temp.get(j)));
                    fileTransferTaskHaspMap.remove(temp.get(j));
                    --j;
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"RuntimeException while Updating remote service file transfer thread hashmap:", (Throwable)e);
        }
    }

    public static void scheduleNewFileTransferTask(int remoteServiceID) {
        if (!fileTransferTaskHaspMap.containsKey(remoteServiceID)) {
            WRFileTransferThread.schedule(remoteServiceID);
        }
    }
}

