/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.integration;

import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.integration.ThreadPool;
import com.sisl.dtco.integration.WRCMPRThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class WRPingingThread
extends TimerTask {
    private static final Logger logger = Logger.getLogger(WRPingingThread.class);
    int iRemoteServiceID;
    private static HashMap<Integer, Timer> pingingTaskHaspMap = new HashMap();

    public WRPingingThread(int iRemoteServiceID) {
        this.iRemoteServiceID = iRemoteServiceID;
    }

    @Override
    public void run() {
        logger.debug((Object)("Pinging Thread working for Remote Service ID:" + this.iRemoteServiceID));
        WRCMPRThread wrTask = new WRCMPRThread(this.iRemoteServiceID);
        Thread wrExecutor = new Thread(wrTask);
        try {
            ExecutorService es = ThreadPool.getThreadPool();
            logger.info((Object)("WR Task initiated for Remote Service ID:" + this.iRemoteServiceID));
            es.execute(wrExecutor);
        }
        catch (RuntimeException e) {
            logger.error((Object)"RuntimeException:", (Throwable)e);
        }
    }

    public static void reschedule(int iRemoteServiceID) {
        try {
            logger.debug((Object)("Pinging Timer Reschedulling for Remote Service ID:" + iRemoteServiceID));
            WRPingingThread.cancelPingingTask(iRemoteServiceID);
            WRPingingThread.schedule(iRemoteServiceID);
        }
        catch (RuntimeException e) {
            logger.error((Object)("RuntimeException while reschedulling pinging timer for Remote service ID:" + iRemoteServiceID + " :"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(int iRemoteServiceID) {
        try {
            Date objDate = new Date(System.currentTimeMillis());
            RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
            String strPollingFrequency = objRemoteServiceDao.getPollingFrequency(iRemoteServiceID);
            logger.debug((Object)("strPollingFrequency in schedule(): " + strPollingFrequency));
            if (strPollingFrequency == null || strPollingFrequency.length() == 0) {
                strPollingFrequency = "1";
            }
            int pollingFrequencySeconds = Integer.parseInt(strPollingFrequency) * 60;
            long pollingFrequencyMilliSeconds = (long)pollingFrequencySeconds * 1000L;
            Timer timer = new Timer();
            timer.schedule((TimerTask)new WRPingingThread(iRemoteServiceID), objDate, pollingFrequencyMilliSeconds);
            logger.debug((Object)("Map size before schedule:" + pingingTaskHaspMap.size()));
            HashMap<Integer, Timer> hashMap = pingingTaskHaspMap;
            synchronized (hashMap) {
                pingingTaskHaspMap.put(iRemoteServiceID, timer);
            }
            logger.debug((Object)("Map size after schedule:" + pingingTaskHaspMap.size()));
            logger.debug((Object)("Pinging Timer scheduled for Remote Service ID:" + iRemoteServiceID));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("NumberFormatException while schedulling pinging timer for Remote service ID:" + iRemoteServiceID + " :"), (Throwable)e);
        }
    }

    public static void cancelPingingTask(int iRemoteServiceID) {
        try {
            Timer timerCancel = pingingTaskHaspMap.get(iRemoteServiceID);
            timerCancel.cancel();
            logger.debug((Object)("Pinging Timer Cancelled for Remote Service ID:" + iRemoteServiceID));
        }
        catch (RuntimeException e) {
            logger.error((Object)("RuntimeException while cancelling pinging timer for Remote service ID:" + iRemoteServiceID + " :"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTasksNotRequired(List<Integer> listRemoteServiceIDs, String CommandName) {
        try {
            ArrayList<Integer> temp = new ArrayList<Integer>();
            Iterator<Map.Entry<Integer, Timer>> itrPingingTaskHaspMap = pingingTaskHaspMap.entrySet().iterator();
            if (CommandName == "") {
                while (itrPingingTaskHaspMap.hasNext()) {
                    Map.Entry<Integer, Timer> entry = itrPingingTaskHaspMap.next();
                    boolean idExists = false;
                    int i = 0;
                    while (i < listRemoteServiceIDs.size()) {
                        if (entry.getKey() == listRemoteServiceIDs.get(i)) {
                            idExists = true;
                            break;
                        }
                        ++i;
                    }
                    if (idExists) continue;
                    WRPingingThread.cancelPingingTask(entry.getKey());
                    temp.add(entry.getKey());
                }
            } else if (CommandName.equals("DLCY")) {
                int i = 0;
                while (i < listRemoteServiceIDs.size()) {
                    if (pingingTaskHaspMap.containsKey(listRemoteServiceIDs.get(i))) {
                        WRPingingThread.cancelPingingTask(listRemoteServiceIDs.get(i));
                        temp.add(listRemoteServiceIDs.get(i));
                    }
                    ++i;
                }
            }
            HashMap<Integer, Timer> hashMap = pingingTaskHaspMap;
            synchronized (hashMap) {
                int j = temp.size() - 1;
                while (j >= 0) {
                    logger.debug((Object)("Removing RS ID:" + temp.get(j)));
                    pingingTaskHaspMap.remove(temp.get(j));
                    --j;
                }
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"RuntimeException while Updating remote service pinging thread hashmap:", (Throwable)e);
        }
    }

    public static void scheduleNewPingingTask(int remoteServiceID) {
        if (!pingingTaskHaspMap.containsKey(remoteServiceID)) {
            WRPingingThread.schedule(remoteServiceID);
        }
    }
}

