/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.service;

import com.sisl.card.interactor.SmartCardCtl;
import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.ReadRegistry;
import com.sisl.dtco.appl.Application;
import com.sisl.dtco.dao.FailureMessageDao;
import com.sisl.dtco.dao.GeneralDao;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.AccountsDetailsXMLChild;
import org.tempuri.BackgroundServiceSetting;
import org.tempuri.ServiceVO;

public class GeneralFailureMessageService
extends Thread {
    boolean ServiceStarted = false;
    static boolean bFetchAuthLogFlag = false;
    static boolean bResetAuthFlag = false;
    private static final Logger logger = Logger.getLogger(GeneralFailureMessageService.class);
    List<String> fileList;
    String SOURCE_FOLDER_AuthLog;
    String SOURCE_FOLDER_CommonLog;
    String OUTPUT_ZIP_FILE;
    String strCommand = "";
    String uploadDirectory;
    File folderToSaveWCFFile;
    static long fromDateTime;
    static long toDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.debug((Object)"Thread Started GeneralFailureMessageService.........");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.debug((Object)"InterruptedException :");
        }
        while (true) {
            FileOutputStream fout = null;
            this.SOURCE_FOLDER_AuthLog = " ";
            this.SOURCE_FOLDER_CommonLog = " ";
            this.OUTPUT_ZIP_FILE = " ";
            this.strCommand = " ";
            this.uploadDirectory = " ";
            this.folderToSaveWCFFile = null;
            this.fileList = new ArrayList<String>();
            try {
                try {
                    ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
                    int serviceIdAuth = 0;
                    int serviceTypeID = 0;
                    int i = 0;
                    while (i < objServiceVO.length) {
                        if (objServiceVO[i].getSServiceTypeId() == 2) {
                            serviceIdAuth = objServiceVO[i].getIServiceID();
                            serviceTypeID = objServiceVO[i].getSServiceTypeId();
                            break;
                        }
                        ++i;
                    }
                    logger.debug((Object)("serviceIdAuth passed:" + serviceIdAuth + " serviceTypeID:" + serviceTypeID));
                    logger.debug((Object)("bResetAuthFlag:   " + bResetAuthFlag));
                    BackgroundServiceSetting objSettings = FailureMessageDao.getInstance().clearMessage_1b3(serviceTypeID, this.ServiceStarted, serviceIdAuth, bResetAuthFlag, bFetchAuthLogFlag);
                    bFetchAuthLogFlag = objSettings.isFetchAuthLogs();
                    logger.debug((Object)("value of flag in updateStatus method: " + bFetchAuthLogFlag));
                    String authLogFileName = null;
                    if (bFetchAuthLogFlag) {
                        fromDateTime = objSettings.getRequestStart().longValue();
                        toDate = objSettings.getRequestEnd().longValue();
                        logger.debug((Object)("bFetchAuthLogFlag value : " + bFetchAuthLogFlag + " fromDateTime: " + fromDateTime + " toDate: " + toDate));
                        if (System.getProperty("os.arch").equals("x86")) {
                            this.strCommand = "reg query \"HKEY_Local_Machine\\Software\\RTMWeb\" /v InstallationPath";
                            this.uploadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(this.strCommand);
                        } else {
                            this.strCommand = "reg query \"HKEY_Local_Machine\\Software\\Wow6432Node\\RTMWeb\" /v InstallationPath";
                            this.uploadDirectory = ReadRegistry.getCurrentUserPersonalFolderPath(this.strCommand);
                        }
                        this.SOURCE_FOLDER_AuthLog = String.valueOf(this.uploadDirectory) + "\\AuthModule\\logs";
                        this.SOURCE_FOLDER_CommonLog = String.valueOf(this.uploadDirectory) + "\\Common\\WebLogs";
                        this.folderToSaveWCFFile = new File(String.valueOf(this.SOURCE_FOLDER_AuthLog) + "//" + "WCFLogs.txt");
                        logger.debug((Object)("WCF folder path:  " + this.folderToSaveWCFFile + "folderToSaveWCFFile.isDirectory(): " + this.folderToSaveWCFFile.isDirectory()));
                        File dir1 = new File(this.SOURCE_FOLDER_AuthLog);
                        File dir2 = new File(this.SOURCE_FOLDER_CommonLog);
                        if (dir2.isDirectory()) {
                            String[] files = dir2.list();
                            File file = dir2;
                            synchronized (file) {
                                String[] stringArray = files;
                                int n = files.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String file2 = stringArray[n2];
                                    String pathToPicFile = String.valueOf(dir2.getAbsolutePath()) + "\\" + file2;
                                    logger.debug((Object)("After copying log files pathToPicFile :: " + pathToPicFile));
                                    logger.debug((Object)("Path for dir1 :: " + dir1.getAbsolutePath()));
                                    try {
                                        Files.copy(new File(pathToPicFile).toPath(), this.folderToSaveWCFFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                        logger.debug((Object)("folderToSaveWCFFile.toPath():::  " + this.folderToSaveWCFFile.toPath()));
                                        logger.debug((Object)("pathToPicFile::: " + pathToPicFile));
                                    }
                                    catch (IOException ioe) {
                                        ioe.printStackTrace();
                                        logger.error((Object)("IO Exception in File.copy ::::: " + ioe.getMessage()));
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        logger.error((Object)("Exception in FileUtils.copy ::::::::: " + e.getMessage()));
                                    }
                                    ++n2;
                                }
                            }
                        }
                        SimpleDateFormat df = new SimpleDateFormat("dd_MM_yy HH_mm");
                        Date dateobj = new Date();
                        String localHost = InetAddress.getLocalHost().getHostName();
                        authLogFileName = String.valueOf(localHost) + "_" + serviceIdAuth + "_" + "AuthLog" + "_" + df.format(dateobj) + ".zip";
                        this.OUTPUT_ZIP_FILE = String.valueOf(this.uploadDirectory) + "\\AuthModule\\" + authLogFileName;
                        logger.debug((Object)("authLogFileName Name  =  " + authLogFileName));
                        logger.debug((Object)("OUTPUT_ZIP_FILE Name in GeneralFailureMessageService: " + this.OUTPUT_ZIP_FILE));
                        this.generateFileList(new File(this.SOURCE_FOLDER_AuthLog));
                        this.zipIt(this.OUTPUT_ZIP_FILE);
                        byte[] authLog = GeneralFailureMessageService.readZipFile(this.OUTPUT_ZIP_FILE);
                        boolean isFIleUploaded = false;
                        if (authLog != null) {
                            isFIleUploaded = GeneralDao.getInstance().UploadFile(serviceIdAuth, authLogFileName, "AUTH", authLog);
                            logger.debug((Object)("\n***** IS AUTHLog File successfully uploaded On Server*****" + isFIleUploaded));
                        }
                        if (!bResetAuthFlag) {
                            bResetAuthFlag = true;
                            logger.debug((Object)("After uploading File : bResetAuthLogFlag::   " + bResetAuthFlag));
                        }
                        if (isFIleUploaded || authLog == null) {
                            this.deleteZipFile(this.OUTPUT_ZIP_FILE);
                            logger.debug((Object)"Auth LOG Folder is Deleted After uploading on Server.....");
                        }
                    } else {
                        bResetAuthFlag = false;
                    }
                    this.ServiceStarted = true;
                    this.checkCardReader();
                    this.checkTisOffice();
                    int sleepTime = GeneralDao.getAuthRTMMessageIntervalSec();
                    long longSleepTime = (long)sleepTime * 1000L;
                    Thread.sleep(longSleepTime);
                }
                catch (Exception ex) {
                    logger.debug((Object)("Exception in Failure Message thread:" + ex));
                    if (fout == null) continue;
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        logger.debug((Object)e.getMessage());
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        logger.debug((Object)e.getMessage());
                    }
                }
                throw throwable;
            }
            if (fout == null) continue;
            try {
                fout.close();
                continue;
            }
            catch (IOException e) {
                logger.debug((Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public static String mergeTwoDirectories(File dir1, File dir2) {
        File[] files;
        String targetDirPath = dir1.getAbsolutePath();
        File[] fileArray = files = dir2.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.renameTo(new File(String.valueOf(targetDirPath) + File.separator + file.getName()));
            ++n2;
        }
        return targetDirPath;
    }

    public void zipIt(String zipFile) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            File zip = new File(zipFile);
            for (String file : this.fileList) {
                int len;
                if (zip.length() >= 0x200000L) {
                    logger.debug((Object)"Zip file is exceeding 2 MB.. breaking!!");
                    break;
                }
                logger.debug((Object)("Auth File to Be Zipped : " + file));
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(String.valueOf(this.SOURCE_FOLDER_AuthLog) + File.separator + file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.flush();
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            logger.debug((Object)("Exception while Zipping Auth File:  " + ex));
        }
    }

    public void generateFileList(File node) {
        if (node.isFile() && (node.getName().startsWith("AuthenticationModule") || node.getName().startsWith("wrapper")) || node.getName().startsWith("WCFLogs")) {
            this.fileList.add(this.generateZipEntry(node.getAbsoluteFile().toString()));
        }
        if (node.isDirectory() && node.getName().startsWith("logs")) {
            String[] subNote;
            ArrayList<String> fList = null;
            final ArrayList<File> latestLogFileNameList = new ArrayList<File>();
            try {
                FileFilter filter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (!file.isFile()) {
                            return false;
                        }
                        long lastModified = file.lastModified();
                        if (fromDateTime <= lastModified && toDate >= lastModified) {
                            return true;
                        }
                        if (lastModified >= toDate) {
                            latestLogFileNameList.add(file);
                        }
                        return false;
                    }
                };
                File[] myFiles = node.listFiles(filter);
                Arrays.sort(myFiles, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
                logger.debug((Object)("latestLogFileNameList.size() " + latestLogFileNameList.size()));
                File[] latestLogFileNameArray = latestLogFileNameList.toArray(new File[latestLogFileNameList.size()]);
                Arrays.sort(latestLogFileNameArray, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
                boolean isLatestAuthLogFileAdded = false;
                boolean isLatestWrapperLogFileAdded = false;
                boolean isLatestWCFLogFileAdded = false;
                latestLogFileNameList.clear();
                File[] fileArray = latestLogFileNameArray;
                int n = latestLogFileNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!isLatestAuthLogFileAdded && file.getName().startsWith("AuthenticationModule")) {
                        isLatestAuthLogFileAdded = true;
                        latestLogFileNameList.add(file);
                    } else if (!isLatestWrapperLogFileAdded && file.getName().startsWith("wrapper")) {
                        isLatestWrapperLogFileAdded = true;
                        latestLogFileNameList.add(file);
                    } else {
                        if (isLatestWCFLogFileAdded || !file.getName().startsWith("WCFLogs")) break;
                        isLatestWCFLogFileAdded = true;
                        latestLogFileNameList.add(file);
                    }
                    ++n2;
                }
                File[] finalmyFile = new File[myFiles.length + latestLogFileNameList.size()];
                int i = 0;
                while (i < myFiles.length) {
                    finalmyFile[i] = myFiles[i];
                    ++i;
                }
                i = 0;
                int j = myFiles.length;
                while (i < latestLogFileNameList.size()) {
                    finalmyFile[j] = (File)latestLogFileNameList.get(i);
                    ++i;
                    ++j;
                }
                logger.debug((Object)("No. of Filtered Files as per time frame: " + finalmyFile.length));
                long sizeCounter = 0L;
                fList = new ArrayList<String>();
                File[] fileArray2 = finalmyFile;
                int n3 = finalmyFile.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    if (sizeCounter + file.length() > 0x3200000L) break;
                    fList.add(file.getName());
                    sizeCounter += file.length();
                    ++n4;
                }
                logger.debug((Object)("No. of Filtered Files as per size: " + fList.size()));
            }
            catch (Exception e) {
                fList = null;
                logger.error((Object)("Exception in Filtering process: " + ConfigUtil.getStackTraceAsString(e)));
            }
            String[] stringArray = subNote = fList != null ? fList.toArray(new String[fList.size()]) : node.list();
            int n = subNote.length;
            int n5 = 0;
            while (n5 < n) {
                String filename = stringArray[n5];
                this.generateFileList(new File(node, filename));
                ++n5;
            }
        }
    }

    private String generateZipEntry(String file) {
        return file.substring(this.SOURCE_FOLDER_AuthLog.length() + 1, file.length());
    }

    public void deleteZipFile(String zipFilePath) {
        File zipFile = new File(zipFilePath);
        zipFile.delete();
        logger.debug((Object)("File is Deleted From the path " + this.OUTPUT_ZIP_FILE));
    }

    public static byte[] readZipFile(String OUTPUT_ZIP_FILE) {
        FileInputStream fileInputStream = null;
        File file = new File(OUTPUT_ZIP_FILE);
        byte[] bFile = new byte[(int)file.length()];
        try {
            fileInputStream = new FileInputStream(OUTPUT_ZIP_FILE);
            fileInputStream.read(bFile);
            fileInputStream.close();
        }
        catch (Exception e) {
            logger.debug((Object)("read zipFile for Auth Logs:  " + e.getMessage()));
        }
        return bFile;
    }

    public void checkCardReader() {
        logger.debug((Object)"Checking card reader and valid company card.....");
        try {
            SmartCardCtl objSmartCardCtl = SmartCardCtl.getInstance();
            int terminalCount = objSmartCardCtl.getTerminalCount();
            logger.debug((Object)("Terminal Count:" + terminalCount));
            ServiceVO[] objServiceVO = Application.objServiceInfo.getServices();
            ArrayList<Integer> listServicesVO = new ArrayList<Integer>();
            int serviceIdAuth = 0;
            int i = 0;
            while (i < objServiceVO.length) {
                listServicesVO.add(objServiceVO[i].getIServiceID());
                ++i;
            }
            serviceIdAuth = (Integer)listServicesVO.get(0);
            if (terminalCount > 0) {
                logger.debug((Object)("Service id of auth for addFailureMessageCardNotPresent:" + serviceIdAuth));
                FailureMessageDao.getInstance().addFailureMessageCardNotPresent(String.valueOf(serviceIdAuth));
                String strCardNotRead = "";
                int numberOfTerminals = SmartCardCtl.listCardNotRead.size();
                logger.debug((Object)("Number of terminals having wrong card:" + numberOfTerminals));
                int i2 = 0;
                while (i2 < numberOfTerminals) {
                    String strTerminalName = (String)SmartCardCtl.listCardNotRead.get(i2);
                    logger.debug((Object)("Terminal from which card not read." + strTerminalName));
                    strCardNotRead = strCardNotRead.equals("") ? strTerminalName : String.valueOf(strCardNotRead) + "," + strTerminalName;
                    ++i2;
                }
                if (numberOfTerminals > 0) {
                    FailureMessageDao.getInstance().addFailureMessageCardNotRead(strCardNotRead, serviceIdAuth);
                }
            } else {
                logger.debug((Object)"failure msg for code 4");
                FailureMessageDao.getInstance().addGenralMessage(serviceIdAuth, "4", "", "");
            }
            int weeks = Integer.parseInt(ConfigUtil.getValue("CompanyCardExpiryPeriod"));
            String strAcc = "";
            AccountsDetailsXMLChild[] objAccountsVO = Application.listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int i3 = 0;
                while (i3 < objAccountsVO.length) {
                    strAcc = strAcc.equals("") ? String.valueOf(objAccountsVO[i3].getAccountId()) : String.valueOf(strAcc) + "#" + objAccountsVO[i3].getAccountId();
                    ++i3;
                }
            }
            FailureMessageDao.getInstance().addFailureMessageCardExpiry(weeks, strAcc);
        }
        catch (Exception e) {
            logger.debug((Object)("Exception in checking card reader:" + e));
        }
    }

    public void checkTisOffice() {
        logger.debug((Object)"Checking Tis-Office location access......");
        try {
            String strdownloadLocationTO = "";
            ArrayList<AccountVO> arListOfUrl = new ArrayList<AccountVO>();
            String sFailURLs = "";
            String sSuccessURLs = "";
            AccountsDetailsXMLChild[] objAccountsVO = Application.listAccounts.getAccounts();
            if (objAccountsVO != null) {
                int i = 0;
                while (i < objAccountsVO.length) {
                    if (objAccountsVO[i].getArchiveMode() == 2) {
                        AccountVO acc = new AccountVO();
                        acc.setAccountName(objAccountsVO[i].getAccountName());
                        acc.setSTISOfficeServer(objAccountsVO[i].getSTISOfficeServer());
                        arListOfUrl.add(acc);
                    }
                    ++i;
                }
            }
            if (arListOfUrl != null && !arListOfUrl.isEmpty()) {
                int iCounter = 0;
                while (iCounter < arListOfUrl.size()) {
                    File f1 = null;
                    File f2 = null;
                    String strFile1 = "";
                    String strFile2 = "";
                    boolean DLListLocationExist = false;
                    boolean UPListLocationExist = false;
                    strdownloadLocationTO = ((AccountVO)arListOfUrl.get(iCounter)).getSTISOfficeServer();
                    logger.debug((Object)("Location of Tis-Office strdownloadLocationTO: " + strdownloadLocationTO));
                    String hostName = InetAddress.getLocalHost().getHostName();
                    logger.debug((Object)("Machine Name:" + hostName));
                    String hostIP = InetAddress.getLocalHost().getHostAddress();
                    logger.debug((Object)("Machine IP:" + hostIP));
                    if (strdownloadLocationTO.equalsIgnoreCase("\\\\" + hostName) || strdownloadLocationTO.equalsIgnoreCase("\\\\" + hostIP)) {
                        String strCommand = "";
                        String officeLocation = "";
                        strCommand = "reg query \"HKLM\\Software\\VDO\\TisOffice\\Common\" /v TisOfficeService_HOME";
                        officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                        if (officeLocation == null || officeLocation.equals("")) {
                            strCommand = "reg query \"HKLM\\Software\\Siemens VDO Trading\\TisOffice\\Common\" /v TisOfficeService_HOME";
                            officeLocation = ReadRegistry.getCurrentUserPersonalFolderPath(strCommand);
                        }
                        logger.debug((Object)("Location of Tis-Office officeLocation: " + officeLocation));
                        strFile1 = String.valueOf(officeLocation) + "\\DLListLocation";
                        strFile2 = String.valueOf(officeLocation) + "\\UPListLocation";
                    } else {
                        strFile1 = String.valueOf(strdownloadLocationTO) + "\\DLListLocation";
                        strFile2 = String.valueOf(strdownloadLocationTO) + "\\UPListLocation";
                    }
                    f1 = new File(strFile1);
                    f2 = new File(strFile2);
                    DLListLocationExist = f1.exists();
                    UPListLocationExist = f2.exists();
                    logger.debug((Object)("DLListLocation folder exists:" + DLListLocationExist));
                    logger.debug((Object)("UPListLocation folder exists:" + UPListLocationExist));
                    if (DLListLocationExist && UPListLocationExist) {
                        logger.debug((Object)"DLListLocation and UPListLocation folders exist.");
                    } else {
                        sFailURLs = String.valueOf(sFailURLs) + "," + ((AccountVO)arListOfUrl.get(iCounter)).getAccountId() + ":" + strdownloadLocationTO;
                    }
                    ++iCounter;
                }
            }
            if (sSuccessURLs.length() > 1) {
                sSuccessURLs = sSuccessURLs.substring(1, sSuccessURLs.length());
                logger.debug((Object)("sSuccessURLs::: " + sSuccessURLs));
                FailureMessageDao.getInstance().addSuccessMessageTISOfficeURL(sSuccessURLs);
            }
            if (sFailURLs.length() > 1) {
                sFailURLs = sFailURLs.substring(1, sFailURLs.length());
                logger.debug((Object)("FailURLs::: " + sFailURLs));
                FailureMessageDao.getInstance().addFailureMessageTISOfficeURL(sFailURLs);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Exception in checking Tis-Office location:" + e));
        }
    }
}

