/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.service;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.dao.CompanyDao;
import com.sisl.dtco.dao.DTCOFileTransferStatusDao;
import com.sisl.dtco.dao.DriverDetailsDao;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.dao.RemoteServiceDao;
import com.sisl.dtco.dao.VehicleDetailsDao;
import com.sisl.dtco.integration.WRPingingThread;
import com.sisl.dtco.vo.CommandLAUTData;
import com.sisl.dtco.vo.CommandLocalAuthenticationsData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import org.apache.log4j.Logger;
import org.tempuri.AccountVO;
import org.tempuri.FileTransferStatusVO;

public class PersistListReader {
    static PersistListReader instance = new PersistListReader();
    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
    int reminderId = 0;
    private static final Logger logger = Logger.getLogger(PersistListReader.class);

    public static PersistListReader getPersistListReader() {
        if (instance == null) {
            instance = new PersistListReader();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    public synchronized boolean addLineInFile(String strFileName, String strAdd) throws IOException {
        boolean lineAdded = false;
        FileOutputStream fout = null;
        Writer out = null;
        try {
            try {
                fout = new FileOutputStream(strFileName, true);
                out = new OutputStreamWriter((OutputStream)fout, "UTF8");
                out.write(strAdd);
                lineAdded = true;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"FileNotFoundException in addLineInFile mwthod of PaersistListReader class::", (Throwable)e);
                if (out != null) {
                    out.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (UnsupportedEncodingException e) {
                block16: {
                    logger.error((Object)"UnsupportedEncodingException in addLineInFile mwthod of PaersistListReader class::", (Throwable)e);
                    if (out == null) break block16;
                    out.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                block17: {
                    logger.error((Object)"IOException in addLineInFile method of PaersistListReader class::", (Throwable)e);
                    if (out == null) break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    out.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
        return lineAdded;
    }

    public void processLAUTData(CommandResponseVO commandResponseVO, int iRemoteServiceID) {
        CommandLocalAuthenticationsData objCommandLocalAuthenticationsData = commandResponseVO.getCommandLocalAuthenticationsData();
        CommandLAUTData[] localAuthenticationDatas = objCommandLocalAuthenticationsData.getLocalAuthentications();
        int j = 0;
        while (j < localAuthenticationDatas.length) {
            CommandLAUTData objCommandLAUTData = localAuthenticationDatas[j];
            String vrn = objCommandLAUTData.getVehicleRegistrationNumber();
            String coDriverCardNumber = objCommandLAUTData.getCoDriverCardNumber();
            String driverCardNumber = objCommandLAUTData.getDriverCardNumber();
            String strStatus = objCommandLAUTData.getStatus();
            logger.debug((Object)("Length of status is : " + strStatus.length()));
            if (strStatus.length() != 4) {
                logger.debug((Object)("Length of status is : " + strStatus.length() + " :Hence returning"));
                return;
            }
            int[] status = new int[4];
            int k = 0;
            while (k < 4) {
                Character c = new Character(strStatus.charAt(k));
                String s = c.toString();
                status[k] = Integer.parseInt(s);
                ++k;
            }
            DTCOCommandVO objDTCOCommandVO = new DTCOCommandVO();
            objDTCOCommandVO.setRemoteDeviceSerialNumber(objCommandLAUTData.getSerialId());
            objDTCOCommandVO.setRemoteServiceID(iRemoteServiceID);
            objDTCOCommandVO.setRetryCount(0);
            objDTCOCommandVO.setFailureCode(Byte.parseByte("0"));
            objDTCOCommandVO.setTimeStamp(objCommandLAUTData.getTimeStamp());
            Date reminderDate = new Date((long)GeneralAPI.getCurrentDateTimeInt() * 1000L);
            logger.debug((Object)("ReminderDate" + reminderDate));
            objDTCOCommandVO.setReminderDate(reminderDate);
            int i = 0;
            while (i < 4) {
                if (i == 0) {
                    objDTCOCommandVO.setStatus(status[i]);
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(driverCardNumber));
                    this.handleDriverStatus(objDTCOCommandVO);
                } else if (i == 1) {
                    objDTCOCommandVO.setStatus(status[i]);
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(coDriverCardNumber));
                    this.handleDriverStatus(objDTCOCommandVO);
                } else if (i == 2) {
                    objDTCOCommandVO.setStatus(status[i]);
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(vrn));
                    this.handleMassMemoryStatus(objDTCOCommandVO);
                } else if (i == 3) {
                    objDTCOCommandVO.setStatus(status[i]);
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(vrn));
                    this.handleSpecialDataStatus(objDTCOCommandVO);
                }
                ++i;
            }
            ++j;
        }
        if (iRemoteServiceID != -1) {
            WRPingingThread.reschedule(iRemoteServiceID);
        }
    }

    private void handleDriverStatus(DTCOCommandVO objDTCOCommandVO) {
        block24: {
            logger.debug((Object)("Handle driver status with entityId:" + objDTCOCommandVO.getEntityId()));
            int status = objDTCOCommandVO.getStatus();
            boolean driverFound = false;
            try {
                String entityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
                if (entityId != null && !entityId.trim().equals("")) {
                    entityId = "D" + entityId.trim();
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                    objDTCOCommandVO = objRemoteServiceDao.getRemoteServiceCompany(objDTCOCommandVO);
                    FileTransferStatusVO objFileTransferStatusVO = new FileTransferStatusVO();
                    if (objDTCOCommandVO.getDldType() == 1 || objDTCOCommandVO.getDldType() == 2) {
                        objDTCOCommandVO.setDldType(3);
                    }
                    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                    int statusCheck = 0;
                    objFileTransferStatusVO = objReminderListDao.getEntityName(objDTCOCommandVO.getReminderDate(), objDTCOCommandVO.getCompanyID(), entityId, statusCheck);
                    DTCOFileTransferStatusDao objDTCOFileTransferStatusDao = DTCOFileTransferStatusDao.getInstance();
                    objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    objFileTransferStatusVO.setSerialId(objDTCOCommandVO.getRemoteDeviceSerialNumber());
                    objFileTransferStatusVO.setInitTimeStamp(Integer.toString(objDTCOCommandVO.getTimeStamp()));
                    objFileTransferStatusVO.setDldType(objDTCOCommandVO.getDldType());
                    objFileTransferStatusVO.setCompanyID(objDTCOCommandVO.getCompanyID());
                    if (objFileTransferStatusVO.getReminderID() == 0) {
                        DriverDetailsDao objDriverDetailsDao = DriverDetailsDao.getInstance();
                        driverFound = objDriverDetailsDao.checkEntryinDriverDetails(entityId.substring(1), objDTCOCommandVO.getCompanyID());
                    }
                    logger.debug((Object)("driver status received is: " + status));
                    if (status == 3 || status == 9) {
                        return;
                    }
                    if (status == 2) {
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            objDTCOCommandVO.setStatus(7);
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(1);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (driverFound) {
                                logger.info((Object)("Not a new driver:" + entityId));
                                return;
                            }
                            logger.debug((Object)"New driver so going to add mass memory status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding driver reminder: ", (Throwable)e);
                            }
                        }
                        break block24;
                    }
                    if (status == 1) {
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            objDTCOCommandVO.setStatus(5);
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(0);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (driverFound) {
                                logger.info((Object)("Not a new driver:" + entityId));
                                return;
                            }
                            logger.debug((Object)"New driver so going to add mass memory status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding driver reminder: ", (Throwable)e);
                            }
                        }
                        break block24;
                    }
                    if (status != 0) break block24;
                    objDTCOCommandVO.setStatus(6);
                    if (objFileTransferStatusVO.getReminderID() != 0) {
                        logger.debug((Object)("going to update driver status with entityId:" + objDTCOCommandVO.getEntityId()));
                        objDTCOCommandVO.setAuthType(0);
                        objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                        objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                        objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                        objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                        objFileTransferStatusVO.setAuthType(0);
                        objFileTransferStatusVO = objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        if (objFileTransferStatusVO.getUpdatedStatus() == -1) {
                            objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                        }
                        break block24;
                    }
                    if (driverFound) {
                        logger.info((Object)("Not a new driver:" + entityId));
                        return;
                    }
                    logger.debug((Object)"New driver so going to add mass memory status ");
                    try {
                        this.reminderId = objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception while adding driver reminder: ", (Throwable)e);
                    }
                    objFileTransferStatusVO.setAuthType(0);
                    objFileTransferStatusVO.setEntityName(GeneralAPI.convertStringToByte("Unknown"));
                    objFileTransferStatusVO.setReminderID(this.reminderId);
                    objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                    break block24;
                }
                logger.error((Object)"entityId received is null");
                return;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("NumberFormatException while handling driver entity:" + e));
            }
            catch (Exception e) {
                logger.error((Object)("Exception while handling driver entity:" + e));
            }
        }
    }

    private void handleMassMemoryStatus(DTCOCommandVO objDTCOCommandVO) {
        block24: {
            logger.debug((Object)("Handle mass memory status with entityId:" + objDTCOCommandVO.getEntityId()));
            int status = objDTCOCommandVO.getStatus();
            boolean vehicleFound = false;
            try {
                String entityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
                if (entityId != null && !entityId.trim().equals("")) {
                    entityId = entityId.trim();
                    entityId = "V" + entityId;
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                    RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                    objDTCOCommandVO = objRemoteServiceDao.getRemoteServiceCompany(objDTCOCommandVO);
                    logger.debug((Object)("values:" + objDTCOCommandVO.getReminderDate() + " " + objDTCOCommandVO.getCompanyID() + " " + entityId));
                    int statusCheck = 0;
                    FileTransferStatusVO objFileTransferStatusVO = objReminderListDao.getEntityName(objDTCOCommandVO.getReminderDate(), objDTCOCommandVO.getCompanyID(), entityId, statusCheck);
                    logger.debug((Object)(" after dao  entity name:" + objFileTransferStatusVO.getEntityName()));
                    DTCOFileTransferStatusDao objDTCOFileTransferStatusDao = DTCOFileTransferStatusDao.getInstance();
                    objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    objFileTransferStatusVO.setSerialId(objDTCOCommandVO.getRemoteDeviceSerialNumber());
                    objFileTransferStatusVO.setInitTimeStamp(Integer.toString(objDTCOCommandVO.getTimeStamp()));
                    objFileTransferStatusVO.setCompanyID(objDTCOCommandVO.getCompanyID());
                    objFileTransferStatusVO.setDldType(objDTCOCommandVO.getDldType());
                    if (objDTCOCommandVO.getDldType() == 1 || objDTCOCommandVO.getDldType() == 2) {
                        objDTCOCommandVO.setDldType(3);
                    }
                    logger.debug((Object)(" entity in mass memory: " + objFileTransferStatusVO.getEntityName()));
                    if (objFileTransferStatusVO.getReminderID() == 0) {
                        logger.debug((Object)"checkinf for new vwehicle..");
                        VehicleDetailsDao objVehicleDetailsDao = VehicleDetailsDao.getInstance();
                        vehicleFound = objVehicleDetailsDao.checkEntryinVehicleDetails(entityId.substring(1), objDTCOCommandVO.getCompanyID());
                    }
                    logger.debug((Object)("vehicleFound:" + vehicleFound));
                    logger.debug((Object)("mass memory status received is: " + status));
                    if (status == 3 || status == 9) {
                        return;
                    }
                    if (status == 2) {
                        objDTCOCommandVO.setStatus(7);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            logger.debug((Object)"going to update mass memory status ");
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(1);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (vehicleFound) {
                                logger.debug((Object)("Not a new vehicle, vrn: " + entityId));
                                return;
                            }
                            logger.debug((Object)"New vehicle so going to add mass memory status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                            }
                        }
                        break block24;
                    }
                    if (status == 1) {
                        objDTCOCommandVO.setStatus(5);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            logger.debug((Object)"going to update mass memory status ");
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(0);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (vehicleFound) {
                                logger.info((Object)("Not a new vehicle, vrn: " + entityId));
                                return;
                            }
                            logger.debug((Object)"New vehicle so going to add mass memory status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                            }
                        }
                        break block24;
                    }
                    if (status != 0) break block24;
                    logger.debug((Object)" in status 0");
                    objDTCOCommandVO.setStatus(6);
                    if (objFileTransferStatusVO.getReminderID() != 0) {
                        objDTCOCommandVO.setAuthType(0);
                        objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                        objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                        objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                        objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                        objFileTransferStatusVO.setAuthType(0);
                        objFileTransferStatusVO = objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        if (objFileTransferStatusVO.getUpdatedStatus() == -1) {
                            objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                        }
                        break block24;
                    }
                    if (vehicleFound) {
                        logger.info((Object)("Not a new vehicle, vrn: " + entityId));
                        return;
                    }
                    logger.debug((Object)"New vehicle so going to add mass memory status ");
                    try {
                        this.reminderId = objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                    }
                    objFileTransferStatusVO.setAuthType(0);
                    objFileTransferStatusVO.setEntityName(GeneralAPI.convertStringToByte(""));
                    objFileTransferStatusVO.setReminderID(this.reminderId);
                    objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                    break block24;
                }
                logger.error((Object)"Entity id received as null for mass memory");
                return;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("NumberFormatException while handling vehicle mass memory task:" + e));
            }
            catch (Exception e) {
                logger.error((Object)("Exception while handling vehicle mass memory task:" + e));
            }
        }
    }

    private void handleSpecialDataStatus(DTCOCommandVO objDTCOCommandVO) {
        block32: {
            int status = objDTCOCommandVO.getStatus();
            boolean vehicleFound = false;
            try {
                String entityId = GeneralAPI.byteToString(objDTCOCommandVO.getEntityId());
                if (entityId != null && !entityId.trim().equals("")) {
                    CompanyDao objCompanyDao;
                    entityId = entityId.trim();
                    entityId = "S" + entityId;
                    objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                    FileTransferStatusVO objFileTransferStatusVO = new FileTransferStatusVO();
                    RemoteServiceDao objRemoteServiceDao = RemoteServiceDao.getInstance();
                    objDTCOCommandVO = objRemoteServiceDao.getRemoteServiceCompany(objDTCOCommandVO);
                    logger.debug((Object)("values in spl:" + objDTCOCommandVO.getReminderDate() + " " + objDTCOCommandVO.getCompanyID() + " " + entityId));
                    int statusCheck = 0;
                    objFileTransferStatusVO = objReminderListDao.getEntityName(objDTCOCommandVO.getReminderDate(), objDTCOCommandVO.getCompanyID(), entityId, statusCheck);
                    logger.debug((Object)(" after dao  entity name in spl:" + objFileTransferStatusVO.getEntityName()));
                    DTCOFileTransferStatusDao objDTCOFileTransferStatusDao = DTCOFileTransferStatusDao.getInstance();
                    objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                    objFileTransferStatusVO.setEntityName(objFileTransferStatusVO.getEntityName());
                    objFileTransferStatusVO.setSerialId(objDTCOCommandVO.getRemoteDeviceSerialNumber());
                    objFileTransferStatusVO.setInitTimeStamp(Integer.toString(objDTCOCommandVO.getTimeStamp()));
                    objFileTransferStatusVO.setCompanyID(objDTCOCommandVO.getCompanyID());
                    objFileTransferStatusVO.setDldType(objDTCOCommandVO.getDldType());
                    if (objDTCOCommandVO.getDldType() == 1 || objDTCOCommandVO.getDldType() == 2) {
                        objDTCOCommandVO.setDldType(3);
                    }
                    logger.debug((Object)(" id for spl:" + objFileTransferStatusVO.getReminderID()));
                    if (objFileTransferStatusVO.getReminderID() == 0) {
                        logger.debug((Object)"checkinf for new vwehicle in special type..");
                        VehicleDetailsDao objVehicleDetailsDao = VehicleDetailsDao.getInstance();
                        vehicleFound = objVehicleDetailsDao.checkEntryinVehicleDetails(entityId.substring(1), objDTCOCommandVO.getCompanyID());
                    }
                    logger.debug((Object)("vehicleFound in specl:" + vehicleFound));
                    logger.debug((Object)("special data status received is: " + status));
                    if (status == 9) {
                        return;
                    }
                    if (status == 2) {
                        objDTCOCommandVO.setStatus(7);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(1);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (vehicleFound) {
                                logger.debug((Object)("Not a new vehicle, vrn: " + entityId));
                                return;
                            }
                            logger.debug((Object)"New vehicle so going to add specialdata status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                            }
                        }
                        break block32;
                    }
                    if (status == 1) {
                        objDTCOCommandVO.setStatus(5);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(0);
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("16"));
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                        } else {
                            if (vehicleFound) {
                                logger.debug((Object)("Not a new vehicle, vrn: " + entityId));
                                return;
                            }
                            logger.debug((Object)"New vehicle so going to add specialdata status ");
                            try {
                                objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                            }
                        }
                        break block32;
                    }
                    if (status == 0) {
                        objDTCOCommandVO.setStatus(6);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            logger.debug((Object)" in special : entity name");
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(0);
                            objFileTransferStatusVO = objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                            if (objFileTransferStatusVO.getUpdatedStatus() == -1) {
                                objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                            }
                            break block32;
                        }
                        if (vehicleFound) {
                            logger.debug((Object)("Not a new vehicle, vrn: " + entityId));
                            return;
                        }
                        objCompanyDao = CompanyDao.getInstance();
                        AccountVO objCompanyVO = objCompanyDao.getCompanyUserType(objDTCOCommandVO.getCompanyID());
                        if (!objCompanyVO.isBSVSpecificDataIndicator()) break block32;
                        try {
                            this.reminderId = objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                        }
                        objFileTransferStatusVO.setAuthType(0);
                        objFileTransferStatusVO.setEntityName(GeneralAPI.convertStringToByte(""));
                        objFileTransferStatusVO.setReminderID(this.reminderId);
                        objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, objDTCOCommandVO.getRemoteServiceID());
                        break block32;
                    }
                    if (status == 3) {
                        objDTCOCommandVO.setStatus(7);
                        if (objFileTransferStatusVO.getReminderID() != 0) {
                            objDTCOCommandVO.setAuthType(0);
                            objDTCOCommandVO.setTimeStampAuthenticationStarted(GeneralAPI.getCurrentDateTimeInt());
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(String.valueOf(objFileTransferStatusVO.getReminderID())));
                            objReminderListDao.updateStatusLocalAuthentication(objDTCOCommandVO);
                            objDTCOCommandVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setAuthType(1);
                            objFileTransferStatusVO.setStatusCode((short)3);
                            objDTCOFileTransferStatusDao.updateStatus(objFileTransferStatusVO);
                            entityId = entityId.substring(1);
                            objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(entityId));
                            objFileTransferStatusVO.setStatusCode((short)Byte.parseByte("1"));
                            objDTCOFileTransferStatusDao.updateSpecialDataDownloadStatus(objDTCOCommandVO.getCompanyID(), entityId);
                        } else {
                            if (vehicleFound) {
                                logger.debug((Object)("Not a new vehicle, vrn: " + entityId));
                                return;
                            }
                            objCompanyDao = CompanyDao.getInstance();
                            AccountVO objCompanyVO = objCompanyDao.getCompanyUserType(objDTCOCommandVO.getCompanyID());
                            if (objCompanyVO.isBSVSpecificDataIndicator()) {
                                logger.debug((Object)"New vehicle so going to add specialdata status ");
                                try {
                                    objReminderListDao.addReminder(objDTCOCommandVO.getCompanyID(), entityId, "", objDTCOCommandVO.getTimeStamp(), objDTCOCommandVO.getRemoteDeviceSerialNumber(), objDTCOCommandVO.getStatus(), objDTCOCommandVO.getDldType(), 1, 0, "", 0);
                                }
                                catch (Exception e) {
                                    logger.error((Object)"Exception while adding reminder: ", (Throwable)e);
                                }
                            }
                        }
                    }
                    break block32;
                }
                logger.error((Object)"Entity id received as null special data:");
                return;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("NumberFormatException while handling vehicle special data task:" + e));
            }
            catch (Exception e) {
                logger.error((Object)("Exception while handling vehicle special data task:" + e));
            }
        }
    }
}

