/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.task.state;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.SMCPUtils;
import com.sisl.dtco.exceptions.CommPingingTimeoutException;
import com.sisl.dtco.formatter.APDUFormatter;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.task.state.CardConnectionRetryState;
import com.sisl.dtco.task.state.FailedState;
import com.sisl.dtco.task.state.GenericAuthenticationState;
import com.sisl.dtco.task.state.RemoteDownloadState;
import com.sisl.dtco.vo.CommandDTADData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import org.apache.log4j.Logger;

public class APDUState
extends GenericAuthenticationState {
    DTCOCommandVO objDTCOCommandVO;
    AuthenticationManager objAuthenticationController;
    String cardTerminal;
    AuthenticationTask objAuthenticationTask;
    private byte[] apdu;
    private final Logger logger = Logger.getLogger(APDUState.class);

    public APDUState(DTCOCommandVO objDTCOCommandVO, String cardTerminal, AuthenticationManager objAuthenticationController, AuthenticationTask objAuthenticationTask, byte[] apdu) {
        this.objDTCOCommandVO = objDTCOCommandVO;
        this.objAuthenticationController = objAuthenticationController;
        this.cardTerminal = cardTerminal;
        this.objAuthenticationTask = objAuthenticationTask;
        this.apdu = apdu;
    }

    @Override
    public void processState() {
        this.logger.debug((Object)("APDU state :processState() starts for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
        try {
            super.processState(this.cardTerminal);
            this.logger.debug((Object)("current state" + this.objAuthenticationTask.getCurrentState()));
            this.processResponse(this.apdu);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            this.logger.error((Object)("Setting current state to CardConnectionRetryState for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
            this.objAuthenticationTask.setCurrentState(new CardConnectionRetryState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, this.objAuthenticationTask.getCurrentState()));
            this.objAuthenticationTask.processState();
        }
    }

    @Override
    public void processResponse(byte[] apdu) {
        InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
        this.logger.debug((Object)("Vuresponse:" + this.toHexString(apdu)));
        this.logger.debug((Object)("5th byte in Vuresponse: :" + apdu[4]));
        boolean bManageSecurityEnvironment = false;
        switch (apdu[4]) {
            case 1: {
                try {
                    boolean card_status = this.objSmartCardCtl.checkCompanyCardPresent(this.cardTerminal);
                    this.logger.debug((Object)("Status of company card  in card Terminal:" + this.cardTerminal + "is" + card_status));
                    if (apdu.length <= 5 || !card_status) break;
                    this.logger.debug((Object)"Initializing APDUFormatter");
                    APDUFormatter formatter = new APDUFormatter();
                    byte[] command_apdu = new byte[apdu.length - 1 - 4];
                    System.arraycopy(apdu, 5, command_apdu, 0, command_apdu.length);
                    this.logger.debug((Object)("Sending command apdu to  Card Reader:" + this.cardTerminal + "::" + command_apdu));
                    this.logger.debug((Object)("Data sent to card:" + SMCPUtils.toHexString(command_apdu)));
                    byte[] response_apdu = this.objSmartCardCtl.sendCommandAPDU(this.cardTerminal, command_apdu);
                    if (this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                        String responseAPDU = SMCPUtils.toHexString(response_apdu);
                        this.logger.debug((Object)("****first byte in case of Stoneridge********=" + command_apdu[1]));
                        if (command_apdu[1] == 34 && responseAPDU.endsWith("6A88")) {
                            this.logger.debug((Object)("****set vale true in case of Stonridge ManageSecurityEnvironment******=" + command_apdu[2]));
                            bManageSecurityEnvironment = true;
                        }
                        this.logger.debug((Object)("ResponseAPDU..." + responseAPDU));
                        int len = responseAPDU.length();
                        this.logger.debug((Object)("Length of responseAPDU :" + len));
                    }
                    this.logger.debug((Object)("Receiving response apdu from Card Reader " + this.cardTerminal + "::" + response_apdu));
                    this.logger.debug((Object)("Data received from card:" + SMCPUtils.toHexString(response_apdu)));
                    byte[] apduToComm = formatter.createPayload(response_apdu);
                    this.logger.debug((Object)("Final APDU  from Card Reader " + this.cardTerminal + " is sent to Comm:" + apduToComm));
                    this.logger.debug((Object)("Data Code in CCAD:" + apduToComm[4]));
                    try {
                        this.logger.debug((Object)("Length of data in  CCAD:" + apduToComm.length));
                        if (this.objDTCOCommandVO.getDldType() == 3) {
                            objInvokeRemoteDevice.sendAuthenticationDataToWRCOMM(this.objDTCOCommandVO, apduToComm);
                            long currentTime = System.currentTimeMillis();
                            apdu = objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                            this.logger.debug((Object)("APDU Received from DLD DTCOConsts.WR :" + apdu));
                            while (apdu == null) {
                                long PingingTime = System.currentTimeMillis();
                                long tmeDiffInMinutes = (PingingTime - currentTime) / 60000L;
                                this.logger.debug((Object)("Time Difference in Minutes:" + tmeDiffInMinutes));
                                long pingingFreq = Long.parseLong(ConfigUtil.getValue("PingingTimeoutPeriodWR"));
                                if (tmeDiffInMinutes < pingingFreq) {
                                    Thread.sleep(Integer.parseInt(ConfigUtil.getValue("PingingFrequency")) * 1000);
                                    this.logger.debug((Object)"Calling pingCommServer again");
                                    apdu = objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                                    continue;
                                }
                                throw new CommPingingTimeoutException("Timeout occured while pinging to COMM");
                            }
                        } else {
                            CommandResponseVO objCommandResponseVO = objInvokeRemoteDevice.sendAuthenticationDataToSRCOMM(this.objDTCOCommandVO, apduToComm);
                            CommandDTADData objCommandDTADData = objCommandResponseVO.getCommandDTADData();
                            apdu = objCommandDTADData.getAuthData();
                            this.logger.debug((Object)("APDU Received from DLD :" + apdu));
                        }
                        this.objAuthenticationTask.setCurrentState(new APDUState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, apdu));
                        this.objAuthenticationTask.processState();
                    }
                    catch (CommPingingTimeoutException e) {
                        this.logger.error((Object)"Setting current State to Failed State");
                        this.objDTCOCommandVO.setFailureCode((byte)12);
                        this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                        this.objAuthenticationTask.processState();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Setting current State to Failed State");
                        this.objDTCOCommandVO.setFailureCode((byte)12);
                        this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                        this.objAuthenticationTask.processState();
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Setting current State to CardConnectionRetryState " + ConfigUtil.getStackTraceAsString(e)));
                    this.objAuthenticationTask.setCurrentState(new CardConnectionRetryState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, this.objAuthenticationTask.getCurrentState()));
                    this.objAuthenticationTask.processState();
                }
                break;
            }
            case 5: {
                this.objAuthenticationTask.setCurrentState(new RemoteDownloadState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processResponse(apdu);
                break;
            }
            case 7: {
                this.logger.debug((Object)("Setting current state to Stop Authentication for DTCO " + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode((byte)15);
                this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 4);
                break;
            }
            case 2: {
                this.logger.debug((Object)("Setting current state to RemoteDownloadState for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode((byte)0);
                this.objAuthenticationTask.setCurrentState(new RemoteDownloadState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
                break;
            }
            case 3: {
                this.logger.debug((Object)"Inside AUTH_FAILURE...");
                this.logger.debug((Object)("DLD type =" + this.objDTCOCommandVO.getDldType()));
                if (this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                    this.logger.debug((Object)("Hexa string of apdu array =" + SMCPUtils.toHexString(apdu)));
                    byte acode = GeneralAPI.authFailureCode(apdu);
                    this.logger.debug((Object)("acode for apdu =" + acode));
                    this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode(acode);
                } else {
                    this.logger.debug((Object)("acode for apdu[4] =" + apdu[4]));
                    this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode(apdu[4]);
                }
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
                break;
            }
            case 4: {
                this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode(apdu[4]);
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
                break;
            }
            default: {
                this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode(apdu[4]);
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
            }
        }
    }

    public String toHexString(byte[] b) {
        try {
            char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            StringBuffer sb = new StringBuffer(b.length * 2);
            int i = 0;
            while (i < b.length) {
                sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
                sb.append(hexChar[b[i] & 0xF]);
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in converting to hex String.... returning null ");
            e.printStackTrace();
            return null;
        }
    }
}

