/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.task.state;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.formatter.CloseAuthenticationFormatter;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.task.state.GenericAuthenticationState;
import com.sisl.dtco.vo.DTCOCommandVO;
import org.apache.log4j.Logger;

public class CardConnectionRetryState
extends GenericAuthenticationState {
    DTCOCommandVO objDTCOCommandVO;
    AuthenticationManager objAuthenticationController;
    AuthenticationTask objAuthenticationTask;
    private final Logger logger = Logger.getLogger(CardConnectionRetryState.class);
    private String cardTerminal;
    private GenericAuthenticationState previousState;

    public CardConnectionRetryState(DTCOCommandVO objDTCOCommandVO, String cardTerminal, AuthenticationManager objAuthenticationController, AuthenticationTask objAuthenticationTask, GenericAuthenticationState previousState) {
        this.objDTCOCommandVO = objDTCOCommandVO;
        this.objAuthenticationController = objAuthenticationController;
        this.cardTerminal = cardTerminal;
        this.objAuthenticationTask = objAuthenticationTask;
        this.previousState = previousState;
    }

    @Override
    public void processState() {
        this.logger.debug((Object)"CardConnectionRetryState :processState()start");
        InvokeRemoteDevice device = InvokeRemoteDevice.getInstance();
        CloseAuthenticationFormatter formatter = new CloseAuthenticationFormatter();
        formatter.setDldType(this.objDTCOCommandVO.getDldType());
        byte[] closeAuthData = formatter.createPayload(null);
        try {
            if (this.objDTCOCommandVO.getDldType() == 3) {
                this.logger.debug((Object)"Sending Close Auth Request to WR COMM");
                device.sendAuthenticationDataToWRCOMM(this.objDTCOCommandVO, closeAuthData);
            } else {
                try {
                    this.logger.debug((Object)"Sending Close Auth Request to SR COMM");
                    this.objDTCOCommandVO.setBreakRequired(true);
                    device.sendAuthenticationDataToSRCOMM(this.objDTCOCommandVO, closeAuthData);
                    GeneralAPI.closeSocketConnection(this.objDTCOCommandVO);
                }
                catch (Exception e) {
                    GeneralAPI.closeSocketConnection(this.objDTCOCommandVO);
                    this.logger.error((Object)"Exception while sending closing command in Card Connection Retry state", (Throwable)e);
                }
            }
            byte code = this.objDTCOCommandVO.getFailureCode();
            if (code < 51 || code > 72) {
                this.objDTCOCommandVO.setFailureCode((byte)14);
            }
            this.logger.debug((Object)"Calling AuthEvent in CardConnectionRetry State");
            this.processResponse(null);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while sending Close Authentication Request to COMM:" + e));
            this.processResponse(null);
        }
    }

    @Override
    public void processResponse(byte[] vuResponse) {
        this.logger.debug((Object)"No need to interact with comm");
        this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 3);
    }
}

