/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.task.state;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.SMCPUtils;
import com.sisl.dtco.exceptions.CommPingingTimeoutException;
import com.sisl.dtco.formatter.GetReadyFormatter;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.task.state.APDUState;
import com.sisl.dtco.task.state.CardConnectionRetryState;
import com.sisl.dtco.task.state.FailedState;
import com.sisl.dtco.task.state.GenericAuthenticationState;
import com.sisl.dtco.vo.CommandDTADData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import org.apache.log4j.Logger;

public class GetReadyState
extends GenericAuthenticationState {
    DTCOCommandVO objDTCOCommandVO;
    AuthenticationManager objAuthenticationController;
    String cardTerminal;
    AuthenticationTask objAuthenticationTask;
    InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
    private final Logger logger = Logger.getLogger(GetReadyState.class);

    public GetReadyState(DTCOCommandVO objDTCOCommandVO, String cardTerminal, AuthenticationManager objAuthenticationController, AuthenticationTask objAuthenticationTask) {
        this.objDTCOCommandVO = objDTCOCommandVO;
        this.objAuthenticationController = objAuthenticationController;
        this.cardTerminal = cardTerminal;
        this.objAuthenticationTask = objAuthenticationTask;
    }

    @Override
    public void processState() {
        byte[] vuResponse = new byte[255];
        byte[] atr = new byte[255];
        this.logger.debug((Object)("getready state :processState()start for " + this.cardTerminal + " and DTCO" + this.objDTCOCommandVO));
        try {
            super.processState(this.cardTerminal);
            if (this.objSmartCardCtl.checkCompanyCardPresent(this.cardTerminal)) {
                this.objSmartCardCtl.reconnect(this.cardTerminal, this.objDTCOCommandVO.getProtocol());
                atr = this.objSmartCardCtl.getCompanyCardATR(this.cardTerminal);
                this.logger.debug((Object)("DLD type =" + this.objDTCOCommandVO.getDldType()));
                if (this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                    String atr1 = SMCPUtils.toHexString(atr);
                    this.logger.debug((Object)("ATR received from card :" + atr1));
                    int len = atr1.length();
                    this.logger.debug((Object)("Length of atr1 :" + len));
                }
                GetReadyFormatter formatter = new GetReadyFormatter();
                byte[] apdu = formatter.createPayload(atr);
                this.logger.debug((Object)("Length of data in  CCAD:" + apdu.length));
                this.logger.debug((Object)("Response of ATR  sent to Comm from card Reader :" + this.cardTerminal + " is" + apdu));
                this.logger.debug((Object)("Data Code in CCAD:" + apdu[4]));
                try {
                    if (this.objDTCOCommandVO.getDldType() == 3) {
                        this.objInvokeRemoteDevice.sendAuthenticationDataToWRCOMM(this.objDTCOCommandVO, apdu);
                        long currentTime = System.currentTimeMillis();
                        vuResponse = this.objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                        while (vuResponse == null) {
                            long PingingTime = System.currentTimeMillis();
                            long tmeDiffInMinutes = (PingingTime - currentTime) / 60000L;
                            this.logger.debug((Object)("Time Diff in minutes:" + tmeDiffInMinutes));
                            long pingingFreq = Long.parseLong(ConfigUtil.getValue("PingingTimeoutPeriodWR"));
                            if (tmeDiffInMinutes < pingingFreq) {
                                Thread.sleep(Integer.parseInt(ConfigUtil.getValue("PingingFrequency")) * 1000);
                                vuResponse = this.objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                                continue;
                            }
                            throw new CommPingingTimeoutException("Timeout occured while pinging to COMM");
                        }
                    } else {
                        CommandResponseVO objCommandResponseVO = this.objInvokeRemoteDevice.sendAuthenticationDataToSRCOMM(this.objDTCOCommandVO, apdu);
                        this.logger.debug((Object)("COOMAND NAME IS : " + objCommandResponseVO.getCmdName()));
                        CommandDTADData objCommandDTADData = objCommandResponseVO.getCommandDTADData();
                        vuResponse = objCommandDTADData.getAuthData();
                    }
                    this.logger.debug((Object)("Vuresponse:" + this.toHexString(vuResponse) + " for DTCO:" + this.objDTCOCommandVO));
                    this.logger.debug((Object)("5th byte in Vuresponse: :" + vuResponse[4]));
                    this.processResponse(vuResponse);
                }
                catch (CommPingingTimeoutException e) {
                    this.logger.error((Object)("Exception while communicating to COMM:" + e));
                    this.objDTCOCommandVO.setFailureCode((byte)12);
                    this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                    this.objAuthenticationTask.processState();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception while getting response from  COMM:" + e));
                    this.objDTCOCommandVO.setFailureCode((byte)12);
                    this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                    this.objAuthenticationTask.processState();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            this.logger.error((Object)("Setting current state to CardConnectionRetryState for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
            this.objAuthenticationTask.setCurrentState(new CardConnectionRetryState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, this.objAuthenticationTask.getCurrentState()));
            this.objAuthenticationTask.processState();
        }
    }

    @Override
    public void processResponse(byte[] vuResponse) {
        int CardProtocol = 1;
        int DtcoProtocol = 1;
        int len = vuResponse.length;
        this.logger.debug((Object)("Lenght of vuResponse:" + len));
        this.logger.debug((Object)("vuResponse[0]:" + vuResponse[0]));
        this.logger.debug((Object)("vuResponse[1]:" + vuResponse[1]));
        if (vuResponse[0] == 0 && vuResponse[1] == 136) {
            if (len == 22) {
                DtcoProtocol = 1;
            }
            if (len == 21) {
                DtcoProtocol = 0;
            }
            this.logger.debug((Object)("1.DtcoProtocol:" + DtcoProtocol));
        }
        if (vuResponse[0] == 12 && vuResponse[1] == 176) {
            if (len == 15) {
                DtcoProtocol = 1;
            }
            if (len == 14) {
                DtcoProtocol = 0;
            }
            this.logger.debug((Object)("2.DtcoProtocol:" + DtcoProtocol));
        }
        if (CardProtocol != DtcoProtocol) {
            this.objDTCOCommandVO.setProtocol("T=0");
            this.logger.debug((Object)("CardProtocol:" + CardProtocol + "\nDtcoProtocol:" + DtcoProtocol));
            this.processState();
            return;
        }
        if (vuResponse[4] == 1) {
            this.logger.debug((Object)("Setting current state to APDUstate for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
            this.objDTCOCommandVO.setFailureCode((byte)0);
            this.objAuthenticationTask.setCurrentState(new APDUState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, vuResponse));
            this.objAuthenticationTask.processState();
        } else if (vuResponse[4] == 7) {
            this.logger.debug((Object)("Setting current state to Stop Authentication for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
            this.logger.debug((Object)("Company Card Number (GetReadyState STOP_AUTHENTICATION) " + this.objDTCOCommandVO.getCompanyCardNo()));
            this.objDTCOCommandVO.setFailureCode((byte)15);
            this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 4);
        } else if (vuResponse[4] == 3) {
            this.logger.debug((Object)"Inside AUTH_FAILURE...");
            this.logger.debug((Object)("DLD type =" + this.objDTCOCommandVO.getDldType()));
            if (this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                this.logger.debug((Object)("Hexa string of apdu array =" + SMCPUtils.toHexString(vuResponse)));
                byte acode = GeneralAPI.authFailureCode(vuResponse);
                this.logger.debug((Object)("acode for apdu =" + acode));
                this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode(acode);
            } else {
                this.logger.debug((Object)("acode for apdu[4] =" + vuResponse[4]));
                this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode(vuResponse[4]);
            }
            this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
            this.objAuthenticationTask.processState();
        } else if (vuResponse[4] == 4) {
            this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
            this.objDTCOCommandVO.setFailureCode(vuResponse[4]);
            this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
            this.objAuthenticationTask.processState();
        } else {
            this.logger.debug((Object)("Setting current state to Failedstate for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
            this.logger.debug((Object)("Company Card Number (GetReadyState default) " + this.objDTCOCommandVO.getCompanyCardNo()));
            this.objDTCOCommandVO.setFailureCode(vuResponse[4]);
            this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
            this.objAuthenticationTask.processState();
        }
    }

    public String toHexString(byte[] b) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }
}

