/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.task.state;

import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.SMCPUtils;
import com.sisl.dtco.exceptions.CommPingingTimeoutException;
import com.sisl.dtco.formatter.LocalDownlodFormatter;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.task.state.FailedState;
import com.sisl.dtco.task.state.GenericAuthenticationState;
import com.sisl.dtco.vo.CommandDTADData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import org.apache.log4j.Logger;

public class LocalDownlodState
extends GenericAuthenticationState {
    DTCOCommandVO objDTCOCommandVO;
    String cardTerminal;
    AuthenticationManager objAuthenticationController;
    AuthenticationTask objAuthenticationTask;
    InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
    private final Logger logger = Logger.getLogger(LocalDownlodState.class);

    public LocalDownlodState(DTCOCommandVO objDTCOCommandVO, String cardTerminal, AuthenticationManager objAuthenticationController, AuthenticationTask objAuthenticationTask) {
        this.objDTCOCommandVO = objDTCOCommandVO;
        this.objAuthenticationController = objAuthenticationController;
        this.cardTerminal = cardTerminal;
        this.objAuthenticationTask = objAuthenticationTask;
    }

    @Override
    public void processState() {
        byte[] vuResponse = new byte[255];
        byte[] dtad = new byte[255];
        LocalDownlodFormatter formatter = new LocalDownlodFormatter();
        byte[] apdu = formatter.createPayload(dtad);
        this.logger.debug((Object)("Length of data in  CCAD:" + apdu.length));
        this.logger.debug((Object)("Data Code in CCAD:" + apdu[4]));
        try {
            CommandResponseVO objCommandResponseVO = this.objInvokeRemoteDevice.sendAuthenticationDataToSRCOMM(this.objDTCOCommandVO, apdu);
            this.logger.debug((Object)("COOMAND NAME IS : " + objCommandResponseVO.getCmdName()));
            CommandDTADData objCommandDTADData = objCommandResponseVO.getCommandDTADData();
            vuResponse = objCommandDTADData.getAuthData();
            this.logger.debug((Object)("Vuresponse:" + this.toHexString(vuResponse) + " for DTCO:" + this.objDTCOCommandVO));
            this.logger.debug((Object)("5th byte in Vuresponse: :" + vuResponse[4]));
            this.processResponse(vuResponse);
        }
        catch (CommPingingTimeoutException e) {
            this.logger.error((Object)("Exception while communicating to COMM:" + e));
            this.objDTCOCommandVO.setFailureCode((byte)12);
            this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
            this.objAuthenticationTask.processState();
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception while getting response from  COMM:" + e));
            this.objDTCOCommandVO.setFailureCode((byte)12);
            this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
            this.objAuthenticationTask.processState();
        }
    }

    @Override
    public void processResponse(byte[] vuResponse) {
        switch (vuResponse[4]) {
            case 5: {
                byte[] timeStamp = new byte[4];
                System.arraycopy(vuResponse, 0, timeStamp, 0, timeStamp.length);
                if (this.objDTCOCommandVO.getDldType() != 8) break;
                this.objDTCOCommandVO.setTimeStamp(SMCPUtils.toInt(timeStamp));
                this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 2);
                break;
            }
            case 3: {
                this.logger.debug((Object)"Inside AUTH_FAILURE...");
                this.logger.debug((Object)("DLD type =" + this.objDTCOCommandVO.getDldType()));
                if (this.objDTCOCommandVO.getDldType() == 8) {
                    this.logger.debug((Object)("Hexa string of apdu array =" + SMCPUtils.toHexString(vuResponse)));
                    byte acode = GeneralAPI.authFailureCode(vuResponse);
                    this.logger.debug((Object)("acode for apdu =" + acode));
                    this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode(acode);
                } else {
                    this.logger.debug((Object)("acode for apdu[4] =" + vuResponse[4]));
                    this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode(vuResponse[4]);
                }
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
                break;
            }
            case 7: {
                this.logger.debug((Object)("Setting current state to Stop Authentication for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode((byte)15);
                this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 4);
                break;
            }
            default: {
                this.logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                this.objDTCOCommandVO.setFailureCode(vuResponse[4]);
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
            }
        }
    }

    public String toHexString(byte[] b) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
            sb.append(hexChar[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }
}

