/*
 * Decompiled with CFR 0.152.
 */
package com.sisl.dtco.task.state;

import com.sisl.dtco.Utility.ConfigUtil;
import com.sisl.dtco.Utility.GeneralAPI;
import com.sisl.dtco.Utility.SMCPUtils;
import com.sisl.dtco.dao.DTCOFileTransferStatusDao;
import com.sisl.dtco.dao.ReminderListDao;
import com.sisl.dtco.exceptions.CommPingingTimeoutException;
import com.sisl.dtco.formatter.RemoteDownloadFormatter;
import com.sisl.dtco.integration.AuthenticationManager;
import com.sisl.dtco.integration.InvokeRemoteDevice;
import com.sisl.dtco.task.AuthenticationTask;
import com.sisl.dtco.task.state.APDUState;
import com.sisl.dtco.task.state.FailedState;
import com.sisl.dtco.task.state.GenericAuthenticationState;
import com.sisl.dtco.vo.CommandDTADData;
import com.sisl.dtco.vo.CommandResponseVO;
import com.sisl.dtco.vo.DTCOCommandVO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.tempuri.FileTransferStatusVO;

public class RemoteDownloadState
extends GenericAuthenticationState {
    private DTCOCommandVO objDTCOCommandVO;
    private AuthenticationManager objAuthenticationController;
    InvokeRemoteDevice objInvokeRemoteDevice = InvokeRemoteDevice.getInstance();
    String cardTerminal;
    private AuthenticationTask objAuthenticationTask;
    byte[] commResponse = null;
    private static final Logger logger = Logger.getLogger(RemoteDownloadState.class);

    public RemoteDownloadState(DTCOCommandVO objDTCOCommandVO, String cardTerminal, AuthenticationManager objAuthenticationController, AuthenticationTask objAuthenticationTask) {
        logger.debug((Object)"Setting constructor parameters");
        this.objDTCOCommandVO = objDTCOCommandVO;
        this.objAuthenticationController = objAuthenticationController;
        this.cardTerminal = cardTerminal;
        this.objAuthenticationTask = objAuthenticationTask;
    }

    @Override
    public void processState() {
        try {
            logger.debug((Object)"Remote DownloadState:processState() starts");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Calendar cal = Calendar.getInstance();
            logger.warn((Object)("Request List to be sent:" + this.objDTCOCommandVO.getRequestList()));
            int i = 0;
            while (i < this.objDTCOCommandVO.getRequestList().size()) {
                byte[] temp;
                byte[] byArray = temp = this.objDTCOCommandVO.getRequestList().get(i);
                int n = temp.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    logger.warn((Object)("requestList_RemoteDownloadState[" + i + "]::" + String.format("%02x", b)));
                    ++n2;
                }
                ++i;
            }
            logger.debug((Object)("Size of Request List:" + this.objDTCOCommandVO.getRequestList().size()));
            i = 0;
            while (i < this.objDTCOCommandVO.getRequestList().size()) {
                byte[] downloadRequest = this.objDTCOCommandVO.getRequestList().get(i);
                bos.write(downloadRequest[0]);
                logger.warn((Object)("Download Request 0th Byte:" + String.format("%02x", downloadRequest[0])));
                switch (downloadRequest[0]) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 33: 
                    case 35: 
                    case 36: 
                    case 37: {
                        bos.write(0);
                        break;
                    }
                    case 23: {
                        bos.write(1);
                        bos.write(1);
                        bos.write(23);
                        bos.write(1);
                        bos.write(2);
                        break;
                    }
                    case 27: {
                        Date newFromDate;
                        long todateTimeInLong;
                        long diffDays;
                        int maxDaysToDownload;
                        int fromDateTime;
                        try {
                            logger.debug((Object)"For TREP 1B case... Inside processState");
                            if (downloadRequest[1] == 1) {
                                logger.debug((Object)"For TREP 1B case... Inside ACTIVITIES_SINCE_LAST_DOWNLOAD case");
                                bos.write(10);
                                bos.write(2);
                                fromDateTime = this.objDTCOCommandVO.getDownloadDateForSpecial();
                                logger.debug((Object)("last special download date in remote download state : " + fromDateTime));
                                int toDateTime = (int)(cal.getTimeInMillis() / 1000L);
                                logger.debug((Object)("current date in remote download state : " + toDateTime));
                                maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                                long diff = toDateTime - fromDateTime;
                                diffDays = diff / 86400L;
                                if (diffDays > (long)maxDaysToDownload) {
                                    todateTimeInLong = (long)toDateTime * 1000L;
                                    newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                    fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                    logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                                }
                                bos.write(SMCPUtils.toByte(fromDateTime));
                                bos.write(3);
                                bos.write(SMCPUtils.toByte(toDateTime));
                                break;
                            }
                            if (downloadRequest[1] == 2) {
                                logger.debug((Object)"For TREP 1B case... Inside ACTIVITIES_BETWEEN_TWO_DATES case");
                                bos.write(10);
                                bos.write(2);
                                fromDateTime = this.objDTCOCommandVO.getSpecialFromDate();
                                logger.debug((Object)("fromDateTime: " + fromDateTime));
                                int toDateTime = this.objDTCOCommandVO.getSpecialToDate();
                                logger.debug((Object)("toDateTime : " + toDateTime));
                                maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                                long diff = toDateTime - fromDateTime;
                                diffDays = diff / 86400L;
                                if (diffDays > (long)maxDaysToDownload) {
                                    todateTimeInLong = (long)toDateTime * 1000L;
                                    newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                    fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                    logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                                }
                                bos.write(SMCPUtils.toByte(fromDateTime));
                                bos.write(3);
                                bos.write(SMCPUtils.toByte(toDateTime));
                                break;
                            }
                            if (downloadRequest[1] != 3) break;
                            logger.debug((Object)"For TREP 1B case... Inside ACTIVITIES_LAST_DAYS case");
                            bos.write(10);
                            bos.write(2);
                            fromDateTime = this.objDTCOCommandVO.getSpecialFromDate();
                            logger.debug((Object)("fromDateTime: " + fromDateTime));
                            int toDateTime = (int)(cal.getTimeInMillis() / 1000L);
                            logger.debug((Object)("toDateTime : " + toDateTime));
                            maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                            long diff = toDateTime - fromDateTime;
                            diffDays = diff / 86400L;
                            if (diffDays > (long)maxDaysToDownload) {
                                todateTimeInLong = (long)toDateTime * 1000L;
                                newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                            }
                            bos.write(SMCPUtils.toByte(fromDateTime));
                            bos.write(3);
                            bos.write(SMCPUtils.toByte(toDateTime));
                        }
                        catch (IOException e) {
                            logger.error((Object)"Exception while writing ADDITIONAL_DATA_1B in RemoteDownload State class", (Throwable)e);
                        }
                        break;
                    }
                    case 2: 
                    case 34: {
                        Date newFromDate;
                        long todateTimeInLong;
                        long diffDays;
                        int maxDaysToDownload;
                        int fromDateTime;
                        try {
                            if (downloadRequest[1] == 1) {
                                logger.debug((Object)"ACTIVITIES_SINCE_LAST_DOWNLOAD");
                                bos.write(10);
                                bos.write(2);
                                fromDateTime = this.objDTCOCommandVO.getDownloadDate();
                                logger.debug((Object)("fromDateTime: " + fromDateTime));
                                int toDateTime = (int)(cal.getTimeInMillis() / 1000L);
                                logger.debug((Object)("toDateTime : " + toDateTime));
                                maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                                long diff = toDateTime - fromDateTime;
                                diffDays = diff / 86400L;
                                if (diffDays > (long)maxDaysToDownload) {
                                    todateTimeInLong = (long)toDateTime * 1000L;
                                    newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                    fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                    logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                                }
                                bos.write(SMCPUtils.toByte(fromDateTime));
                                bos.write(3);
                                bos.write(SMCPUtils.toByte(toDateTime));
                                break;
                            }
                            if (downloadRequest[1] == 2) {
                                logger.debug((Object)"ACTIVITIES_BETWEEN_TWO_DATES");
                                bos.write(10);
                                bos.write(2);
                                fromDateTime = this.objDTCOCommandVO.getActivityFromDate();
                                logger.debug((Object)("fromDateTime: " + fromDateTime));
                                int toDateTime = this.objDTCOCommandVO.getActivityToDate();
                                logger.debug((Object)("toDateTime : " + toDateTime));
                                maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                                long diff = toDateTime - fromDateTime;
                                diffDays = diff / 86400L;
                                if (diffDays > (long)maxDaysToDownload) {
                                    todateTimeInLong = (long)toDateTime * 1000L;
                                    newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                    fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                    logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                                }
                                bos.write(SMCPUtils.toByte(fromDateTime));
                                bos.write(3);
                                bos.write(SMCPUtils.toByte(toDateTime));
                                break;
                            }
                            if (downloadRequest[1] != 3) break;
                            logger.debug((Object)"ACTIVITIES_LAST_DAYS");
                            bos.write(10);
                            bos.write(2);
                            fromDateTime = this.objDTCOCommandVO.getActivityFromDate();
                            logger.debug((Object)("fromDateTime: " + fromDateTime));
                            int toDateTime = (int)(cal.getTimeInMillis() / 1000L);
                            logger.debug((Object)("toDateTime : " + toDateTime));
                            maxDaysToDownload = Integer.parseInt(ConfigUtil.getValue("MaxNumberOfDaysToDownload"));
                            long diff = toDateTime - fromDateTime;
                            diffDays = diff / 86400L;
                            if (diffDays > (long)maxDaysToDownload) {
                                todateTimeInLong = (long)toDateTime * 1000L;
                                newFromDate = GeneralAPI.addNumberOfDays(new Date(todateTimeInLong), -maxDaysToDownload);
                                fromDateTime = (int)(newFromDate.getTime() / 1000L);
                                logger.debug((Object)("From Date updated because difference between from and to datetime was greater than expected. Now the time is:" + fromDateTime));
                            }
                            bos.write(SMCPUtils.toByte(fromDateTime));
                            bos.write(3);
                            bos.write(SMCPUtils.toByte(toDateTime));
                        }
                        catch (IOException e) {
                            logger.error((Object)"Exception while writing activities of ACTIVITIES_OF_SPECIFIED_CALENDER_DAY in RemoteDownload State class", (Throwable)e);
                        }
                        break;
                    }
                    case 6: {
                        if (downloadRequest[1] == 1) {
                            logger.debug((Object)"Adding Driver Data Request List in Remote Download State ");
                            bos.write(1);
                            bos.write(1);
                        } else if (downloadRequest[1] == 2) {
                            logger.debug((Object)"Adding Co Driver Data Request List in Remote Download State ");
                            bos.write(1);
                            bos.write(2);
                        } else if (downloadRequest[1] == 3) {
                            logger.debug((Object)"Adding both Driver and Co Driver Data Request List in Remote Download State ");
                            bos.write(1);
                            bos.write(1);
                            bos.write(6);
                            bos.write(1);
                            bos.write(2);
                        }
                        if (this.objDTCOCommandVO.getDldType() != 2 && this.objDTCOCommandVO.getDldType() != 10 && this.objDTCOCommandVO.getDldType() != 8) break;
                        String strDtcoVer = this.objDTCOCommandVO.getStrDTCOVersion();
                        String twoInitialsOfDtcoVer = "";
                        if (!(strDtcoVer.equalsIgnoreCase("") || strDtcoVer.equalsIgnoreCase(null) || strDtcoVer.equalsIgnoreCase("00") || strDtcoVer == null || strDtcoVer.length() != 4)) {
                            twoInitialsOfDtcoVer = strDtcoVer.substring(0, 2);
                        }
                        logger.debug((Object)("DTCO Version is : " + this.objDTCOCommandVO.getStrDTCOVersion()));
                        logger.debug((Object)("DTCO Version first two Initials is : " + twoInitialsOfDtcoVer));
                        if (!twoInitialsOfDtcoVer.equalsIgnoreCase("13") && !twoInitialsOfDtcoVer.equalsIgnoreCase("14")) break;
                        logger.debug((Object)("DLD Type is  : " + this.objDTCOCommandVO.getDldType()));
                        logger.debug((Object)"For DTCO Version 1.3 and 1.4 Inside ADD_LAST_DOWNLOAD DATE case");
                        logger.debug((Object)("objDTCOCommandVO.getRequestList().size() is : " + this.objDTCOCommandVO.getRequestList().size()));
                        if (this.objDTCOCommandVO.getRequestList().size() != 1) break;
                        logger.debug((Object)"Adding Overviw Block Request List in Remote Download State ");
                        bos.write(1);
                        bos.write(0);
                    }
                }
                ++i;
            }
            RemoteDownloadFormatter formatter = new RemoteDownloadFormatter();
            byte[] request = formatter.createPayload(bos.toByteArray());
            if (request != null) {
                logger.debug((Object)("message to be sent to comm: " + Arrays.toString(request)));
            } else {
                logger.debug((Object)"message to be sent to comm: null");
            }
            try {
                if (this.objDTCOCommandVO.getDldType() == 3) {
                    this.objInvokeRemoteDevice.sendAuthenticationDataToWRCOMM(this.objDTCOCommandVO, request);
                    long currentTime = System.currentTimeMillis();
                    this.commResponse = this.objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                    while (this.commResponse == null) {
                        long pingingFreq;
                        long PingingTime = System.currentTimeMillis();
                        long tmeDiffInMinutes = (PingingTime - currentTime) / 60000L;
                        if (tmeDiffInMinutes < (pingingFreq = Long.parseLong(ConfigUtil.getValue("PingingTimeoutPeriodWR")))) {
                            Thread.sleep(Integer.parseInt(ConfigUtil.getValue("PingingFrequency")) * 1000);
                            this.commResponse = this.objInvokeRemoteDevice.pingCommServer(this.objDTCOCommandVO, currentTime);
                            continue;
                        }
                        logger.error((Object)"Timeout occured while pinging to COMM");
                        throw new CommPingingTimeoutException("Timeout occured while pinging to COMM");
                    }
                } else {
                    CommandResponseVO objCommandResponseVO = this.objInvokeRemoteDevice.sendAuthenticationDataToSRCOMM(this.objDTCOCommandVO, request);
                    CommandDTADData objCommandDTADData = objCommandResponseVO.getCommandDTADData();
                    this.commResponse = objCommandDTADData.getAuthData();
                }
                this.processResponse(this.commResponse);
            }
            catch (CommPingingTimeoutException e) {
                logger.error((Object)"Setting Current state to Failed state ");
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
            }
            catch (Exception e) {
                logger.error((Object)"Setting Current state to Failed state ");
                this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                this.objAuthenticationTask.processState();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception in RemoteDownloadState:", (Throwable)e);
        }
    }

    @Override
    public void processResponse(byte[] commResponse) {
        block29: {
            logger.debug((Object)("5th byte in Vuresponse in remote download state :" + commResponse[4]));
            logger.debug((Object)("Vuresponse:" + this.toHexString(commResponse)));
            try {
                if (commResponse[4] == 5) {
                    logger.debug((Object)("Authentication succeeded for  current DTCO ::" + this.objDTCOCommandVO));
                    this.objDTCOCommandVO.setFailureCode((byte)0);
                    byte[] timeStamp = new byte[4];
                    System.arraycopy(commResponse, 0, timeStamp, 0, timeStamp.length);
                    if (this.objDTCOCommandVO.getDldType() == 1 || this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                        this.objDTCOCommandVO.setTimeStamp(SMCPUtils.toInt(timeStamp));
                    }
                    logger.debug((Object)("Timestamp as received from COMM: " + this.objDTCOCommandVO.getTimeStamp()));
                    if (this.objDTCOCommandVO.getDldType() == 3) {
                        logger.debug((Object)("bytes for timestamp" + timeStamp[0] + ":" + timeStamp[1] + ":" + timeStamp[2] + ":" + timeStamp[3]));
                        byte[] reverseTimeStamp = new byte[]{timeStamp[3], timeStamp[2], timeStamp[1], timeStamp[0]};
                        this.objDTCOCommandVO.setTimeStamp(SMCPUtils.toInt(reverseTimeStamp));
                        logger.debug((Object)("reversed timestamp for WR to:" + this.objDTCOCommandVO.getTimeStamp()));
                        int count = 1;
                        String[] arrEntity = GeneralAPI.byteToString(this.objDTCOCommandVO.getEntityId()).split("#");
                        try {
                            int j = 0;
                            while (j < arrEntity.length) {
                                logger.debug((Object)("Entity:" + arrEntity[j]));
                                DTCOFileTransferStatusDao objDTCOFileTransferStatusDao = DTCOFileTransferStatusDao.getInstance();
                                FileTransferStatusVO objFileTransferStatusVO = new FileTransferStatusVO();
                                objFileTransferStatusVO.setCompanyID(this.objDTCOCommandVO.getCompanyID());
                                this.objDTCOCommandVO.getReminderDate();
                                ReminderListDao objReminderListDao = ReminderListDao.getInstance();
                                FileTransferStatusVO objFileTransfer = new FileTransferStatusVO();
                                boolean statusCheck = true;
                                if (arrEntity[j].startsWith("V")) {
                                    objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                    objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                    objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                    objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDVU());
                                    objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                    objFileTransferStatusVO.setAuthType(1);
                                    objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                } else if (arrEntity[j].startsWith("S")) {
                                    objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                    objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                    objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                    objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                    objFileTransferStatusVO.setAuthType(1);
                                    objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDSV());
                                    objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                } else if (arrEntity[j].startsWith("D")) {
                                    if (count == 1 && this.objDTCOCommandVO.isDriverIndicator() && this.objDTCOCommandVO.isCodriverIndicator()) {
                                        logger.debug((Object)"Setting Driver :");
                                        objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                        objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                        objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                        objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                        objFileTransferStatusVO.setAuthType(1);
                                        objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDDriver());
                                        objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                        ++count;
                                    } else if (count == 1 && !this.objDTCOCommandVO.isDriverIndicator() && this.objDTCOCommandVO.isCodriverIndicator()) {
                                        logger.debug((Object)"Setting Co Driver only:");
                                        objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                        objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                        objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                        objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                        objFileTransferStatusVO.setAuthType(1);
                                        objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDCoDriver());
                                        objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                    } else if (count == 1 && this.objDTCOCommandVO.isDriverIndicator() && !this.objDTCOCommandVO.isCodriverIndicator()) {
                                        logger.debug((Object)"Setting Driver Only :");
                                        objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                        objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                        objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                        objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                        objFileTransferStatusVO.setAuthType(1);
                                        objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDDriver());
                                        objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                    } else {
                                        logger.debug((Object)"Setting Co Driver :");
                                        objFileTransferStatusVO.setEntityId(GeneralAPI.convertStringToByte(arrEntity[j]));
                                        objFileTransferStatusVO.setSerialId(this.objDTCOCommandVO.getRemoteDeviceSerialNumber());
                                        objFileTransferStatusVO.setInitTimeStamp(Integer.toString(this.objDTCOCommandVO.getTimeStamp()));
                                        objFileTransferStatusVO.setDldType(this.objDTCOCommandVO.getDldType());
                                        objFileTransferStatusVO.setAuthType(1);
                                        objFileTransferStatusVO.setReminderID(this.objDTCOCommandVO.getReminderIDCoDriver());
                                        objDTCOFileTransferStatusDao.insertStatus(objFileTransferStatusVO, this.objDTCOCommandVO.getRemoteServiceID());
                                    }
                                }
                                ++j;
                            }
                        }
                        catch (Exception e) {
                            logger.debug((Object)"Exception in RemoteDownloadState....", (Throwable)e);
                        }
                    }
                    this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 2);
                    break block29;
                }
                if (commResponse[4] == 1) {
                    this.objAuthenticationTask.setCurrentState(new APDUState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask, commResponse));
                    this.objAuthenticationTask.processState();
                } else if (commResponse[4] == 7) {
                    logger.debug((Object)("Setting current state to Stop Authentication for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode((byte)15);
                    this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 4);
                } else if (commResponse[4] == 4) {
                    logger.debug((Object)("Setting current state to Stop Authentication for DTCO" + this.objDTCOCommandVO + "assigned to terminal" + this.cardTerminal));
                    this.objDTCOCommandVO.setFailureCode((byte)6);
                    this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 3);
                } else if (commResponse[4] == 3) {
                    logger.debug((Object)"Inside AUTH_FAILURE...");
                    logger.debug((Object)("DLD type =" + this.objDTCOCommandVO.getDldType()));
                    if (this.objDTCOCommandVO.getDldType() == 2 || this.objDTCOCommandVO.getDldType() == 10 || this.objDTCOCommandVO.getDldType() == 8) {
                        logger.debug((Object)("Hexa string of apdu array =" + SMCPUtils.toHexString(commResponse)));
                        byte acode = GeneralAPI.authFailureCode(commResponse);
                        logger.debug((Object)("acode for apdu =" + acode));
                        logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                        this.objDTCOCommandVO.setFailureCode(acode);
                    } else {
                        logger.debug((Object)("acode for apdu[4] =" + commResponse[4]));
                        logger.debug((Object)("Setting current state to Failed state for DTCO " + this.objDTCOCommandVO + " assigned to Terminal:" + this.cardTerminal));
                        this.objDTCOCommandVO.setFailureCode(commResponse[4]);
                    }
                    this.objAuthenticationTask.setCurrentState(new FailedState(this.objDTCOCommandVO, this.cardTerminal, this.objAuthenticationController, this.objAuthenticationTask));
                    this.objAuthenticationTask.processState();
                } else {
                    logger.debug((Object)("Remote Download Aceess Not Granted for  current DTCO ::" + this.objDTCOCommandVO));
                    this.objDTCOCommandVO.setFailureCode(commResponse[4]);
                    this.objAuthenticationController.authEvent(this.objDTCOCommandVO, 3);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toHexString(byte[] b) {
        try {
            char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            StringBuffer sb = new StringBuffer(b.length * 2);
            int i = 0;
            while (i < b.length) {
                sb.append(hexChar[(b[i] & 0xF0) >>> 4]);
                sb.append(hexChar[b[i] & 0xF]);
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"Error in converting to hex String.... returning null ");
            e.printStackTrace();
            return null;
        }
    }
}

